# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRulesPackagesResult',
    'AwaitableGetRulesPackagesResult',
    'get_rules_packages',
    'get_rules_packages_output',
]

@pulumi.output_type
class GetRulesPackagesResult:
    """
    A collection of values returned by getRulesPackages.
    """
    def __init__(__self__, arns=None, id=None, region=None):
        if arns and not isinstance(arns, list):
            raise TypeError("Expected argument 'arns' to be a list")
        pulumi.set(__self__, "arns", arns)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arns(self) -> Sequence[_builtins.str]:
        """
        List of the Amazon Inspector Classic Rules Packages arns available in the AWS region.
        """
        return pulumi.get(self, "arns")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetRulesPackagesResult(GetRulesPackagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRulesPackagesResult(
            arns=self.arns,
            id=self.id,
            region=self.region)


def get_rules_packages(region: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRulesPackagesResult:
    """
    The Amazon Inspector Classic Rules Packages data source allows access to the list of AWS
    Inspector Rules Packages which can be used by Amazon Inspector Classic within the region
    configured in the provider.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    # Declare the data source
    rules = aws.inspector.get_rules_packages()
    # e.g., Use in aws_inspector_assessment_template
    group = aws.inspector.ResourceGroup("group", tags={
        "test": "test",
    })
    assessment = aws.inspector.AssessmentTarget("assessment",
        name="test",
        resource_group_arn=group.arn)
    assessment_assessment_template = aws.inspector.AssessmentTemplate("assessment",
        name="Test",
        target_arn=assessment.arn,
        duration=60,
        rules_package_arns=rules.arns)
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:inspector/getRulesPackages:getRulesPackages', __args__, opts=opts, typ=GetRulesPackagesResult).value

    return AwaitableGetRulesPackagesResult(
        arns=pulumi.get(__ret__, 'arns'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'))
def get_rules_packages_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRulesPackagesResult]:
    """
    The Amazon Inspector Classic Rules Packages data source allows access to the list of AWS
    Inspector Rules Packages which can be used by Amazon Inspector Classic within the region
    configured in the provider.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    # Declare the data source
    rules = aws.inspector.get_rules_packages()
    # e.g., Use in aws_inspector_assessment_template
    group = aws.inspector.ResourceGroup("group", tags={
        "test": "test",
    })
    assessment = aws.inspector.AssessmentTarget("assessment",
        name="test",
        resource_group_arn=group.arn)
    assessment_assessment_template = aws.inspector.AssessmentTemplate("assessment",
        name="Test",
        target_arn=assessment.arn,
        duration=60,
        rules_package_arns=rules.arns)
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:inspector/getRulesPackages:getRulesPackages', __args__, opts=opts, typ=GetRulesPackagesResult)
    return __ret__.apply(lambda __response__: GetRulesPackagesResult(
        arns=pulumi.get(__response__, 'arns'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region')))
