# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthorizerArgs', 'Authorizer']

@pulumi.input_type
class AuthorizerArgs:
    def __init__(__self__, *,
                 authorizer_function_arn: pulumi.Input[_builtins.str],
                 enable_caching_for_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 token_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 token_signing_public_keys: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Authorizer resource.
        :param pulumi.Input[_builtins.str] authorizer_function_arn: The ARN of the authorizer's Lambda function.
        :param pulumi.Input[_builtins.bool] enable_caching_for_http: Specifies whether the HTTP caching is enabled or not. Default: `false`.
        :param pulumi.Input[_builtins.str] name: The name of the authorizer.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] signing_disabled: Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
        :param pulumi.Input[_builtins.str] status: The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] token_key_name: The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] token_signing_public_keys: The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
        """
        pulumi.set(__self__, "authorizer_function_arn", authorizer_function_arn)
        if enable_caching_for_http is not None:
            pulumi.set(__self__, "enable_caching_for_http", enable_caching_for_http)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if signing_disabled is not None:
            pulumi.set(__self__, "signing_disabled", signing_disabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if token_key_name is not None:
            pulumi.set(__self__, "token_key_name", token_key_name)
        if token_signing_public_keys is not None:
            pulumi.set(__self__, "token_signing_public_keys", token_signing_public_keys)

    @_builtins.property
    @pulumi.getter(name="authorizerFunctionArn")
    def authorizer_function_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The ARN of the authorizer's Lambda function.
        """
        return pulumi.get(self, "authorizer_function_arn")

    @authorizer_function_arn.setter
    def authorizer_function_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authorizer_function_arn", value)

    @_builtins.property
    @pulumi.getter(name="enableCachingForHttp")
    def enable_caching_for_http(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the HTTP caching is enabled or not. Default: `false`.
        """
        return pulumi.get(self, "enable_caching_for_http")

    @enable_caching_for_http.setter
    def enable_caching_for_http(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_caching_for_http", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the authorizer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="signingDisabled")
    def signing_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
        """
        return pulumi.get(self, "signing_disabled")

    @signing_disabled.setter
    def signing_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "signing_disabled", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tokenKeyName")
    def token_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
        """
        return pulumi.get(self, "token_key_name")

    @token_key_name.setter
    def token_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_key_name", value)

    @_builtins.property
    @pulumi.getter(name="tokenSigningPublicKeys")
    def token_signing_public_keys(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
        """
        return pulumi.get(self, "token_signing_public_keys")

    @token_signing_public_keys.setter
    def token_signing_public_keys(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_signing_public_keys", value)


@pulumi.input_type
class _AuthorizerState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 authorizer_function_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_caching_for_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 token_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 token_signing_public_keys: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Authorizer resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of the authorizer.
        :param pulumi.Input[_builtins.str] authorizer_function_arn: The ARN of the authorizer's Lambda function.
        :param pulumi.Input[_builtins.bool] enable_caching_for_http: Specifies whether the HTTP caching is enabled or not. Default: `false`.
        :param pulumi.Input[_builtins.str] name: The name of the authorizer.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] signing_disabled: Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
        :param pulumi.Input[_builtins.str] status: The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] token_key_name: The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] token_signing_public_keys: The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if authorizer_function_arn is not None:
            pulumi.set(__self__, "authorizer_function_arn", authorizer_function_arn)
        if enable_caching_for_http is not None:
            pulumi.set(__self__, "enable_caching_for_http", enable_caching_for_http)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if signing_disabled is not None:
            pulumi.set(__self__, "signing_disabled", signing_disabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if token_key_name is not None:
            pulumi.set(__self__, "token_key_name", token_key_name)
        if token_signing_public_keys is not None:
            pulumi.set(__self__, "token_signing_public_keys", token_signing_public_keys)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the authorizer.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="authorizerFunctionArn")
    def authorizer_function_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the authorizer's Lambda function.
        """
        return pulumi.get(self, "authorizer_function_arn")

    @authorizer_function_arn.setter
    def authorizer_function_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorizer_function_arn", value)

    @_builtins.property
    @pulumi.getter(name="enableCachingForHttp")
    def enable_caching_for_http(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the HTTP caching is enabled or not. Default: `false`.
        """
        return pulumi.get(self, "enable_caching_for_http")

    @enable_caching_for_http.setter
    def enable_caching_for_http(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_caching_for_http", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the authorizer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="signingDisabled")
    def signing_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
        """
        return pulumi.get(self, "signing_disabled")

    @signing_disabled.setter
    def signing_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "signing_disabled", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="tokenKeyName")
    def token_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
        """
        return pulumi.get(self, "token_key_name")

    @token_key_name.setter
    def token_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_key_name", value)

    @_builtins.property
    @pulumi.getter(name="tokenSigningPublicKeys")
    def token_signing_public_keys(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
        """
        return pulumi.get(self, "token_signing_public_keys")

    @token_signing_public_keys.setter
    def token_signing_public_keys(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "token_signing_public_keys", value)


@pulumi.type_token("aws:iot/authorizer:Authorizer")
class Authorizer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorizer_function_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_caching_for_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 token_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 token_signing_public_keys: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Creates and manages an AWS IoT Authorizer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.iot.Authorizer("example",
            name="example",
            authorizer_function_arn=example_aws_lambda_function["arn"],
            signing_disabled=False,
            status="ACTIVE",
            token_key_name="Token-Header",
            token_signing_public_keys={
                "Key1": std.file(input="test-fixtures/iot-authorizer-signing-key.pem").result,
            },
            tags={
                "Name": "example",
            })
        ```

        ## Import

        Using `pulumi import`, import IOT Authorizers using the name. For example:

        ```sh
        $ pulumi import aws:iot/authorizer:Authorizer example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorizer_function_arn: The ARN of the authorizer's Lambda function.
        :param pulumi.Input[_builtins.bool] enable_caching_for_http: Specifies whether the HTTP caching is enabled or not. Default: `false`.
        :param pulumi.Input[_builtins.str] name: The name of the authorizer.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] signing_disabled: Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
        :param pulumi.Input[_builtins.str] status: The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] token_key_name: The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] token_signing_public_keys: The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorizerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an AWS IoT Authorizer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        example = aws.iot.Authorizer("example",
            name="example",
            authorizer_function_arn=example_aws_lambda_function["arn"],
            signing_disabled=False,
            status="ACTIVE",
            token_key_name="Token-Header",
            token_signing_public_keys={
                "Key1": std.file(input="test-fixtures/iot-authorizer-signing-key.pem").result,
            },
            tags={
                "Name": "example",
            })
        ```

        ## Import

        Using `pulumi import`, import IOT Authorizers using the name. For example:

        ```sh
        $ pulumi import aws:iot/authorizer:Authorizer example example
        ```

        :param str resource_name: The name of the resource.
        :param AuthorizerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorizer_function_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_caching_for_http: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 token_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 token_signing_public_keys: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizerArgs.__new__(AuthorizerArgs)

            if authorizer_function_arn is None and not opts.urn:
                raise TypeError("Missing required property 'authorizer_function_arn'")
            __props__.__dict__["authorizer_function_arn"] = authorizer_function_arn
            __props__.__dict__["enable_caching_for_http"] = enable_caching_for_http
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["signing_disabled"] = signing_disabled
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["token_key_name"] = token_key_name
            __props__.__dict__["token_signing_public_keys"] = None if token_signing_public_keys is None else pulumi.Output.secret(token_signing_public_keys)
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["tokenSigningPublicKeys"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Authorizer, __self__).__init__(
            'aws:iot/authorizer:Authorizer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            authorizer_function_arn: Optional[pulumi.Input[_builtins.str]] = None,
            enable_caching_for_http: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            signing_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            token_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            token_signing_public_keys: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Authorizer':
        """
        Get an existing Authorizer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of the authorizer.
        :param pulumi.Input[_builtins.str] authorizer_function_arn: The ARN of the authorizer's Lambda function.
        :param pulumi.Input[_builtins.bool] enable_caching_for_http: Specifies whether the HTTP caching is enabled or not. Default: `false`.
        :param pulumi.Input[_builtins.str] name: The name of the authorizer.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] signing_disabled: Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
        :param pulumi.Input[_builtins.str] status: The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] token_key_name: The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] token_signing_public_keys: The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorizerState.__new__(_AuthorizerState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["authorizer_function_arn"] = authorizer_function_arn
        __props__.__dict__["enable_caching_for_http"] = enable_caching_for_http
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["signing_disabled"] = signing_disabled
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["token_key_name"] = token_key_name
        __props__.__dict__["token_signing_public_keys"] = token_signing_public_keys
        return Authorizer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the authorizer.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="authorizerFunctionArn")
    def authorizer_function_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the authorizer's Lambda function.
        """
        return pulumi.get(self, "authorizer_function_arn")

    @_builtins.property
    @pulumi.getter(name="enableCachingForHttp")
    def enable_caching_for_http(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the HTTP caching is enabled or not. Default: `false`.
        """
        return pulumi.get(self, "enable_caching_for_http")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the authorizer.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="signingDisabled")
    def signing_disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether AWS IoT validates the token signature in an authorization request. Default: `false`.
        """
        return pulumi.get(self, "signing_disabled")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The status of Authorizer request at creation. Valid values: `ACTIVE`, `INACTIVE`. Default: `ACTIVE`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="tokenKeyName")
    def token_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the token key used to extract the token from the HTTP headers. This value is required if signing is enabled in your authorizer.
        """
        return pulumi.get(self, "token_key_name")

    @_builtins.property
    @pulumi.getter(name="tokenSigningPublicKeys")
    def token_signing_public_keys(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The public keys used to verify the digital signature returned by your custom authentication service. This value is required if signing is enabled in your authorizer.
        """
        return pulumi.get(self, "token_signing_public_keys")

