# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCipherTextResult',
    'AwaitableGetCipherTextResult',
    'get_cipher_text',
    'get_cipher_text_output',
]

@pulumi.output_type
class GetCipherTextResult:
    """
    A collection of values returned by getCipherText.
    """
    def __init__(__self__, ciphertext_blob=None, context=None, id=None, key_id=None, plaintext=None, region=None):
        if ciphertext_blob and not isinstance(ciphertext_blob, str):
            raise TypeError("Expected argument 'ciphertext_blob' to be a str")
        pulumi.set(__self__, "ciphertext_blob", ciphertext_blob)
        if context and not isinstance(context, dict):
            raise TypeError("Expected argument 'context' to be a dict")
        pulumi.set(__self__, "context", context)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if plaintext and not isinstance(plaintext, str):
            raise TypeError("Expected argument 'plaintext' to be a str")
        pulumi.set(__self__, "plaintext", plaintext)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="ciphertextBlob")
    def ciphertext_blob(self) -> _builtins.str:
        """
        Base64 encoded ciphertext
        """
        return pulumi.get(self, "ciphertext_blob")

    @_builtins.property
    @pulumi.getter
    def context(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "context")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter
    def plaintext(self) -> _builtins.str:
        return pulumi.get(self, "plaintext")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetCipherTextResult(GetCipherTextResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCipherTextResult(
            ciphertext_blob=self.ciphertext_blob,
            context=self.context,
            id=self.id,
            key_id=self.key_id,
            plaintext=self.plaintext,
            region=self.region)


def get_cipher_text(context: Optional[Mapping[str, _builtins.str]] = None,
                    key_id: Optional[_builtins.str] = None,
                    plaintext: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCipherTextResult:
    """
    The KMS ciphertext data source allows you to encrypt plaintext into ciphertext
    by using an AWS KMS customer master key. The value returned by this data source
    changes every apply. For a stable ciphertext value, see the `kms.Ciphertext`
    resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    oauth_config = aws.kms.Key("oauth_config",
        description="oauth config",
        is_enabled=True)
    oauth = aws.kms.get_cipher_text_output(key_id=oauth_config.key_id,
        plaintext=\"\"\"{
      "client_id": "e587dbae22222f55da22",
      "client_secret": "8289575d00000ace55e1815ec13673955721b8a5"
    }
    \"\"\")
    ```


    :param Mapping[str, _builtins.str] context: An optional mapping that makes up the encryption context.
    :param _builtins.str key_id: Globally unique key ID for the customer master key.
    :param _builtins.str plaintext: Data to be encrypted. Note that this may show up in logs, and it will be stored in the state file.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['context'] = context
    __args__['keyId'] = key_id
    __args__['plaintext'] = plaintext
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:kms/getCipherText:getCipherText', __args__, opts=opts, typ=GetCipherTextResult).value

    return AwaitableGetCipherTextResult(
        ciphertext_blob=pulumi.get(__ret__, 'ciphertext_blob'),
        context=pulumi.get(__ret__, 'context'),
        id=pulumi.get(__ret__, 'id'),
        key_id=pulumi.get(__ret__, 'key_id'),
        plaintext=pulumi.get(__ret__, 'plaintext'),
        region=pulumi.get(__ret__, 'region'))
def get_cipher_text_output(context: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                           key_id: Optional[pulumi.Input[_builtins.str]] = None,
                           plaintext: Optional[pulumi.Input[_builtins.str]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCipherTextResult]:
    """
    The KMS ciphertext data source allows you to encrypt plaintext into ciphertext
    by using an AWS KMS customer master key. The value returned by this data source
    changes every apply. For a stable ciphertext value, see the `kms.Ciphertext`
    resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    oauth_config = aws.kms.Key("oauth_config",
        description="oauth config",
        is_enabled=True)
    oauth = aws.kms.get_cipher_text_output(key_id=oauth_config.key_id,
        plaintext=\"\"\"{
      "client_id": "e587dbae22222f55da22",
      "client_secret": "8289575d00000ace55e1815ec13673955721b8a5"
    }
    \"\"\")
    ```


    :param Mapping[str, _builtins.str] context: An optional mapping that makes up the encryption context.
    :param _builtins.str key_id: Globally unique key ID for the customer master key.
    :param _builtins.str plaintext: Data to be encrypted. Note that this may show up in logs, and it will be stored in the state file.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['context'] = context
    __args__['keyId'] = key_id
    __args__['plaintext'] = plaintext
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:kms/getCipherText:getCipherText', __args__, opts=opts, typ=GetCipherTextResult)
    return __ret__.apply(lambda __response__: GetCipherTextResult(
        ciphertext_blob=pulumi.get(__response__, 'ciphertext_blob'),
        context=pulumi.get(__response__, 'context'),
        id=pulumi.get(__response__, 'id'),
        key_id=pulumi.get(__response__, 'key_id'),
        plaintext=pulumi.get(__response__, 'plaintext'),
        region=pulumi.get(__response__, 'region')))
