# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LfTagExpressionArgs', 'LfTagExpression']

@pulumi.input_type
class LfTagExpressionArgs:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expressions: Optional[pulumi.Input[Sequence[pulumi.Input['LfTagExpressionExpressionArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LfTagExpression resource.
        :param pulumi.Input[_builtins.str] catalog_id: ID of the Data Catalog. Defaults to the account ID if not specified.
        :param pulumi.Input[_builtins.str] description: Description of the LF-Tag Expression.
        :param pulumi.Input[Sequence[pulumi.Input['LfTagExpressionExpressionArgs']]] expressions: A list of LF-Tag conditions (key-value pairs). See expression for more details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] name: Name of the LF-Tag Expression.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expressions is not None:
            pulumi.set(__self__, "expressions", expressions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Data Catalog. Defaults to the account ID if not specified.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the LF-Tag Expression.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def expressions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LfTagExpressionExpressionArgs']]]]:
        """
        A list of LF-Tag conditions (key-value pairs). See expression for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "expressions")

    @expressions.setter
    def expressions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LfTagExpressionExpressionArgs']]]]):
        pulumi.set(self, "expressions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the LF-Tag Expression.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _LfTagExpressionState:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expressions: Optional[pulumi.Input[Sequence[pulumi.Input['LfTagExpressionExpressionArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LfTagExpression resources.
        :param pulumi.Input[_builtins.str] catalog_id: ID of the Data Catalog. Defaults to the account ID if not specified.
        :param pulumi.Input[_builtins.str] description: Description of the LF-Tag Expression.
        :param pulumi.Input[Sequence[pulumi.Input['LfTagExpressionExpressionArgs']]] expressions: A list of LF-Tag conditions (key-value pairs). See expression for more details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] name: Name of the LF-Tag Expression.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expressions is not None:
            pulumi.set(__self__, "expressions", expressions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Data Catalog. Defaults to the account ID if not specified.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the LF-Tag Expression.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def expressions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LfTagExpressionExpressionArgs']]]]:
        """
        A list of LF-Tag conditions (key-value pairs). See expression for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "expressions")

    @expressions.setter
    def expressions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LfTagExpressionExpressionArgs']]]]):
        pulumi.set(self, "expressions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the LF-Tag Expression.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:lakeformation/lfTagExpression:LfTagExpression")
class LfTagExpression(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expressions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LfTagExpressionExpressionArgs', 'LfTagExpressionExpressionArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Lake Formation LF Tag Expression.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.LfTag("example",
            key="example",
            values=["value"])
        example_lf_tag_expression = aws.lakeformation.LfTagExpression("example",
            name="example",
            expressions=[{
                "tag_key": example.key,
                "tag_values": example.values,
            }])
        ```

        ## Import

        Using `pulumi import`, import Lake Formation LF Tag Expression using the `name,catalog_id`. For example:

        ```sh
        $ pulumi import aws:lakeformation/lfTagExpression:LfTagExpression example example-tag-expression,123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: ID of the Data Catalog. Defaults to the account ID if not specified.
        :param pulumi.Input[_builtins.str] description: Description of the LF-Tag Expression.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LfTagExpressionExpressionArgs', 'LfTagExpressionExpressionArgsDict']]]] expressions: A list of LF-Tag conditions (key-value pairs). See expression for more details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] name: Name of the LF-Tag Expression.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LfTagExpressionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Lake Formation LF Tag Expression.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lakeformation.LfTag("example",
            key="example",
            values=["value"])
        example_lf_tag_expression = aws.lakeformation.LfTagExpression("example",
            name="example",
            expressions=[{
                "tag_key": example.key,
                "tag_values": example.values,
            }])
        ```

        ## Import

        Using `pulumi import`, import Lake Formation LF Tag Expression using the `name,catalog_id`. For example:

        ```sh
        $ pulumi import aws:lakeformation/lfTagExpression:LfTagExpression example example-tag-expression,123456789012
        ```

        :param str resource_name: The name of the resource.
        :param LfTagExpressionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LfTagExpressionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expressions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LfTagExpressionExpressionArgs', 'LfTagExpressionExpressionArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LfTagExpressionArgs.__new__(LfTagExpressionArgs)

            __props__.__dict__["catalog_id"] = catalog_id
            __props__.__dict__["description"] = description
            __props__.__dict__["expressions"] = expressions
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
        super(LfTagExpression, __self__).__init__(
            'aws:lakeformation/lfTagExpression:LfTagExpression',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            expressions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LfTagExpressionExpressionArgs', 'LfTagExpressionExpressionArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'LfTagExpression':
        """
        Get an existing LfTagExpression resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] catalog_id: ID of the Data Catalog. Defaults to the account ID if not specified.
        :param pulumi.Input[_builtins.str] description: Description of the LF-Tag Expression.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LfTagExpressionExpressionArgs', 'LfTagExpressionExpressionArgsDict']]]] expressions: A list of LF-Tag conditions (key-value pairs). See expression for more details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] name: Name of the LF-Tag Expression.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LfTagExpressionState.__new__(_LfTagExpressionState)

        __props__.__dict__["catalog_id"] = catalog_id
        __props__.__dict__["description"] = description
        __props__.__dict__["expressions"] = expressions
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return LfTagExpression(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Data Catalog. Defaults to the account ID if not specified.
        """
        return pulumi.get(self, "catalog_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the LF-Tag Expression.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def expressions(self) -> pulumi.Output[Optional[Sequence['outputs.LfTagExpressionExpression']]]:
        """
        A list of LF-Tag conditions (key-value pairs). See expression for more details.

        The following arguments are optional:
        """
        return pulumi.get(self, "expressions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the LF-Tag Expression.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

