# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CodeSigningConfigArgs', 'CodeSigningConfig']

@pulumi.input_type
class CodeSigningConfigArgs:
    def __init__(__self__, *,
                 allowed_publishers: pulumi.Input['CodeSigningConfigAllowedPublishersArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input['CodeSigningConfigPoliciesArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a CodeSigningConfig resource.
        :param pulumi.Input['CodeSigningConfigAllowedPublishersArgs'] allowed_publishers: Configuration block of allowed publishers as signing profiles for this code signing configuration. See below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: Descriptive name for this code signing configuration.
        :param pulumi.Input['CodeSigningConfigPoliciesArgs'] policies: Configuration block of code signing policies that define the actions to take if the validation checks fail. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "allowed_publishers", allowed_publishers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="allowedPublishers")
    def allowed_publishers(self) -> pulumi.Input['CodeSigningConfigAllowedPublishersArgs']:
        """
        Configuration block of allowed publishers as signing profiles for this code signing configuration. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "allowed_publishers")

    @allowed_publishers.setter
    def allowed_publishers(self, value: pulumi.Input['CodeSigningConfigAllowedPublishersArgs']):
        pulumi.set(self, "allowed_publishers", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Descriptive name for this code signing configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input['CodeSigningConfigPoliciesArgs']]:
        """
        Configuration block of code signing policies that define the actions to take if the validation checks fail. See below.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input['CodeSigningConfigPoliciesArgs']]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CodeSigningConfigState:
    def __init__(__self__, *,
                 allowed_publishers: Optional[pulumi.Input['CodeSigningConfigAllowedPublishersArgs']] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 last_modified: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input['CodeSigningConfigPoliciesArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CodeSigningConfig resources.
        :param pulumi.Input['CodeSigningConfigAllowedPublishersArgs'] allowed_publishers: Configuration block of allowed publishers as signing profiles for this code signing configuration. See below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] arn: ARN of the code signing configuration.
        :param pulumi.Input[_builtins.str] config_id: Unique identifier for the code signing configuration.
        :param pulumi.Input[_builtins.str] description: Descriptive name for this code signing configuration.
        :param pulumi.Input[_builtins.str] last_modified: Date and time that the code signing configuration was last modified.
        :param pulumi.Input['CodeSigningConfigPoliciesArgs'] policies: Configuration block of code signing policies that define the actions to take if the validation checks fail. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if allowed_publishers is not None:
            pulumi.set(__self__, "allowed_publishers", allowed_publishers)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter(name="allowedPublishers")
    def allowed_publishers(self) -> Optional[pulumi.Input['CodeSigningConfigAllowedPublishersArgs']]:
        """
        Configuration block of allowed publishers as signing profiles for this code signing configuration. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "allowed_publishers")

    @allowed_publishers.setter
    def allowed_publishers(self, value: Optional[pulumi.Input['CodeSigningConfigAllowedPublishersArgs']]):
        pulumi.set(self, "allowed_publishers", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the code signing configuration.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for the code signing configuration.
        """
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "config_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Descriptive name for this code signing configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time that the code signing configuration was last modified.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified", value)

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input['CodeSigningConfigPoliciesArgs']]:
        """
        Configuration block of code signing policies that define the actions to take if the validation checks fail. See below.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input['CodeSigningConfigPoliciesArgs']]):
        pulumi.set(self, "policies", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:lambda/codeSigningConfig:CodeSigningConfig")
class CodeSigningConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_publishers: Optional[pulumi.Input[Union['CodeSigningConfigAllowedPublishersArgs', 'CodeSigningConfigAllowedPublishersArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Union['CodeSigningConfigPoliciesArgs', 'CodeSigningConfigPoliciesArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an AWS Lambda Code Signing Config. Use this resource to define allowed signing profiles and code-signing validation policies for Lambda functions to ensure code integrity and authenticity.

        For information about Lambda code signing configurations and how to use them, see [configuring code signing for Lambda functions](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Create signing profiles for different environments
        prod = aws.signer.SigningProfile("prod",
            platform_id="AWSLambda-SHA384-ECDSA",
            name_prefix="prod_lambda_",
            tags={
                "Environment": "production",
            })
        dev = aws.signer.SigningProfile("dev",
            platform_id="AWSLambda-SHA384-ECDSA",
            name_prefix="dev_lambda_",
            tags={
                "Environment": "development",
            })
        # Code signing configuration with enforcement
        example = aws.lambda_.CodeSigningConfig("example",
            description="Code signing configuration for Lambda functions",
            allowed_publishers={
                "signing_profile_version_arns": [
                    prod.version_arn,
                    dev.version_arn,
                ],
            },
            policies={
                "untrusted_artifact_on_deployment": "Enforce",
            },
            tags={
                "Environment": "production",
                "Purpose": "code-signing",
            })
        ```

        ### Warning Only Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.CodeSigningConfig("example",
            description="Development code signing configuration",
            allowed_publishers={
                "signing_profile_version_arns": [dev["versionArn"]],
            },
            policies={
                "untrusted_artifact_on_deployment": "Warn",
            },
            tags={
                "Environment": "development",
                "Purpose": "code-signing",
            })
        ```

        ### Multiple Environment Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        # Production signing configuration
        prod = aws.lambda_.CodeSigningConfig("prod",
            description="Production code signing configuration with strict enforcement",
            allowed_publishers={
                "signing_profile_version_arns": [prod_aws_signer_signing_profile["versionArn"]],
            },
            policies={
                "untrusted_artifact_on_deployment": "Enforce",
            },
            tags={
                "Environment": "production",
                "Security": "strict",
            })
        # Development signing configuration
        dev = aws.lambda_.CodeSigningConfig("dev",
            description="Development code signing configuration with warnings",
            allowed_publishers={
                "signing_profile_version_arns": [
                    dev_aws_signer_signing_profile["versionArn"],
                    test["versionArn"],
                ],
            },
            policies={
                "untrusted_artifact_on_deployment": "Warn",
            },
            tags={
                "Environment": "development",
                "Security": "flexible",
            })
        ```

        ## Import

        For backwards compatibility, the following legacy `pulumi import` command is also supported:

        ```sh
        $ pulumi import aws:lambda/codeSigningConfig:CodeSigningConfig example arn:aws:lambda:us-west-2:123456789012:code-signing-config:csc-0f6c334abcdea4d8b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CodeSigningConfigAllowedPublishersArgs', 'CodeSigningConfigAllowedPublishersArgsDict']] allowed_publishers: Configuration block of allowed publishers as signing profiles for this code signing configuration. See below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: Descriptive name for this code signing configuration.
        :param pulumi.Input[Union['CodeSigningConfigPoliciesArgs', 'CodeSigningConfigPoliciesArgsDict']] policies: Configuration block of code signing policies that define the actions to take if the validation checks fail. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CodeSigningConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Lambda Code Signing Config. Use this resource to define allowed signing profiles and code-signing validation policies for Lambda functions to ensure code integrity and authenticity.

        For information about Lambda code signing configurations and how to use them, see [configuring code signing for Lambda functions](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        # Create signing profiles for different environments
        prod = aws.signer.SigningProfile("prod",
            platform_id="AWSLambda-SHA384-ECDSA",
            name_prefix="prod_lambda_",
            tags={
                "Environment": "production",
            })
        dev = aws.signer.SigningProfile("dev",
            platform_id="AWSLambda-SHA384-ECDSA",
            name_prefix="dev_lambda_",
            tags={
                "Environment": "development",
            })
        # Code signing configuration with enforcement
        example = aws.lambda_.CodeSigningConfig("example",
            description="Code signing configuration for Lambda functions",
            allowed_publishers={
                "signing_profile_version_arns": [
                    prod.version_arn,
                    dev.version_arn,
                ],
            },
            policies={
                "untrusted_artifact_on_deployment": "Enforce",
            },
            tags={
                "Environment": "production",
                "Purpose": "code-signing",
            })
        ```

        ### Warning Only Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.CodeSigningConfig("example",
            description="Development code signing configuration",
            allowed_publishers={
                "signing_profile_version_arns": [dev["versionArn"]],
            },
            policies={
                "untrusted_artifact_on_deployment": "Warn",
            },
            tags={
                "Environment": "development",
                "Purpose": "code-signing",
            })
        ```

        ### Multiple Environment Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        # Production signing configuration
        prod = aws.lambda_.CodeSigningConfig("prod",
            description="Production code signing configuration with strict enforcement",
            allowed_publishers={
                "signing_profile_version_arns": [prod_aws_signer_signing_profile["versionArn"]],
            },
            policies={
                "untrusted_artifact_on_deployment": "Enforce",
            },
            tags={
                "Environment": "production",
                "Security": "strict",
            })
        # Development signing configuration
        dev = aws.lambda_.CodeSigningConfig("dev",
            description="Development code signing configuration with warnings",
            allowed_publishers={
                "signing_profile_version_arns": [
                    dev_aws_signer_signing_profile["versionArn"],
                    test["versionArn"],
                ],
            },
            policies={
                "untrusted_artifact_on_deployment": "Warn",
            },
            tags={
                "Environment": "development",
                "Security": "flexible",
            })
        ```

        ## Import

        For backwards compatibility, the following legacy `pulumi import` command is also supported:

        ```sh
        $ pulumi import aws:lambda/codeSigningConfig:CodeSigningConfig example arn:aws:lambda:us-west-2:123456789012:code-signing-config:csc-0f6c334abcdea4d8b
        ```

        :param str resource_name: The name of the resource.
        :param CodeSigningConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CodeSigningConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_publishers: Optional[pulumi.Input[Union['CodeSigningConfigAllowedPublishersArgs', 'CodeSigningConfigAllowedPublishersArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 policies: Optional[pulumi.Input[Union['CodeSigningConfigPoliciesArgs', 'CodeSigningConfigPoliciesArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CodeSigningConfigArgs.__new__(CodeSigningConfigArgs)

            if allowed_publishers is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_publishers'")
            __props__.__dict__["allowed_publishers"] = allowed_publishers
            __props__.__dict__["description"] = description
            __props__.__dict__["policies"] = policies
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["config_id"] = None
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["tags_all"] = None
        super(CodeSigningConfig, __self__).__init__(
            'aws:lambda/codeSigningConfig:CodeSigningConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_publishers: Optional[pulumi.Input[Union['CodeSigningConfigAllowedPublishersArgs', 'CodeSigningConfigAllowedPublishersArgsDict']]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            config_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            last_modified: Optional[pulumi.Input[_builtins.str]] = None,
            policies: Optional[pulumi.Input[Union['CodeSigningConfigPoliciesArgs', 'CodeSigningConfigPoliciesArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'CodeSigningConfig':
        """
        Get an existing CodeSigningConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CodeSigningConfigAllowedPublishersArgs', 'CodeSigningConfigAllowedPublishersArgsDict']] allowed_publishers: Configuration block of allowed publishers as signing profiles for this code signing configuration. See below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] arn: ARN of the code signing configuration.
        :param pulumi.Input[_builtins.str] config_id: Unique identifier for the code signing configuration.
        :param pulumi.Input[_builtins.str] description: Descriptive name for this code signing configuration.
        :param pulumi.Input[_builtins.str] last_modified: Date and time that the code signing configuration was last modified.
        :param pulumi.Input[Union['CodeSigningConfigPoliciesArgs', 'CodeSigningConfigPoliciesArgsDict']] policies: Configuration block of code signing policies that define the actions to take if the validation checks fail. See below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CodeSigningConfigState.__new__(_CodeSigningConfigState)

        __props__.__dict__["allowed_publishers"] = allowed_publishers
        __props__.__dict__["arn"] = arn
        __props__.__dict__["config_id"] = config_id
        __props__.__dict__["description"] = description
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["policies"] = policies
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return CodeSigningConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedPublishers")
    def allowed_publishers(self) -> pulumi.Output['outputs.CodeSigningConfigAllowedPublishers']:
        """
        Configuration block of allowed publishers as signing profiles for this code signing configuration. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "allowed_publishers")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the code signing configuration.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for the code signing configuration.
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Descriptive name for this code signing configuration.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time that the code signing configuration was last modified.
        """
        return pulumi.get(self, "last_modified")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> pulumi.Output['outputs.CodeSigningConfigPolicies']:
        """
        Configuration block of code signing policies that define the actions to take if the validation checks fail. See below.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the object. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

