# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionEventInvokeConfigArgs', 'FunctionEventInvokeConfig']

@pulumi.input_type
class FunctionEventInvokeConfigArgs:
    def __init__(__self__, *,
                 function_name: pulumi.Input[_builtins.str],
                 destination_config: Optional[pulumi.Input['FunctionEventInvokeConfigDestinationConfigArgs']] = None,
                 maximum_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FunctionEventInvokeConfig resource.
        :param pulumi.Input[_builtins.str] function_name: Name or ARN of the Lambda Function, omitting any version or alias qualifier.
               
               The following arguments are optional:
        :param pulumi.Input['FunctionEventInvokeConfigDestinationConfigArgs'] destination_config: Configuration block with destination configuration. See below.
        :param pulumi.Input[_builtins.int] maximum_event_age_in_seconds: Maximum age of a request that Lambda sends to a function for processing in seconds. Valid values between 60 and 21600.
        :param pulumi.Input[_builtins.int] maximum_retry_attempts: Maximum number of times to retry when the function returns an error. Valid values between 0 and 2. Defaults to 2.
        :param pulumi.Input[_builtins.str] qualifier: Lambda Function published version, `$LATEST`, or Lambda Alias name.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "function_name", function_name)
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if maximum_event_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_event_age_in_seconds", maximum_event_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name or ARN of the Lambda Function, omitting any version or alias qualifier.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['FunctionEventInvokeConfigDestinationConfigArgs']]:
        """
        Configuration block with destination configuration. See below.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['FunctionEventInvokeConfigDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @_builtins.property
    @pulumi.getter(name="maximumEventAgeInSeconds")
    def maximum_event_age_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum age of a request that Lambda sends to a function for processing in seconds. Valid values between 60 and 21600.
        """
        return pulumi.get(self, "maximum_event_age_in_seconds")

    @maximum_event_age_in_seconds.setter
    def maximum_event_age_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_event_age_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of times to retry when the function returns an error. Valid values between 0 and 2. Defaults to 2.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @maximum_retry_attempts.setter
    def maximum_retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_retry_attempts", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Lambda Function published version, `$LATEST`, or Lambda Alias name.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _FunctionEventInvokeConfigState:
    def __init__(__self__, *,
                 destination_config: Optional[pulumi.Input['FunctionEventInvokeConfigDestinationConfigArgs']] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FunctionEventInvokeConfig resources.
        :param pulumi.Input['FunctionEventInvokeConfigDestinationConfigArgs'] destination_config: Configuration block with destination configuration. See below.
        :param pulumi.Input[_builtins.str] function_name: Name or ARN of the Lambda Function, omitting any version or alias qualifier.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] maximum_event_age_in_seconds: Maximum age of a request that Lambda sends to a function for processing in seconds. Valid values between 60 and 21600.
        :param pulumi.Input[_builtins.int] maximum_retry_attempts: Maximum number of times to retry when the function returns an error. Valid values between 0 and 2. Defaults to 2.
        :param pulumi.Input[_builtins.str] qualifier: Lambda Function published version, `$LATEST`, or Lambda Alias name.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if maximum_event_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_event_age_in_seconds", maximum_event_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['FunctionEventInvokeConfigDestinationConfigArgs']]:
        """
        Configuration block with destination configuration. See below.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['FunctionEventInvokeConfigDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name or ARN of the Lambda Function, omitting any version or alias qualifier.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_name", value)

    @_builtins.property
    @pulumi.getter(name="maximumEventAgeInSeconds")
    def maximum_event_age_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum age of a request that Lambda sends to a function for processing in seconds. Valid values between 60 and 21600.
        """
        return pulumi.get(self, "maximum_event_age_in_seconds")

    @maximum_event_age_in_seconds.setter
    def maximum_event_age_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_event_age_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of times to retry when the function returns an error. Valid values between 0 and 2. Defaults to 2.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @maximum_retry_attempts.setter
    def maximum_retry_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_retry_attempts", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Lambda Function published version, `$LATEST`, or Lambda Alias name.
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig")
class FunctionEventInvokeConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_config: Optional[pulumi.Input[Union['FunctionEventInvokeConfigDestinationConfigArgs', 'FunctionEventInvokeConfigDestinationConfigArgsDict']]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an AWS Lambda Function Event Invoke Config. Use this resource to configure error handling and destinations for asynchronous Lambda function invocations.

        More information about asynchronous invocations and the configurable values can be found in the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html).

        ## Example Usage

        ### Complete Error Handling and Destinations

        > **Note:** Ensure the Lambda Function IAM Role has necessary permissions for the destination, such as `sqs:SendMessage` or `sns:Publish`, otherwise the API will return a generic `InvalidParameterValueException: The destination ARN arn:PARTITION:SERVICE:REGION:ACCOUNT:RESOURCE is invalid.` error.

        ```python
        import pulumi
        import pulumi_aws as aws

        # SQS queue for failed invocations
        dlq = aws.sqs.Queue("dlq",
            name="lambda-dlq",
            tags={
                "Environment": "production",
                "Purpose": "lambda-error-handling",
            })
        # SNS topic for successful invocations
        success = aws.sns.Topic("success",
            name="lambda-success-notifications",
            tags={
                "Environment": "production",
                "Purpose": "lambda-success-notifications",
            })
        # Complete event invoke configuration
        example = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            maximum_event_age_in_seconds=300,
            maximum_retry_attempts=1,
            destination_config={
                "on_failure": {
                    "destination": dlq.arn,
                },
                "on_success": {
                    "destination": success.arn,
                },
            })
        ```

        ### Error Handling Only

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            maximum_event_age_in_seconds=60,
            maximum_retry_attempts=0)
        ```

        ### Configuration for Lambda Alias

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.Alias("example",
            name="production",
            description="Production alias",
            function_name=example_aws_lambda_function["functionName"],
            function_version=example_aws_lambda_function["version"])
        example_function_event_invoke_config = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            qualifier=example.name,
            maximum_event_age_in_seconds=1800,
            maximum_retry_attempts=2,
            destination_config={
                "on_failure": {
                    "destination": production_dlq["arn"],
                },
            })
        ```

        ### Configuration for Published Version

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            qualifier=example_aws_lambda_function["version"],
            maximum_event_age_in_seconds=21600,
            maximum_retry_attempts=2,
            destination_config={
                "on_failure": {
                    "destination": version_dlq["arn"],
                },
                "on_success": {
                    "destination": version_success["arn"],
                },
            })
        ```

        ### Configuration for Latest Version

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            qualifier="$LATEST",
            maximum_event_age_in_seconds=120,
            maximum_retry_attempts=0,
            destination_config={
                "on_failure": {
                    "destination": dev_dlq["arn"],
                },
            })
        ```

        ### Multiple Destination Types

        ```python
        import pulumi
        import pulumi_aws as aws

        # S3 bucket for archiving successful events
        lambda_success_archive = aws.s3.Bucket("lambda_success_archive", bucket=f"lambda-success-archive-{bucket_suffix['hex']}")
        # EventBridge custom bus for failed events
        lambda_failures = aws.cloudwatch.EventBus("lambda_failures", name="lambda-failure-events")
        example = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            destination_config={
                "on_failure": {
                    "destination": lambda_failures.arn,
                },
                "on_success": {
                    "destination": lambda_success_archive.arn,
                },
            })
        ```

        ## Import

        ARN with qualifier:

        Name without qualifier (all versions and aliases):

        Name with qualifier:

        For backwards compatibility, the following legacy `pulumi import` commands are also supported:

        Using ARN without qualifier:

        ```sh
        $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example arn:aws:lambda:us-east-1:123456789012:function:example
        ```
        Using ARN with qualifier:

        ```sh
        $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example arn:aws:lambda:us-east-1:123456789012:function:example:production
        ```
        Name without qualifier (all versions and aliases):

        ```sh
        $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example example
        ```
        Name with qualifier:

        ```sh
        $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example example:production
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FunctionEventInvokeConfigDestinationConfigArgs', 'FunctionEventInvokeConfigDestinationConfigArgsDict']] destination_config: Configuration block with destination configuration. See below.
        :param pulumi.Input[_builtins.str] function_name: Name or ARN of the Lambda Function, omitting any version or alias qualifier.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] maximum_event_age_in_seconds: Maximum age of a request that Lambda sends to a function for processing in seconds. Valid values between 60 and 21600.
        :param pulumi.Input[_builtins.int] maximum_retry_attempts: Maximum number of times to retry when the function returns an error. Valid values between 0 and 2. Defaults to 2.
        :param pulumi.Input[_builtins.str] qualifier: Lambda Function published version, `$LATEST`, or Lambda Alias name.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionEventInvokeConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Lambda Function Event Invoke Config. Use this resource to configure error handling and destinations for asynchronous Lambda function invocations.

        More information about asynchronous invocations and the configurable values can be found in the [Lambda Developer Guide](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html).

        ## Example Usage

        ### Complete Error Handling and Destinations

        > **Note:** Ensure the Lambda Function IAM Role has necessary permissions for the destination, such as `sqs:SendMessage` or `sns:Publish`, otherwise the API will return a generic `InvalidParameterValueException: The destination ARN arn:PARTITION:SERVICE:REGION:ACCOUNT:RESOURCE is invalid.` error.

        ```python
        import pulumi
        import pulumi_aws as aws

        # SQS queue for failed invocations
        dlq = aws.sqs.Queue("dlq",
            name="lambda-dlq",
            tags={
                "Environment": "production",
                "Purpose": "lambda-error-handling",
            })
        # SNS topic for successful invocations
        success = aws.sns.Topic("success",
            name="lambda-success-notifications",
            tags={
                "Environment": "production",
                "Purpose": "lambda-success-notifications",
            })
        # Complete event invoke configuration
        example = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            maximum_event_age_in_seconds=300,
            maximum_retry_attempts=1,
            destination_config={
                "on_failure": {
                    "destination": dlq.arn,
                },
                "on_success": {
                    "destination": success.arn,
                },
            })
        ```

        ### Error Handling Only

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            maximum_event_age_in_seconds=60,
            maximum_retry_attempts=0)
        ```

        ### Configuration for Lambda Alias

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.Alias("example",
            name="production",
            description="Production alias",
            function_name=example_aws_lambda_function["functionName"],
            function_version=example_aws_lambda_function["version"])
        example_function_event_invoke_config = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            qualifier=example.name,
            maximum_event_age_in_seconds=1800,
            maximum_retry_attempts=2,
            destination_config={
                "on_failure": {
                    "destination": production_dlq["arn"],
                },
            })
        ```

        ### Configuration for Published Version

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            qualifier=example_aws_lambda_function["version"],
            maximum_event_age_in_seconds=21600,
            maximum_retry_attempts=2,
            destination_config={
                "on_failure": {
                    "destination": version_dlq["arn"],
                },
                "on_success": {
                    "destination": version_success["arn"],
                },
            })
        ```

        ### Configuration for Latest Version

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            qualifier="$LATEST",
            maximum_event_age_in_seconds=120,
            maximum_retry_attempts=0,
            destination_config={
                "on_failure": {
                    "destination": dev_dlq["arn"],
                },
            })
        ```

        ### Multiple Destination Types

        ```python
        import pulumi
        import pulumi_aws as aws

        # S3 bucket for archiving successful events
        lambda_success_archive = aws.s3.Bucket("lambda_success_archive", bucket=f"lambda-success-archive-{bucket_suffix['hex']}")
        # EventBridge custom bus for failed events
        lambda_failures = aws.cloudwatch.EventBus("lambda_failures", name="lambda-failure-events")
        example = aws.lambda_.FunctionEventInvokeConfig("example",
            function_name=example_aws_lambda_function["functionName"],
            destination_config={
                "on_failure": {
                    "destination": lambda_failures.arn,
                },
                "on_success": {
                    "destination": lambda_success_archive.arn,
                },
            })
        ```

        ## Import

        ARN with qualifier:

        Name without qualifier (all versions and aliases):

        Name with qualifier:

        For backwards compatibility, the following legacy `pulumi import` commands are also supported:

        Using ARN without qualifier:

        ```sh
        $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example arn:aws:lambda:us-east-1:123456789012:function:example
        ```
        Using ARN with qualifier:

        ```sh
        $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example arn:aws:lambda:us-east-1:123456789012:function:example:production
        ```
        Name without qualifier (all versions and aliases):

        ```sh
        $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example example
        ```
        Name with qualifier:

        ```sh
        $ pulumi import aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig example example:production
        ```

        :param str resource_name: The name of the resource.
        :param FunctionEventInvokeConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionEventInvokeConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_config: Optional[pulumi.Input[Union['FunctionEventInvokeConfigDestinationConfigArgs', 'FunctionEventInvokeConfigDestinationConfigArgsDict']]] = None,
                 function_name: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 qualifier: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionEventInvokeConfigArgs.__new__(FunctionEventInvokeConfigArgs)

            __props__.__dict__["destination_config"] = destination_config
            if function_name is None and not opts.urn:
                raise TypeError("Missing required property 'function_name'")
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["maximum_event_age_in_seconds"] = maximum_event_age_in_seconds
            __props__.__dict__["maximum_retry_attempts"] = maximum_retry_attempts
            __props__.__dict__["qualifier"] = qualifier
            __props__.__dict__["region"] = region
        super(FunctionEventInvokeConfig, __self__).__init__(
            'aws:lambda/functionEventInvokeConfig:FunctionEventInvokeConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destination_config: Optional[pulumi.Input[Union['FunctionEventInvokeConfigDestinationConfigArgs', 'FunctionEventInvokeConfigDestinationConfigArgsDict']]] = None,
            function_name: Optional[pulumi.Input[_builtins.str]] = None,
            maximum_event_age_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            maximum_retry_attempts: Optional[pulumi.Input[_builtins.int]] = None,
            qualifier: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'FunctionEventInvokeConfig':
        """
        Get an existing FunctionEventInvokeConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FunctionEventInvokeConfigDestinationConfigArgs', 'FunctionEventInvokeConfigDestinationConfigArgsDict']] destination_config: Configuration block with destination configuration. See below.
        :param pulumi.Input[_builtins.str] function_name: Name or ARN of the Lambda Function, omitting any version or alias qualifier.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] maximum_event_age_in_seconds: Maximum age of a request that Lambda sends to a function for processing in seconds. Valid values between 60 and 21600.
        :param pulumi.Input[_builtins.int] maximum_retry_attempts: Maximum number of times to retry when the function returns an error. Valid values between 0 and 2. Defaults to 2.
        :param pulumi.Input[_builtins.str] qualifier: Lambda Function published version, `$LATEST`, or Lambda Alias name.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionEventInvokeConfigState.__new__(_FunctionEventInvokeConfigState)

        __props__.__dict__["destination_config"] = destination_config
        __props__.__dict__["function_name"] = function_name
        __props__.__dict__["maximum_event_age_in_seconds"] = maximum_event_age_in_seconds
        __props__.__dict__["maximum_retry_attempts"] = maximum_retry_attempts
        __props__.__dict__["qualifier"] = qualifier
        __props__.__dict__["region"] = region
        return FunctionEventInvokeConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> pulumi.Output[Optional['outputs.FunctionEventInvokeConfigDestinationConfig']]:
        """
        Configuration block with destination configuration. See below.
        """
        return pulumi.get(self, "destination_config")

    @_builtins.property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name or ARN of the Lambda Function, omitting any version or alias qualifier.

        The following arguments are optional:
        """
        return pulumi.get(self, "function_name")

    @_builtins.property
    @pulumi.getter(name="maximumEventAgeInSeconds")
    def maximum_event_age_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum age of a request that Lambda sends to a function for processing in seconds. Valid values between 60 and 21600.
        """
        return pulumi.get(self, "maximum_event_age_in_seconds")

    @_builtins.property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum number of times to retry when the function returns an error. Valid values between 0 and 2. Defaults to 2.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Lambda Function published version, `$LATEST`, or Lambda Alias name.
        """
        return pulumi.get(self, "qualifier")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

