# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LayerVersionPermissionArgs', 'LayerVersionPermission']

@pulumi.input_type
class LayerVersionPermissionArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 layer_name: pulumi.Input[_builtins.str],
                 principal: pulumi.Input[_builtins.str],
                 statement_id: pulumi.Input[_builtins.str],
                 version_number: pulumi.Input[_builtins.int],
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a LayerVersionPermission resource.
        :param pulumi.Input[_builtins.str] action: Action that will be allowed. `lambda:GetLayerVersion` is the standard value for layer access.
        :param pulumi.Input[_builtins.str] layer_name: Name or ARN of the Lambda Layer.
        :param pulumi.Input[_builtins.str] principal: AWS account ID that should be able to use your Lambda Layer. Use `*` to share with all AWS accounts.
        :param pulumi.Input[_builtins.str] statement_id: Unique identifier for the permission statement.
        :param pulumi.Input[_builtins.int] version_number: Version of Lambda Layer to grant access to. Note: permissions only apply to a single version of a layer.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] organization_id: AWS Organization ID that should be able to use your Lambda Layer. `principal` should be set to `*` when `organization_id` is provided.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_destroy: Whether to retain the permission when the resource is destroyed. Default is `false`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "layer_name", layer_name)
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "statement_id", statement_id)
        pulumi.set(__self__, "version_number", version_number)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Action that will be allowed. `lambda:GetLayerVersion` is the standard value for layer access.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name or ARN of the Lambda Layer.
        """
        return pulumi.get(self, "layer_name")

    @layer_name.setter
    def layer_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "layer_name", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Input[_builtins.str]:
        """
        AWS account ID that should be able to use your Lambda Layer. Use `*` to share with all AWS accounts.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique identifier for the permission statement.
        """
        return pulumi.get(self, "statement_id")

    @statement_id.setter
    def statement_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "statement_id", value)

    @_builtins.property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> pulumi.Input[_builtins.int]:
        """
        Version of Lambda Layer to grant access to. Note: permissions only apply to a single version of a layer.

        The following arguments are optional:
        """
        return pulumi.get(self, "version_number")

    @version_number.setter
    def version_number(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "version_number", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS Organization ID that should be able to use your Lambda Layer. `principal` should be set to `*` when `organization_id` is provided.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to retain the permission when the resource is destroyed. Default is `false`.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_destroy", value)


@pulumi.input_type
class _LayerVersionPermissionState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 layer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 revision_id: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 statement_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_number: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering LayerVersionPermission resources.
        :param pulumi.Input[_builtins.str] action: Action that will be allowed. `lambda:GetLayerVersion` is the standard value for layer access.
        :param pulumi.Input[_builtins.str] layer_name: Name or ARN of the Lambda Layer.
        :param pulumi.Input[_builtins.str] organization_id: AWS Organization ID that should be able to use your Lambda Layer. `principal` should be set to `*` when `organization_id` is provided.
        :param pulumi.Input[_builtins.str] policy: Full Lambda Layer Permission policy.
        :param pulumi.Input[_builtins.str] principal: AWS account ID that should be able to use your Lambda Layer. Use `*` to share with all AWS accounts.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] revision_id: Unique identifier for the current revision of the policy.
        :param pulumi.Input[_builtins.bool] skip_destroy: Whether to retain the permission when the resource is destroyed. Default is `false`.
        :param pulumi.Input[_builtins.str] statement_id: Unique identifier for the permission statement.
        :param pulumi.Input[_builtins.int] version_number: Version of Lambda Layer to grant access to. Note: permissions only apply to a single version of a layer.
               
               The following arguments are optional:
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if layer_name is not None:
            pulumi.set(__self__, "layer_name", layer_name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)
        if skip_destroy is not None:
            pulumi.set(__self__, "skip_destroy", skip_destroy)
        if statement_id is not None:
            pulumi.set(__self__, "statement_id", statement_id)
        if version_number is not None:
            pulumi.set(__self__, "version_number", version_number)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action that will be allowed. `lambda:GetLayerVersion` is the standard value for layer access.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name or ARN of the Lambda Layer.
        """
        return pulumi.get(self, "layer_name")

    @layer_name.setter
    def layer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "layer_name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS Organization ID that should be able to use your Lambda Layer. `principal` should be set to `*` when `organization_id` is provided.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full Lambda Layer Permission policy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS account ID that should be able to use your Lambda Layer. Use `*` to share with all AWS accounts.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for the current revision of the policy.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision_id", value)

    @_builtins.property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to retain the permission when the resource is destroyed. Default is `false`.
        """
        return pulumi.get(self, "skip_destroy")

    @skip_destroy.setter
    def skip_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_destroy", value)

    @_builtins.property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for the permission statement.
        """
        return pulumi.get(self, "statement_id")

    @statement_id.setter
    def statement_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "statement_id", value)

    @_builtins.property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Version of Lambda Layer to grant access to. Note: permissions only apply to a single version of a layer.

        The following arguments are optional:
        """
        return pulumi.get(self, "version_number")

    @version_number.setter
    def version_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version_number", value)


@pulumi.type_token("aws:lambda/layerVersionPermission:LayerVersionPermission")
class LayerVersionPermission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 layer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 statement_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_number: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages an AWS Lambda Layer Version Permission. Use this resource to share Lambda Layers with other AWS accounts, organizations, or make them publicly accessible.

        For information about Lambda Layer Permissions and how to use them, see [Using Resource-based Policies for AWS Lambda](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountlayer).

        > **Note:** Setting `skip_destroy` to `true` means that the AWS Provider will not destroy any layer version permission, even when running `pulumi destroy`. Layer version permissions are thus intentional dangling resources that are not managed by Pulumi and may incur extra expense in your AWS account.

        ## Example Usage

        ### Share Layer with Specific Account

        ```python
        import pulumi
        import pulumi_aws as aws

        # Lambda layer to share
        example = aws.lambda_.LayerVersion("example",
            code=pulumi.FileArchive("layer.zip"),
            layer_name="shared_utilities",
            description="Common utilities for Lambda functions",
            compatible_runtimes=[
                "nodejs20.x",
                "python3.12",
            ])
        # Grant permission to specific AWS account
        example_layer_version_permission = aws.lambda_.LayerVersionPermission("example",
            layer_name=example.layer_name,
            version_number=example.version,
            principal="123456789012",
            action="lambda:GetLayerVersion",
            statement_id="dev-account-access")
        ```

        ### Share Layer with Organization

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.LayerVersionPermission("example",
            layer_name=example_aws_lambda_layer_version["layerName"],
            version_number=example_aws_lambda_layer_version["version"],
            principal="*",
            organization_id="o-1234567890",
            action="lambda:GetLayerVersion",
            statement_id="org-wide-access")
        ```

        ### Share Layer Publicly

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.LayerVersionPermission("example",
            layer_name=example_aws_lambda_layer_version["layerName"],
            version_number=example_aws_lambda_layer_version["version"],
            principal="*",
            action="lambda:GetLayerVersion",
            statement_id="public-access")
        ```

        ### Multiple Account Access

        ```python
        import pulumi
        import pulumi_aws as aws

        # Share with multiple specific accounts
        dev_account = aws.lambda_.LayerVersionPermission("dev_account",
            layer_name=example["layerName"],
            version_number=example["version"],
            principal="111111111111",
            action="lambda:GetLayerVersion",
            statement_id="dev-account")
        staging_account = aws.lambda_.LayerVersionPermission("staging_account",
            layer_name=example["layerName"],
            version_number=example["version"],
            principal="222222222222",
            action="lambda:GetLayerVersion",
            statement_id="staging-account")
        prod_account = aws.lambda_.LayerVersionPermission("prod_account",
            layer_name=example["layerName"],
            version_number=example["version"],
            principal="333333333333",
            action="lambda:GetLayerVersion",
            statement_id="prod-account")
        ```

        ## Import

        For backwards compatibility, the following legacy `pulumi import` command is also supported:

        ```sh
        $ pulumi import aws:lambda/layerVersionPermission:LayerVersionPermission example arn:aws:lambda:us-west-2:123456789012:layer:shared_utilities,1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action that will be allowed. `lambda:GetLayerVersion` is the standard value for layer access.
        :param pulumi.Input[_builtins.str] layer_name: Name or ARN of the Lambda Layer.
        :param pulumi.Input[_builtins.str] organization_id: AWS Organization ID that should be able to use your Lambda Layer. `principal` should be set to `*` when `organization_id` is provided.
        :param pulumi.Input[_builtins.str] principal: AWS account ID that should be able to use your Lambda Layer. Use `*` to share with all AWS accounts.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] skip_destroy: Whether to retain the permission when the resource is destroyed. Default is `false`.
        :param pulumi.Input[_builtins.str] statement_id: Unique identifier for the permission statement.
        :param pulumi.Input[_builtins.int] version_number: Version of Lambda Layer to grant access to. Note: permissions only apply to a single version of a layer.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LayerVersionPermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Lambda Layer Version Permission. Use this resource to share Lambda Layers with other AWS accounts, organizations, or make them publicly accessible.

        For information about Lambda Layer Permissions and how to use them, see [Using Resource-based Policies for AWS Lambda](https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountlayer).

        > **Note:** Setting `skip_destroy` to `true` means that the AWS Provider will not destroy any layer version permission, even when running `pulumi destroy`. Layer version permissions are thus intentional dangling resources that are not managed by Pulumi and may incur extra expense in your AWS account.

        ## Example Usage

        ### Share Layer with Specific Account

        ```python
        import pulumi
        import pulumi_aws as aws

        # Lambda layer to share
        example = aws.lambda_.LayerVersion("example",
            code=pulumi.FileArchive("layer.zip"),
            layer_name="shared_utilities",
            description="Common utilities for Lambda functions",
            compatible_runtimes=[
                "nodejs20.x",
                "python3.12",
            ])
        # Grant permission to specific AWS account
        example_layer_version_permission = aws.lambda_.LayerVersionPermission("example",
            layer_name=example.layer_name,
            version_number=example.version,
            principal="123456789012",
            action="lambda:GetLayerVersion",
            statement_id="dev-account-access")
        ```

        ### Share Layer with Organization

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.LayerVersionPermission("example",
            layer_name=example_aws_lambda_layer_version["layerName"],
            version_number=example_aws_lambda_layer_version["version"],
            principal="*",
            organization_id="o-1234567890",
            action="lambda:GetLayerVersion",
            statement_id="org-wide-access")
        ```

        ### Share Layer Publicly

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lambda_.LayerVersionPermission("example",
            layer_name=example_aws_lambda_layer_version["layerName"],
            version_number=example_aws_lambda_layer_version["version"],
            principal="*",
            action="lambda:GetLayerVersion",
            statement_id="public-access")
        ```

        ### Multiple Account Access

        ```python
        import pulumi
        import pulumi_aws as aws

        # Share with multiple specific accounts
        dev_account = aws.lambda_.LayerVersionPermission("dev_account",
            layer_name=example["layerName"],
            version_number=example["version"],
            principal="111111111111",
            action="lambda:GetLayerVersion",
            statement_id="dev-account")
        staging_account = aws.lambda_.LayerVersionPermission("staging_account",
            layer_name=example["layerName"],
            version_number=example["version"],
            principal="222222222222",
            action="lambda:GetLayerVersion",
            statement_id="staging-account")
        prod_account = aws.lambda_.LayerVersionPermission("prod_account",
            layer_name=example["layerName"],
            version_number=example["version"],
            principal="333333333333",
            action="lambda:GetLayerVersion",
            statement_id="prod-account")
        ```

        ## Import

        For backwards compatibility, the following legacy `pulumi import` command is also supported:

        ```sh
        $ pulumi import aws:lambda/layerVersionPermission:LayerVersionPermission example arn:aws:lambda:us-west-2:123456789012:layer:shared_utilities,1
        ```

        :param str resource_name: The name of the resource.
        :param LayerVersionPermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LayerVersionPermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 layer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 statement_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version_number: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LayerVersionPermissionArgs.__new__(LayerVersionPermissionArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if layer_name is None and not opts.urn:
                raise TypeError("Missing required property 'layer_name'")
            __props__.__dict__["layer_name"] = layer_name
            __props__.__dict__["organization_id"] = organization_id
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            __props__.__dict__["region"] = region
            __props__.__dict__["skip_destroy"] = skip_destroy
            if statement_id is None and not opts.urn:
                raise TypeError("Missing required property 'statement_id'")
            __props__.__dict__["statement_id"] = statement_id
            if version_number is None and not opts.urn:
                raise TypeError("Missing required property 'version_number'")
            __props__.__dict__["version_number"] = version_number
            __props__.__dict__["policy"] = None
            __props__.__dict__["revision_id"] = None
        super(LayerVersionPermission, __self__).__init__(
            'aws:lambda/layerVersionPermission:LayerVersionPermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            layer_name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            principal: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            revision_id: Optional[pulumi.Input[_builtins.str]] = None,
            skip_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            statement_id: Optional[pulumi.Input[_builtins.str]] = None,
            version_number: Optional[pulumi.Input[_builtins.int]] = None) -> 'LayerVersionPermission':
        """
        Get an existing LayerVersionPermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action that will be allowed. `lambda:GetLayerVersion` is the standard value for layer access.
        :param pulumi.Input[_builtins.str] layer_name: Name or ARN of the Lambda Layer.
        :param pulumi.Input[_builtins.str] organization_id: AWS Organization ID that should be able to use your Lambda Layer. `principal` should be set to `*` when `organization_id` is provided.
        :param pulumi.Input[_builtins.str] policy: Full Lambda Layer Permission policy.
        :param pulumi.Input[_builtins.str] principal: AWS account ID that should be able to use your Lambda Layer. Use `*` to share with all AWS accounts.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] revision_id: Unique identifier for the current revision of the policy.
        :param pulumi.Input[_builtins.bool] skip_destroy: Whether to retain the permission when the resource is destroyed. Default is `false`.
        :param pulumi.Input[_builtins.str] statement_id: Unique identifier for the permission statement.
        :param pulumi.Input[_builtins.int] version_number: Version of Lambda Layer to grant access to. Note: permissions only apply to a single version of a layer.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LayerVersionPermissionState.__new__(_LayerVersionPermissionState)

        __props__.__dict__["action"] = action
        __props__.__dict__["layer_name"] = layer_name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["policy"] = policy
        __props__.__dict__["principal"] = principal
        __props__.__dict__["region"] = region
        __props__.__dict__["revision_id"] = revision_id
        __props__.__dict__["skip_destroy"] = skip_destroy
        __props__.__dict__["statement_id"] = statement_id
        __props__.__dict__["version_number"] = version_number
        return LayerVersionPermission(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        Action that will be allowed. `lambda:GetLayerVersion` is the standard value for layer access.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name or ARN of the Lambda Layer.
        """
        return pulumi.get(self, "layer_name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS Organization ID that should be able to use your Lambda Layer. `principal` should be set to `*` when `organization_id` is provided.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        Full Lambda Layer Permission policy.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Output[_builtins.str]:
        """
        AWS account ID that should be able to use your Lambda Layer. Use `*` to share with all AWS accounts.
        """
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for the current revision of the policy.
        """
        return pulumi.get(self, "revision_id")

    @_builtins.property
    @pulumi.getter(name="skipDestroy")
    def skip_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to retain the permission when the resource is destroyed. Default is `false`.
        """
        return pulumi.get(self, "skip_destroy")

    @_builtins.property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for the permission statement.
        """
        return pulumi.get(self, "statement_id")

    @_builtins.property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> pulumi.Output[_builtins.int]:
        """
        Version of Lambda Layer to grant access to. Note: permissions only apply to a single version of a layer.

        The following arguments are optional:
        """
        return pulumi.get(self, "version_number")

