# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetListenerResult',
    'AwaitableGetListenerResult',
    'get_listener',
    'get_listener_output',
]

@pulumi.output_type
class GetListenerResult:
    """
    A collection of values returned by getListener.
    """
    def __init__(__self__, alpn_policy=None, arn=None, certificate_arn=None, default_actions=None, id=None, load_balancer_arn=None, mutual_authentications=None, port=None, protocol=None, region=None, ssl_policy=None, tags=None):
        if alpn_policy and not isinstance(alpn_policy, str):
            raise TypeError("Expected argument 'alpn_policy' to be a str")
        pulumi.set(__self__, "alpn_policy", alpn_policy)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if certificate_arn and not isinstance(certificate_arn, str):
            raise TypeError("Expected argument 'certificate_arn' to be a str")
        pulumi.set(__self__, "certificate_arn", certificate_arn)
        if default_actions and not isinstance(default_actions, list):
            raise TypeError("Expected argument 'default_actions' to be a list")
        pulumi.set(__self__, "default_actions", default_actions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_balancer_arn and not isinstance(load_balancer_arn, str):
            raise TypeError("Expected argument 'load_balancer_arn' to be a str")
        pulumi.set(__self__, "load_balancer_arn", load_balancer_arn)
        if mutual_authentications and not isinstance(mutual_authentications, list):
            raise TypeError("Expected argument 'mutual_authentications' to be a list")
        pulumi.set(__self__, "mutual_authentications", mutual_authentications)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if ssl_policy and not isinstance(ssl_policy, str):
            raise TypeError("Expected argument 'ssl_policy' to be a str")
        pulumi.set(__self__, "ssl_policy", ssl_policy)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> _builtins.str:
        return pulumi.get(self, "alpn_policy")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> _builtins.str:
        return pulumi.get(self, "certificate_arn")

    @_builtins.property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> Sequence['outputs.GetListenerDefaultActionResult']:
        return pulumi.get(self, "default_actions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> _builtins.str:
        return pulumi.get(self, "load_balancer_arn")

    @_builtins.property
    @pulumi.getter(name="mutualAuthentications")
    def mutual_authentications(self) -> Sequence['outputs.GetListenerMutualAuthenticationResult']:
        return pulumi.get(self, "mutual_authentications")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> _builtins.str:
        return pulumi.get(self, "ssl_policy")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "tags")


class AwaitableGetListenerResult(GetListenerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListenerResult(
            alpn_policy=self.alpn_policy,
            arn=self.arn,
            certificate_arn=self.certificate_arn,
            default_actions=self.default_actions,
            id=self.id,
            load_balancer_arn=self.load_balancer_arn,
            mutual_authentications=self.mutual_authentications,
            port=self.port,
            protocol=self.protocol,
            region=self.region,
            ssl_policy=self.ssl_policy,
            tags=self.tags)


def get_listener(arn: Optional[_builtins.str] = None,
                 load_balancer_arn: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 region: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListenerResult:
    """
    > **Note:** `alb.Listener` is known as `lb.Listener`. The functionality is identical.

    Provides information about a Load Balancer Listener.

    This data source can prove useful when a module accepts an LB Listener as an input variable and needs to know the LB it is attached to, or other information specific to the listener in question.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    listener_arn = config.require("listenerArn")
    listener = aws.lb.get_listener(arn=listener_arn)
    # get listener from load_balancer_arn and port
    selected = aws.lb.get_load_balancer(name="default-public")
    selected443 = aws.lb.get_listener(load_balancer_arn=selected.arn,
        port=443)
    ```


    :param _builtins.str arn: ARN of the listener. Required if `load_balancer_arn` and `port` is not set.
    :param _builtins.str load_balancer_arn: ARN of the load balancer. Required if `arn` is not set.
    :param _builtins.int port: Port of the listener. Required if `arn` is not set.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['loadBalancerArn'] = load_balancer_arn
    __args__['port'] = port
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lb/getListener:getListener', __args__, opts=opts, typ=GetListenerResult).value

    return AwaitableGetListenerResult(
        alpn_policy=pulumi.get(__ret__, 'alpn_policy'),
        arn=pulumi.get(__ret__, 'arn'),
        certificate_arn=pulumi.get(__ret__, 'certificate_arn'),
        default_actions=pulumi.get(__ret__, 'default_actions'),
        id=pulumi.get(__ret__, 'id'),
        load_balancer_arn=pulumi.get(__ret__, 'load_balancer_arn'),
        mutual_authentications=pulumi.get(__ret__, 'mutual_authentications'),
        port=pulumi.get(__ret__, 'port'),
        protocol=pulumi.get(__ret__, 'protocol'),
        region=pulumi.get(__ret__, 'region'),
        ssl_policy=pulumi.get(__ret__, 'ssl_policy'),
        tags=pulumi.get(__ret__, 'tags'))
def get_listener_output(arn: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        load_balancer_arn: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        port: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListenerResult]:
    """
    > **Note:** `alb.Listener` is known as `lb.Listener`. The functionality is identical.

    Provides information about a Load Balancer Listener.

    This data source can prove useful when a module accepts an LB Listener as an input variable and needs to know the LB it is attached to, or other information specific to the listener in question.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    config = pulumi.Config()
    listener_arn = config.require("listenerArn")
    listener = aws.lb.get_listener(arn=listener_arn)
    # get listener from load_balancer_arn and port
    selected = aws.lb.get_load_balancer(name="default-public")
    selected443 = aws.lb.get_listener(load_balancer_arn=selected.arn,
        port=443)
    ```


    :param _builtins.str arn: ARN of the listener. Required if `load_balancer_arn` and `port` is not set.
    :param _builtins.str load_balancer_arn: ARN of the load balancer. Required if `arn` is not set.
    :param _builtins.int port: Port of the listener. Required if `arn` is not set.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    __args__['loadBalancerArn'] = load_balancer_arn
    __args__['port'] = port
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lb/getListener:getListener', __args__, opts=opts, typ=GetListenerResult)
    return __ret__.apply(lambda __response__: GetListenerResult(
        alpn_policy=pulumi.get(__response__, 'alpn_policy'),
        arn=pulumi.get(__response__, 'arn'),
        certificate_arn=pulumi.get(__response__, 'certificate_arn'),
        default_actions=pulumi.get(__response__, 'default_actions'),
        id=pulumi.get(__response__, 'id'),
        load_balancer_arn=pulumi.get(__response__, 'load_balancer_arn'),
        mutual_authentications=pulumi.get(__response__, 'mutual_authentications'),
        port=pulumi.get(__response__, 'port'),
        protocol=pulumi.get(__response__, 'protocol'),
        region=pulumi.get(__response__, 'region'),
        ssl_policy=pulumi.get(__response__, 'ssl_policy'),
        tags=pulumi.get(__response__, 'tags')))
