# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBotAliasResult',
    'AwaitableGetBotAliasResult',
    'get_bot_alias',
    'get_bot_alias_output',
]

@pulumi.output_type
class GetBotAliasResult:
    """
    A collection of values returned by getBotAlias.
    """
    def __init__(__self__, arn=None, bot_name=None, bot_version=None, checksum=None, created_date=None, description=None, id=None, last_updated_date=None, name=None, region=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if bot_name and not isinstance(bot_name, str):
            raise TypeError("Expected argument 'bot_name' to be a str")
        pulumi.set(__self__, "bot_name", bot_name)
        if bot_version and not isinstance(bot_version, str):
            raise TypeError("Expected argument 'bot_version' to be a str")
        pulumi.set(__self__, "bot_version", bot_version)
        if checksum and not isinstance(checksum, str):
            raise TypeError("Expected argument 'checksum' to be a str")
        pulumi.set(__self__, "checksum", checksum)
        if created_date and not isinstance(created_date, str):
            raise TypeError("Expected argument 'created_date' to be a str")
        pulumi.set(__self__, "created_date", created_date)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_date and not isinstance(last_updated_date, str):
            raise TypeError("Expected argument 'last_updated_date' to be a str")
        pulumi.set(__self__, "last_updated_date", last_updated_date)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the bot alias.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="botName")
    def bot_name(self) -> _builtins.str:
        """
        Name of the bot.
        """
        return pulumi.get(self, "bot_name")

    @_builtins.property
    @pulumi.getter(name="botVersion")
    def bot_version(self) -> _builtins.str:
        """
        Version of the bot that the alias points to.
        """
        return pulumi.get(self, "bot_version")

    @_builtins.property
    @pulumi.getter
    def checksum(self) -> _builtins.str:
        """
        Checksum of the bot alias.
        """
        return pulumi.get(self, "checksum")

    @_builtins.property
    @pulumi.getter(name="createdDate")
    def created_date(self) -> _builtins.str:
        """
        Date that the bot alias was created.
        """
        return pulumi.get(self, "created_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the alias.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedDate")
    def last_updated_date(self) -> _builtins.str:
        """
        Date that the bot alias was updated. When you create a resource, the creation date and the last updated date are the same.
        """
        return pulumi.get(self, "last_updated_date")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the alias. The name is not case sensitive.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetBotAliasResult(GetBotAliasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBotAliasResult(
            arn=self.arn,
            bot_name=self.bot_name,
            bot_version=self.bot_version,
            checksum=self.checksum,
            created_date=self.created_date,
            description=self.description,
            id=self.id,
            last_updated_date=self.last_updated_date,
            name=self.name,
            region=self.region)


def get_bot_alias(bot_name: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBotAliasResult:
    """
    Provides details about a specific Amazon Lex Bot Alias.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    order_flowers_prod = aws.lex.get_bot_alias(bot_name="OrderFlowers",
        name="OrderFlowersProd")
    ```


    :param _builtins.str bot_name: Name of the bot.
    :param _builtins.str name: Name of the bot alias. The name is case sensitive.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['botName'] = bot_name
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:lex/getBotAlias:getBotAlias', __args__, opts=opts, typ=GetBotAliasResult).value

    return AwaitableGetBotAliasResult(
        arn=pulumi.get(__ret__, 'arn'),
        bot_name=pulumi.get(__ret__, 'bot_name'),
        bot_version=pulumi.get(__ret__, 'bot_version'),
        checksum=pulumi.get(__ret__, 'checksum'),
        created_date=pulumi.get(__ret__, 'created_date'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_date=pulumi.get(__ret__, 'last_updated_date'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'))
def get_bot_alias_output(bot_name: Optional[pulumi.Input[_builtins.str]] = None,
                         name: Optional[pulumi.Input[_builtins.str]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBotAliasResult]:
    """
    Provides details about a specific Amazon Lex Bot Alias.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    order_flowers_prod = aws.lex.get_bot_alias(bot_name="OrderFlowers",
        name="OrderFlowersProd")
    ```


    :param _builtins.str bot_name: Name of the bot.
    :param _builtins.str name: Name of the bot alias. The name is case sensitive.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['botName'] = bot_name
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:lex/getBotAlias:getBotAlias', __args__, opts=opts, typ=GetBotAliasResult)
    return __ret__.apply(lambda __response__: GetBotAliasResult(
        arn=pulumi.get(__response__, 'arn'),
        bot_name=pulumi.get(__response__, 'bot_name'),
        bot_version=pulumi.get(__response__, 'bot_version'),
        checksum=pulumi.get(__response__, 'checksum'),
        created_date=pulumi.get(__response__, 'created_date'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        last_updated_date=pulumi.get(__response__, 'last_updated_date'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region')))
