# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[_builtins.str],
                 blueprint_id: pulumi.Input[_builtins.str],
                 bundle_id: pulumi.Input[_builtins.str],
                 add_on: Optional[pulumi.Input['InstanceAddOnArgs']] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] availability_zone: Availability Zone in which to create your instance. A list of available zones can be obtained using the AWS CLI command: [`aws lightsail get-regions --include-availability-zones`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-regions.html).
        :param pulumi.Input[_builtins.str] blueprint_id: ID for a virtual private server image. A list of available blueprint IDs can be obtained using the AWS CLI command: [`aws lightsail get-blueprints`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-blueprints.html).
        :param pulumi.Input[_builtins.str] bundle_id: Bundle of specification information. A list of available bundle IDs can be obtained using the AWS CLI command: [`aws lightsail get-bundles`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-bundles.html).
        :param pulumi.Input['InstanceAddOnArgs'] add_on: Add-on configuration for the instance. See below.
        :param pulumi.Input[_builtins.str] ip_address_type: IP address type of the Lightsail Instance. Valid values: `dualstack`, `ipv4`, `ipv6`. Default: `dualstack`.
        :param pulumi.Input[_builtins.str] key_pair_name: Name of your key pair. Created in the Lightsail console (cannot use `ec2.KeyPair` at this time).
        :param pulumi.Input[_builtins.str] name: Name of the Lightsail Instance. Names must be unique within each AWS Region in your Lightsail account.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] user_data: Single lined launch script as a string to configure server with additional user data.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "blueprint_id", blueprint_id)
        pulumi.set(__self__, "bundle_id", bundle_id)
        if add_on is not None:
            pulumi.set(__self__, "add_on", add_on)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[_builtins.str]:
        """
        Availability Zone in which to create your instance. A list of available zones can be obtained using the AWS CLI command: [`aws lightsail get-regions --include-availability-zones`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-regions.html).
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="blueprintId")
    def blueprint_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID for a virtual private server image. A list of available blueprint IDs can be obtained using the AWS CLI command: [`aws lightsail get-blueprints`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-blueprints.html).
        """
        return pulumi.get(self, "blueprint_id")

    @blueprint_id.setter
    def blueprint_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "blueprint_id", value)

    @_builtins.property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Input[_builtins.str]:
        """
        Bundle of specification information. A list of available bundle IDs can be obtained using the AWS CLI command: [`aws lightsail get-bundles`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-bundles.html).
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bundle_id", value)

    @_builtins.property
    @pulumi.getter(name="addOn")
    def add_on(self) -> Optional[pulumi.Input['InstanceAddOnArgs']]:
        """
        Add-on configuration for the instance. See below.
        """
        return pulumi.get(self, "add_on")

    @add_on.setter
    def add_on(self, value: Optional[pulumi.Input['InstanceAddOnArgs']]):
        pulumi.set(self, "add_on", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address type of the Lightsail Instance. Valid values: `dualstack`, `ipv4`, `ipv6`. Default: `dualstack`.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of your key pair. Created in the Lightsail console (cannot use `ec2.KeyPair` at this time).
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Lightsail Instance. Names must be unique within each AWS Region in your Lightsail account.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Single lined launch script as a string to configure server with additional user data.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 add_on: Optional[pulumi.Input['InstanceAddOnArgs']] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 blueprint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_static_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ram_size: Optional[pulumi.Input[_builtins.float]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input['InstanceAddOnArgs'] add_on: Add-on configuration for the instance. See below.
        :param pulumi.Input[_builtins.str] arn: ARN of the Lightsail instance (matches `id`).
        :param pulumi.Input[_builtins.str] availability_zone: Availability Zone in which to create your instance. A list of available zones can be obtained using the AWS CLI command: [`aws lightsail get-regions --include-availability-zones`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-regions.html).
        :param pulumi.Input[_builtins.str] blueprint_id: ID for a virtual private server image. A list of available blueprint IDs can be obtained using the AWS CLI command: [`aws lightsail get-blueprints`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-blueprints.html).
        :param pulumi.Input[_builtins.str] bundle_id: Bundle of specification information. A list of available bundle IDs can be obtained using the AWS CLI command: [`aws lightsail get-bundles`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-bundles.html).
        :param pulumi.Input[_builtins.int] cpu_count: Number of vCPUs the instance has.
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the instance was created.
        :param pulumi.Input[_builtins.str] ip_address_type: IP address type of the Lightsail Instance. Valid values: `dualstack`, `ipv4`, `ipv6`. Default: `dualstack`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: List of IPv6 addresses for the Lightsail instance.
        :param pulumi.Input[_builtins.bool] is_static_ip: Whether this instance has a static IP assigned to it.
        :param pulumi.Input[_builtins.str] key_pair_name: Name of your key pair. Created in the Lightsail console (cannot use `ec2.KeyPair` at this time).
        :param pulumi.Input[_builtins.str] name: Name of the Lightsail Instance. Names must be unique within each AWS Region in your Lightsail account.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] private_ip_address: Private IP address of the instance.
        :param pulumi.Input[_builtins.str] public_ip_address: Public IP address of the instance.
        :param pulumi.Input[_builtins.float] ram_size: Amount of RAM in GB on the instance (e.g., 1.0).
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] user_data: Single lined launch script as a string to configure server with additional user data.
        :param pulumi.Input[_builtins.str] username: User name for connecting to the instance (e.g., ec2-user).
        """
        if add_on is not None:
            pulumi.set(__self__, "add_on", add_on)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if blueprint_id is not None:
            pulumi.set(__self__, "blueprint_id", blueprint_id)
        if bundle_id is not None:
            pulumi.set(__self__, "bundle_id", bundle_id)
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if is_static_ip is not None:
            pulumi.set(__self__, "is_static_ip", is_static_ip)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if ram_size is not None:
            pulumi.set(__self__, "ram_size", ram_size)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="addOn")
    def add_on(self) -> Optional[pulumi.Input['InstanceAddOnArgs']]:
        """
        Add-on configuration for the instance. See below.
        """
        return pulumi.get(self, "add_on")

    @add_on.setter
    def add_on(self, value: Optional[pulumi.Input['InstanceAddOnArgs']]):
        pulumi.set(self, "add_on", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Lightsail instance (matches `id`).
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Availability Zone in which to create your instance. A list of available zones can be obtained using the AWS CLI command: [`aws lightsail get-regions --include-availability-zones`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-regions.html).
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="blueprintId")
    def blueprint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID for a virtual private server image. A list of available blueprint IDs can be obtained using the AWS CLI command: [`aws lightsail get-blueprints`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-blueprints.html).
        """
        return pulumi.get(self, "blueprint_id")

    @blueprint_id.setter
    def blueprint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "blueprint_id", value)

    @_builtins.property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bundle of specification information. A list of available bundle IDs can be obtained using the AWS CLI command: [`aws lightsail get-bundles`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-bundles.html).
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bundle_id", value)

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of vCPUs the instance has.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_count", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the instance was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IP address type of the Lightsail Instance. Valid values: `dualstack`, `ipv4`, `ipv6`. Default: `dualstack`.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of IPv6 addresses for the Lightsail instance.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @_builtins.property
    @pulumi.getter(name="isStaticIp")
    def is_static_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this instance has a static IP assigned to it.
        """
        return pulumi.get(self, "is_static_ip")

    @is_static_ip.setter
    def is_static_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_static_ip", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of your key pair. Created in the Lightsail console (cannot use `ec2.KeyPair` at this time).
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Lightsail Instance. Names must be unique within each AWS Region in your Lightsail account.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP address of the instance.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Public IP address of the instance.
        """
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="ramSize")
    def ram_size(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Amount of RAM in GB on the instance (e.g., 1.0).
        """
        return pulumi.get(self, "ram_size")

    @ram_size.setter
    def ram_size(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "ram_size", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Single lined launch script as a string to configure server with additional user data.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User name for connecting to the instance (e.g., ec2-user).
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("aws:lightsail/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_on: Optional[pulumi.Input[Union['InstanceAddOnArgs', 'InstanceAddOnArgsDict']]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 blueprint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Lightsail Instance. Use this resource to create easy virtual private servers with custom software already setup.

        > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.Instance("example",
            name="example",
            availability_zone="us-east-1b",
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0",
            key_pair_name="some_key_name",
            tags={
                "foo": "bar",
            })
        ```

        ### Example With User Data

        Lightsail user data is handled differently than EC2 user data. Lightsail user data only accepts a single lined string. The below example shows installing apache and creating the index page.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.Instance("example",
            name="example",
            availability_zone="us-east-1b",
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0",
            user_data="sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html")
        ```

        ### Enable Auto Snapshots

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.Instance("example",
            name="example",
            availability_zone="us-east-1b",
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0",
            add_on={
                "type": "AutoSnapshot",
                "snapshot_time": "06:00",
                "status": "Enabled",
            },
            tags={
                "foo": "bar",
            })
        ```

        ## Import

        Using `pulumi import`, import Lightsail Instances using their name. For example:

        ```sh
        $ pulumi import aws:lightsail/instance:Instance example 'example'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceAddOnArgs', 'InstanceAddOnArgsDict']] add_on: Add-on configuration for the instance. See below.
        :param pulumi.Input[_builtins.str] availability_zone: Availability Zone in which to create your instance. A list of available zones can be obtained using the AWS CLI command: [`aws lightsail get-regions --include-availability-zones`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-regions.html).
        :param pulumi.Input[_builtins.str] blueprint_id: ID for a virtual private server image. A list of available blueprint IDs can be obtained using the AWS CLI command: [`aws lightsail get-blueprints`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-blueprints.html).
        :param pulumi.Input[_builtins.str] bundle_id: Bundle of specification information. A list of available bundle IDs can be obtained using the AWS CLI command: [`aws lightsail get-bundles`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-bundles.html).
        :param pulumi.Input[_builtins.str] ip_address_type: IP address type of the Lightsail Instance. Valid values: `dualstack`, `ipv4`, `ipv6`. Default: `dualstack`.
        :param pulumi.Input[_builtins.str] key_pair_name: Name of your key pair. Created in the Lightsail console (cannot use `ec2.KeyPair` at this time).
        :param pulumi.Input[_builtins.str] name: Name of the Lightsail Instance. Names must be unique within each AWS Region in your Lightsail account.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] user_data: Single lined launch script as a string to configure server with additional user data.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Lightsail Instance. Use this resource to create easy virtual private servers with custom software already setup.

        > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.Instance("example",
            name="example",
            availability_zone="us-east-1b",
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0",
            key_pair_name="some_key_name",
            tags={
                "foo": "bar",
            })
        ```

        ### Example With User Data

        Lightsail user data is handled differently than EC2 user data. Lightsail user data only accepts a single lined string. The below example shows installing apache and creating the index page.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.Instance("example",
            name="example",
            availability_zone="us-east-1b",
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0",
            user_data="sudo yum install -y httpd && sudo systemctl start httpd && sudo systemctl enable httpd && echo '<h1>Deployed via Pulumi</h1>' | sudo tee /var/www/html/index.html")
        ```

        ### Enable Auto Snapshots

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.Instance("example",
            name="example",
            availability_zone="us-east-1b",
            blueprint_id="amazon_linux_2",
            bundle_id="nano_3_0",
            add_on={
                "type": "AutoSnapshot",
                "snapshot_time": "06:00",
                "status": "Enabled",
            },
            tags={
                "foo": "bar",
            })
        ```

        ## Import

        Using `pulumi import`, import Lightsail Instances using their name. For example:

        ```sh
        $ pulumi import aws:lightsail/instance:Instance example 'example'
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_on: Optional[pulumi.Input[Union['InstanceAddOnArgs', 'InstanceAddOnArgsDict']]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 blueprint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["add_on"] = add_on
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            if blueprint_id is None and not opts.urn:
                raise TypeError("Missing required property 'blueprint_id'")
            __props__.__dict__["blueprint_id"] = blueprint_id
            if bundle_id is None and not opts.urn:
                raise TypeError("Missing required property 'bundle_id'")
            __props__.__dict__["bundle_id"] = bundle_id
            __props__.__dict__["ip_address_type"] = ip_address_type
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["arn"] = None
            __props__.__dict__["cpu_count"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["ipv6_addresses"] = None
            __props__.__dict__["is_static_ip"] = None
            __props__.__dict__["private_ip_address"] = None
            __props__.__dict__["public_ip_address"] = None
            __props__.__dict__["ram_size"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["username"] = None
        super(Instance, __self__).__init__(
            'aws:lightsail/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            add_on: Optional[pulumi.Input[Union['InstanceAddOnArgs', 'InstanceAddOnArgsDict']]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            blueprint_id: Optional[pulumi.Input[_builtins.str]] = None,
            bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
            cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            is_static_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            ram_size: Optional[pulumi.Input[_builtins.float]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceAddOnArgs', 'InstanceAddOnArgsDict']] add_on: Add-on configuration for the instance. See below.
        :param pulumi.Input[_builtins.str] arn: ARN of the Lightsail instance (matches `id`).
        :param pulumi.Input[_builtins.str] availability_zone: Availability Zone in which to create your instance. A list of available zones can be obtained using the AWS CLI command: [`aws lightsail get-regions --include-availability-zones`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-regions.html).
        :param pulumi.Input[_builtins.str] blueprint_id: ID for a virtual private server image. A list of available blueprint IDs can be obtained using the AWS CLI command: [`aws lightsail get-blueprints`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-blueprints.html).
        :param pulumi.Input[_builtins.str] bundle_id: Bundle of specification information. A list of available bundle IDs can be obtained using the AWS CLI command: [`aws lightsail get-bundles`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-bundles.html).
        :param pulumi.Input[_builtins.int] cpu_count: Number of vCPUs the instance has.
        :param pulumi.Input[_builtins.str] created_at: Timestamp when the instance was created.
        :param pulumi.Input[_builtins.str] ip_address_type: IP address type of the Lightsail Instance. Valid values: `dualstack`, `ipv4`, `ipv6`. Default: `dualstack`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv6_addresses: List of IPv6 addresses for the Lightsail instance.
        :param pulumi.Input[_builtins.bool] is_static_ip: Whether this instance has a static IP assigned to it.
        :param pulumi.Input[_builtins.str] key_pair_name: Name of your key pair. Created in the Lightsail console (cannot use `ec2.KeyPair` at this time).
        :param pulumi.Input[_builtins.str] name: Name of the Lightsail Instance. Names must be unique within each AWS Region in your Lightsail account.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] private_ip_address: Private IP address of the instance.
        :param pulumi.Input[_builtins.str] public_ip_address: Public IP address of the instance.
        :param pulumi.Input[_builtins.float] ram_size: Amount of RAM in GB on the instance (e.g., 1.0).
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] user_data: Single lined launch script as a string to configure server with additional user data.
        :param pulumi.Input[_builtins.str] username: User name for connecting to the instance (e.g., ec2-user).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["add_on"] = add_on
        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["blueprint_id"] = blueprint_id
        __props__.__dict__["bundle_id"] = bundle_id
        __props__.__dict__["cpu_count"] = cpu_count
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["ip_address_type"] = ip_address_type
        __props__.__dict__["ipv6_addresses"] = ipv6_addresses
        __props__.__dict__["is_static_ip"] = is_static_ip
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["name"] = name
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["public_ip_address"] = public_ip_address
        __props__.__dict__["ram_size"] = ram_size
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["username"] = username
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addOn")
    def add_on(self) -> pulumi.Output[Optional['outputs.InstanceAddOn']]:
        """
        Add-on configuration for the instance. See below.
        """
        return pulumi.get(self, "add_on")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Lightsail instance (matches `id`).
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Availability Zone in which to create your instance. A list of available zones can be obtained using the AWS CLI command: [`aws lightsail get-regions --include-availability-zones`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-regions.html).
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="blueprintId")
    def blueprint_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID for a virtual private server image. A list of available blueprint IDs can be obtained using the AWS CLI command: [`aws lightsail get-blueprints`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-blueprints.html).
        """
        return pulumi.get(self, "blueprint_id")

    @_builtins.property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Output[_builtins.str]:
        """
        Bundle of specification information. A list of available bundle IDs can be obtained using the AWS CLI command: [`aws lightsail get-bundles`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/lightsail/get-bundles.html).
        """
        return pulumi.get(self, "bundle_id")

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of vCPUs the instance has.
        """
        return pulumi.get(self, "cpu_count")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the instance was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IP address type of the Lightsail Instance. Valid values: `dualstack`, `ipv4`, `ipv6`. Default: `dualstack`.
        """
        return pulumi.get(self, "ip_address_type")

    @_builtins.property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of IPv6 addresses for the Lightsail instance.
        """
        return pulumi.get(self, "ipv6_addresses")

    @_builtins.property
    @pulumi.getter(name="isStaticIp")
    def is_static_ip(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this instance has a static IP assigned to it.
        """
        return pulumi.get(self, "is_static_ip")

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of your key pair. Created in the Lightsail console (cannot use `ec2.KeyPair` at this time).
        """
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Lightsail Instance. Names must be unique within each AWS Region in your Lightsail account.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        Private IP address of the instance.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        Public IP address of the instance.
        """
        return pulumi.get(self, "public_ip_address")

    @_builtins.property
    @pulumi.getter(name="ramSize")
    def ram_size(self) -> pulumi.Output[_builtins.float]:
        """
        Amount of RAM in GB on the instance (e.g., 1.0).
        """
        return pulumi.get(self, "ram_size")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Single lined launch script as a string to configure server with additional user data.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        User name for connecting to the instance (e.g., ec2-user).
        """
        return pulumi.get(self, "username")

