# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['StaticIpAttachmentArgs', 'StaticIpAttachment']

@pulumi.input_type
class StaticIpAttachmentArgs:
    def __init__(__self__, *,
                 instance_name: pulumi.Input[_builtins.str],
                 static_ip_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StaticIpAttachment resource.
        :param pulumi.Input[_builtins.str] instance_name: Name of the Lightsail instance to attach the IP to.
        :param pulumi.Input[_builtins.str] static_ip_name: Name of the allocated static IP.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "static_ip_name", static_ip_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Lightsail instance to attach the IP to.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="staticIpName")
    def static_ip_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the allocated static IP.

        The following arguments are optional:
        """
        return pulumi.get(self, "static_ip_name")

    @static_ip_name.setter
    def static_ip_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "static_ip_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _StaticIpAttachmentState:
    def __init__(__self__, *,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 static_ip_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StaticIpAttachment resources.
        :param pulumi.Input[_builtins.str] instance_name: Name of the Lightsail instance to attach the IP to.
        :param pulumi.Input[_builtins.str] ip_address: Allocated static IP address.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] static_ip_name: Name of the allocated static IP.
               
               The following arguments are optional:
        """
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if static_ip_name is not None:
            pulumi.set(__self__, "static_ip_name", static_ip_name)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Lightsail instance to attach the IP to.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allocated static IP address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="staticIpName")
    def static_ip_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the allocated static IP.

        The following arguments are optional:
        """
        return pulumi.get(self, "static_ip_name")

    @static_ip_name.setter
    def static_ip_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "static_ip_name", value)


@pulumi.type_token("aws:lightsail/staticIpAttachment:StaticIpAttachment")
class StaticIpAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 static_ip_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a static IP address attachment - relationship between a Lightsail static IP and Lightsail instance.

        Use this resource to attach a static IP address to a Lightsail instance to provide a consistent public IP address that persists across instance restarts.

        > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.StaticIp("example", name="example")
        example_instance = aws.lightsail.Instance("example",
            name="example",
            availability_zone="us-east-1a",
            blueprint_id="ubuntu_20_04",
            bundle_id="nano_2_0")
        example_static_ip_attachment = aws.lightsail.StaticIpAttachment("example",
            static_ip_name=example.id,
            instance_name=example_instance.id)
        ```

        ## Import

        Using `pulumi import`, import `aws_lightsail_static_ip_attachment` using the static IP name. For example:

        ```sh
        $ pulumi import aws:lightsail/staticIpAttachment:StaticIpAttachment example example-static-ip
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_name: Name of the Lightsail instance to attach the IP to.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] static_ip_name: Name of the allocated static IP.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StaticIpAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a static IP address attachment - relationship between a Lightsail static IP and Lightsail instance.

        Use this resource to attach a static IP address to a Lightsail instance to provide a consistent public IP address that persists across instance restarts.

        > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail) for more details.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lightsail.StaticIp("example", name="example")
        example_instance = aws.lightsail.Instance("example",
            name="example",
            availability_zone="us-east-1a",
            blueprint_id="ubuntu_20_04",
            bundle_id="nano_2_0")
        example_static_ip_attachment = aws.lightsail.StaticIpAttachment("example",
            static_ip_name=example.id,
            instance_name=example_instance.id)
        ```

        ## Import

        Using `pulumi import`, import `aws_lightsail_static_ip_attachment` using the static IP name. For example:

        ```sh
        $ pulumi import aws:lightsail/staticIpAttachment:StaticIpAttachment example example-static-ip
        ```

        :param str resource_name: The name of the resource.
        :param StaticIpAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StaticIpAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 static_ip_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StaticIpAttachmentArgs.__new__(StaticIpAttachmentArgs)

            if instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'instance_name'")
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["region"] = region
            if static_ip_name is None and not opts.urn:
                raise TypeError("Missing required property 'static_ip_name'")
            __props__.__dict__["static_ip_name"] = static_ip_name
            __props__.__dict__["ip_address"] = None
        super(StaticIpAttachment, __self__).__init__(
            'aws:lightsail/staticIpAttachment:StaticIpAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            static_ip_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'StaticIpAttachment':
        """
        Get an existing StaticIpAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_name: Name of the Lightsail instance to attach the IP to.
        :param pulumi.Input[_builtins.str] ip_address: Allocated static IP address.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] static_ip_name: Name of the allocated static IP.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StaticIpAttachmentState.__new__(_StaticIpAttachmentState)

        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["region"] = region
        __props__.__dict__["static_ip_name"] = static_ip_name
        return StaticIpAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Lightsail instance to attach the IP to.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        Allocated static IP address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="staticIpName")
    def static_ip_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the allocated static IP.

        The following arguments are optional:
        """
        return pulumi.get(self, "static_ip_name")

