# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMapResult',
    'AwaitableGetMapResult',
    'get_map',
    'get_map_output',
]

@pulumi.output_type
class GetMapResult:
    """
    A collection of values returned by getMap.
    """
    def __init__(__self__, configurations=None, create_time=None, description=None, id=None, map_arn=None, map_name=None, region=None, tags=None, update_time=None):
        if configurations and not isinstance(configurations, list):
            raise TypeError("Expected argument 'configurations' to be a list")
        pulumi.set(__self__, "configurations", configurations)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if map_arn and not isinstance(map_arn, str):
            raise TypeError("Expected argument 'map_arn' to be a str")
        pulumi.set(__self__, "map_arn", map_arn)
        if map_name and not isinstance(map_name, str):
            raise TypeError("Expected argument 'map_name' to be a str")
        pulumi.set(__self__, "map_name", map_name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetMapConfigurationResult']:
        """
        List of configurations that specify the map tile style selected from a partner data provider.
        """
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Timestamp for when the map resource was created in ISO 8601 format.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Optional description for the map resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mapArn")
    def map_arn(self) -> _builtins.str:
        """
        ARN for the map resource.
        """
        return pulumi.get(self, "map_arn")

    @_builtins.property
    @pulumi.getter(name="mapName")
    def map_name(self) -> _builtins.str:
        return pulumi.get(self, "map_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value map of resource tags for the map.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        Timestamp for when the map resource was last updated in ISO 8601 format.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetMapResult(GetMapResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMapResult(
            configurations=self.configurations,
            create_time=self.create_time,
            description=self.description,
            id=self.id,
            map_arn=self.map_arn,
            map_name=self.map_name,
            region=self.region,
            tags=self.tags,
            update_time=self.update_time)


def get_map(map_name: Optional[_builtins.str] = None,
            region: Optional[_builtins.str] = None,
            tags: Optional[Mapping[str, _builtins.str]] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMapResult:
    """
    Retrieve information about a Location Service Map.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.location.get_map(map_name="example")
    ```


    :param _builtins.str map_name: Name of the map resource.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags for the map.
    """
    __args__ = dict()
    __args__['mapName'] = map_name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:location/getMap:getMap', __args__, opts=opts, typ=GetMapResult).value

    return AwaitableGetMapResult(
        configurations=pulumi.get(__ret__, 'configurations'),
        create_time=pulumi.get(__ret__, 'create_time'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        map_arn=pulumi.get(__ret__, 'map_arn'),
        map_name=pulumi.get(__ret__, 'map_name'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_map_output(map_name: Optional[pulumi.Input[_builtins.str]] = None,
                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMapResult]:
    """
    Retrieve information about a Location Service Map.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.location.get_map(map_name="example")
    ```


    :param _builtins.str map_name: Name of the map resource.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Key-value map of resource tags for the map.
    """
    __args__ = dict()
    __args__['mapName'] = map_name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:location/getMap:getMap', __args__, opts=opts, typ=GetMapResult)
    return __ret__.apply(lambda __response__: GetMapResult(
        configurations=pulumi.get(__response__, 'configurations'),
        create_time=pulumi.get(__response__, 'create_time'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        map_arn=pulumi.get(__response__, 'map_arn'),
        map_name=pulumi.get(__response__, 'map_name'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        update_time=pulumi.get(__response__, 'update_time')))
