# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TrackerAssociationArgs', 'TrackerAssociation']

@pulumi.input_type
class TrackerAssociationArgs:
    def __init__(__self__, *,
                 consumer_arn: pulumi.Input[_builtins.str],
                 tracker_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TrackerAssociation resource.
        :param pulumi.Input[_builtins.str] consumer_arn: The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        :param pulumi.Input[_builtins.str] tracker_name: The name of the tracker resource to be associated with a geofence collection.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "consumer_arn", consumer_arn)
        pulumi.set(__self__, "tracker_name", tracker_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        """
        return pulumi.get(self, "consumer_arn")

    @consumer_arn.setter
    def consumer_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "consumer_arn", value)

    @_builtins.property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the tracker resource to be associated with a geofence collection.
        """
        return pulumi.get(self, "tracker_name")

    @tracker_name.setter
    def tracker_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tracker_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _TrackerAssociationState:
    def __init__(__self__, *,
                 consumer_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tracker_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TrackerAssociation resources.
        :param pulumi.Input[_builtins.str] consumer_arn: The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] tracker_name: The name of the tracker resource to be associated with a geofence collection.
        """
        if consumer_arn is not None:
            pulumi.set(__self__, "consumer_arn", consumer_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tracker_name is not None:
            pulumi.set(__self__, "tracker_name", tracker_name)

    @_builtins.property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        """
        return pulumi.get(self, "consumer_arn")

    @consumer_arn.setter
    def consumer_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "consumer_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the tracker resource to be associated with a geofence collection.
        """
        return pulumi.get(self, "tracker_name")

    @tracker_name.setter
    def tracker_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tracker_name", value)


@pulumi.type_token("aws:location/trackerAssociation:TrackerAssociation")
class TrackerAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumer_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tracker_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Location Tracker Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.location.GeofenceCollection("example", collection_name="example")
        example_tracker = aws.location.Tracker("example", tracker_name="example")
        example_tracker_association = aws.location.TrackerAssociation("example",
            consumer_arn=example.collection_arn,
            tracker_name=example_tracker.tracker_name)
        ```

        ## Import

        Using `pulumi import`, import Location Tracker Association using the `tracker_name|consumer_arn`. For example:

        ```sh
        $ pulumi import aws:location/trackerAssociation:TrackerAssociation example "tracker_name|consumer_arn"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] consumer_arn: The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] tracker_name: The name of the tracker resource to be associated with a geofence collection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrackerAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Location Tracker Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.location.GeofenceCollection("example", collection_name="example")
        example_tracker = aws.location.Tracker("example", tracker_name="example")
        example_tracker_association = aws.location.TrackerAssociation("example",
            consumer_arn=example.collection_arn,
            tracker_name=example_tracker.tracker_name)
        ```

        ## Import

        Using `pulumi import`, import Location Tracker Association using the `tracker_name|consumer_arn`. For example:

        ```sh
        $ pulumi import aws:location/trackerAssociation:TrackerAssociation example "tracker_name|consumer_arn"
        ```

        :param str resource_name: The name of the resource.
        :param TrackerAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrackerAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumer_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tracker_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrackerAssociationArgs.__new__(TrackerAssociationArgs)

            if consumer_arn is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_arn'")
            __props__.__dict__["consumer_arn"] = consumer_arn
            __props__.__dict__["region"] = region
            if tracker_name is None and not opts.urn:
                raise TypeError("Missing required property 'tracker_name'")
            __props__.__dict__["tracker_name"] = tracker_name
        super(TrackerAssociation, __self__).__init__(
            'aws:location/trackerAssociation:TrackerAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            consumer_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tracker_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'TrackerAssociation':
        """
        Get an existing TrackerAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] consumer_arn: The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] tracker_name: The name of the tracker resource to be associated with a geofence collection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrackerAssociationState.__new__(_TrackerAssociationState)

        __props__.__dict__["consumer_arn"] = consumer_arn
        __props__.__dict__["region"] = region
        __props__.__dict__["tracker_name"] = tracker_name
        return TrackerAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="consumerArn")
    def consumer_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.
        """
        return pulumi.get(self, "consumer_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="trackerName")
    def tracker_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the tracker resource to be associated with a geofence collection.
        """
        return pulumi.get(self, "tracker_name")

