# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClassificationJobArgs', 'ClassificationJob']

@pulumi.input_type
class ClassificationJobArgs:
    def __init__(__self__, *,
                 job_type: pulumi.Input[_builtins.str],
                 s3_job_definition: pulumi.Input['ClassificationJobS3JobDefinitionArgs'],
                 custom_data_identifier_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_status: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 sampling_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 schedule_frequency: Optional[pulumi.Input['ClassificationJobScheduleFrequencyArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ClassificationJob resource.
        :param pulumi.Input[_builtins.str] job_type: The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don't specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
        :param pulumi.Input['ClassificationJobS3JobDefinitionArgs'] s3_job_definition: The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_data_identifier_ids: The custom data identifiers to use for data analysis and classification.
        :param pulumi.Input[_builtins.str] description: A custom description of the job. The description can contain as many as 200 characters.
        :param pulumi.Input[_builtins.bool] initial_run: Specifies whether to analyze all existing, eligible objects immediately after the job is created.
        :param pulumi.Input[_builtins.str] job_status: The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
        :param pulumi.Input[_builtins.str] name: A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] sampling_percentage: The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
        :param pulumi.Input['ClassificationJobScheduleFrequencyArgs'] schedule_frequency: The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "job_type", job_type)
        pulumi.set(__self__, "s3_job_definition", s3_job_definition)
        if custom_data_identifier_ids is not None:
            pulumi.set(__self__, "custom_data_identifier_ids", custom_data_identifier_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if initial_run is not None:
            pulumi.set(__self__, "initial_run", initial_run)
        if job_status is not None:
            pulumi.set(__self__, "job_status", job_status)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sampling_percentage is not None:
            pulumi.set(__self__, "sampling_percentage", sampling_percentage)
        if schedule_frequency is not None:
            pulumi.set(__self__, "schedule_frequency", schedule_frequency)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[_builtins.str]:
        """
        The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don't specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "job_type", value)

    @_builtins.property
    @pulumi.getter(name="s3JobDefinition")
    def s3_job_definition(self) -> pulumi.Input['ClassificationJobS3JobDefinitionArgs']:
        """
        The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
        """
        return pulumi.get(self, "s3_job_definition")

    @s3_job_definition.setter
    def s3_job_definition(self, value: pulumi.Input['ClassificationJobS3JobDefinitionArgs']):
        pulumi.set(self, "s3_job_definition", value)

    @_builtins.property
    @pulumi.getter(name="customDataIdentifierIds")
    def custom_data_identifier_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The custom data identifiers to use for data analysis and classification.
        """
        return pulumi.get(self, "custom_data_identifier_ids")

    @custom_data_identifier_ids.setter
    def custom_data_identifier_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_data_identifier_ids", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom description of the job. The description can contain as many as 200 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="initialRun")
    def initial_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to analyze all existing, eligible objects immediately after the job is created.
        """
        return pulumi.get(self, "initial_run")

    @initial_run.setter
    def initial_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "initial_run", value)

    @_builtins.property
    @pulumi.getter(name="jobStatus")
    def job_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
        """
        return pulumi.get(self, "job_status")

    @job_status.setter
    def job_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_status", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
        """
        return pulumi.get(self, "sampling_percentage")

    @sampling_percentage.setter
    def sampling_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sampling_percentage", value)

    @_builtins.property
    @pulumi.getter(name="scheduleFrequency")
    def schedule_frequency(self) -> Optional[pulumi.Input['ClassificationJobScheduleFrequencyArgs']]:
        """
        The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
        """
        return pulumi.get(self, "schedule_frequency")

    @schedule_frequency.setter
    def schedule_frequency(self, value: Optional[pulumi.Input['ClassificationJobScheduleFrequencyArgs']]):
        pulumi.set(self, "schedule_frequency", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClassificationJobState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_data_identifier_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 job_status: Optional[pulumi.Input[_builtins.str]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_job_definition: Optional[pulumi.Input['ClassificationJobS3JobDefinitionArgs']] = None,
                 sampling_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 schedule_frequency: Optional[pulumi.Input['ClassificationJobScheduleFrequencyArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_paused_details: Optional[pulumi.Input[Sequence[pulumi.Input['ClassificationJobUserPausedDetailArgs']]]] = None):
        """
        Input properties used for looking up and filtering ClassificationJob resources.
        :param pulumi.Input[_builtins.str] created_at: The date and time, in UTC and extended RFC 3339 format, when the job was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_data_identifier_ids: The custom data identifiers to use for data analysis and classification.
        :param pulumi.Input[_builtins.str] description: A custom description of the job. The description can contain as many as 200 characters.
        :param pulumi.Input[_builtins.bool] initial_run: Specifies whether to analyze all existing, eligible objects immediately after the job is created.
        :param pulumi.Input[_builtins.str] job_status: The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
        :param pulumi.Input[_builtins.str] job_type: The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don't specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
        :param pulumi.Input[_builtins.str] name: A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['ClassificationJobS3JobDefinitionArgs'] s3_job_definition: The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
        :param pulumi.Input[_builtins.int] sampling_percentage: The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
        :param pulumi.Input['ClassificationJobScheduleFrequencyArgs'] schedule_frequency: The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['ClassificationJobUserPausedDetailArgs']]] user_paused_details: If the current status of the job is `USER_PAUSED`, specifies when the job was paused and when the job or job run will expire and be canceled if it isn't resumed. This value is present only if the value for `job-status` is `USER_PAUSED`.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if custom_data_identifier_ids is not None:
            pulumi.set(__self__, "custom_data_identifier_ids", custom_data_identifier_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if initial_run is not None:
            pulumi.set(__self__, "initial_run", initial_run)
        if job_arn is not None:
            pulumi.set(__self__, "job_arn", job_arn)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if job_status is not None:
            pulumi.set(__self__, "job_status", job_status)
        if job_type is not None:
            pulumi.set(__self__, "job_type", job_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_job_definition is not None:
            pulumi.set(__self__, "s3_job_definition", s3_job_definition)
        if sampling_percentage is not None:
            pulumi.set(__self__, "sampling_percentage", sampling_percentage)
        if schedule_frequency is not None:
            pulumi.set(__self__, "schedule_frequency", schedule_frequency)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if user_paused_details is not None:
            pulumi.set(__self__, "user_paused_details", user_paused_details)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time, in UTC and extended RFC 3339 format, when the job was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="customDataIdentifierIds")
    def custom_data_identifier_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The custom data identifiers to use for data analysis and classification.
        """
        return pulumi.get(self, "custom_data_identifier_ids")

    @custom_data_identifier_ids.setter
    def custom_data_identifier_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_data_identifier_ids", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom description of the job. The description can contain as many as 200 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="initialRun")
    def initial_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to analyze all existing, eligible objects immediately after the job is created.
        """
        return pulumi.get(self, "initial_run")

    @initial_run.setter
    def initial_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "initial_run", value)

    @_builtins.property
    @pulumi.getter(name="jobArn")
    def job_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "job_arn")

    @job_arn.setter
    def job_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_arn", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="jobStatus")
    def job_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
        """
        return pulumi.get(self, "job_status")

    @job_status.setter
    def job_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_status", value)

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don't specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="s3JobDefinition")
    def s3_job_definition(self) -> Optional[pulumi.Input['ClassificationJobS3JobDefinitionArgs']]:
        """
        The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
        """
        return pulumi.get(self, "s3_job_definition")

    @s3_job_definition.setter
    def s3_job_definition(self, value: Optional[pulumi.Input['ClassificationJobS3JobDefinitionArgs']]):
        pulumi.set(self, "s3_job_definition", value)

    @_builtins.property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
        """
        return pulumi.get(self, "sampling_percentage")

    @sampling_percentage.setter
    def sampling_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sampling_percentage", value)

    @_builtins.property
    @pulumi.getter(name="scheduleFrequency")
    def schedule_frequency(self) -> Optional[pulumi.Input['ClassificationJobScheduleFrequencyArgs']]:
        """
        The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
        """
        return pulumi.get(self, "schedule_frequency")

    @schedule_frequency.setter
    def schedule_frequency(self, value: Optional[pulumi.Input['ClassificationJobScheduleFrequencyArgs']]):
        pulumi.set(self, "schedule_frequency", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="userPausedDetails")
    def user_paused_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClassificationJobUserPausedDetailArgs']]]]:
        """
        If the current status of the job is `USER_PAUSED`, specifies when the job was paused and when the job or job run will expire and be canceled if it isn't resumed. This value is present only if the value for `job-status` is `USER_PAUSED`.
        """
        return pulumi.get(self, "user_paused_details")

    @user_paused_details.setter
    def user_paused_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClassificationJobUserPausedDetailArgs']]]]):
        pulumi.set(self, "user_paused_details", value)


@pulumi.type_token("aws:macie2/classificationJob:ClassificationJob")
class ClassificationJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_data_identifier_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_status: Optional[pulumi.Input[_builtins.str]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_job_definition: Optional[pulumi.Input[Union['ClassificationJobS3JobDefinitionArgs', 'ClassificationJobS3JobDefinitionArgsDict']]] = None,
                 sampling_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 schedule_frequency: Optional[pulumi.Input[Union['ClassificationJobScheduleFrequencyArgs', 'ClassificationJobScheduleFrequencyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage an [AWS Macie Classification Job](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.macie2.Account("test")
        test_classification_job = aws.macie2.ClassificationJob("test",
            job_type="ONE_TIME",
            name="NAME OF THE CLASSIFICATION JOB",
            s3_job_definition={
                "bucket_definitions": [{
                    "account_id": "ACCOUNT ID",
                    "buckets": ["S3 BUCKET NAME"],
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[test]))
        ```

        ## Import

        Using `pulumi import`, import `aws_macie2_classification_job` using the id. For example:

        ```sh
        $ pulumi import aws:macie2/classificationJob:ClassificationJob example abcd1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_data_identifier_ids: The custom data identifiers to use for data analysis and classification.
        :param pulumi.Input[_builtins.str] description: A custom description of the job. The description can contain as many as 200 characters.
        :param pulumi.Input[_builtins.bool] initial_run: Specifies whether to analyze all existing, eligible objects immediately after the job is created.
        :param pulumi.Input[_builtins.str] job_status: The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
        :param pulumi.Input[_builtins.str] job_type: The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don't specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
        :param pulumi.Input[_builtins.str] name: A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ClassificationJobS3JobDefinitionArgs', 'ClassificationJobS3JobDefinitionArgsDict']] s3_job_definition: The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
        :param pulumi.Input[_builtins.int] sampling_percentage: The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
        :param pulumi.Input[Union['ClassificationJobScheduleFrequencyArgs', 'ClassificationJobScheduleFrequencyArgsDict']] schedule_frequency: The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClassificationJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage an [AWS Macie Classification Job](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.macie2.Account("test")
        test_classification_job = aws.macie2.ClassificationJob("test",
            job_type="ONE_TIME",
            name="NAME OF THE CLASSIFICATION JOB",
            s3_job_definition={
                "bucket_definitions": [{
                    "account_id": "ACCOUNT ID",
                    "buckets": ["S3 BUCKET NAME"],
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[test]))
        ```

        ## Import

        Using `pulumi import`, import `aws_macie2_classification_job` using the id. For example:

        ```sh
        $ pulumi import aws:macie2/classificationJob:ClassificationJob example abcd1
        ```

        :param str resource_name: The name of the resource.
        :param ClassificationJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClassificationJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_data_identifier_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 initial_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 job_status: Optional[pulumi.Input[_builtins.str]] = None,
                 job_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 s3_job_definition: Optional[pulumi.Input[Union['ClassificationJobS3JobDefinitionArgs', 'ClassificationJobS3JobDefinitionArgsDict']]] = None,
                 sampling_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 schedule_frequency: Optional[pulumi.Input[Union['ClassificationJobScheduleFrequencyArgs', 'ClassificationJobScheduleFrequencyArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClassificationJobArgs.__new__(ClassificationJobArgs)

            __props__.__dict__["custom_data_identifier_ids"] = custom_data_identifier_ids
            __props__.__dict__["description"] = description
            __props__.__dict__["initial_run"] = initial_run
            __props__.__dict__["job_status"] = job_status
            if job_type is None and not opts.urn:
                raise TypeError("Missing required property 'job_type'")
            __props__.__dict__["job_type"] = job_type
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["region"] = region
            if s3_job_definition is None and not opts.urn:
                raise TypeError("Missing required property 's3_job_definition'")
            __props__.__dict__["s3_job_definition"] = s3_job_definition
            __props__.__dict__["sampling_percentage"] = sampling_percentage
            __props__.__dict__["schedule_frequency"] = schedule_frequency
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["job_arn"] = None
            __props__.__dict__["job_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["user_paused_details"] = None
        super(ClassificationJob, __self__).__init__(
            'aws:macie2/classificationJob:ClassificationJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            custom_data_identifier_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            initial_run: Optional[pulumi.Input[_builtins.bool]] = None,
            job_arn: Optional[pulumi.Input[_builtins.str]] = None,
            job_id: Optional[pulumi.Input[_builtins.str]] = None,
            job_status: Optional[pulumi.Input[_builtins.str]] = None,
            job_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            s3_job_definition: Optional[pulumi.Input[Union['ClassificationJobS3JobDefinitionArgs', 'ClassificationJobS3JobDefinitionArgsDict']]] = None,
            sampling_percentage: Optional[pulumi.Input[_builtins.int]] = None,
            schedule_frequency: Optional[pulumi.Input[Union['ClassificationJobScheduleFrequencyArgs', 'ClassificationJobScheduleFrequencyArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user_paused_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClassificationJobUserPausedDetailArgs', 'ClassificationJobUserPausedDetailArgsDict']]]]] = None) -> 'ClassificationJob':
        """
        Get an existing ClassificationJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time, in UTC and extended RFC 3339 format, when the job was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_data_identifier_ids: The custom data identifiers to use for data analysis and classification.
        :param pulumi.Input[_builtins.str] description: A custom description of the job. The description can contain as many as 200 characters.
        :param pulumi.Input[_builtins.bool] initial_run: Specifies whether to analyze all existing, eligible objects immediately after the job is created.
        :param pulumi.Input[_builtins.str] job_status: The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
        :param pulumi.Input[_builtins.str] job_type: The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don't specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
        :param pulumi.Input[_builtins.str] name: A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['ClassificationJobS3JobDefinitionArgs', 'ClassificationJobS3JobDefinitionArgsDict']] s3_job_definition: The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
        :param pulumi.Input[_builtins.int] sampling_percentage: The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
        :param pulumi.Input[Union['ClassificationJobScheduleFrequencyArgs', 'ClassificationJobScheduleFrequencyArgsDict']] schedule_frequency: The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClassificationJobUserPausedDetailArgs', 'ClassificationJobUserPausedDetailArgsDict']]]] user_paused_details: If the current status of the job is `USER_PAUSED`, specifies when the job was paused and when the job or job run will expire and be canceled if it isn't resumed. This value is present only if the value for `job-status` is `USER_PAUSED`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClassificationJobState.__new__(_ClassificationJobState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["custom_data_identifier_ids"] = custom_data_identifier_ids
        __props__.__dict__["description"] = description
        __props__.__dict__["initial_run"] = initial_run
        __props__.__dict__["job_arn"] = job_arn
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["job_status"] = job_status
        __props__.__dict__["job_type"] = job_type
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["region"] = region
        __props__.__dict__["s3_job_definition"] = s3_job_definition
        __props__.__dict__["sampling_percentage"] = sampling_percentage
        __props__.__dict__["schedule_frequency"] = schedule_frequency
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["user_paused_details"] = user_paused_details
        return ClassificationJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time, in UTC and extended RFC 3339 format, when the job was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customDataIdentifierIds")
    def custom_data_identifier_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The custom data identifiers to use for data analysis and classification.
        """
        return pulumi.get(self, "custom_data_identifier_ids")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A custom description of the job. The description can contain as many as 200 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="initialRun")
    def initial_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to analyze all existing, eligible objects immediately after the job is created.
        """
        return pulumi.get(self, "initial_run")

    @_builtins.property
    @pulumi.getter(name="jobArn")
    def job_arn(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "job_arn")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="jobStatus")
    def job_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
        """
        return pulumi.get(self, "job_status")

    @_builtins.property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Output[_builtins.str]:
        """
        The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don't specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
        """
        return pulumi.get(self, "job_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="s3JobDefinition")
    def s3_job_definition(self) -> pulumi.Output['outputs.ClassificationJobS3JobDefinition']:
        """
        The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
        """
        return pulumi.get(self, "s3_job_definition")

    @_builtins.property
    @pulumi.getter(name="samplingPercentage")
    def sampling_percentage(self) -> pulumi.Output[_builtins.int]:
        """
        The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
        """
        return pulumi.get(self, "sampling_percentage")

    @_builtins.property
    @pulumi.getter(name="scheduleFrequency")
    def schedule_frequency(self) -> pulumi.Output['outputs.ClassificationJobScheduleFrequency']:
        """
        The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
        """
        return pulumi.get(self, "schedule_frequency")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="userPausedDetails")
    def user_paused_details(self) -> pulumi.Output[Sequence['outputs.ClassificationJobUserPausedDetail']]:
        """
        If the current status of the job is `USER_PAUSED`, specifies when the job was paused and when the job or job run will expire and be canceled if it isn't resumed. This value is present only if the value for `job-status` is `USER_PAUSED`.
        """
        return pulumi.get(self, "user_paused_details")

