# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAclResult',
    'AwaitableGetAclResult',
    'get_acl',
    'get_acl_output',
]

@pulumi.output_type
class GetAclResult:
    """
    A collection of values returned by getAcl.
    """
    def __init__(__self__, arn=None, id=None, minimum_engine_version=None, name=None, region=None, tags=None, user_names=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if minimum_engine_version and not isinstance(minimum_engine_version, str):
            raise TypeError("Expected argument 'minimum_engine_version' to be a str")
        pulumi.set(__self__, "minimum_engine_version", minimum_engine_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if user_names and not isinstance(user_names, list):
            raise TypeError("Expected argument 'user_names' to be a list")
        pulumi.set(__self__, "user_names", user_names)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the ACL.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="minimumEngineVersion")
    def minimum_engine_version(self) -> _builtins.str:
        """
        The minimum engine version supported by the ACL.
        """
        return pulumi.get(self, "minimum_engine_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Map of tags assigned to the ACL.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userNames")
    def user_names(self) -> Sequence[_builtins.str]:
        """
        Set of MemoryDB user names included in this ACL.
        """
        return pulumi.get(self, "user_names")


class AwaitableGetAclResult(GetAclResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAclResult(
            arn=self.arn,
            id=self.id,
            minimum_engine_version=self.minimum_engine_version,
            name=self.name,
            region=self.region,
            tags=self.tags,
            user_names=self.user_names)


def get_acl(name: Optional[_builtins.str] = None,
            region: Optional[_builtins.str] = None,
            tags: Optional[Mapping[str, _builtins.str]] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAclResult:
    """
    Provides information about a MemoryDB ACL.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.memorydb.get_acl(name="my-acl")
    ```


    :param _builtins.str name: Name of the ACL.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the ACL.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:memorydb/getAcl:getAcl', __args__, opts=opts, typ=GetAclResult).value

    return AwaitableGetAclResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        minimum_engine_version=pulumi.get(__ret__, 'minimum_engine_version'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'),
        user_names=pulumi.get(__ret__, 'user_names'))
def get_acl_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAclResult]:
    """
    Provides information about a MemoryDB ACL.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.memorydb.get_acl(name="my-acl")
    ```


    :param _builtins.str name: Name of the ACL.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the ACL.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:memorydb/getAcl:getAcl', __args__, opts=opts, typ=GetAclResult)
    return __ret__.apply(lambda __response__: GetAclResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        minimum_engine_version=pulumi.get(__response__, 'minimum_engine_version'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags'),
        user_names=pulumi.get(__response__, 'user_names')))
