# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBrokerResult',
    'AwaitableGetBrokerResult',
    'get_broker',
    'get_broker_output',
]

@pulumi.output_type
class GetBrokerResult:
    """
    A collection of values returned by getBroker.
    """
    def __init__(__self__, arn=None, authentication_strategy=None, auto_minor_version_upgrade=None, broker_id=None, broker_name=None, configuration=None, deployment_mode=None, encryption_options=None, engine_type=None, engine_version=None, host_instance_type=None, id=None, instances=None, ldap_server_metadatas=None, logs=None, maintenance_window_start_time=None, publicly_accessible=None, region=None, security_groups=None, storage_type=None, subnet_ids=None, tags=None, users=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if authentication_strategy and not isinstance(authentication_strategy, str):
            raise TypeError("Expected argument 'authentication_strategy' to be a str")
        pulumi.set(__self__, "authentication_strategy", authentication_strategy)
        if auto_minor_version_upgrade and not isinstance(auto_minor_version_upgrade, bool):
            raise TypeError("Expected argument 'auto_minor_version_upgrade' to be a bool")
        pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if broker_id and not isinstance(broker_id, str):
            raise TypeError("Expected argument 'broker_id' to be a str")
        pulumi.set(__self__, "broker_id", broker_id)
        if broker_name and not isinstance(broker_name, str):
            raise TypeError("Expected argument 'broker_name' to be a str")
        pulumi.set(__self__, "broker_name", broker_name)
        if configuration and not isinstance(configuration, dict):
            raise TypeError("Expected argument 'configuration' to be a dict")
        pulumi.set(__self__, "configuration", configuration)
        if deployment_mode and not isinstance(deployment_mode, str):
            raise TypeError("Expected argument 'deployment_mode' to be a str")
        pulumi.set(__self__, "deployment_mode", deployment_mode)
        if encryption_options and not isinstance(encryption_options, list):
            raise TypeError("Expected argument 'encryption_options' to be a list")
        pulumi.set(__self__, "encryption_options", encryption_options)
        if engine_type and not isinstance(engine_type, str):
            raise TypeError("Expected argument 'engine_type' to be a str")
        pulumi.set(__self__, "engine_type", engine_type)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if host_instance_type and not isinstance(host_instance_type, str):
            raise TypeError("Expected argument 'host_instance_type' to be a str")
        pulumi.set(__self__, "host_instance_type", host_instance_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if ldap_server_metadatas and not isinstance(ldap_server_metadatas, list):
            raise TypeError("Expected argument 'ldap_server_metadatas' to be a list")
        pulumi.set(__self__, "ldap_server_metadatas", ldap_server_metadatas)
        if logs and not isinstance(logs, dict):
            raise TypeError("Expected argument 'logs' to be a dict")
        pulumi.set(__self__, "logs", logs)
        if maintenance_window_start_time and not isinstance(maintenance_window_start_time, dict):
            raise TypeError("Expected argument 'maintenance_window_start_time' to be a dict")
        pulumi.set(__self__, "maintenance_window_start_time", maintenance_window_start_time)
        if publicly_accessible and not isinstance(publicly_accessible, bool):
            raise TypeError("Expected argument 'publicly_accessible' to be a bool")
        pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_groups and not isinstance(security_groups, list):
            raise TypeError("Expected argument 'security_groups' to be a list")
        pulumi.set(__self__, "security_groups", security_groups)
        if storage_type and not isinstance(storage_type, str):
            raise TypeError("Expected argument 'storage_type' to be a str")
        pulumi.set(__self__, "storage_type", storage_type)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the broker.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="authenticationStrategy")
    def authentication_strategy(self) -> _builtins.str:
        """
        Authentication strategy used to secure the broker.
        """
        return pulumi.get(self, "authentication_strategy")

    @_builtins.property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> _builtins.bool:
        """
        Whether to automatically upgrade to new minor versions of brokers as Amazon MQ makes releases available.
        """
        return pulumi.get(self, "auto_minor_version_upgrade")

    @_builtins.property
    @pulumi.getter(name="brokerId")
    def broker_id(self) -> _builtins.str:
        return pulumi.get(self, "broker_id")

    @_builtins.property
    @pulumi.getter(name="brokerName")
    def broker_name(self) -> _builtins.str:
        return pulumi.get(self, "broker_name")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> 'outputs.GetBrokerConfigurationResult':
        """
        Configuration block for broker configuration. See Configuration below.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter(name="deploymentMode")
    def deployment_mode(self) -> _builtins.str:
        """
        Deployment mode of the broker.
        """
        return pulumi.get(self, "deployment_mode")

    @_builtins.property
    @pulumi.getter(name="encryptionOptions")
    def encryption_options(self) -> Sequence['outputs.GetBrokerEncryptionOptionResult']:
        """
        Configuration block containing encryption options. See Encryption Options below.
        """
        return pulumi.get(self, "encryption_options")

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> _builtins.str:
        """
        Type of broker engine.
        """
        return pulumi.get(self, "engine_type")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        Version of the broker engine.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="hostInstanceType")
    def host_instance_type(self) -> _builtins.str:
        """
        Broker's instance type.
        """
        return pulumi.get(self, "host_instance_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetBrokerInstanceResult']:
        """
        List of information about allocated brokers (both active & standby). See Instances below.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="ldapServerMetadatas")
    def ldap_server_metadatas(self) -> Sequence['outputs.GetBrokerLdapServerMetadataResult']:
        """
        Configuration block for the LDAP server used to authenticate and authorize connections to the broker. See LDAP Server Metadata below.
        """
        return pulumi.get(self, "ldap_server_metadatas")

    @_builtins.property
    @pulumi.getter
    def logs(self) -> 'outputs.GetBrokerLogsResult':
        """
        Configuration block for the logging configuration of the broker. See Logs below.
        """
        return pulumi.get(self, "logs")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowStartTime")
    def maintenance_window_start_time(self) -> 'outputs.GetBrokerMaintenanceWindowStartTimeResult':
        """
        Configuration block for the maintenance window start time. See Maintenance Window Start Time below.
        """
        return pulumi.get(self, "maintenance_window_start_time")

    @_builtins.property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> _builtins.bool:
        """
        Whether to enable connections from applications outside of the VPC that hosts the broker's subnets.
        """
        return pulumi.get(self, "publicly_accessible")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[_builtins.str]:
        """
        List of security group IDs assigned to the broker.
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        """
        Storage type of the broker.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[_builtins.str]:
        """
        List of subnet IDs in which to launch the broker.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Map of tags assigned to the broker.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetBrokerUserResult']:
        """
        Configuration block for broker users. See User below.
        """
        return pulumi.get(self, "users")


class AwaitableGetBrokerResult(GetBrokerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBrokerResult(
            arn=self.arn,
            authentication_strategy=self.authentication_strategy,
            auto_minor_version_upgrade=self.auto_minor_version_upgrade,
            broker_id=self.broker_id,
            broker_name=self.broker_name,
            configuration=self.configuration,
            deployment_mode=self.deployment_mode,
            encryption_options=self.encryption_options,
            engine_type=self.engine_type,
            engine_version=self.engine_version,
            host_instance_type=self.host_instance_type,
            id=self.id,
            instances=self.instances,
            ldap_server_metadatas=self.ldap_server_metadatas,
            logs=self.logs,
            maintenance_window_start_time=self.maintenance_window_start_time,
            publicly_accessible=self.publicly_accessible,
            region=self.region,
            security_groups=self.security_groups,
            storage_type=self.storage_type,
            subnet_ids=self.subnet_ids,
            tags=self.tags,
            users=self.users)


def get_broker(broker_id: Optional[_builtins.str] = None,
               broker_name: Optional[_builtins.str] = None,
               region: Optional[_builtins.str] = None,
               tags: Optional[Mapping[str, _builtins.str]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBrokerResult:
    """
    Provides details about an existing Amazon MQ broker. Use this data source to retrieve configuration and metadata for an Amazon MQ broker by ID or name.


    :param _builtins.str broker_id: Unique ID of the MQ broker.
    :param _builtins.str broker_name: Unique name of the MQ broker.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
           > **Note:** Either `broker_id` or `broker_name` must be specified.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the broker.
    """
    __args__ = dict()
    __args__['brokerId'] = broker_id
    __args__['brokerName'] = broker_name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:mq/getBroker:getBroker', __args__, opts=opts, typ=GetBrokerResult).value

    return AwaitableGetBrokerResult(
        arn=pulumi.get(__ret__, 'arn'),
        authentication_strategy=pulumi.get(__ret__, 'authentication_strategy'),
        auto_minor_version_upgrade=pulumi.get(__ret__, 'auto_minor_version_upgrade'),
        broker_id=pulumi.get(__ret__, 'broker_id'),
        broker_name=pulumi.get(__ret__, 'broker_name'),
        configuration=pulumi.get(__ret__, 'configuration'),
        deployment_mode=pulumi.get(__ret__, 'deployment_mode'),
        encryption_options=pulumi.get(__ret__, 'encryption_options'),
        engine_type=pulumi.get(__ret__, 'engine_type'),
        engine_version=pulumi.get(__ret__, 'engine_version'),
        host_instance_type=pulumi.get(__ret__, 'host_instance_type'),
        id=pulumi.get(__ret__, 'id'),
        instances=pulumi.get(__ret__, 'instances'),
        ldap_server_metadatas=pulumi.get(__ret__, 'ldap_server_metadatas'),
        logs=pulumi.get(__ret__, 'logs'),
        maintenance_window_start_time=pulumi.get(__ret__, 'maintenance_window_start_time'),
        publicly_accessible=pulumi.get(__ret__, 'publicly_accessible'),
        region=pulumi.get(__ret__, 'region'),
        security_groups=pulumi.get(__ret__, 'security_groups'),
        storage_type=pulumi.get(__ret__, 'storage_type'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        tags=pulumi.get(__ret__, 'tags'),
        users=pulumi.get(__ret__, 'users'))
def get_broker_output(broker_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      broker_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBrokerResult]:
    """
    Provides details about an existing Amazon MQ broker. Use this data source to retrieve configuration and metadata for an Amazon MQ broker by ID or name.


    :param _builtins.str broker_id: Unique ID of the MQ broker.
    :param _builtins.str broker_name: Unique name of the MQ broker.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
           > **Note:** Either `broker_id` or `broker_name` must be specified.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the broker.
    """
    __args__ = dict()
    __args__['brokerId'] = broker_id
    __args__['brokerName'] = broker_name
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:mq/getBroker:getBroker', __args__, opts=opts, typ=GetBrokerResult)
    return __ret__.apply(lambda __response__: GetBrokerResult(
        arn=pulumi.get(__response__, 'arn'),
        authentication_strategy=pulumi.get(__response__, 'authentication_strategy'),
        auto_minor_version_upgrade=pulumi.get(__response__, 'auto_minor_version_upgrade'),
        broker_id=pulumi.get(__response__, 'broker_id'),
        broker_name=pulumi.get(__response__, 'broker_name'),
        configuration=pulumi.get(__response__, 'configuration'),
        deployment_mode=pulumi.get(__response__, 'deployment_mode'),
        encryption_options=pulumi.get(__response__, 'encryption_options'),
        engine_type=pulumi.get(__response__, 'engine_type'),
        engine_version=pulumi.get(__response__, 'engine_version'),
        host_instance_type=pulumi.get(__response__, 'host_instance_type'),
        id=pulumi.get(__response__, 'id'),
        instances=pulumi.get(__response__, 'instances'),
        ldap_server_metadatas=pulumi.get(__response__, 'ldap_server_metadatas'),
        logs=pulumi.get(__response__, 'logs'),
        maintenance_window_start_time=pulumi.get(__response__, 'maintenance_window_start_time'),
        publicly_accessible=pulumi.get(__response__, 'publicly_accessible'),
        region=pulumi.get(__response__, 'region'),
        security_groups=pulumi.get(__response__, 'security_groups'),
        storage_type=pulumi.get(__response__, 'storage_type'),
        subnet_ids=pulumi.get(__response__, 'subnet_ids'),
        tags=pulumi.get(__response__, 'tags'),
        users=pulumi.get(__response__, 'users')))
