# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectorArgs', 'Connector']

@pulumi.input_type
class ConnectorArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input['ConnectorCapacityArgs'],
                 connector_configuration: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 kafka_cluster: pulumi.Input['ConnectorKafkaClusterArgs'],
                 kafka_cluster_client_authentication: pulumi.Input['ConnectorKafkaClusterClientAuthenticationArgs'],
                 kafka_cluster_encryption_in_transit: pulumi.Input['ConnectorKafkaClusterEncryptionInTransitArgs'],
                 kafkaconnect_version: pulumi.Input[_builtins.str],
                 plugins: pulumi.Input[Sequence[pulumi.Input['ConnectorPluginArgs']]],
                 service_execution_role_arn: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery: Optional[pulumi.Input['ConnectorLogDeliveryArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_configuration: Optional[pulumi.Input['ConnectorWorkerConfigurationArgs']] = None):
        """
        The set of arguments for constructing a Connector resource.
        :param pulumi.Input['ConnectorCapacityArgs'] capacity: Information about the capacity allocated to the connector. See `capacity` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] connector_configuration: A map of keys to values that represent the configuration for the connector.
        :param pulumi.Input['ConnectorKafkaClusterArgs'] kafka_cluster: Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
        :param pulumi.Input['ConnectorKafkaClusterClientAuthenticationArgs'] kafka_cluster_client_authentication: Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
        :param pulumi.Input['ConnectorKafkaClusterEncryptionInTransitArgs'] kafka_cluster_encryption_in_transit: Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
        :param pulumi.Input[_builtins.str] kafkaconnect_version: The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorPluginArgs']]] plugins: Specifies which plugins to use for the connector. See `plugin` Block for details.
        :param pulumi.Input[_builtins.str] service_execution_role_arn: The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: A summary description of the connector.
        :param pulumi.Input['ConnectorLogDeliveryArgs'] log_delivery: Details about log delivery. See `log_delivery` Block for details.
        :param pulumi.Input[_builtins.str] name: The name of the connector.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['ConnectorWorkerConfigurationArgs'] worker_configuration: Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "connector_configuration", connector_configuration)
        pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        pulumi.set(__self__, "kafka_cluster_client_authentication", kafka_cluster_client_authentication)
        pulumi.set(__self__, "kafka_cluster_encryption_in_transit", kafka_cluster_encryption_in_transit)
        pulumi.set(__self__, "kafkaconnect_version", kafkaconnect_version)
        pulumi.set(__self__, "plugins", plugins)
        pulumi.set(__self__, "service_execution_role_arn", service_execution_role_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if log_delivery is not None:
            pulumi.set(__self__, "log_delivery", log_delivery)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if worker_configuration is not None:
            pulumi.set(__self__, "worker_configuration", worker_configuration)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Input['ConnectorCapacityArgs']:
        """
        Information about the capacity allocated to the connector. See `capacity` Block for details.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input['ConnectorCapacityArgs']):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="connectorConfiguration")
    def connector_configuration(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        A map of keys to values that represent the configuration for the connector.
        """
        return pulumi.get(self, "connector_configuration")

    @connector_configuration.setter
    def connector_configuration(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "connector_configuration", value)

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> pulumi.Input['ConnectorKafkaClusterArgs']:
        """
        Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
        """
        return pulumi.get(self, "kafka_cluster")

    @kafka_cluster.setter
    def kafka_cluster(self, value: pulumi.Input['ConnectorKafkaClusterArgs']):
        pulumi.set(self, "kafka_cluster", value)

    @_builtins.property
    @pulumi.getter(name="kafkaClusterClientAuthentication")
    def kafka_cluster_client_authentication(self) -> pulumi.Input['ConnectorKafkaClusterClientAuthenticationArgs']:
        """
        Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
        """
        return pulumi.get(self, "kafka_cluster_client_authentication")

    @kafka_cluster_client_authentication.setter
    def kafka_cluster_client_authentication(self, value: pulumi.Input['ConnectorKafkaClusterClientAuthenticationArgs']):
        pulumi.set(self, "kafka_cluster_client_authentication", value)

    @_builtins.property
    @pulumi.getter(name="kafkaClusterEncryptionInTransit")
    def kafka_cluster_encryption_in_transit(self) -> pulumi.Input['ConnectorKafkaClusterEncryptionInTransitArgs']:
        """
        Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
        """
        return pulumi.get(self, "kafka_cluster_encryption_in_transit")

    @kafka_cluster_encryption_in_transit.setter
    def kafka_cluster_encryption_in_transit(self, value: pulumi.Input['ConnectorKafkaClusterEncryptionInTransitArgs']):
        pulumi.set(self, "kafka_cluster_encryption_in_transit", value)

    @_builtins.property
    @pulumi.getter(name="kafkaconnectVersion")
    def kafkaconnect_version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
        """
        return pulumi.get(self, "kafkaconnect_version")

    @kafkaconnect_version.setter
    def kafkaconnect_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kafkaconnect_version", value)

    @_builtins.property
    @pulumi.getter
    def plugins(self) -> pulumi.Input[Sequence[pulumi.Input['ConnectorPluginArgs']]]:
        """
        Specifies which plugins to use for the connector. See `plugin` Block for details.
        """
        return pulumi.get(self, "plugins")

    @plugins.setter
    def plugins(self, value: pulumi.Input[Sequence[pulumi.Input['ConnectorPluginArgs']]]):
        pulumi.set(self, "plugins", value)

    @_builtins.property
    @pulumi.getter(name="serviceExecutionRoleArn")
    def service_execution_role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_execution_role_arn")

    @service_execution_role_arn.setter
    def service_execution_role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_execution_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A summary description of the connector.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="logDelivery")
    def log_delivery(self) -> Optional[pulumi.Input['ConnectorLogDeliveryArgs']]:
        """
        Details about log delivery. See `log_delivery` Block for details.
        """
        return pulumi.get(self, "log_delivery")

    @log_delivery.setter
    def log_delivery(self, value: Optional[pulumi.Input['ConnectorLogDeliveryArgs']]):
        pulumi.set(self, "log_delivery", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workerConfiguration")
    def worker_configuration(self) -> Optional[pulumi.Input['ConnectorWorkerConfigurationArgs']]:
        """
        Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
        """
        return pulumi.get(self, "worker_configuration")

    @worker_configuration.setter
    def worker_configuration(self, value: Optional[pulumi.Input['ConnectorWorkerConfigurationArgs']]):
        pulumi.set(self, "worker_configuration", value)


@pulumi.input_type
class _ConnectorState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity: Optional[pulumi.Input['ConnectorCapacityArgs']] = None,
                 connector_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_cluster: Optional[pulumi.Input['ConnectorKafkaClusterArgs']] = None,
                 kafka_cluster_client_authentication: Optional[pulumi.Input['ConnectorKafkaClusterClientAuthenticationArgs']] = None,
                 kafka_cluster_encryption_in_transit: Optional[pulumi.Input['ConnectorKafkaClusterEncryptionInTransitArgs']] = None,
                 kafkaconnect_version: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery: Optional[pulumi.Input['ConnectorLogDeliveryArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plugins: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorPluginArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_configuration: Optional[pulumi.Input['ConnectorWorkerConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering Connector resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the connector.
        :param pulumi.Input['ConnectorCapacityArgs'] capacity: Information about the capacity allocated to the connector. See `capacity` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] connector_configuration: A map of keys to values that represent the configuration for the connector.
        :param pulumi.Input[_builtins.str] description: A summary description of the connector.
        :param pulumi.Input['ConnectorKafkaClusterArgs'] kafka_cluster: Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
        :param pulumi.Input['ConnectorKafkaClusterClientAuthenticationArgs'] kafka_cluster_client_authentication: Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
        :param pulumi.Input['ConnectorKafkaClusterEncryptionInTransitArgs'] kafka_cluster_encryption_in_transit: Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
        :param pulumi.Input[_builtins.str] kafkaconnect_version: The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
        :param pulumi.Input['ConnectorLogDeliveryArgs'] log_delivery: Details about log delivery. See `log_delivery` Block for details.
        :param pulumi.Input[_builtins.str] name: The name of the connector.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectorPluginArgs']]] plugins: Specifies which plugins to use for the connector. See `plugin` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] service_execution_role_arn: The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] version: The current version of the connector.
        :param pulumi.Input['ConnectorWorkerConfigurationArgs'] worker_configuration: Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if connector_configuration is not None:
            pulumi.set(__self__, "connector_configuration", connector_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kafka_cluster is not None:
            pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        if kafka_cluster_client_authentication is not None:
            pulumi.set(__self__, "kafka_cluster_client_authentication", kafka_cluster_client_authentication)
        if kafka_cluster_encryption_in_transit is not None:
            pulumi.set(__self__, "kafka_cluster_encryption_in_transit", kafka_cluster_encryption_in_transit)
        if kafkaconnect_version is not None:
            pulumi.set(__self__, "kafkaconnect_version", kafkaconnect_version)
        if log_delivery is not None:
            pulumi.set(__self__, "log_delivery", log_delivery)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plugins is not None:
            pulumi.set(__self__, "plugins", plugins)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_execution_role_arn is not None:
            pulumi.set(__self__, "service_execution_role_arn", service_execution_role_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if worker_configuration is not None:
            pulumi.set(__self__, "worker_configuration", worker_configuration)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the connector.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input['ConnectorCapacityArgs']]:
        """
        Information about the capacity allocated to the connector. See `capacity` Block for details.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input['ConnectorCapacityArgs']]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter(name="connectorConfiguration")
    def connector_configuration(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of keys to values that represent the configuration for the connector.
        """
        return pulumi.get(self, "connector_configuration")

    @connector_configuration.setter
    def connector_configuration(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connector_configuration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A summary description of the connector.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> Optional[pulumi.Input['ConnectorKafkaClusterArgs']]:
        """
        Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
        """
        return pulumi.get(self, "kafka_cluster")

    @kafka_cluster.setter
    def kafka_cluster(self, value: Optional[pulumi.Input['ConnectorKafkaClusterArgs']]):
        pulumi.set(self, "kafka_cluster", value)

    @_builtins.property
    @pulumi.getter(name="kafkaClusterClientAuthentication")
    def kafka_cluster_client_authentication(self) -> Optional[pulumi.Input['ConnectorKafkaClusterClientAuthenticationArgs']]:
        """
        Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
        """
        return pulumi.get(self, "kafka_cluster_client_authentication")

    @kafka_cluster_client_authentication.setter
    def kafka_cluster_client_authentication(self, value: Optional[pulumi.Input['ConnectorKafkaClusterClientAuthenticationArgs']]):
        pulumi.set(self, "kafka_cluster_client_authentication", value)

    @_builtins.property
    @pulumi.getter(name="kafkaClusterEncryptionInTransit")
    def kafka_cluster_encryption_in_transit(self) -> Optional[pulumi.Input['ConnectorKafkaClusterEncryptionInTransitArgs']]:
        """
        Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
        """
        return pulumi.get(self, "kafka_cluster_encryption_in_transit")

    @kafka_cluster_encryption_in_transit.setter
    def kafka_cluster_encryption_in_transit(self, value: Optional[pulumi.Input['ConnectorKafkaClusterEncryptionInTransitArgs']]):
        pulumi.set(self, "kafka_cluster_encryption_in_transit", value)

    @_builtins.property
    @pulumi.getter(name="kafkaconnectVersion")
    def kafkaconnect_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
        """
        return pulumi.get(self, "kafkaconnect_version")

    @kafkaconnect_version.setter
    def kafkaconnect_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kafkaconnect_version", value)

    @_builtins.property
    @pulumi.getter(name="logDelivery")
    def log_delivery(self) -> Optional[pulumi.Input['ConnectorLogDeliveryArgs']]:
        """
        Details about log delivery. See `log_delivery` Block for details.
        """
        return pulumi.get(self, "log_delivery")

    @log_delivery.setter
    def log_delivery(self, value: Optional[pulumi.Input['ConnectorLogDeliveryArgs']]):
        pulumi.set(self, "log_delivery", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def plugins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorPluginArgs']]]]:
        """
        Specifies which plugins to use for the connector. See `plugin` Block for details.
        """
        return pulumi.get(self, "plugins")

    @plugins.setter
    def plugins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectorPluginArgs']]]]):
        pulumi.set(self, "plugins", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceExecutionRoleArn")
    def service_execution_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_execution_role_arn")

    @service_execution_role_arn.setter
    def service_execution_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_execution_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current version of the connector.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="workerConfiguration")
    def worker_configuration(self) -> Optional[pulumi.Input['ConnectorWorkerConfigurationArgs']]:
        """
        Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
        """
        return pulumi.get(self, "worker_configuration")

    @worker_configuration.setter
    def worker_configuration(self, value: Optional[pulumi.Input['ConnectorWorkerConfigurationArgs']]):
        pulumi.set(self, "worker_configuration", value)


@pulumi.type_token("aws:mskconnect/connector:Connector")
class Connector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[Union['ConnectorCapacityArgs', 'ConnectorCapacityArgsDict']]] = None,
                 connector_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_cluster: Optional[pulumi.Input[Union['ConnectorKafkaClusterArgs', 'ConnectorKafkaClusterArgsDict']]] = None,
                 kafka_cluster_client_authentication: Optional[pulumi.Input[Union['ConnectorKafkaClusterClientAuthenticationArgs', 'ConnectorKafkaClusterClientAuthenticationArgsDict']]] = None,
                 kafka_cluster_encryption_in_transit: Optional[pulumi.Input[Union['ConnectorKafkaClusterEncryptionInTransitArgs', 'ConnectorKafkaClusterEncryptionInTransitArgsDict']]] = None,
                 kafkaconnect_version: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery: Optional[pulumi.Input[Union['ConnectorLogDeliveryArgs', 'ConnectorLogDeliveryArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plugins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorPluginArgs', 'ConnectorPluginArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_configuration: Optional[pulumi.Input[Union['ConnectorWorkerConfigurationArgs', 'ConnectorWorkerConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Provides an Amazon MSK Connect Connector resource.

        ## Example Usage

        ### Basic configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.mskconnect.Connector("example",
            name="example",
            kafkaconnect_version="2.7.1",
            capacity={
                "autoscaling": {
                    "mcu_count": 1,
                    "min_worker_count": 1,
                    "max_worker_count": 2,
                    "scale_in_policy": {
                        "cpu_utilization_percentage": 20,
                    },
                    "scale_out_policy": {
                        "cpu_utilization_percentage": 80,
                    },
                },
            },
            connector_configuration={
                "connector.class": "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector",
                "tasks.max": "1",
                "topics": "example",
            },
            kafka_cluster={
                "apache_kafka_cluster": {
                    "bootstrap_servers": example_aws_msk_cluster["bootstrapBrokersTls"],
                    "vpc": {
                        "security_groups": [example_aws_security_group["id"]],
                        "subnets": [
                            example1["id"],
                            example2["id"],
                            example3["id"],
                        ],
                    },
                },
            },
            kafka_cluster_client_authentication={
                "authentication_type": "NONE",
            },
            kafka_cluster_encryption_in_transit={
                "encryption_type": "TLS",
            },
            plugins=[{
                "custom_plugin": {
                    "arn": example_aws_mskconnect_custom_plugin["arn"],
                    "revision": example_aws_mskconnect_custom_plugin["latestRevision"],
                },
            }],
            service_execution_role_arn=example_aws_iam_role["arn"])
        ```

        ## Import

        Using `pulumi import`, import MSK Connect Connector using the connector's `arn`. For example:

        ```sh
        $ pulumi import aws:mskconnect/connector:Connector example 'arn:aws:kafkaconnect:eu-central-1:123456789012:connector/example/264edee4-17a3-412e-bd76-6681cfc93805-3'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectorCapacityArgs', 'ConnectorCapacityArgsDict']] capacity: Information about the capacity allocated to the connector. See `capacity` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] connector_configuration: A map of keys to values that represent the configuration for the connector.
        :param pulumi.Input[_builtins.str] description: A summary description of the connector.
        :param pulumi.Input[Union['ConnectorKafkaClusterArgs', 'ConnectorKafkaClusterArgsDict']] kafka_cluster: Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
        :param pulumi.Input[Union['ConnectorKafkaClusterClientAuthenticationArgs', 'ConnectorKafkaClusterClientAuthenticationArgsDict']] kafka_cluster_client_authentication: Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
        :param pulumi.Input[Union['ConnectorKafkaClusterEncryptionInTransitArgs', 'ConnectorKafkaClusterEncryptionInTransitArgsDict']] kafka_cluster_encryption_in_transit: Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
        :param pulumi.Input[_builtins.str] kafkaconnect_version: The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
        :param pulumi.Input[Union['ConnectorLogDeliveryArgs', 'ConnectorLogDeliveryArgsDict']] log_delivery: Details about log delivery. See `log_delivery` Block for details.
        :param pulumi.Input[_builtins.str] name: The name of the connector.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectorPluginArgs', 'ConnectorPluginArgsDict']]]] plugins: Specifies which plugins to use for the connector. See `plugin` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] service_execution_role_arn: The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['ConnectorWorkerConfigurationArgs', 'ConnectorWorkerConfigurationArgsDict']] worker_configuration: Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Amazon MSK Connect Connector resource.

        ## Example Usage

        ### Basic configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.mskconnect.Connector("example",
            name="example",
            kafkaconnect_version="2.7.1",
            capacity={
                "autoscaling": {
                    "mcu_count": 1,
                    "min_worker_count": 1,
                    "max_worker_count": 2,
                    "scale_in_policy": {
                        "cpu_utilization_percentage": 20,
                    },
                    "scale_out_policy": {
                        "cpu_utilization_percentage": 80,
                    },
                },
            },
            connector_configuration={
                "connector.class": "com.github.jcustenborder.kafka.connect.simulator.SimulatorSinkConnector",
                "tasks.max": "1",
                "topics": "example",
            },
            kafka_cluster={
                "apache_kafka_cluster": {
                    "bootstrap_servers": example_aws_msk_cluster["bootstrapBrokersTls"],
                    "vpc": {
                        "security_groups": [example_aws_security_group["id"]],
                        "subnets": [
                            example1["id"],
                            example2["id"],
                            example3["id"],
                        ],
                    },
                },
            },
            kafka_cluster_client_authentication={
                "authentication_type": "NONE",
            },
            kafka_cluster_encryption_in_transit={
                "encryption_type": "TLS",
            },
            plugins=[{
                "custom_plugin": {
                    "arn": example_aws_mskconnect_custom_plugin["arn"],
                    "revision": example_aws_mskconnect_custom_plugin["latestRevision"],
                },
            }],
            service_execution_role_arn=example_aws_iam_role["arn"])
        ```

        ## Import

        Using `pulumi import`, import MSK Connect Connector using the connector's `arn`. For example:

        ```sh
        $ pulumi import aws:mskconnect/connector:Connector example 'arn:aws:kafkaconnect:eu-central-1:123456789012:connector/example/264edee4-17a3-412e-bd76-6681cfc93805-3'
        ```

        :param str resource_name: The name of the resource.
        :param ConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[Union['ConnectorCapacityArgs', 'ConnectorCapacityArgsDict']]] = None,
                 connector_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_cluster: Optional[pulumi.Input[Union['ConnectorKafkaClusterArgs', 'ConnectorKafkaClusterArgsDict']]] = None,
                 kafka_cluster_client_authentication: Optional[pulumi.Input[Union['ConnectorKafkaClusterClientAuthenticationArgs', 'ConnectorKafkaClusterClientAuthenticationArgsDict']]] = None,
                 kafka_cluster_encryption_in_transit: Optional[pulumi.Input[Union['ConnectorKafkaClusterEncryptionInTransitArgs', 'ConnectorKafkaClusterEncryptionInTransitArgsDict']]] = None,
                 kafkaconnect_version: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery: Optional[pulumi.Input[Union['ConnectorLogDeliveryArgs', 'ConnectorLogDeliveryArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plugins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorPluginArgs', 'ConnectorPluginArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 worker_configuration: Optional[pulumi.Input[Union['ConnectorWorkerConfigurationArgs', 'ConnectorWorkerConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectorArgs.__new__(ConnectorArgs)

            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            if connector_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'connector_configuration'")
            __props__.__dict__["connector_configuration"] = connector_configuration
            __props__.__dict__["description"] = description
            if kafka_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_cluster'")
            __props__.__dict__["kafka_cluster"] = kafka_cluster
            if kafka_cluster_client_authentication is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_cluster_client_authentication'")
            __props__.__dict__["kafka_cluster_client_authentication"] = kafka_cluster_client_authentication
            if kafka_cluster_encryption_in_transit is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_cluster_encryption_in_transit'")
            __props__.__dict__["kafka_cluster_encryption_in_transit"] = kafka_cluster_encryption_in_transit
            if kafkaconnect_version is None and not opts.urn:
                raise TypeError("Missing required property 'kafkaconnect_version'")
            __props__.__dict__["kafkaconnect_version"] = kafkaconnect_version
            __props__.__dict__["log_delivery"] = log_delivery
            __props__.__dict__["name"] = name
            if plugins is None and not opts.urn:
                raise TypeError("Missing required property 'plugins'")
            __props__.__dict__["plugins"] = plugins
            __props__.__dict__["region"] = region
            if service_execution_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'service_execution_role_arn'")
            __props__.__dict__["service_execution_role_arn"] = service_execution_role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["worker_configuration"] = worker_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["version"] = None
        super(Connector, __self__).__init__(
            'aws:mskconnect/connector:Connector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            capacity: Optional[pulumi.Input[Union['ConnectorCapacityArgs', 'ConnectorCapacityArgsDict']]] = None,
            connector_configuration: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            kafka_cluster: Optional[pulumi.Input[Union['ConnectorKafkaClusterArgs', 'ConnectorKafkaClusterArgsDict']]] = None,
            kafka_cluster_client_authentication: Optional[pulumi.Input[Union['ConnectorKafkaClusterClientAuthenticationArgs', 'ConnectorKafkaClusterClientAuthenticationArgsDict']]] = None,
            kafka_cluster_encryption_in_transit: Optional[pulumi.Input[Union['ConnectorKafkaClusterEncryptionInTransitArgs', 'ConnectorKafkaClusterEncryptionInTransitArgsDict']]] = None,
            kafkaconnect_version: Optional[pulumi.Input[_builtins.str]] = None,
            log_delivery: Optional[pulumi.Input[Union['ConnectorLogDeliveryArgs', 'ConnectorLogDeliveryArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            plugins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectorPluginArgs', 'ConnectorPluginArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            worker_configuration: Optional[pulumi.Input[Union['ConnectorWorkerConfigurationArgs', 'ConnectorWorkerConfigurationArgsDict']]] = None) -> 'Connector':
        """
        Get an existing Connector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the connector.
        :param pulumi.Input[Union['ConnectorCapacityArgs', 'ConnectorCapacityArgsDict']] capacity: Information about the capacity allocated to the connector. See `capacity` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] connector_configuration: A map of keys to values that represent the configuration for the connector.
        :param pulumi.Input[_builtins.str] description: A summary description of the connector.
        :param pulumi.Input[Union['ConnectorKafkaClusterArgs', 'ConnectorKafkaClusterArgsDict']] kafka_cluster: Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
        :param pulumi.Input[Union['ConnectorKafkaClusterClientAuthenticationArgs', 'ConnectorKafkaClusterClientAuthenticationArgsDict']] kafka_cluster_client_authentication: Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
        :param pulumi.Input[Union['ConnectorKafkaClusterEncryptionInTransitArgs', 'ConnectorKafkaClusterEncryptionInTransitArgsDict']] kafka_cluster_encryption_in_transit: Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
        :param pulumi.Input[_builtins.str] kafkaconnect_version: The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
        :param pulumi.Input[Union['ConnectorLogDeliveryArgs', 'ConnectorLogDeliveryArgsDict']] log_delivery: Details about log delivery. See `log_delivery` Block for details.
        :param pulumi.Input[_builtins.str] name: The name of the connector.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectorPluginArgs', 'ConnectorPluginArgsDict']]]] plugins: Specifies which plugins to use for the connector. See `plugin` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] service_execution_role_arn: The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] version: The current version of the connector.
        :param pulumi.Input[Union['ConnectorWorkerConfigurationArgs', 'ConnectorWorkerConfigurationArgsDict']] worker_configuration: Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectorState.__new__(_ConnectorState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["connector_configuration"] = connector_configuration
        __props__.__dict__["description"] = description
        __props__.__dict__["kafka_cluster"] = kafka_cluster
        __props__.__dict__["kafka_cluster_client_authentication"] = kafka_cluster_client_authentication
        __props__.__dict__["kafka_cluster_encryption_in_transit"] = kafka_cluster_encryption_in_transit
        __props__.__dict__["kafkaconnect_version"] = kafkaconnect_version
        __props__.__dict__["log_delivery"] = log_delivery
        __props__.__dict__["name"] = name
        __props__.__dict__["plugins"] = plugins
        __props__.__dict__["region"] = region
        __props__.__dict__["service_execution_role_arn"] = service_execution_role_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["version"] = version
        __props__.__dict__["worker_configuration"] = worker_configuration
        return Connector(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the connector.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output['outputs.ConnectorCapacity']:
        """
        Information about the capacity allocated to the connector. See `capacity` Block for details.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="connectorConfiguration")
    def connector_configuration(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of keys to values that represent the configuration for the connector.
        """
        return pulumi.get(self, "connector_configuration")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A summary description of the connector.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> pulumi.Output['outputs.ConnectorKafkaCluster']:
        """
        Specifies which Apache Kafka cluster to connect to. See `kafka_cluster` Block for details.
        """
        return pulumi.get(self, "kafka_cluster")

    @_builtins.property
    @pulumi.getter(name="kafkaClusterClientAuthentication")
    def kafka_cluster_client_authentication(self) -> pulumi.Output['outputs.ConnectorKafkaClusterClientAuthentication']:
        """
        Details of the client authentication used by the Apache Kafka cluster. See `kafka_cluster_client_authentication` Block for details.
        """
        return pulumi.get(self, "kafka_cluster_client_authentication")

    @_builtins.property
    @pulumi.getter(name="kafkaClusterEncryptionInTransit")
    def kafka_cluster_encryption_in_transit(self) -> pulumi.Output['outputs.ConnectorKafkaClusterEncryptionInTransit']:
        """
        Details of encryption in transit to the Apache Kafka cluster. See `kafka_cluster_encryption_in_transit` Block for details.
        """
        return pulumi.get(self, "kafka_cluster_encryption_in_transit")

    @_builtins.property
    @pulumi.getter(name="kafkaconnectVersion")
    def kafkaconnect_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
        """
        return pulumi.get(self, "kafkaconnect_version")

    @_builtins.property
    @pulumi.getter(name="logDelivery")
    def log_delivery(self) -> pulumi.Output[Optional['outputs.ConnectorLogDelivery']]:
        """
        Details about log delivery. See `log_delivery` Block for details.
        """
        return pulumi.get(self, "log_delivery")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the connector.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def plugins(self) -> pulumi.Output[Sequence['outputs.ConnectorPlugin']]:
        """
        Specifies which plugins to use for the connector. See `plugin` Block for details.
        """
        return pulumi.get(self, "plugins")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceExecutionRoleArn")
    def service_execution_role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.

        The following arguments are optional:
        """
        return pulumi.get(self, "service_execution_role_arn")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The current version of the connector.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="workerConfiguration")
    def worker_configuration(self) -> pulumi.Output[Optional['outputs.ConnectorWorkerConfiguration']]:
        """
        Specifies which worker configuration to use with the connector. See `worker_configuration` Block for details.
        """
        return pulumi.get(self, "worker_configuration")

