# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    """
    A collection of values returned by getConnection.
    """
    def __init__(__self__, arn=None, connected_device_id=None, connected_link_id=None, connection_id=None, description=None, device_id=None, global_network_id=None, id=None, link_id=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if connected_device_id and not isinstance(connected_device_id, str):
            raise TypeError("Expected argument 'connected_device_id' to be a str")
        pulumi.set(__self__, "connected_device_id", connected_device_id)
        if connected_link_id and not isinstance(connected_link_id, str):
            raise TypeError("Expected argument 'connected_link_id' to be a str")
        pulumi.set(__self__, "connected_link_id", connected_link_id)
        if connection_id and not isinstance(connection_id, str):
            raise TypeError("Expected argument 'connection_id' to be a str")
        pulumi.set(__self__, "connection_id", connection_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_id and not isinstance(device_id, str):
            raise TypeError("Expected argument 'device_id' to be a str")
        pulumi.set(__self__, "device_id", device_id)
        if global_network_id and not isinstance(global_network_id, str):
            raise TypeError("Expected argument 'global_network_id' to be a str")
        pulumi.set(__self__, "global_network_id", global_network_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if link_id and not isinstance(link_id, str):
            raise TypeError("Expected argument 'link_id' to be a str")
        pulumi.set(__self__, "link_id", link_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the connection.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="connectedDeviceId")
    def connected_device_id(self) -> _builtins.str:
        """
        ID of the second device in the connection.
        """
        return pulumi.get(self, "connected_device_id")

    @_builtins.property
    @pulumi.getter(name="connectedLinkId")
    def connected_link_id(self) -> _builtins.str:
        """
        ID of the link for the second device.
        """
        return pulumi.get(self, "connected_link_id")

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> _builtins.str:
        return pulumi.get(self, "connection_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the connection.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> _builtins.str:
        """
        ID of the first device in the connection.
        """
        return pulumi.get(self, "device_id")

    @_builtins.property
    @pulumi.getter(name="globalNetworkId")
    def global_network_id(self) -> _builtins.str:
        return pulumi.get(self, "global_network_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="linkId")
    def link_id(self) -> _builtins.str:
        """
        ID of the link for the first device.
        """
        return pulumi.get(self, "link_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Key-value tags for the connection.
        """
        return pulumi.get(self, "tags")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            arn=self.arn,
            connected_device_id=self.connected_device_id,
            connected_link_id=self.connected_link_id,
            connection_id=self.connection_id,
            description=self.description,
            device_id=self.device_id,
            global_network_id=self.global_network_id,
            id=self.id,
            link_id=self.link_id,
            tags=self.tags)


def get_connection(connection_id: Optional[_builtins.str] = None,
                   global_network_id: Optional[_builtins.str] = None,
                   tags: Optional[Mapping[str, _builtins.str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    Provides details about an existing Network Manager connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_connection(global_network_id=global_network_id,
        connection_id=connection_id)
    ```


    :param _builtins.str connection_id: ID of the specific connection to retrieve.
    :param _builtins.str global_network_id: ID of the Global Network of the connection to retrieve.
    :param Mapping[str, _builtins.str] tags: Key-value tags for the connection.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    __args__['globalNetworkId'] = global_network_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:networkmanager/getConnection:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        arn=pulumi.get(__ret__, 'arn'),
        connected_device_id=pulumi.get(__ret__, 'connected_device_id'),
        connected_link_id=pulumi.get(__ret__, 'connected_link_id'),
        connection_id=pulumi.get(__ret__, 'connection_id'),
        description=pulumi.get(__ret__, 'description'),
        device_id=pulumi.get(__ret__, 'device_id'),
        global_network_id=pulumi.get(__ret__, 'global_network_id'),
        id=pulumi.get(__ret__, 'id'),
        link_id=pulumi.get(__ret__, 'link_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_connection_output(connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                          global_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                          tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectionResult]:
    """
    Provides details about an existing Network Manager connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.networkmanager.get_connection(global_network_id=global_network_id,
        connection_id=connection_id)
    ```


    :param _builtins.str connection_id: ID of the specific connection to retrieve.
    :param _builtins.str global_network_id: ID of the Global Network of the connection to retrieve.
    :param Mapping[str, _builtins.str] tags: Key-value tags for the connection.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    __args__['globalNetworkId'] = global_network_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:networkmanager/getConnection:getConnection', __args__, opts=opts, typ=GetConnectionResult)
    return __ret__.apply(lambda __response__: GetConnectionResult(
        arn=pulumi.get(__response__, 'arn'),
        connected_device_id=pulumi.get(__response__, 'connected_device_id'),
        connected_link_id=pulumi.get(__response__, 'connected_link_id'),
        connection_id=pulumi.get(__response__, 'connection_id'),
        description=pulumi.get(__response__, 'description'),
        device_id=pulumi.get(__response__, 'device_id'),
        global_network_id=pulumi.get(__response__, 'global_network_id'),
        id=pulumi.get(__response__, 'id'),
        link_id=pulumi.get(__response__, 'link_id'),
        tags=pulumi.get(__response__, 'tags')))
