# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EventRuleArgs', 'EventRule']

@pulumi.input_type
class EventRuleArgs:
    def __init__(__self__, *,
                 event_type: pulumi.Input[_builtins.str],
                 notification_configuration_arn: pulumi.Input[_builtins.str],
                 regions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 source: pulumi.Input[_builtins.str],
                 event_pattern: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EventRule resource.
        :param pulumi.Input[_builtins.str] event_type: Type of event to match. Must be between 1 and 128 characters, and match the pattern `([a-zA-Z0-9 \\-\\(\\)])+`.
        :param pulumi.Input[_builtins.str] notification_configuration_arn: ARN of the notification configuration to associate with this event rule. Must match the pattern `arn:aws:notifications::[0-9]{12}:configuration/[a-z0-9]{27}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: Set of AWS regions where the event rule will be applied. Each region must be between 2 and 25 characters, and match the pattern `([a-z]{1,2})-([a-z]{1,15}-)+([0-9])`.
        :param pulumi.Input[_builtins.str] source: Source of the event. Must be between 1 and 36 characters, and match the pattern `aws.([a-z0-9\\-])+`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] event_pattern: JSON string defining the event pattern to match. Maximum length is 4096 characters.
        """
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "notification_configuration_arn", notification_configuration_arn)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "source", source)
        if event_pattern is not None:
            pulumi.set(__self__, "event_pattern", event_pattern)

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of event to match. Must be between 1 and 128 characters, and match the pattern `([a-zA-Z0-9 \\-\\(\\)])+`.
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "event_type", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfigurationArn")
    def notification_configuration_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the notification configuration to associate with this event rule. Must match the pattern `arn:aws:notifications::[0-9]{12}:configuration/[a-z0-9]{27}`.
        """
        return pulumi.get(self, "notification_configuration_arn")

    @notification_configuration_arn.setter
    def notification_configuration_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "notification_configuration_arn", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Set of AWS regions where the event rule will be applied. Each region must be between 2 and 25 characters, and match the pattern `([a-z]{1,2})-([a-z]{1,15}-)+([0-9])`.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        Source of the event. Must be between 1 and 36 characters, and match the pattern `aws.([a-z0-9\\-])+`.

        The following arguments are optional:
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON string defining the event pattern to match. Maximum length is 4096 characters.
        """
        return pulumi.get(self, "event_pattern")

    @event_pattern.setter
    def event_pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_pattern", value)


@pulumi.input_type
class _EventRuleState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 event_pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 event_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_configuration_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EventRule resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the Event Rule.
        :param pulumi.Input[_builtins.str] event_pattern: JSON string defining the event pattern to match. Maximum length is 4096 characters.
        :param pulumi.Input[_builtins.str] event_type: Type of event to match. Must be between 1 and 128 characters, and match the pattern `([a-zA-Z0-9 \\-\\(\\)])+`.
        :param pulumi.Input[_builtins.str] notification_configuration_arn: ARN of the notification configuration to associate with this event rule. Must match the pattern `arn:aws:notifications::[0-9]{12}:configuration/[a-z0-9]{27}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: Set of AWS regions where the event rule will be applied. Each region must be between 2 and 25 characters, and match the pattern `([a-z]{1,2})-([a-z]{1,15}-)+([0-9])`.
        :param pulumi.Input[_builtins.str] source: Source of the event. Must be between 1 and 36 characters, and match the pattern `aws.([a-z0-9\\-])+`.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if event_pattern is not None:
            pulumi.set(__self__, "event_pattern", event_pattern)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if notification_configuration_arn is not None:
            pulumi.set(__self__, "notification_configuration_arn", notification_configuration_arn)
        if regions is not None:
            pulumi.set(__self__, "regions", regions)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Event Rule.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JSON string defining the event pattern to match. Maximum length is 4096 characters.
        """
        return pulumi.get(self, "event_pattern")

    @event_pattern.setter
    def event_pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_pattern", value)

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of event to match. Must be between 1 and 128 characters, and match the pattern `([a-zA-Z0-9 \\-\\(\\)])+`.
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "event_type", value)

    @_builtins.property
    @pulumi.getter(name="notificationConfigurationArn")
    def notification_configuration_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the notification configuration to associate with this event rule. Must match the pattern `arn:aws:notifications::[0-9]{12}:configuration/[a-z0-9]{27}`.
        """
        return pulumi.get(self, "notification_configuration_arn")

    @notification_configuration_arn.setter
    def notification_configuration_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_configuration_arn", value)

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of AWS regions where the event rule will be applied. Each region must be between 2 and 25 characters, and match the pattern `([a-z]{1,2})-([a-z]{1,15}-)+([0-9])`.
        """
        return pulumi.get(self, "regions")

    @regions.setter
    def regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "regions", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source of the event. Must be between 1 and 36 characters, and match the pattern `aws.([a-z0-9\\-])+`.

        The following arguments are optional:
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


@pulumi.type_token("aws:notifications/eventRule:EventRule")
class EventRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 event_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_configuration_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS User Notifications Event Rule.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.notifications.NotificationConfiguration("example",
            name="example",
            description="example configuration")
        example_event_rule = aws.notifications.EventRule("example",
            event_pattern=json.dumps({
                "detail": {
                    "state": {
                        "value": ["ALARM"],
                    },
                },
            }),
            event_type="CloudWatch Alarm State Change",
            notification_configuration_arn=example.arn,
            regions=[
                "us-east-1",
                "us-west-2",
            ],
            source="aws.cloudwatch")
        ```

        ## Import

        Using `pulumi import`, import User Notifications Event Rule using the `arn`. For example:

        ```sh
        $ pulumi import aws:notifications/eventRule:EventRule example arn:aws:notifications::123456789012:configuration/abc123def456ghi789jkl012mno345/rule/abc123def456ghi789jkl012mno345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] event_pattern: JSON string defining the event pattern to match. Maximum length is 4096 characters.
        :param pulumi.Input[_builtins.str] event_type: Type of event to match. Must be between 1 and 128 characters, and match the pattern `([a-zA-Z0-9 \\-\\(\\)])+`.
        :param pulumi.Input[_builtins.str] notification_configuration_arn: ARN of the notification configuration to associate with this event rule. Must match the pattern `arn:aws:notifications::[0-9]{12}:configuration/[a-z0-9]{27}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: Set of AWS regions where the event rule will be applied. Each region must be between 2 and 25 characters, and match the pattern `([a-z]{1,2})-([a-z]{1,15}-)+([0-9])`.
        :param pulumi.Input[_builtins.str] source: Source of the event. Must be between 1 and 36 characters, and match the pattern `aws.([a-z0-9\\-])+`.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS User Notifications Event Rule.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.notifications.NotificationConfiguration("example",
            name="example",
            description="example configuration")
        example_event_rule = aws.notifications.EventRule("example",
            event_pattern=json.dumps({
                "detail": {
                    "state": {
                        "value": ["ALARM"],
                    },
                },
            }),
            event_type="CloudWatch Alarm State Change",
            notification_configuration_arn=example.arn,
            regions=[
                "us-east-1",
                "us-west-2",
            ],
            source="aws.cloudwatch")
        ```

        ## Import

        Using `pulumi import`, import User Notifications Event Rule using the `arn`. For example:

        ```sh
        $ pulumi import aws:notifications/eventRule:EventRule example arn:aws:notifications::123456789012:configuration/abc123def456ghi789jkl012mno345/rule/abc123def456ghi789jkl012mno345
        ```

        :param str resource_name: The name of the resource.
        :param EventRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 event_type: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_configuration_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventRuleArgs.__new__(EventRuleArgs)

            __props__.__dict__["event_pattern"] = event_pattern
            if event_type is None and not opts.urn:
                raise TypeError("Missing required property 'event_type'")
            __props__.__dict__["event_type"] = event_type
            if notification_configuration_arn is None and not opts.urn:
                raise TypeError("Missing required property 'notification_configuration_arn'")
            __props__.__dict__["notification_configuration_arn"] = notification_configuration_arn
            if regions is None and not opts.urn:
                raise TypeError("Missing required property 'regions'")
            __props__.__dict__["regions"] = regions
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["arn"] = None
        super(EventRule, __self__).__init__(
            'aws:notifications/eventRule:EventRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            event_pattern: Optional[pulumi.Input[_builtins.str]] = None,
            event_type: Optional[pulumi.Input[_builtins.str]] = None,
            notification_configuration_arn: Optional[pulumi.Input[_builtins.str]] = None,
            regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None) -> 'EventRule':
        """
        Get an existing EventRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the Event Rule.
        :param pulumi.Input[_builtins.str] event_pattern: JSON string defining the event pattern to match. Maximum length is 4096 characters.
        :param pulumi.Input[_builtins.str] event_type: Type of event to match. Must be between 1 and 128 characters, and match the pattern `([a-zA-Z0-9 \\-\\(\\)])+`.
        :param pulumi.Input[_builtins.str] notification_configuration_arn: ARN of the notification configuration to associate with this event rule. Must match the pattern `arn:aws:notifications::[0-9]{12}:configuration/[a-z0-9]{27}`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] regions: Set of AWS regions where the event rule will be applied. Each region must be between 2 and 25 characters, and match the pattern `([a-z]{1,2})-([a-z]{1,15}-)+([0-9])`.
        :param pulumi.Input[_builtins.str] source: Source of the event. Must be between 1 and 36 characters, and match the pattern `aws.([a-z0-9\\-])+`.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EventRuleState.__new__(_EventRuleState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["event_pattern"] = event_pattern
        __props__.__dict__["event_type"] = event_type
        __props__.__dict__["notification_configuration_arn"] = notification_configuration_arn
        __props__.__dict__["regions"] = regions
        __props__.__dict__["source"] = source
        return EventRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Event Rule.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        JSON string defining the event pattern to match. Maximum length is 4096 characters.
        """
        return pulumi.get(self, "event_pattern")

    @_builtins.property
    @pulumi.getter(name="eventType")
    def event_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of event to match. Must be between 1 and 128 characters, and match the pattern `([a-zA-Z0-9 \\-\\(\\)])+`.
        """
        return pulumi.get(self, "event_type")

    @_builtins.property
    @pulumi.getter(name="notificationConfigurationArn")
    def notification_configuration_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the notification configuration to associate with this event rule. Must match the pattern `arn:aws:notifications::[0-9]{12}:configuration/[a-z0-9]{27}`.
        """
        return pulumi.get(self, "notification_configuration_arn")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Set of AWS regions where the event rule will be applied. Each region must be between 2 and 25 characters, and match the pattern `([a-z]{1,2})-([a-z]{1,15}-)+([0-9])`.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        Source of the event. Must be between 1 and 36 characters, and match the pattern `aws.([a-z0-9\\-])+`.

        The following arguments are optional:
        """
        return pulumi.get(self, "source")

