# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LinkArgs', 'Link']

@pulumi.input_type
class LinkArgs:
    def __init__(__self__, *,
                 label_template: pulumi.Input[_builtins.str],
                 resource_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 sink_identifier: pulumi.Input[_builtins.str],
                 link_configuration: Optional[pulumi.Input['LinkLinkConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Link resource.
        :param pulumi.Input[_builtins.str] label_template: Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types: Types of data that the source account shares with the monitoring account.
        :param pulumi.Input[_builtins.str] sink_identifier: Identifier of the sink to use to create this link.
               
               The following arguments are optional:
        :param pulumi.Input['LinkLinkConfigurationArgs'] link_configuration: Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "label_template", label_template)
        pulumi.set(__self__, "resource_types", resource_types)
        pulumi.set(__self__, "sink_identifier", sink_identifier)
        if link_configuration is not None:
            pulumi.set(__self__, "link_configuration", link_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="labelTemplate")
    def label_template(self) -> pulumi.Input[_builtins.str]:
        """
        Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        """
        return pulumi.get(self, "label_template")

    @label_template.setter
    def label_template(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label_template", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Types of data that the source account shares with the monitoring account.
        """
        return pulumi.get(self, "resource_types")

    @resource_types.setter
    def resource_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "resource_types", value)

    @_builtins.property
    @pulumi.getter(name="sinkIdentifier")
    def sink_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the sink to use to create this link.

        The following arguments are optional:
        """
        return pulumi.get(self, "sink_identifier")

    @sink_identifier.setter
    def sink_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sink_identifier", value)

    @_builtins.property
    @pulumi.getter(name="linkConfiguration")
    def link_configuration(self) -> Optional[pulumi.Input['LinkLinkConfigurationArgs']]:
        """
        Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
        """
        return pulumi.get(self, "link_configuration")

    @link_configuration.setter
    def link_configuration(self, value: Optional[pulumi.Input['LinkLinkConfigurationArgs']]):
        pulumi.set(self, "link_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _LinkState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 label_template: Optional[pulumi.Input[_builtins.str]] = None,
                 link_configuration: Optional[pulumi.Input['LinkLinkConfigurationArgs']] = None,
                 link_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sink_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 sink_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Link resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the link.
        :param pulumi.Input[_builtins.str] label: Label that is assigned to this link.
        :param pulumi.Input[_builtins.str] label_template: Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        :param pulumi.Input['LinkLinkConfigurationArgs'] link_configuration: Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
        :param pulumi.Input[_builtins.str] link_id: ID string that AWS generated as part of the link ARN.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types: Types of data that the source account shares with the monitoring account.
        :param pulumi.Input[_builtins.str] sink_arn: ARN of the sink that is used for this link.
        :param pulumi.Input[_builtins.str] sink_identifier: Identifier of the sink to use to create this link.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if label_template is not None:
            pulumi.set(__self__, "label_template", label_template)
        if link_configuration is not None:
            pulumi.set(__self__, "link_configuration", link_configuration)
        if link_id is not None:
            pulumi.set(__self__, "link_id", link_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_types is not None:
            pulumi.set(__self__, "resource_types", resource_types)
        if sink_arn is not None:
            pulumi.set(__self__, "sink_arn", sink_arn)
        if sink_identifier is not None:
            pulumi.set(__self__, "sink_identifier", sink_identifier)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the link.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Label that is assigned to this link.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter(name="labelTemplate")
    def label_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        """
        return pulumi.get(self, "label_template")

    @label_template.setter
    def label_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label_template", value)

    @_builtins.property
    @pulumi.getter(name="linkConfiguration")
    def link_configuration(self) -> Optional[pulumi.Input['LinkLinkConfigurationArgs']]:
        """
        Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
        """
        return pulumi.get(self, "link_configuration")

    @link_configuration.setter
    def link_configuration(self, value: Optional[pulumi.Input['LinkLinkConfigurationArgs']]):
        pulumi.set(self, "link_configuration", value)

    @_builtins.property
    @pulumi.getter(name="linkId")
    def link_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID string that AWS generated as part of the link ARN.
        """
        return pulumi.get(self, "link_id")

    @link_id.setter
    def link_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Types of data that the source account shares with the monitoring account.
        """
        return pulumi.get(self, "resource_types")

    @resource_types.setter
    def resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "resource_types", value)

    @_builtins.property
    @pulumi.getter(name="sinkArn")
    def sink_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the sink that is used for this link.
        """
        return pulumi.get(self, "sink_arn")

    @sink_arn.setter
    def sink_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sink_arn", value)

    @_builtins.property
    @pulumi.getter(name="sinkIdentifier")
    def sink_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the sink to use to create this link.

        The following arguments are optional:
        """
        return pulumi.get(self, "sink_identifier")

    @sink_identifier.setter
    def sink_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sink_identifier", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:oam/link:Link")
class Link(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label_template: Optional[pulumi.Input[_builtins.str]] = None,
                 link_configuration: Optional[pulumi.Input[Union['LinkLinkConfigurationArgs', 'LinkLinkConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sink_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS CloudWatch Observability Access Manager Link.

        > **NOTE:** Creating an `oam.Link` may sometimes fail if the `oam.SinkPolicy` for the attached `oam.Sink` is not created before the `oam.Link`. To prevent this, declare an explicit dependency using a `depends_on` meta-argument.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_sink = aws.oam.Sink("example")
        example_sink_policy = aws.oam.SinkPolicy("example", sink_identifier=example_sink.arn)
        example = aws.oam.Link("example",
            label_template="$AccountName",
            resource_types=["AWS::CloudWatch::Metric"],
            sink_identifier=example_sink.arn,
            tags={
                "Env": "prod",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_sink_policy]))
        ```

        ### Log Group Filtering

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.oam.Link("example",
            label_template="$AccountName",
            link_configuration={
                "log_group_configuration": {
                    "filter": "LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'",
                },
            },
            resource_types=["AWS::Logs::LogGroup"],
            sink_identifier=example_aws_oam_sink["arn"],
            opts = pulumi.ResourceOptions(depends_on=[example_aws_oam_sink_policy]))
        ```

        ### Metric Filtering

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.oam.Link("example",
            label_template="$AccountName",
            link_configuration={
                "metric_configuration": {
                    "filter": "Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')",
                },
            },
            resource_types=["AWS::CloudWatch::Metric"],
            sink_identifier=example_aws_oam_sink["arn"],
            opts = pulumi.ResourceOptions(depends_on=[example_aws_oam_sink_policy]))
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Observability Access Manager Link using the `arn`. For example:

        ```sh
        $ pulumi import aws:oam/link:Link example arn:aws:oam:us-west-2:123456789012:link/link-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] label_template: Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        :param pulumi.Input[Union['LinkLinkConfigurationArgs', 'LinkLinkConfigurationArgsDict']] link_configuration: Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types: Types of data that the source account shares with the monitoring account.
        :param pulumi.Input[_builtins.str] sink_identifier: Identifier of the sink to use to create this link.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS CloudWatch Observability Access Manager Link.

        > **NOTE:** Creating an `oam.Link` may sometimes fail if the `oam.SinkPolicy` for the attached `oam.Sink` is not created before the `oam.Link`. To prevent this, declare an explicit dependency using a `depends_on` meta-argument.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_sink = aws.oam.Sink("example")
        example_sink_policy = aws.oam.SinkPolicy("example", sink_identifier=example_sink.arn)
        example = aws.oam.Link("example",
            label_template="$AccountName",
            resource_types=["AWS::CloudWatch::Metric"],
            sink_identifier=example_sink.arn,
            tags={
                "Env": "prod",
            },
            opts = pulumi.ResourceOptions(depends_on=[example_sink_policy]))
        ```

        ### Log Group Filtering

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.oam.Link("example",
            label_template="$AccountName",
            link_configuration={
                "log_group_configuration": {
                    "filter": "LogGroupName LIKE 'aws/lambda/%' OR LogGroupName LIKE 'AWSLogs%'",
                },
            },
            resource_types=["AWS::Logs::LogGroup"],
            sink_identifier=example_aws_oam_sink["arn"],
            opts = pulumi.ResourceOptions(depends_on=[example_aws_oam_sink_policy]))
        ```

        ### Metric Filtering

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.oam.Link("example",
            label_template="$AccountName",
            link_configuration={
                "metric_configuration": {
                    "filter": "Namespace IN ('AWS/EC2', 'AWS/ELB', 'AWS/S3')",
                },
            },
            resource_types=["AWS::CloudWatch::Metric"],
            sink_identifier=example_aws_oam_sink["arn"],
            opts = pulumi.ResourceOptions(depends_on=[example_aws_oam_sink_policy]))
        ```

        ## Import

        Using `pulumi import`, import CloudWatch Observability Access Manager Link using the `arn`. For example:

        ```sh
        $ pulumi import aws:oam/link:Link example arn:aws:oam:us-west-2:123456789012:link/link-id
        ```

        :param str resource_name: The name of the resource.
        :param LinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label_template: Optional[pulumi.Input[_builtins.str]] = None,
                 link_configuration: Optional[pulumi.Input[Union['LinkLinkConfigurationArgs', 'LinkLinkConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sink_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkArgs.__new__(LinkArgs)

            if label_template is None and not opts.urn:
                raise TypeError("Missing required property 'label_template'")
            __props__.__dict__["label_template"] = label_template
            __props__.__dict__["link_configuration"] = link_configuration
            __props__.__dict__["region"] = region
            if resource_types is None and not opts.urn:
                raise TypeError("Missing required property 'resource_types'")
            __props__.__dict__["resource_types"] = resource_types
            if sink_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'sink_identifier'")
            __props__.__dict__["sink_identifier"] = sink_identifier
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["label"] = None
            __props__.__dict__["link_id"] = None
            __props__.__dict__["sink_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Link, __self__).__init__(
            'aws:oam/link:Link',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            label_template: Optional[pulumi.Input[_builtins.str]] = None,
            link_configuration: Optional[pulumi.Input[Union['LinkLinkConfigurationArgs', 'LinkLinkConfigurationArgsDict']]] = None,
            link_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sink_arn: Optional[pulumi.Input[_builtins.str]] = None,
            sink_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Link':
        """
        Get an existing Link resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the link.
        :param pulumi.Input[_builtins.str] label: Label that is assigned to this link.
        :param pulumi.Input[_builtins.str] label_template: Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        :param pulumi.Input[Union['LinkLinkConfigurationArgs', 'LinkLinkConfigurationArgsDict']] link_configuration: Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
        :param pulumi.Input[_builtins.str] link_id: ID string that AWS generated as part of the link ARN.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resource_types: Types of data that the source account shares with the monitoring account.
        :param pulumi.Input[_builtins.str] sink_arn: ARN of the sink that is used for this link.
        :param pulumi.Input[_builtins.str] sink_identifier: Identifier of the sink to use to create this link.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinkState.__new__(_LinkState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["label"] = label
        __props__.__dict__["label_template"] = label_template
        __props__.__dict__["link_configuration"] = link_configuration
        __props__.__dict__["link_id"] = link_id
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_types"] = resource_types
        __props__.__dict__["sink_arn"] = sink_arn
        __props__.__dict__["sink_identifier"] = sink_identifier
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return Link(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the link.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        Label that is assigned to this link.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="labelTemplate")
    def label_template(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable name to use to identify this source account when you are viewing data from it in the monitoring account.
        """
        return pulumi.get(self, "label_template")

    @_builtins.property
    @pulumi.getter(name="linkConfiguration")
    def link_configuration(self) -> pulumi.Output[Optional['outputs.LinkLinkConfiguration']]:
        """
        Configuration for creating filters that specify that only some metric namespaces or log groups are to be shared from the source account to the monitoring account. See `link_configuration` Block for details.
        """
        return pulumi.get(self, "link_configuration")

    @_builtins.property
    @pulumi.getter(name="linkId")
    def link_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID string that AWS generated as part of the link ARN.
        """
        return pulumi.get(self, "link_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Types of data that the source account shares with the monitoring account.
        """
        return pulumi.get(self, "resource_types")

    @_builtins.property
    @pulumi.getter(name="sinkArn")
    def sink_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the sink that is used for this link.
        """
        return pulumi.get(self, "sink_arn")

    @_builtins.property
    @pulumi.getter(name="sinkIdentifier")
    def sink_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the sink to use to create this link.

        The following arguments are optional:
        """
        return pulumi.get(self, "sink_identifier")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

