# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudAutonomousVmClusterArgs', 'CloudAutonomousVmCluster']

@pulumi.input_type
class CloudAutonomousVmClusterArgs:
    def __init__(__self__, *,
                 autonomous_data_storage_size_in_tbs: pulumi.Input[_builtins.float],
                 cloud_exadata_infrastructure_id: pulumi.Input[_builtins.str],
                 cpu_core_count_per_node: pulumi.Input[_builtins.int],
                 db_servers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 display_name: pulumi.Input[_builtins.str],
                 memory_per_oracle_compute_unit_in_gbs: pulumi.Input[_builtins.int],
                 odb_network_id: pulumi.Input[_builtins.str],
                 scan_listener_port_non_tls: pulumi.Input[_builtins.int],
                 scan_listener_port_tls: pulumi.Input[_builtins.int],
                 total_container_databases: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_mtls_enabled_vm_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['CloudAutonomousVmClusterTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a CloudAutonomousVmCluster resource.
        :param pulumi.Input[_builtins.int] cpu_core_count_per_node: The number of CPU cores enabled per node in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] description: The description of the Autonomous VM cluster.
        :param pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs'] maintenance_window: The maintenance window of the Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "autonomous_data_storage_size_in_tbs", autonomous_data_storage_size_in_tbs)
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        pulumi.set(__self__, "cpu_core_count_per_node", cpu_core_count_per_node)
        pulumi.set(__self__, "db_servers", db_servers)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "memory_per_oracle_compute_unit_in_gbs", memory_per_oracle_compute_unit_in_gbs)
        pulumi.set(__self__, "odb_network_id", odb_network_id)
        pulumi.set(__self__, "scan_listener_port_non_tls", scan_listener_port_non_tls)
        pulumi.set(__self__, "scan_listener_port_tls", scan_listener_port_tls)
        pulumi.set(__self__, "total_container_databases", total_container_databases)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_mtls_enabled_vm_cluster is not None:
            pulumi.set(__self__, "is_mtls_enabled_vm_cluster", is_mtls_enabled_vm_cluster)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="autonomousDataStorageSizeInTbs")
    def autonomous_data_storage_size_in_tbs(self) -> pulumi.Input[_builtins.float]:
        return pulumi.get(self, "autonomous_data_storage_size_in_tbs")

    @autonomous_data_storage_size_in_tbs.setter
    def autonomous_data_storage_size_in_tbs(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "autonomous_data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @_builtins.property
    @pulumi.getter(name="cpuCoreCountPerNode")
    def cpu_core_count_per_node(self) -> pulumi.Input[_builtins.int]:
        """
        The number of CPU cores enabled per node in the Autonomous VM cluster.
        """
        return pulumi.get(self, "cpu_core_count_per_node")

    @cpu_core_count_per_node.setter
    def cpu_core_count_per_node(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cpu_core_count_per_node", value)

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "db_servers", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @memory_per_oracle_compute_unit_in_gbs.setter
    def memory_per_oracle_compute_unit_in_gbs(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "memory_per_oracle_compute_unit_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "odb_network_id")

    @odb_network_id.setter
    def odb_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "odb_network_id", value)

    @_builtins.property
    @pulumi.getter(name="scanListenerPortNonTls")
    def scan_listener_port_non_tls(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "scan_listener_port_non_tls")

    @scan_listener_port_non_tls.setter
    def scan_listener_port_non_tls(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "scan_listener_port_non_tls", value)

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTls")
    def scan_listener_port_tls(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "scan_listener_port_tls")

    @scan_listener_port_tls.setter
    def scan_listener_port_tls(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "scan_listener_port_tls", value)

    @_builtins.property
    @pulumi.getter(name="totalContainerDatabases")
    def total_container_databases(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "total_container_databases")

    @total_container_databases.setter
    def total_container_databases(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "total_container_databases", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Autonomous VM cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isMtlsEnabledVmCluster")
    def is_mtls_enabled_vm_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_mtls_enabled_vm_cluster")

    @is_mtls_enabled_vm_cluster.setter
    def is_mtls_enabled_vm_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_mtls_enabled_vm_cluster", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs']]:
        """
        The maintenance window of the Autonomous VM cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudAutonomousVmClusterTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudAutonomousVmClusterTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _CloudAutonomousVmClusterState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 autonomous_data_storage_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 available_autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 available_container_databases: Optional[pulumi.Input[_builtins.int]] = None,
                 available_cpus: Optional[pulumi.Input[_builtins.float]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_model: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_core_count_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 cpu_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 data_storage_size_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 exadata_storage_in_tbs_lowest_scaled_value: Optional[pulumi.Input[_builtins.float]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 is_mtls_enabled_vm_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs']] = None,
                 max_acds_lowest_scaled_value: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 non_provisionable_autonomous_container_databases: Optional[pulumi.Input[_builtins.int]] = None,
                 oci_resource_anchor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 percent_progress: Optional[pulumi.Input[_builtins.float]] = None,
                 provisionable_autonomous_container_databases: Optional[pulumi.Input[_builtins.int]] = None,
                 provisioned_autonomous_container_databases: Optional[pulumi.Input[_builtins.int]] = None,
                 provisioned_cpus: Optional[pulumi.Input[_builtins.float]] = None,
                 reclaimable_cpus: Optional[pulumi.Input[_builtins.float]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserved_cpus: Optional[pulumi.Input[_builtins.float]] = None,
                 scan_listener_port_non_tls: Optional[pulumi.Input[_builtins.int]] = None,
                 scan_listener_port_tls: Optional[pulumi.Input[_builtins.int]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_database_ssl_certificate_expires: Optional[pulumi.Input[_builtins.str]] = None,
                 time_ords_certificate_expires: Optional[pulumi.Input[_builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['CloudAutonomousVmClusterTimeoutsArgs']] = None,
                 total_container_databases: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CloudAutonomousVmCluster resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) for the Exadata infrastructure.
        :param pulumi.Input[_builtins.float] autonomous_data_storage_percentage: The progress of the current operation on the Autonomous VM cluster, as a percentage.
        :param pulumi.Input[_builtins.float] available_autonomous_data_storage_size_in_tbs: The available data storage space for Autonomous Databases in the Autonomous VM cluster, in TB.
        :param pulumi.Input[_builtins.int] available_container_databases: The number of Autonomous CDBs that you can create with the currently available storage.
        :param pulumi.Input[_builtins.float] available_cpus: The number of CPU cores available for allocation to Autonomous Databases.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous VM cluster: ECPU or OCPU.
        :param pulumi.Input[_builtins.int] cpu_core_count: The total number of CPU cores in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.int] cpu_core_count_per_node: The number of CPU cores enabled per node in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.float] cpu_percentage: The percentage of total CPU cores currently in use in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] created_at: The date and time when the Autonomous VM cluster was created.
        :param pulumi.Input[_builtins.float] data_storage_size_in_gbs: The total data storage allocated to the Autonomous VM cluster, in GB.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The total data storage allocated to the Autonomous VM cluster, in TB.
        :param pulumi.Input[_builtins.str] description: The description of the Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] domain: The domain name of the Autonomous VM cluster.
        :param pulumi.Input[_builtins.float] exadata_storage_in_tbs_lowest_scaled_value: The minimum value to which you can scale down the Exadata storage, in TB.
        :param pulumi.Input[_builtins.str] hostname: The hostname of the Autonomous VM cluster.
        :param pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs'] maintenance_window: The maintenance window of the Autonomous VM cluster.
        :param pulumi.Input[_builtins.int] max_acds_lowest_scaled_value: The minimum value to which you can scale down the maximum number of Autonomous CDBs.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The total amount of memory allocated to the Autonomous VM cluster, in gigabytes(GB).
        :param pulumi.Input[_builtins.int] node_count: The number of database server nodes in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.int] non_provisionable_autonomous_container_databases: The number of Autonomous CDBs that can't be provisioned because of resource constraints.
        :param pulumi.Input[_builtins.str] oci_resource_anchor_name: The name of the OCI resource anchor associated with this Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] oci_url: The URL for accessing the OCI console page for this Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] ocid: The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
        :param pulumi.Input[_builtins.int] odb_node_storage_size_in_gbs: The local node storage allocated to the Autonomous VM cluster, in gigabytes (GB).
        :param pulumi.Input[_builtins.float] percent_progress: The progress of the current operation on the Autonomous VM cluster, as a percentage.
        :param pulumi.Input[_builtins.int] provisionable_autonomous_container_databases: The number of Autonomous CDBs that can be provisioned in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.int] provisioned_autonomous_container_databases: The number of Autonomous CDBs currently provisioned in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.float] provisioned_cpus: The number of CPUs provisioned in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.float] reclaimable_cpus: The number of CPU cores that can be reclaimed from terminated or scaled-down Autonomous Databases.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.float] reserved_cpus: The number of CPU cores reserved for system operations and redundancy.
        :param pulumi.Input[_builtins.str] shape: The shape of the Exadata infrastructure for the Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] status: The status of the Autonomous VM cluster. Possible values include CREATING, AVAILABLE, UPDATING, DELETING, DELETED, FAILED.
        :param pulumi.Input[_builtins.str] status_reason: Additional information about the current status of the Autonomous VM cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: The combined set of user-defined and provider-defined tags.
        :param pulumi.Input[_builtins.str] time_database_ssl_certificate_expires: The expiration date and time of the database SSL certificate.
        :param pulumi.Input[_builtins.str] time_ords_certificate_expires: The expiration date and time of the ORDS certificate.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if autonomous_data_storage_percentage is not None:
            pulumi.set(__self__, "autonomous_data_storage_percentage", autonomous_data_storage_percentage)
        if autonomous_data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "autonomous_data_storage_size_in_tbs", autonomous_data_storage_size_in_tbs)
        if available_autonomous_data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "available_autonomous_data_storage_size_in_tbs", available_autonomous_data_storage_size_in_tbs)
        if available_container_databases is not None:
            pulumi.set(__self__, "available_container_databases", available_container_databases)
        if available_cpus is not None:
            pulumi.set(__self__, "available_cpus", available_cpus)
        if cloud_exadata_infrastructure_id is not None:
            pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if cpu_core_count_per_node is not None:
            pulumi.set(__self__, "cpu_core_count_per_node", cpu_core_count_per_node)
        if cpu_percentage is not None:
            pulumi.set(__self__, "cpu_percentage", cpu_percentage)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if data_storage_size_in_gbs is not None:
            pulumi.set(__self__, "data_storage_size_in_gbs", data_storage_size_in_gbs)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_servers is not None:
            pulumi.set(__self__, "db_servers", db_servers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if exadata_storage_in_tbs_lowest_scaled_value is not None:
            pulumi.set(__self__, "exadata_storage_in_tbs_lowest_scaled_value", exadata_storage_in_tbs_lowest_scaled_value)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if is_mtls_enabled_vm_cluster is not None:
            pulumi.set(__self__, "is_mtls_enabled_vm_cluster", is_mtls_enabled_vm_cluster)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if max_acds_lowest_scaled_value is not None:
            pulumi.set(__self__, "max_acds_lowest_scaled_value", max_acds_lowest_scaled_value)
        if memory_per_oracle_compute_unit_in_gbs is not None:
            pulumi.set(__self__, "memory_per_oracle_compute_unit_in_gbs", memory_per_oracle_compute_unit_in_gbs)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if non_provisionable_autonomous_container_databases is not None:
            pulumi.set(__self__, "non_provisionable_autonomous_container_databases", non_provisionable_autonomous_container_databases)
        if oci_resource_anchor_name is not None:
            pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        if oci_url is not None:
            pulumi.set(__self__, "oci_url", oci_url)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if odb_network_id is not None:
            pulumi.set(__self__, "odb_network_id", odb_network_id)
        if odb_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "odb_node_storage_size_in_gbs", odb_node_storage_size_in_gbs)
        if percent_progress is not None:
            pulumi.set(__self__, "percent_progress", percent_progress)
        if provisionable_autonomous_container_databases is not None:
            pulumi.set(__self__, "provisionable_autonomous_container_databases", provisionable_autonomous_container_databases)
        if provisioned_autonomous_container_databases is not None:
            pulumi.set(__self__, "provisioned_autonomous_container_databases", provisioned_autonomous_container_databases)
        if provisioned_cpus is not None:
            pulumi.set(__self__, "provisioned_cpus", provisioned_cpus)
        if reclaimable_cpus is not None:
            pulumi.set(__self__, "reclaimable_cpus", reclaimable_cpus)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserved_cpus is not None:
            pulumi.set(__self__, "reserved_cpus", reserved_cpus)
        if scan_listener_port_non_tls is not None:
            pulumi.set(__self__, "scan_listener_port_non_tls", scan_listener_port_non_tls)
        if scan_listener_port_tls is not None:
            pulumi.set(__self__, "scan_listener_port_tls", scan_listener_port_tls)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if time_database_ssl_certificate_expires is not None:
            pulumi.set(__self__, "time_database_ssl_certificate_expires", time_database_ssl_certificate_expires)
        if time_ords_certificate_expires is not None:
            pulumi.set(__self__, "time_ords_certificate_expires", time_ords_certificate_expires)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if total_container_databases is not None:
            pulumi.set(__self__, "total_container_databases", total_container_databases)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the Exadata infrastructure.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="autonomousDataStoragePercentage")
    def autonomous_data_storage_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The progress of the current operation on the Autonomous VM cluster, as a percentage.
        """
        return pulumi.get(self, "autonomous_data_storage_percentage")

    @autonomous_data_storage_percentage.setter
    def autonomous_data_storage_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "autonomous_data_storage_percentage", value)

    @_builtins.property
    @pulumi.getter(name="autonomousDataStorageSizeInTbs")
    def autonomous_data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "autonomous_data_storage_size_in_tbs")

    @autonomous_data_storage_size_in_tbs.setter
    def autonomous_data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "autonomous_data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="availableAutonomousDataStorageSizeInTbs")
    def available_autonomous_data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The available data storage space for Autonomous Databases in the Autonomous VM cluster, in TB.
        """
        return pulumi.get(self, "available_autonomous_data_storage_size_in_tbs")

    @available_autonomous_data_storage_size_in_tbs.setter
    def available_autonomous_data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "available_autonomous_data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="availableContainerDatabases")
    def available_container_databases(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Autonomous CDBs that you can create with the currently available storage.
        """
        return pulumi.get(self, "available_container_databases")

    @available_container_databases.setter
    def available_container_databases(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "available_container_databases", value)

    @_builtins.property
    @pulumi.getter(name="availableCpus")
    def available_cpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The number of CPU cores available for allocation to Autonomous Databases.
        """
        return pulumi.get(self, "available_cpus")

    @available_cpus.setter
    def available_cpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "available_cpus", value)

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute model of the Autonomous VM cluster: ECPU or OCPU.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_model", value)

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total number of CPU cores in the Autonomous VM cluster.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_core_count", value)

    @_builtins.property
    @pulumi.getter(name="cpuCoreCountPerNode")
    def cpu_core_count_per_node(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of CPU cores enabled per node in the Autonomous VM cluster.
        """
        return pulumi.get(self, "cpu_core_count_per_node")

    @cpu_core_count_per_node.setter
    def cpu_core_count_per_node(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_core_count_per_node", value)

    @_builtins.property
    @pulumi.getter(name="cpuPercentage")
    def cpu_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The percentage of total CPU cores currently in use in the Autonomous VM cluster.
        """
        return pulumi.get(self, "cpu_percentage")

    @cpu_percentage.setter
    def cpu_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "cpu_percentage", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the Autonomous VM cluster was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGbs")
    def data_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The total data storage allocated to the Autonomous VM cluster, in GB.
        """
        return pulumi.get(self, "data_storage_size_in_gbs")

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The total data storage allocated to the Autonomous VM cluster, in TB.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_servers", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Autonomous VM cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of the Autonomous VM cluster.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="exadataStorageInTbsLowestScaledValue")
    def exadata_storage_in_tbs_lowest_scaled_value(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The minimum value to which you can scale down the Exadata storage, in TB.
        """
        return pulumi.get(self, "exadata_storage_in_tbs_lowest_scaled_value")

    @exadata_storage_in_tbs_lowest_scaled_value.setter
    def exadata_storage_in_tbs_lowest_scaled_value(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "exadata_storage_in_tbs_lowest_scaled_value", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname of the Autonomous VM cluster.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="isMtlsEnabledVmCluster")
    def is_mtls_enabled_vm_cluster(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_mtls_enabled_vm_cluster")

    @is_mtls_enabled_vm_cluster.setter
    def is_mtls_enabled_vm_cluster(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_mtls_enabled_vm_cluster", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs']]:
        """
        The maintenance window of the Autonomous VM cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="maxAcdsLowestScaledValue")
    def max_acds_lowest_scaled_value(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum value to which you can scale down the maximum number of Autonomous CDBs.
        """
        return pulumi.get(self, "max_acds_lowest_scaled_value")

    @max_acds_lowest_scaled_value.setter
    def max_acds_lowest_scaled_value(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_acds_lowest_scaled_value", value)

    @_builtins.property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @memory_per_oracle_compute_unit_in_gbs.setter
    def memory_per_oracle_compute_unit_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_per_oracle_compute_unit_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total amount of memory allocated to the Autonomous VM cluster, in gigabytes(GB).
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of database server nodes in the Autonomous VM cluster.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="nonProvisionableAutonomousContainerDatabases")
    def non_provisionable_autonomous_container_databases(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Autonomous CDBs that can't be provisioned because of resource constraints.
        """
        return pulumi.get(self, "non_provisionable_autonomous_container_databases")

    @non_provisionable_autonomous_container_databases.setter
    def non_provisionable_autonomous_container_databases(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "non_provisionable_autonomous_container_databases", value)

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OCI resource anchor associated with this Autonomous VM cluster.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @oci_resource_anchor_name.setter
    def oci_resource_anchor_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_resource_anchor_name", value)

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL for accessing the OCI console page for this Autonomous VM cluster.
        """
        return pulumi.get(self, "oci_url")

    @oci_url.setter
    def oci_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_url", value)

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocid", value)

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "odb_network_id")

    @odb_network_id.setter
    def odb_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_network_id", value)

    @_builtins.property
    @pulumi.getter(name="odbNodeStorageSizeInGbs")
    def odb_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The local node storage allocated to the Autonomous VM cluster, in gigabytes (GB).
        """
        return pulumi.get(self, "odb_node_storage_size_in_gbs")

    @odb_node_storage_size_in_gbs.setter
    def odb_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "odb_node_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The progress of the current operation on the Autonomous VM cluster, as a percentage.
        """
        return pulumi.get(self, "percent_progress")

    @percent_progress.setter
    def percent_progress(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "percent_progress", value)

    @_builtins.property
    @pulumi.getter(name="provisionableAutonomousContainerDatabases")
    def provisionable_autonomous_container_databases(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Autonomous CDBs that can be provisioned in the Autonomous VM cluster.
        """
        return pulumi.get(self, "provisionable_autonomous_container_databases")

    @provisionable_autonomous_container_databases.setter
    def provisionable_autonomous_container_databases(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "provisionable_autonomous_container_databases", value)

    @_builtins.property
    @pulumi.getter(name="provisionedAutonomousContainerDatabases")
    def provisioned_autonomous_container_databases(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Autonomous CDBs currently provisioned in the Autonomous VM cluster.
        """
        return pulumi.get(self, "provisioned_autonomous_container_databases")

    @provisioned_autonomous_container_databases.setter
    def provisioned_autonomous_container_databases(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "provisioned_autonomous_container_databases", value)

    @_builtins.property
    @pulumi.getter(name="provisionedCpus")
    def provisioned_cpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The number of CPUs provisioned in the Autonomous VM cluster.
        """
        return pulumi.get(self, "provisioned_cpus")

    @provisioned_cpus.setter
    def provisioned_cpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "provisioned_cpus", value)

    @_builtins.property
    @pulumi.getter(name="reclaimableCpus")
    def reclaimable_cpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The number of CPU cores that can be reclaimed from terminated or scaled-down Autonomous Databases.
        """
        return pulumi.get(self, "reclaimable_cpus")

    @reclaimable_cpus.setter
    def reclaimable_cpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "reclaimable_cpus", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reservedCpus")
    def reserved_cpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The number of CPU cores reserved for system operations and redundancy.
        """
        return pulumi.get(self, "reserved_cpus")

    @reserved_cpus.setter
    def reserved_cpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "reserved_cpus", value)

    @_builtins.property
    @pulumi.getter(name="scanListenerPortNonTls")
    def scan_listener_port_non_tls(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "scan_listener_port_non_tls")

    @scan_listener_port_non_tls.setter
    def scan_listener_port_non_tls(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scan_listener_port_non_tls", value)

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTls")
    def scan_listener_port_tls(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "scan_listener_port_tls")

    @scan_listener_port_tls.setter
    def scan_listener_port_tls(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scan_listener_port_tls", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shape of the Exadata infrastructure for the Autonomous VM cluster.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Autonomous VM cluster. Possible values include CREATING, AVAILABLE, UPDATING, DELETING, DELETED, FAILED.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current status of the Autonomous VM cluster.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_reason", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combined set of user-defined and provider-defined tags.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="timeDatabaseSslCertificateExpires")
    def time_database_ssl_certificate_expires(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration date and time of the database SSL certificate.
        """
        return pulumi.get(self, "time_database_ssl_certificate_expires")

    @time_database_ssl_certificate_expires.setter
    def time_database_ssl_certificate_expires(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_database_ssl_certificate_expires", value)

    @_builtins.property
    @pulumi.getter(name="timeOrdsCertificateExpires")
    def time_ords_certificate_expires(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration date and time of the ORDS certificate.
        """
        return pulumi.get(self, "time_ords_certificate_expires")

    @time_ords_certificate_expires.setter
    def time_ords_certificate_expires(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_ords_certificate_expires", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudAutonomousVmClusterTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudAutonomousVmClusterTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="totalContainerDatabases")
    def total_container_databases(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "total_container_databases")

    @total_container_databases.setter
    def total_container_databases(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_container_databases", value)


@pulumi.type_token("aws:odb/cloudAutonomousVmCluster:CloudAutonomousVmCluster")
class CloudAutonomousVmCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_mtls_enabled_vm_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowArgs', 'CloudAutonomousVmClusterMaintenanceWindowArgsDict']]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_listener_port_non_tls: Optional[pulumi.Input[_builtins.int]] = None,
                 scan_listener_port_tls: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudAutonomousVmClusterTimeoutsArgs', 'CloudAutonomousVmClusterTimeoutsArgsDict']]] = None,
                 total_container_databases: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Resource managing cloud autonomous vm cluster in AWS for Oracle Database@AWS.

        You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        avmc_with_minimum_parameters = aws.odb.CloudAutonomousVmCluster("avmc_with_minimum_parameters",
            cloud_exadata_infrastructure_id="<exadata_infra_id>",
            odb_network_id="<odb_net_id>",
            display_name="Ofake-avmc-my_avmc",
            autonomous_data_storage_size_in_tbs=5,
            memory_per_oracle_compute_unit_in_gbs=2,
            total_container_databases=1,
            cpu_core_count_per_node=40,
            license_model="LICENSE_INCLUDED",
            db_servers=["<my_db_server_id>"],
            scan_listener_port_tls=8561,
            scan_listener_port_non_tls=1024,
            maintenance_window={
                "preference": "NO_PREFERENCE",
            })
        avmc_with_all_params = aws.odb.CloudAutonomousVmCluster("avmc_with_all_params",
            description="my first avmc",
            time_zone="UTC",
            cloud_exadata_infrastructure_id="<aws_odb_cloud_exadata_infrastructure.test.id>",
            odb_network_id="<aws_odb_network.test.id>",
            display_name="Ofake_my avmc",
            autonomous_data_storage_size_in_tbs=5,
            memory_per_oracle_compute_unit_in_gbs=2,
            total_container_databases=1,
            cpu_core_count_per_node=40,
            license_model="LICENSE_INCLUDED",
            db_servers=[
                "<my_db_server_1>",
                "<my_db_server_2>",
            ],
            scan_listener_port_tls=8561,
            scan_listener_port_non_tls=1024,
            maintenance_window={
                "days_of_weeks": [
                    {
                        "name": "MONDAY",
                    },
                    {
                        "name": "TUESDAY",
                    },
                ],
                "hours_of_days": [
                    4,
                    16,
                ],
                "lead_time_in_weeks": 3,
                "months": [
                    {
                        "name": "FEBRUARY",
                    },
                    {
                        "name": "MAY",
                    },
                    {
                        "name": "AUGUST",
                    },
                    {
                        "name": "NOVEMBER",
                    },
                ],
                "preference": "CUSTOM_PREFERENCE",
                "weeks_of_months": [
                    2,
                    4,
                ],
            },
            tags={
                "env": "dev",
            })
        ```

        ## Import

        Using `pulumi import`, import cloud autonomous vm cluster `id`. For example:

        ```sh
        $ pulumi import aws:odb/cloudAutonomousVmCluster:CloudAutonomousVmCluster example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cpu_core_count_per_node: The number of CPU cores enabled per node in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] description: The description of the Autonomous VM cluster.
        :param pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowArgs', 'CloudAutonomousVmClusterMaintenanceWindowArgsDict']] maintenance_window: The maintenance window of the Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudAutonomousVmClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource managing cloud autonomous vm cluster in AWS for Oracle Database@AWS.

        You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        avmc_with_minimum_parameters = aws.odb.CloudAutonomousVmCluster("avmc_with_minimum_parameters",
            cloud_exadata_infrastructure_id="<exadata_infra_id>",
            odb_network_id="<odb_net_id>",
            display_name="Ofake-avmc-my_avmc",
            autonomous_data_storage_size_in_tbs=5,
            memory_per_oracle_compute_unit_in_gbs=2,
            total_container_databases=1,
            cpu_core_count_per_node=40,
            license_model="LICENSE_INCLUDED",
            db_servers=["<my_db_server_id>"],
            scan_listener_port_tls=8561,
            scan_listener_port_non_tls=1024,
            maintenance_window={
                "preference": "NO_PREFERENCE",
            })
        avmc_with_all_params = aws.odb.CloudAutonomousVmCluster("avmc_with_all_params",
            description="my first avmc",
            time_zone="UTC",
            cloud_exadata_infrastructure_id="<aws_odb_cloud_exadata_infrastructure.test.id>",
            odb_network_id="<aws_odb_network.test.id>",
            display_name="Ofake_my avmc",
            autonomous_data_storage_size_in_tbs=5,
            memory_per_oracle_compute_unit_in_gbs=2,
            total_container_databases=1,
            cpu_core_count_per_node=40,
            license_model="LICENSE_INCLUDED",
            db_servers=[
                "<my_db_server_1>",
                "<my_db_server_2>",
            ],
            scan_listener_port_tls=8561,
            scan_listener_port_non_tls=1024,
            maintenance_window={
                "days_of_weeks": [
                    {
                        "name": "MONDAY",
                    },
                    {
                        "name": "TUESDAY",
                    },
                ],
                "hours_of_days": [
                    4,
                    16,
                ],
                "lead_time_in_weeks": 3,
                "months": [
                    {
                        "name": "FEBRUARY",
                    },
                    {
                        "name": "MAY",
                    },
                    {
                        "name": "AUGUST",
                    },
                    {
                        "name": "NOVEMBER",
                    },
                ],
                "preference": "CUSTOM_PREFERENCE",
                "weeks_of_months": [
                    2,
                    4,
                ],
            },
            tags={
                "env": "dev",
            })
        ```

        ## Import

        Using `pulumi import`, import cloud autonomous vm cluster `id`. For example:

        ```sh
        $ pulumi import aws:odb/cloudAutonomousVmCluster:CloudAutonomousVmCluster example example
        ```

        :param str resource_name: The name of the resource.
        :param CloudAutonomousVmClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudAutonomousVmClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_mtls_enabled_vm_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowArgs', 'CloudAutonomousVmClusterMaintenanceWindowArgsDict']]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_listener_port_non_tls: Optional[pulumi.Input[_builtins.int]] = None,
                 scan_listener_port_tls: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudAutonomousVmClusterTimeoutsArgs', 'CloudAutonomousVmClusterTimeoutsArgsDict']]] = None,
                 total_container_databases: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudAutonomousVmClusterArgs.__new__(CloudAutonomousVmClusterArgs)

            if autonomous_data_storage_size_in_tbs is None and not opts.urn:
                raise TypeError("Missing required property 'autonomous_data_storage_size_in_tbs'")
            __props__.__dict__["autonomous_data_storage_size_in_tbs"] = autonomous_data_storage_size_in_tbs
            if cloud_exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_exadata_infrastructure_id'")
            __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
            if cpu_core_count_per_node is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_core_count_per_node'")
            __props__.__dict__["cpu_core_count_per_node"] = cpu_core_count_per_node
            if db_servers is None and not opts.urn:
                raise TypeError("Missing required property 'db_servers'")
            __props__.__dict__["db_servers"] = db_servers
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["is_mtls_enabled_vm_cluster"] = is_mtls_enabled_vm_cluster
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["maintenance_window"] = maintenance_window
            if memory_per_oracle_compute_unit_in_gbs is None and not opts.urn:
                raise TypeError("Missing required property 'memory_per_oracle_compute_unit_in_gbs'")
            __props__.__dict__["memory_per_oracle_compute_unit_in_gbs"] = memory_per_oracle_compute_unit_in_gbs
            if odb_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'odb_network_id'")
            __props__.__dict__["odb_network_id"] = odb_network_id
            __props__.__dict__["region"] = region
            if scan_listener_port_non_tls is None and not opts.urn:
                raise TypeError("Missing required property 'scan_listener_port_non_tls'")
            __props__.__dict__["scan_listener_port_non_tls"] = scan_listener_port_non_tls
            if scan_listener_port_tls is None and not opts.urn:
                raise TypeError("Missing required property 'scan_listener_port_tls'")
            __props__.__dict__["scan_listener_port_tls"] = scan_listener_port_tls
            __props__.__dict__["tags"] = tags
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["timeouts"] = timeouts
            if total_container_databases is None and not opts.urn:
                raise TypeError("Missing required property 'total_container_databases'")
            __props__.__dict__["total_container_databases"] = total_container_databases
            __props__.__dict__["arn"] = None
            __props__.__dict__["autonomous_data_storage_percentage"] = None
            __props__.__dict__["available_autonomous_data_storage_size_in_tbs"] = None
            __props__.__dict__["available_container_databases"] = None
            __props__.__dict__["available_cpus"] = None
            __props__.__dict__["compute_model"] = None
            __props__.__dict__["cpu_core_count"] = None
            __props__.__dict__["cpu_percentage"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["data_storage_size_in_gbs"] = None
            __props__.__dict__["data_storage_size_in_tbs"] = None
            __props__.__dict__["domain"] = None
            __props__.__dict__["exadata_storage_in_tbs_lowest_scaled_value"] = None
            __props__.__dict__["hostname"] = None
            __props__.__dict__["max_acds_lowest_scaled_value"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["node_count"] = None
            __props__.__dict__["non_provisionable_autonomous_container_databases"] = None
            __props__.__dict__["oci_resource_anchor_name"] = None
            __props__.__dict__["oci_url"] = None
            __props__.__dict__["ocid"] = None
            __props__.__dict__["odb_node_storage_size_in_gbs"] = None
            __props__.__dict__["percent_progress"] = None
            __props__.__dict__["provisionable_autonomous_container_databases"] = None
            __props__.__dict__["provisioned_autonomous_container_databases"] = None
            __props__.__dict__["provisioned_cpus"] = None
            __props__.__dict__["reclaimable_cpus"] = None
            __props__.__dict__["reserved_cpus"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_reason"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["time_database_ssl_certificate_expires"] = None
            __props__.__dict__["time_ords_certificate_expires"] = None
        super(CloudAutonomousVmCluster, __self__).__init__(
            'aws:odb/cloudAutonomousVmCluster:CloudAutonomousVmCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            autonomous_data_storage_percentage: Optional[pulumi.Input[_builtins.float]] = None,
            autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            available_autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            available_container_databases: Optional[pulumi.Input[_builtins.int]] = None,
            available_cpus: Optional[pulumi.Input[_builtins.float]] = None,
            cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_model: Optional[pulumi.Input[_builtins.str]] = None,
            cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
            cpu_core_count_per_node: Optional[pulumi.Input[_builtins.int]] = None,
            cpu_percentage: Optional[pulumi.Input[_builtins.float]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            data_storage_size_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            exadata_storage_in_tbs_lowest_scaled_value: Optional[pulumi.Input[_builtins.float]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            is_mtls_enabled_vm_cluster: Optional[pulumi.Input[_builtins.bool]] = None,
            license_model: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowArgs', 'CloudAutonomousVmClusterMaintenanceWindowArgsDict']]] = None,
            max_acds_lowest_scaled_value: Optional[pulumi.Input[_builtins.int]] = None,
            memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            node_count: Optional[pulumi.Input[_builtins.int]] = None,
            non_provisionable_autonomous_container_databases: Optional[pulumi.Input[_builtins.int]] = None,
            oci_resource_anchor_name: Optional[pulumi.Input[_builtins.str]] = None,
            oci_url: Optional[pulumi.Input[_builtins.str]] = None,
            ocid: Optional[pulumi.Input[_builtins.str]] = None,
            odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            odb_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            percent_progress: Optional[pulumi.Input[_builtins.float]] = None,
            provisionable_autonomous_container_databases: Optional[pulumi.Input[_builtins.int]] = None,
            provisioned_autonomous_container_databases: Optional[pulumi.Input[_builtins.int]] = None,
            provisioned_cpus: Optional[pulumi.Input[_builtins.float]] = None,
            reclaimable_cpus: Optional[pulumi.Input[_builtins.float]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            reserved_cpus: Optional[pulumi.Input[_builtins.float]] = None,
            scan_listener_port_non_tls: Optional[pulumi.Input[_builtins.int]] = None,
            scan_listener_port_tls: Optional[pulumi.Input[_builtins.int]] = None,
            shape: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_reason: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_database_ssl_certificate_expires: Optional[pulumi.Input[_builtins.str]] = None,
            time_ords_certificate_expires: Optional[pulumi.Input[_builtins.str]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['CloudAutonomousVmClusterTimeoutsArgs', 'CloudAutonomousVmClusterTimeoutsArgsDict']]] = None,
            total_container_databases: Optional[pulumi.Input[_builtins.int]] = None) -> 'CloudAutonomousVmCluster':
        """
        Get an existing CloudAutonomousVmCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) for the Exadata infrastructure.
        :param pulumi.Input[_builtins.float] autonomous_data_storage_percentage: The progress of the current operation on the Autonomous VM cluster, as a percentage.
        :param pulumi.Input[_builtins.float] available_autonomous_data_storage_size_in_tbs: The available data storage space for Autonomous Databases in the Autonomous VM cluster, in TB.
        :param pulumi.Input[_builtins.int] available_container_databases: The number of Autonomous CDBs that you can create with the currently available storage.
        :param pulumi.Input[_builtins.float] available_cpus: The number of CPU cores available for allocation to Autonomous Databases.
        :param pulumi.Input[_builtins.str] compute_model: The compute model of the Autonomous VM cluster: ECPU or OCPU.
        :param pulumi.Input[_builtins.int] cpu_core_count: The total number of CPU cores in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.int] cpu_core_count_per_node: The number of CPU cores enabled per node in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.float] cpu_percentage: The percentage of total CPU cores currently in use in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] created_at: The date and time when the Autonomous VM cluster was created.
        :param pulumi.Input[_builtins.float] data_storage_size_in_gbs: The total data storage allocated to the Autonomous VM cluster, in GB.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The total data storage allocated to the Autonomous VM cluster, in TB.
        :param pulumi.Input[_builtins.str] description: The description of the Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] domain: The domain name of the Autonomous VM cluster.
        :param pulumi.Input[_builtins.float] exadata_storage_in_tbs_lowest_scaled_value: The minimum value to which you can scale down the Exadata storage, in TB.
        :param pulumi.Input[_builtins.str] hostname: The hostname of the Autonomous VM cluster.
        :param pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowArgs', 'CloudAutonomousVmClusterMaintenanceWindowArgsDict']] maintenance_window: The maintenance window of the Autonomous VM cluster.
        :param pulumi.Input[_builtins.int] max_acds_lowest_scaled_value: The minimum value to which you can scale down the maximum number of Autonomous CDBs.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The total amount of memory allocated to the Autonomous VM cluster, in gigabytes(GB).
        :param pulumi.Input[_builtins.int] node_count: The number of database server nodes in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.int] non_provisionable_autonomous_container_databases: The number of Autonomous CDBs that can't be provisioned because of resource constraints.
        :param pulumi.Input[_builtins.str] oci_resource_anchor_name: The name of the OCI resource anchor associated with this Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] oci_url: The URL for accessing the OCI console page for this Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] ocid: The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
        :param pulumi.Input[_builtins.int] odb_node_storage_size_in_gbs: The local node storage allocated to the Autonomous VM cluster, in gigabytes (GB).
        :param pulumi.Input[_builtins.float] percent_progress: The progress of the current operation on the Autonomous VM cluster, as a percentage.
        :param pulumi.Input[_builtins.int] provisionable_autonomous_container_databases: The number of Autonomous CDBs that can be provisioned in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.int] provisioned_autonomous_container_databases: The number of Autonomous CDBs currently provisioned in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.float] provisioned_cpus: The number of CPUs provisioned in the Autonomous VM cluster.
        :param pulumi.Input[_builtins.float] reclaimable_cpus: The number of CPU cores that can be reclaimed from terminated or scaled-down Autonomous Databases.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.float] reserved_cpus: The number of CPU cores reserved for system operations and redundancy.
        :param pulumi.Input[_builtins.str] shape: The shape of the Exadata infrastructure for the Autonomous VM cluster.
        :param pulumi.Input[_builtins.str] status: The status of the Autonomous VM cluster. Possible values include CREATING, AVAILABLE, UPDATING, DELETING, DELETED, FAILED.
        :param pulumi.Input[_builtins.str] status_reason: Additional information about the current status of the Autonomous VM cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: The combined set of user-defined and provider-defined tags.
        :param pulumi.Input[_builtins.str] time_database_ssl_certificate_expires: The expiration date and time of the database SSL certificate.
        :param pulumi.Input[_builtins.str] time_ords_certificate_expires: The expiration date and time of the ORDS certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudAutonomousVmClusterState.__new__(_CloudAutonomousVmClusterState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["autonomous_data_storage_percentage"] = autonomous_data_storage_percentage
        __props__.__dict__["autonomous_data_storage_size_in_tbs"] = autonomous_data_storage_size_in_tbs
        __props__.__dict__["available_autonomous_data_storage_size_in_tbs"] = available_autonomous_data_storage_size_in_tbs
        __props__.__dict__["available_container_databases"] = available_container_databases
        __props__.__dict__["available_cpus"] = available_cpus
        __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["cpu_core_count_per_node"] = cpu_core_count_per_node
        __props__.__dict__["cpu_percentage"] = cpu_percentage
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["data_storage_size_in_gbs"] = data_storage_size_in_gbs
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_servers"] = db_servers
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain"] = domain
        __props__.__dict__["exadata_storage_in_tbs_lowest_scaled_value"] = exadata_storage_in_tbs_lowest_scaled_value
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["is_mtls_enabled_vm_cluster"] = is_mtls_enabled_vm_cluster
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["max_acds_lowest_scaled_value"] = max_acds_lowest_scaled_value
        __props__.__dict__["memory_per_oracle_compute_unit_in_gbs"] = memory_per_oracle_compute_unit_in_gbs
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["non_provisionable_autonomous_container_databases"] = non_provisionable_autonomous_container_databases
        __props__.__dict__["oci_resource_anchor_name"] = oci_resource_anchor_name
        __props__.__dict__["oci_url"] = oci_url
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["odb_network_id"] = odb_network_id
        __props__.__dict__["odb_node_storage_size_in_gbs"] = odb_node_storage_size_in_gbs
        __props__.__dict__["percent_progress"] = percent_progress
        __props__.__dict__["provisionable_autonomous_container_databases"] = provisionable_autonomous_container_databases
        __props__.__dict__["provisioned_autonomous_container_databases"] = provisioned_autonomous_container_databases
        __props__.__dict__["provisioned_cpus"] = provisioned_cpus
        __props__.__dict__["reclaimable_cpus"] = reclaimable_cpus
        __props__.__dict__["region"] = region
        __props__.__dict__["reserved_cpus"] = reserved_cpus
        __props__.__dict__["scan_listener_port_non_tls"] = scan_listener_port_non_tls
        __props__.__dict__["scan_listener_port_tls"] = scan_listener_port_tls
        __props__.__dict__["shape"] = shape
        __props__.__dict__["status"] = status
        __props__.__dict__["status_reason"] = status_reason
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["time_database_ssl_certificate_expires"] = time_database_ssl_certificate_expires
        __props__.__dict__["time_ords_certificate_expires"] = time_ords_certificate_expires
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["total_container_databases"] = total_container_databases
        return CloudAutonomousVmCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the Exadata infrastructure.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="autonomousDataStoragePercentage")
    def autonomous_data_storage_percentage(self) -> pulumi.Output[_builtins.float]:
        """
        The progress of the current operation on the Autonomous VM cluster, as a percentage.
        """
        return pulumi.get(self, "autonomous_data_storage_percentage")

    @_builtins.property
    @pulumi.getter(name="autonomousDataStorageSizeInTbs")
    def autonomous_data_storage_size_in_tbs(self) -> pulumi.Output[_builtins.float]:
        return pulumi.get(self, "autonomous_data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="availableAutonomousDataStorageSizeInTbs")
    def available_autonomous_data_storage_size_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        The available data storage space for Autonomous Databases in the Autonomous VM cluster, in TB.
        """
        return pulumi.get(self, "available_autonomous_data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="availableContainerDatabases")
    def available_container_databases(self) -> pulumi.Output[_builtins.int]:
        """
        The number of Autonomous CDBs that you can create with the currently available storage.
        """
        return pulumi.get(self, "available_container_databases")

    @_builtins.property
    @pulumi.getter(name="availableCpus")
    def available_cpus(self) -> pulumi.Output[_builtins.float]:
        """
        The number of CPU cores available for allocation to Autonomous Databases.
        """
        return pulumi.get(self, "available_cpus")

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[_builtins.str]:
        """
        The compute model of the Autonomous VM cluster: ECPU or OCPU.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[_builtins.int]:
        """
        The total number of CPU cores in the Autonomous VM cluster.
        """
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="cpuCoreCountPerNode")
    def cpu_core_count_per_node(self) -> pulumi.Output[_builtins.int]:
        """
        The number of CPU cores enabled per node in the Autonomous VM cluster.
        """
        return pulumi.get(self, "cpu_core_count_per_node")

    @_builtins.property
    @pulumi.getter(name="cpuPercentage")
    def cpu_percentage(self) -> pulumi.Output[_builtins.float]:
        """
        The percentage of total CPU cores currently in use in the Autonomous VM cluster.
        """
        return pulumi.get(self, "cpu_percentage")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the Autonomous VM cluster was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInGbs")
    def data_storage_size_in_gbs(self) -> pulumi.Output[_builtins.float]:
        """
        The total data storage allocated to the Autonomous VM cluster, in GB.
        """
        return pulumi.get(self, "data_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        The total data storage allocated to the Autonomous VM cluster, in TB.
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "db_servers")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Autonomous VM cluster.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name of the Autonomous VM cluster.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="exadataStorageInTbsLowestScaledValue")
    def exadata_storage_in_tbs_lowest_scaled_value(self) -> pulumi.Output[_builtins.float]:
        """
        The minimum value to which you can scale down the Exadata storage, in TB.
        """
        return pulumi.get(self, "exadata_storage_in_tbs_lowest_scaled_value")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname of the Autonomous VM cluster.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="isMtlsEnabledVmCluster")
    def is_mtls_enabled_vm_cluster(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_mtls_enabled_vm_cluster")

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "license_model")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional['outputs.CloudAutonomousVmClusterMaintenanceWindow']]:
        """
        The maintenance window of the Autonomous VM cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="maxAcdsLowestScaledValue")
    def max_acds_lowest_scaled_value(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum value to which you can scale down the maximum number of Autonomous CDBs.
        """
        return pulumi.get(self, "max_acds_lowest_scaled_value")

    @_builtins.property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The total amount of memory allocated to the Autonomous VM cluster, in gigabytes(GB).
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of database server nodes in the Autonomous VM cluster.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="nonProvisionableAutonomousContainerDatabases")
    def non_provisionable_autonomous_container_databases(self) -> pulumi.Output[_builtins.int]:
        """
        The number of Autonomous CDBs that can't be provisioned because of resource constraints.
        """
        return pulumi.get(self, "non_provisionable_autonomous_container_databases")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OCI resource anchor associated with this Autonomous VM cluster.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL for accessing the OCI console page for this Autonomous VM cluster.
        """
        return pulumi.get(self, "oci_url")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[_builtins.str]:
        """
        The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "odb_network_id")

    @_builtins.property
    @pulumi.getter(name="odbNodeStorageSizeInGbs")
    def odb_node_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The local node storage allocated to the Autonomous VM cluster, in gigabytes (GB).
        """
        return pulumi.get(self, "odb_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> pulumi.Output[_builtins.float]:
        """
        The progress of the current operation on the Autonomous VM cluster, as a percentage.
        """
        return pulumi.get(self, "percent_progress")

    @_builtins.property
    @pulumi.getter(name="provisionableAutonomousContainerDatabases")
    def provisionable_autonomous_container_databases(self) -> pulumi.Output[_builtins.int]:
        """
        The number of Autonomous CDBs that can be provisioned in the Autonomous VM cluster.
        """
        return pulumi.get(self, "provisionable_autonomous_container_databases")

    @_builtins.property
    @pulumi.getter(name="provisionedAutonomousContainerDatabases")
    def provisioned_autonomous_container_databases(self) -> pulumi.Output[_builtins.int]:
        """
        The number of Autonomous CDBs currently provisioned in the Autonomous VM cluster.
        """
        return pulumi.get(self, "provisioned_autonomous_container_databases")

    @_builtins.property
    @pulumi.getter(name="provisionedCpus")
    def provisioned_cpus(self) -> pulumi.Output[_builtins.float]:
        """
        The number of CPUs provisioned in the Autonomous VM cluster.
        """
        return pulumi.get(self, "provisioned_cpus")

    @_builtins.property
    @pulumi.getter(name="reclaimableCpus")
    def reclaimable_cpus(self) -> pulumi.Output[_builtins.float]:
        """
        The number of CPU cores that can be reclaimed from terminated or scaled-down Autonomous Databases.
        """
        return pulumi.get(self, "reclaimable_cpus")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="reservedCpus")
    def reserved_cpus(self) -> pulumi.Output[_builtins.float]:
        """
        The number of CPU cores reserved for system operations and redundancy.
        """
        return pulumi.get(self, "reserved_cpus")

    @_builtins.property
    @pulumi.getter(name="scanListenerPortNonTls")
    def scan_listener_port_non_tls(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "scan_listener_port_non_tls")

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTls")
    def scan_listener_port_tls(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "scan_listener_port_tls")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Output[_builtins.str]:
        """
        The shape of the Exadata infrastructure for the Autonomous VM cluster.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Autonomous VM cluster. Possible values include CREATING, AVAILABLE, UPDATING, DELETING, DELETED, FAILED.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current status of the Autonomous VM cluster.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combined set of user-defined and provider-defined tags.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="timeDatabaseSslCertificateExpires")
    def time_database_ssl_certificate_expires(self) -> pulumi.Output[_builtins.str]:
        """
        The expiration date and time of the database SSL certificate.
        """
        return pulumi.get(self, "time_database_ssl_certificate_expires")

    @_builtins.property
    @pulumi.getter(name="timeOrdsCertificateExpires")
    def time_ords_certificate_expires(self) -> pulumi.Output[_builtins.str]:
        """
        The expiration date and time of the ORDS certificate.
        """
        return pulumi.get(self, "time_ords_certificate_expires")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.CloudAutonomousVmClusterTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="totalContainerDatabases")
    def total_container_databases(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "total_container_databases")

