# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudExadataInfrastructureArgs', 'CloudExadataInfrastructure']

@pulumi.input_type
class CloudExadataInfrastructureArgs:
    def __init__(__self__, *,
                 availability_zone_id: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 shape: pulumi.Input[_builtins.str],
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.int]] = None,
                 customer_contacts_to_send_to_ocis: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactsToSendToOciArgs']]]] = None,
                 database_server_type: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_count: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_server_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['CloudExadataInfrastructureTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a CloudExadataInfrastructure resource.
        :param pulumi.Input[_builtins.int] compute_count: The number of compute instances that the Exadata infrastructure is located
        :param pulumi.Input[_builtins.str] database_server_type: The database server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        :param pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs'] maintenance_window: The scheduling details for the maintenance window. Patching and system updates take place during the maintenance window
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] storage_count: TThe number of storage servers that are activated for the Exadata infrastructure
        :param pulumi.Input[_builtins.str] storage_server_type: The storage server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "shape", shape)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if customer_contacts_to_send_to_ocis is not None:
            pulumi.set(__self__, "customer_contacts_to_send_to_ocis", customer_contacts_to_send_to_ocis)
        if database_server_type is not None:
            pulumi.set(__self__, "database_server_type", database_server_type)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if storage_count is not None:
            pulumi.set(__self__, "storage_count", storage_count)
        if storage_server_type is not None:
            pulumi.set(__self__, "storage_server_type", storage_server_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of compute instances that the Exadata infrastructure is located
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compute_count", value)

    @_builtins.property
    @pulumi.getter(name="customerContactsToSendToOcis")
    def customer_contacts_to_send_to_ocis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactsToSendToOciArgs']]]]:
        return pulumi.get(self, "customer_contacts_to_send_to_ocis")

    @customer_contacts_to_send_to_ocis.setter
    def customer_contacts_to_send_to_ocis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactsToSendToOciArgs']]]]):
        pulumi.set(self, "customer_contacts_to_send_to_ocis", value)

    @_builtins.property
    @pulumi.getter(name="databaseServerType")
    def database_server_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        """
        return pulumi.get(self, "database_server_type")

    @database_server_type.setter
    def database_server_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_server_type", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']]:
        """
        The scheduling details for the maintenance window. Patching and system updates take place during the maintenance window
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TThe number of storage servers that are activated for the Exadata infrastructure
        """
        return pulumi.get(self, "storage_count")

    @storage_count.setter
    def storage_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_count", value)

    @_builtins.property
    @pulumi.getter(name="storageServerType")
    def storage_server_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        """
        return pulumi.get(self, "storage_server_type")

    @storage_server_type.setter
    def storage_server_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_server_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudExadataInfrastructureTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudExadataInfrastructureTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _CloudExadataInfrastructureState:
    def __init__(__self__, *,
                 activated_storage_count: Optional[pulumi.Input[_builtins.int]] = None,
                 additional_storage_count: Optional[pulumi.Input[_builtins.int]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 available_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.int]] = None,
                 compute_model: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_contacts_to_send_to_ocis: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactsToSendToOciArgs']]]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 database_server_type: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_server_version: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 last_maintenance_run_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']] = None,
                 max_cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_data_storage_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 max_db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 max_memory_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 monthly_db_server_version: Optional[pulumi.Input[_builtins.str]] = None,
                 monthly_storage_server_version: Optional[pulumi.Input[_builtins.str]] = None,
                 next_maintenance_run_id: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_resource_anchor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 percent_progress: Optional[pulumi.Input[_builtins.float]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_count: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_server_type: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_server_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['CloudExadataInfrastructureTimeoutsArgs']] = None,
                 total_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CloudExadataInfrastructure resources.
        :param pulumi.Input[_builtins.int] activated_storage_count: The number of storage servers requested for the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] additional_storage_count: The number of storage servers requested for the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the pipeline.
        :param pulumi.Input[_builtins.int] available_storage_size_in_gbs: The amount of available storage, in gigabytes (GB), for the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] compute_count: The number of compute instances that the Exadata infrastructure is located
        :param pulumi.Input[_builtins.str] compute_model: The OCI model compute model used when you create or clone an instance: ECPU or OCPU.
        :param pulumi.Input[_builtins.int] cpu_count: The total number of CPU cores that are allocated to the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] created_at: The time when the Exadata infrastructure was created.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The size of the Exadata infrastructure's data disk group, in terabytes (TB).
        :param pulumi.Input[_builtins.str] database_server_type: The database server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The size of the Exadata infrastructure's local node storage, in gigabytes (GB).
        :param pulumi.Input[_builtins.str] db_server_version: The software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] last_maintenance_run_id: The Oracle Cloud Identifier (OCID) of the last maintenance run for the Exadata infrastructure.
        :param pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs'] maintenance_window: The scheduling details for the maintenance window. Patching and system updates take place during the maintenance window
        :param pulumi.Input[_builtins.int] max_cpu_count: The total number of CPU cores available on the Exadata infrastructure.
        :param pulumi.Input[_builtins.float] max_data_storage_in_tbs: The total amount of data disk group storage, in terabytes (TB), that's available on the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] max_db_node_storage_size_in_gbs: The total amount of local node storage, in gigabytes (GB), that's available on the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] max_memory_in_gbs: The total amount of memory in gigabytes (GB) available on the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The amount of memory, in gigabytes (GB), that's allocated on the Exadata infrastructure
        :param pulumi.Input[_builtins.str] monthly_db_server_version: The monthly software version of the database servers in the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] monthly_storage_server_version: The monthly software version of the storage servers installed on the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] next_maintenance_run_id: The OCID of the next maintenance run for the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] oci_resource_anchor_name: The name of the OCI resource anchor for the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] oci_url: The HTTPS link to the Exadata infrastructure in OCI
        :param pulumi.Input[_builtins.str] ocid: The OCID of the Exadata infrastructure.
        :param pulumi.Input[_builtins.float] percent_progress: The amount of progress made on the current operation on the Exadata infrastructure, expressed as a percentage.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The current status of the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] status_reason: Additional information about the status of the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] storage_count: TThe number of storage servers that are activated for the Exadata infrastructure
        :param pulumi.Input[_builtins.str] storage_server_type: The storage server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        :param pulumi.Input[_builtins.str] storage_server_version: The software version of the storage servers on the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.int] total_storage_size_in_gbs: The total amount of storage, in gigabytes (GB), on the Exadata infrastructure.
        """
        if activated_storage_count is not None:
            pulumi.set(__self__, "activated_storage_count", activated_storage_count)
        if additional_storage_count is not None:
            pulumi.set(__self__, "additional_storage_count", additional_storage_count)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if available_storage_size_in_gbs is not None:
            pulumi.set(__self__, "available_storage_size_in_gbs", available_storage_size_in_gbs)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if customer_contacts_to_send_to_ocis is not None:
            pulumi.set(__self__, "customer_contacts_to_send_to_ocis", customer_contacts_to_send_to_ocis)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if database_server_type is not None:
            pulumi.set(__self__, "database_server_type", database_server_type)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_version is not None:
            pulumi.set(__self__, "db_server_version", db_server_version)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if last_maintenance_run_id is not None:
            pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if max_cpu_count is not None:
            pulumi.set(__self__, "max_cpu_count", max_cpu_count)
        if max_data_storage_in_tbs is not None:
            pulumi.set(__self__, "max_data_storage_in_tbs", max_data_storage_in_tbs)
        if max_db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "max_db_node_storage_size_in_gbs", max_db_node_storage_size_in_gbs)
        if max_memory_in_gbs is not None:
            pulumi.set(__self__, "max_memory_in_gbs", max_memory_in_gbs)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if monthly_db_server_version is not None:
            pulumi.set(__self__, "monthly_db_server_version", monthly_db_server_version)
        if monthly_storage_server_version is not None:
            pulumi.set(__self__, "monthly_storage_server_version", monthly_storage_server_version)
        if next_maintenance_run_id is not None:
            pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if oci_resource_anchor_name is not None:
            pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        if oci_url is not None:
            pulumi.set(__self__, "oci_url", oci_url)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if percent_progress is not None:
            pulumi.set(__self__, "percent_progress", percent_progress)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if storage_count is not None:
            pulumi.set(__self__, "storage_count", storage_count)
        if storage_server_type is not None:
            pulumi.set(__self__, "storage_server_type", storage_server_type)
        if storage_server_version is not None:
            pulumi.set(__self__, "storage_server_version", storage_server_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if total_storage_size_in_gbs is not None:
            pulumi.set(__self__, "total_storage_size_in_gbs", total_storage_size_in_gbs)

    @_builtins.property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of storage servers requested for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @activated_storage_count.setter
    def activated_storage_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "activated_storage_count", value)

    @_builtins.property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of storage servers requested for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @additional_storage_count.setter
    def additional_storage_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "additional_storage_count", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the pipeline.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "availability_zone_id")

    @availability_zone_id.setter
    def availability_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="availableStorageSizeInGbs")
    def available_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of available storage, in gigabytes (GB), for the Exadata infrastructure.
        """
        return pulumi.get(self, "available_storage_size_in_gbs")

    @available_storage_size_in_gbs.setter
    def available_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "available_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of compute instances that the Exadata infrastructure is located
        """
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "compute_count", value)

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCI model compute model used when you create or clone an instance: ECPU or OCPU.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_model", value)

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total number of CPU cores that are allocated to the Exadata infrastructure.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_count", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the Exadata infrastructure was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="customerContactsToSendToOcis")
    def customer_contacts_to_send_to_ocis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactsToSendToOciArgs']]]]:
        return pulumi.get(self, "customer_contacts_to_send_to_ocis")

    @customer_contacts_to_send_to_ocis.setter
    def customer_contacts_to_send_to_ocis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudExadataInfrastructureCustomerContactsToSendToOciArgs']]]]):
        pulumi.set(self, "customer_contacts_to_send_to_ocis", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The size of the Exadata infrastructure's data disk group, in terabytes (TB).
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="databaseServerType")
    def database_server_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        """
        return pulumi.get(self, "database_server_type")

    @database_server_type.setter
    def database_server_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_server_type", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the Exadata infrastructure's local node storage, in gigabytes (GB).
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "db_server_version")

    @db_server_version.setter
    def db_server_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_server_version", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle Cloud Identifier (OCID) of the last maintenance run for the Exadata infrastructure.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @last_maintenance_run_id.setter
    def last_maintenance_run_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_maintenance_run_id", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']]:
        """
        The scheduling details for the maintenance window. Patching and system updates take place during the maintenance window
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['CloudExadataInfrastructureMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total number of CPU cores available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_cpu_count")

    @max_cpu_count.setter
    def max_cpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_cpu_count", value)

    @_builtins.property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The total amount of data disk group storage, in terabytes (TB), that's available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @max_data_storage_in_tbs.setter
    def max_data_storage_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_data_storage_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="maxDbNodeStorageSizeInGbs")
    def max_db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total amount of local node storage, in gigabytes (GB), that's available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_db_node_storage_size_in_gbs")

    @max_db_node_storage_size_in_gbs.setter
    def max_db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_db_node_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total amount of memory in gigabytes (GB) available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @max_memory_in_gbs.setter
    def max_memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory, in gigabytes (GB), that's allocated on the Exadata infrastructure
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The monthly software version of the database servers in the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_db_server_version")

    @monthly_db_server_version.setter
    def monthly_db_server_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monthly_db_server_version", value)

    @_builtins.property
    @pulumi.getter(name="monthlyStorageServerVersion")
    def monthly_storage_server_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The monthly software version of the storage servers installed on the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_storage_server_version")

    @monthly_storage_server_version.setter
    def monthly_storage_server_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monthly_storage_server_version", value)

    @_builtins.property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the next maintenance run for the Exadata infrastructure.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @next_maintenance_run_id.setter
    def next_maintenance_run_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_maintenance_run_id", value)

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OCI resource anchor for the Exadata infrastructure.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @oci_resource_anchor_name.setter
    def oci_resource_anchor_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_resource_anchor_name", value)

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTPS link to the Exadata infrastructure in OCI
        """
        return pulumi.get(self, "oci_url")

    @oci_url.setter
    def oci_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_url", value)

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the Exadata infrastructure.
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocid", value)

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The amount of progress made on the current operation on the Exadata infrastructure, expressed as a percentage.
        """
        return pulumi.get(self, "percent_progress")

    @percent_progress.setter
    def percent_progress(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "percent_progress", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the Exadata infrastructure.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the status of the Exadata infrastructure.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_reason", value)

    @_builtins.property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TThe number of storage servers that are activated for the Exadata infrastructure
        """
        return pulumi.get(self, "storage_count")

    @storage_count.setter
    def storage_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_count", value)

    @_builtins.property
    @pulumi.getter(name="storageServerType")
    def storage_server_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        """
        return pulumi.get(self, "storage_server_type")

    @storage_server_type.setter
    def storage_server_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_server_type", value)

    @_builtins.property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The software version of the storage servers on the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_server_version")

    @storage_server_version.setter
    def storage_server_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_server_version", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudExadataInfrastructureTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudExadataInfrastructureTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="totalStorageSizeInGbs")
    def total_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total amount of storage, in gigabytes (GB), on the Exadata infrastructure.
        """
        return pulumi.get(self, "total_storage_size_in_gbs")

    @total_storage_size_in_gbs.setter
    def total_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_storage_size_in_gbs", value)


@pulumi.type_token("aws:odb/cloudExadataInfrastructure:CloudExadataInfrastructure")
class CloudExadataInfrastructure(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.int]] = None,
                 customer_contacts_to_send_to_ocis: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureCustomerContactsToSendToOciArgs', 'CloudExadataInfrastructureCustomerContactsToSendToOciArgsDict']]]]] = None,
                 database_server_type: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['CloudExadataInfrastructureMaintenanceWindowArgs', 'CloudExadataInfrastructureMaintenanceWindowArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_count: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_server_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudExadataInfrastructureTimeoutsArgs', 'CloudExadataInfrastructureTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing exadata infrastructure resource in AWS for Oracle Database@AWS.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Exadata Infrastructure using the `id`. For example:

        ```sh
        $ pulumi import aws:odb/cloudExadataInfrastructure:CloudExadataInfrastructure example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] compute_count: The number of compute instances that the Exadata infrastructure is located
        :param pulumi.Input[_builtins.str] database_server_type: The database server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        :param pulumi.Input[Union['CloudExadataInfrastructureMaintenanceWindowArgs', 'CloudExadataInfrastructureMaintenanceWindowArgsDict']] maintenance_window: The scheduling details for the maintenance window. Patching and system updates take place during the maintenance window
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] storage_count: TThe number of storage servers that are activated for the Exadata infrastructure
        :param pulumi.Input[_builtins.str] storage_server_type: The storage server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudExadataInfrastructureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing exadata infrastructure resource in AWS for Oracle Database@AWS.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Exadata Infrastructure using the `id`. For example:

        ```sh
        $ pulumi import aws:odb/cloudExadataInfrastructure:CloudExadataInfrastructure example example
        ```

        :param str resource_name: The name of the resource.
        :param CloudExadataInfrastructureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudExadataInfrastructureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_count: Optional[pulumi.Input[_builtins.int]] = None,
                 customer_contacts_to_send_to_ocis: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureCustomerContactsToSendToOciArgs', 'CloudExadataInfrastructureCustomerContactsToSendToOciArgsDict']]]]] = None,
                 database_server_type: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['CloudExadataInfrastructureMaintenanceWindowArgs', 'CloudExadataInfrastructureMaintenanceWindowArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_count: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_server_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudExadataInfrastructureTimeoutsArgs', 'CloudExadataInfrastructureTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudExadataInfrastructureArgs.__new__(CloudExadataInfrastructureArgs)

            __props__.__dict__["availability_zone"] = availability_zone
            if availability_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone_id'")
            __props__.__dict__["availability_zone_id"] = availability_zone_id
            __props__.__dict__["compute_count"] = compute_count
            __props__.__dict__["customer_contacts_to_send_to_ocis"] = customer_contacts_to_send_to_ocis
            __props__.__dict__["database_server_type"] = database_server_type
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["region"] = region
            if shape is None and not opts.urn:
                raise TypeError("Missing required property 'shape'")
            __props__.__dict__["shape"] = shape
            __props__.__dict__["storage_count"] = storage_count
            __props__.__dict__["storage_server_type"] = storage_server_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["activated_storage_count"] = None
            __props__.__dict__["additional_storage_count"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["available_storage_size_in_gbs"] = None
            __props__.__dict__["compute_model"] = None
            __props__.__dict__["cpu_count"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["data_storage_size_in_tbs"] = None
            __props__.__dict__["db_node_storage_size_in_gbs"] = None
            __props__.__dict__["db_server_version"] = None
            __props__.__dict__["last_maintenance_run_id"] = None
            __props__.__dict__["max_cpu_count"] = None
            __props__.__dict__["max_data_storage_in_tbs"] = None
            __props__.__dict__["max_db_node_storage_size_in_gbs"] = None
            __props__.__dict__["max_memory_in_gbs"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["monthly_db_server_version"] = None
            __props__.__dict__["monthly_storage_server_version"] = None
            __props__.__dict__["next_maintenance_run_id"] = None
            __props__.__dict__["oci_resource_anchor_name"] = None
            __props__.__dict__["oci_url"] = None
            __props__.__dict__["ocid"] = None
            __props__.__dict__["percent_progress"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_reason"] = None
            __props__.__dict__["storage_server_version"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["total_storage_size_in_gbs"] = None
        super(CloudExadataInfrastructure, __self__).__init__(
            'aws:odb/cloudExadataInfrastructure:CloudExadataInfrastructure',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated_storage_count: Optional[pulumi.Input[_builtins.int]] = None,
            additional_storage_count: Optional[pulumi.Input[_builtins.int]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            available_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            compute_count: Optional[pulumi.Input[_builtins.int]] = None,
            compute_model: Optional[pulumi.Input[_builtins.str]] = None,
            cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            customer_contacts_to_send_to_ocis: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudExadataInfrastructureCustomerContactsToSendToOciArgs', 'CloudExadataInfrastructureCustomerContactsToSendToOciArgsDict']]]]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            database_server_type: Optional[pulumi.Input[_builtins.str]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            db_server_version: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            last_maintenance_run_id: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['CloudExadataInfrastructureMaintenanceWindowArgs', 'CloudExadataInfrastructureMaintenanceWindowArgsDict']]] = None,
            max_cpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            max_data_storage_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            max_db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            max_memory_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            monthly_db_server_version: Optional[pulumi.Input[_builtins.str]] = None,
            monthly_storage_server_version: Optional[pulumi.Input[_builtins.str]] = None,
            next_maintenance_run_id: Optional[pulumi.Input[_builtins.str]] = None,
            oci_resource_anchor_name: Optional[pulumi.Input[_builtins.str]] = None,
            oci_url: Optional[pulumi.Input[_builtins.str]] = None,
            ocid: Optional[pulumi.Input[_builtins.str]] = None,
            percent_progress: Optional[pulumi.Input[_builtins.float]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            shape: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_reason: Optional[pulumi.Input[_builtins.str]] = None,
            storage_count: Optional[pulumi.Input[_builtins.int]] = None,
            storage_server_type: Optional[pulumi.Input[_builtins.str]] = None,
            storage_server_version: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['CloudExadataInfrastructureTimeoutsArgs', 'CloudExadataInfrastructureTimeoutsArgsDict']]] = None,
            total_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None) -> 'CloudExadataInfrastructure':
        """
        Get an existing CloudExadataInfrastructure resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] activated_storage_count: The number of storage servers requested for the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] additional_storage_count: The number of storage servers requested for the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the pipeline.
        :param pulumi.Input[_builtins.int] available_storage_size_in_gbs: The amount of available storage, in gigabytes (GB), for the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] compute_count: The number of compute instances that the Exadata infrastructure is located
        :param pulumi.Input[_builtins.str] compute_model: The OCI model compute model used when you create or clone an instance: ECPU or OCPU.
        :param pulumi.Input[_builtins.int] cpu_count: The total number of CPU cores that are allocated to the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] created_at: The time when the Exadata infrastructure was created.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The size of the Exadata infrastructure's data disk group, in terabytes (TB).
        :param pulumi.Input[_builtins.str] database_server_type: The database server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The size of the Exadata infrastructure's local node storage, in gigabytes (GB).
        :param pulumi.Input[_builtins.str] db_server_version: The software version of the database servers (dom0) in the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] last_maintenance_run_id: The Oracle Cloud Identifier (OCID) of the last maintenance run for the Exadata infrastructure.
        :param pulumi.Input[Union['CloudExadataInfrastructureMaintenanceWindowArgs', 'CloudExadataInfrastructureMaintenanceWindowArgsDict']] maintenance_window: The scheduling details for the maintenance window. Patching and system updates take place during the maintenance window
        :param pulumi.Input[_builtins.int] max_cpu_count: The total number of CPU cores available on the Exadata infrastructure.
        :param pulumi.Input[_builtins.float] max_data_storage_in_tbs: The total amount of data disk group storage, in terabytes (TB), that's available on the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] max_db_node_storage_size_in_gbs: The total amount of local node storage, in gigabytes (GB), that's available on the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] max_memory_in_gbs: The total amount of memory in gigabytes (GB) available on the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The amount of memory, in gigabytes (GB), that's allocated on the Exadata infrastructure
        :param pulumi.Input[_builtins.str] monthly_db_server_version: The monthly software version of the database servers in the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] monthly_storage_server_version: The monthly software version of the storage servers installed on the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] next_maintenance_run_id: The OCID of the next maintenance run for the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] oci_resource_anchor_name: The name of the OCI resource anchor for the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] oci_url: The HTTPS link to the Exadata infrastructure in OCI
        :param pulumi.Input[_builtins.str] ocid: The OCID of the Exadata infrastructure.
        :param pulumi.Input[_builtins.float] percent_progress: The amount of progress made on the current operation on the Exadata infrastructure, expressed as a percentage.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] status: The current status of the Exadata infrastructure.
        :param pulumi.Input[_builtins.str] status_reason: Additional information about the status of the Exadata infrastructure.
        :param pulumi.Input[_builtins.int] storage_count: TThe number of storage servers that are activated for the Exadata infrastructure
        :param pulumi.Input[_builtins.str] storage_server_type: The storage server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        :param pulumi.Input[_builtins.str] storage_server_version: The software version of the storage servers on the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.int] total_storage_size_in_gbs: The total amount of storage, in gigabytes (GB), on the Exadata infrastructure.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudExadataInfrastructureState.__new__(_CloudExadataInfrastructureState)

        __props__.__dict__["activated_storage_count"] = activated_storage_count
        __props__.__dict__["additional_storage_count"] = additional_storage_count
        __props__.__dict__["arn"] = arn
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["availability_zone_id"] = availability_zone_id
        __props__.__dict__["available_storage_size_in_gbs"] = available_storage_size_in_gbs
        __props__.__dict__["compute_count"] = compute_count
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["cpu_count"] = cpu_count
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["customer_contacts_to_send_to_ocis"] = customer_contacts_to_send_to_ocis
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["database_server_type"] = database_server_type
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_server_version"] = db_server_version
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["last_maintenance_run_id"] = last_maintenance_run_id
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["max_cpu_count"] = max_cpu_count
        __props__.__dict__["max_data_storage_in_tbs"] = max_data_storage_in_tbs
        __props__.__dict__["max_db_node_storage_size_in_gbs"] = max_db_node_storage_size_in_gbs
        __props__.__dict__["max_memory_in_gbs"] = max_memory_in_gbs
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["monthly_db_server_version"] = monthly_db_server_version
        __props__.__dict__["monthly_storage_server_version"] = monthly_storage_server_version
        __props__.__dict__["next_maintenance_run_id"] = next_maintenance_run_id
        __props__.__dict__["oci_resource_anchor_name"] = oci_resource_anchor_name
        __props__.__dict__["oci_url"] = oci_url
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["percent_progress"] = percent_progress
        __props__.__dict__["region"] = region
        __props__.__dict__["shape"] = shape
        __props__.__dict__["status"] = status
        __props__.__dict__["status_reason"] = status_reason
        __props__.__dict__["storage_count"] = storage_count
        __props__.__dict__["storage_server_type"] = storage_server_type
        __props__.__dict__["storage_server_version"] = storage_server_version
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["total_storage_size_in_gbs"] = total_storage_size_in_gbs
        return CloudExadataInfrastructure(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of storage servers requested for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @_builtins.property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of storage servers requested for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the pipeline.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "availability_zone_id")

    @_builtins.property
    @pulumi.getter(name="availableStorageSizeInGbs")
    def available_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of available storage, in gigabytes (GB), for the Exadata infrastructure.
        """
        return pulumi.get(self, "available_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of compute instances that the Exadata infrastructure is located
        """
        return pulumi.get(self, "compute_count")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[_builtins.str]:
        """
        The OCI model compute model used when you create or clone an instance: ECPU or OCPU.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        The total number of CPU cores that are allocated to the Exadata infrastructure.
        """
        return pulumi.get(self, "cpu_count")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the Exadata infrastructure was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customerContactsToSendToOcis")
    def customer_contacts_to_send_to_ocis(self) -> pulumi.Output[Optional[Sequence['outputs.CloudExadataInfrastructureCustomerContactsToSendToOci']]]:
        return pulumi.get(self, "customer_contacts_to_send_to_ocis")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        The size of the Exadata infrastructure's data disk group, in terabytes (TB).
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="databaseServerType")
    def database_server_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The database server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        """
        return pulumi.get(self, "database_server_type")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the Exadata infrastructure's local node storage, in gigabytes (GB).
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> pulumi.Output[_builtins.str]:
        """
        The software version of the database servers (dom0) in the Exadata infrastructure.
        """
        return pulumi.get(self, "db_server_version")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Oracle Cloud Identifier (OCID) of the last maintenance run for the Exadata infrastructure.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional['outputs.CloudExadataInfrastructureMaintenanceWindow']]:
        """
        The scheduling details for the maintenance window. Patching and system updates take place during the maintenance window
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> pulumi.Output[_builtins.int]:
        """
        The total number of CPU cores available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_cpu_count")

    @_builtins.property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        The total amount of data disk group storage, in terabytes (TB), that's available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @_builtins.property
    @pulumi.getter(name="maxDbNodeStorageSizeInGbs")
    def max_db_node_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The total amount of local node storage, in gigabytes (GB), that's available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The total amount of memory in gigabytes (GB) available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of memory, in gigabytes (GB), that's allocated on the Exadata infrastructure
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> pulumi.Output[_builtins.str]:
        """
        The monthly software version of the database servers in the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_db_server_version")

    @_builtins.property
    @pulumi.getter(name="monthlyStorageServerVersion")
    def monthly_storage_server_version(self) -> pulumi.Output[_builtins.str]:
        """
        The monthly software version of the storage servers installed on the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_storage_server_version")

    @_builtins.property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the next maintenance run for the Exadata infrastructure.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OCI resource anchor for the Exadata infrastructure.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> pulumi.Output[_builtins.str]:
        """
        The HTTPS link to the Exadata infrastructure in OCI
        """
        return pulumi.get(self, "oci_url")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the Exadata infrastructure.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> pulumi.Output[_builtins.float]:
        """
        The amount of progress made on the current operation on the Exadata infrastructure, expressed as a percentage.
        """
        return pulumi.get(self, "percent_progress")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the Exadata infrastructure.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the status of the Exadata infrastructure.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> pulumi.Output[_builtins.int]:
        """
        TThe number of storage servers that are activated for the Exadata infrastructure
        """
        return pulumi.get(self, "storage_count")

    @_builtins.property
    @pulumi.getter(name="storageServerType")
    def storage_server_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The storage server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation
        """
        return pulumi.get(self, "storage_server_type")

    @_builtins.property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> pulumi.Output[_builtins.str]:
        """
        The software version of the storage servers on the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_server_version")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.CloudExadataInfrastructureTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="totalStorageSizeInGbs")
    def total_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The total amount of storage, in gigabytes (GB), on the Exadata infrastructure.
        """
        return pulumi.get(self, "total_storage_size_in_gbs")

