# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudVmClusterArgs', 'CloudVmCluster']

@pulumi.input_type
class CloudVmClusterArgs:
    def __init__(__self__, *,
                 cloud_exadata_infrastructure_id: pulumi.Input[_builtins.str],
                 cpu_core_count: pulumi.Input[_builtins.int],
                 data_storage_size_in_tbs: pulumi.Input[_builtins.float],
                 db_servers: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 display_name: pulumi.Input[_builtins.str],
                 gi_version: pulumi.Input[_builtins.str],
                 hostname_prefix: pulumi.Input[_builtins.str],
                 odb_network_id: pulumi.Input[_builtins.str],
                 ssh_public_keys: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 data_collection_options: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['CloudVmClusterTimeoutsArgs']] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CloudVmCluster resource.
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The unique identifier of the Exadata infrastructure for this VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] cpu_core_count: The number of CPU cores to enable on the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The size of the data disk group, in terabytes (TBs), to allocate for the VM cluster. Changing this will create a new resource.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of database servers for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] gi_version: A valid software version of Oracle Grid Infrastructure (GI). To get the list of valid values, use the ListGiVersions operation and specify the shape of the Exadata infrastructure. Example: 19.0.0.0 Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] hostname_prefix: The host name prefix for the VM cluster. Constraints: - Can't be "localhost" or "hostname". - Can't contain "-version". - The maximum length of the combined hostname and domain is 63 characters. - The hostname must be unique within the subnet. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] odb_network_id: The unique identifier of the ODB network for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Grid Infrastructure (GI) cluster. Changing this will create a new resource.
        :param pulumi.Input['CloudVmClusterDataCollectionOptionsArgs'] data_collection_options: The set of preferences for the various diagnostic collection options for the VM cluster.
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The amount of local node storage, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.bool] is_local_backup_enabled: Specifies whether to enable database backups to local Exadata storage for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.bool] is_sparse_diskgroup_enabled: Specifies whether to create a sparse disk group for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model to apply to the VM cluster. Default: LICENSE_INCLUDED. Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The amount of memory, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp: The port number for TCP connections to the single client access name (SCAN) listener. Valid values: 1024–8999, except 2484, 6100, 6200, 7060, 7070, 7085, and 7879. Default: 1521. Changing this will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] timezone: The configured time zone of the VM cluster. Changing this will create a new resource.
        """
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        pulumi.set(__self__, "db_servers", db_servers)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gi_version", gi_version)
        pulumi.set(__self__, "hostname_prefix", hostname_prefix)
        pulumi.set(__self__, "odb_network_id", odb_network_id)
        pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if is_local_backup_enabled is not None:
            pulumi.set(__self__, "is_local_backup_enabled", is_local_backup_enabled)
        if is_sparse_diskgroup_enabled is not None:
            pulumi.set(__self__, "is_sparse_diskgroup_enabled", is_sparse_diskgroup_enabled)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scan_listener_port_tcp is not None:
            pulumi.set(__self__, "scan_listener_port_tcp", scan_listener_port_tcp)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the Exadata infrastructure for this VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Input[_builtins.int]:
        """
        The number of CPU cores to enable on the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cpu_core_count", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Input[_builtins.float]:
        """
        The size of the data disk group, in terabytes (TBs), to allocate for the VM cluster. Changing this will create a new resource.

        The following arguments are optional:
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of database servers for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "db_servers", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        A user-friendly name for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> pulumi.Input[_builtins.str]:
        """
        A valid software version of Oracle Grid Infrastructure (GI). To get the list of valid values, use the ListGiVersions operation and specify the shape of the Exadata infrastructure. Example: 19.0.0.0 Changing this will create a new resource.
        """
        return pulumi.get(self, "gi_version")

    @gi_version.setter
    def gi_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gi_version", value)

    @_builtins.property
    @pulumi.getter(name="hostnamePrefix")
    def hostname_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The host name prefix for the VM cluster. Constraints: - Can't be "localhost" or "hostname". - Can't contain "-version". - The maximum length of the combined hostname and domain is 63 characters. - The hostname must be unique within the subnet. Changing this will create a new resource.
        """
        return pulumi.get(self, "hostname_prefix")

    @hostname_prefix.setter
    def hostname_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hostname_prefix", value)

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique identifier of the ODB network for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "odb_network_id")

    @odb_network_id.setter
    def odb_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "odb_network_id", value)

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The public key portion of one or more key pairs used for SSH access to the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Grid Infrastructure (GI) cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]:
        """
        The set of preferences for the various diagnostic collection options for the VM cluster.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of local node storage, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable database backups to local Exadata storage for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @is_local_backup_enabled.setter
    def is_local_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_local_backup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to create a sparse disk group for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @is_sparse_diskgroup_enabled.setter
    def is_sparse_diskgroup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_sparse_diskgroup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle license model to apply to the VM cluster. Default: LICENSE_INCLUDED. Changing this will create a new resource.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number for TCP connections to the single client access name (SCAN) listener. Valid values: 1024–8999, except 2484, 6100, 6200, 7060, 7070, 7085, and 7879. Default: 1521. Changing this will create a new resource.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @scan_listener_port_tcp.setter
    def scan_listener_port_tcp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scan_listener_port_tcp", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudVmClusterTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudVmClusterTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configured time zone of the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _CloudVmClusterState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_model: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 data_collection_options: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disk_redundancy: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 gi_version: Optional[pulumi.Input[_builtins.str]] = None,
                 gi_version_computed: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_prefix_computed: Optional[pulumi.Input[_builtins.str]] = None,
                 iorm_config_caches: Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterIormConfigCachArgs']]]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_update_history_entry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_port: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 oci_resource_anchor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oci_url: Optional[pulumi.Input[_builtins.str]] = None,
                 ocid: Optional[pulumi.Input[_builtins.str]] = None,
                 odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 percent_progress: Optional[pulumi.Input[_builtins.float]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_dns_record_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[_builtins.int]] = None,
                 shape: Optional[pulumi.Input[_builtins.str]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 status_reason: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 system_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['CloudVmClusterTimeoutsArgs']] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 vip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CloudVmCluster resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) for the cloud vm cluster.
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The unique identifier of the Exadata infrastructure for this VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Grid Infrastructure (GI) cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] compute_model: The compute model used when the instance is created or cloned — either ECPU or OCPU. ECPU is a virtualized compute unit; OCPU is a physical processor core with hyper-threading.
        :param pulumi.Input[_builtins.int] cpu_core_count: The number of CPU cores to enable on the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the VM cluster was created.
        :param pulumi.Input['CloudVmClusterDataCollectionOptionsArgs'] data_collection_options: The set of preferences for the various diagnostic collection options for the VM cluster.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The size of the data disk group, in terabytes (TBs), to allocate for the VM cluster. Changing this will create a new resource.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The amount of local node storage, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of database servers for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] disk_redundancy: The type of redundancy for the VM cluster: NORMAL (2-way) or HIGH (3-way).
               * `AttrDomain` - The domain name associated with the VM cluster.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] domain: The domain name associated with the VM cluster.
        :param pulumi.Input[_builtins.str] gi_version: A valid software version of Oracle Grid Infrastructure (GI). To get the list of valid values, use the ListGiVersions operation and specify the shape of the Exadata infrastructure. Example: 19.0.0.0 Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] gi_version_computed: A complete software version of Oracle Grid Infrastructure (GI).
        :param pulumi.Input[_builtins.str] hostname_prefix: The host name prefix for the VM cluster. Constraints: - Can't be "localhost" or "hostname". - Can't contain "-version". - The maximum length of the combined hostname and domain is 63 characters. - The hostname must be unique within the subnet. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] hostname_prefix_computed: The host name for the VM cluster. Constraints: - Can't be "localhost" or "hostname". - Can't contain "-version". - The maximum length of the combined hostname and domain is 63 characters. - The hostname must be unique within the subnet. This member is required. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['CloudVmClusterIormConfigCachArgs']]] iorm_config_caches: The Exadata IORM (I/O Resource Manager) configuration cache details for the VM cluster.
        :param pulumi.Input[_builtins.bool] is_local_backup_enabled: Specifies whether to enable database backups to local Exadata storage for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.bool] is_sparse_diskgroup_enabled: Specifies whether to create a sparse disk group for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] last_update_history_entry_id: The OCID of the most recent maintenance update history entry.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model to apply to the VM cluster. Default: LICENSE_INCLUDED. Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] listener_port: The listener port number configured on the VM cluster.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The amount of memory, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] node_count: The total number of nodes in the VM cluster.
        :param pulumi.Input[_builtins.str] oci_resource_anchor_name: The name of the OCI resource anchor associated with the VM cluster.
        :param pulumi.Input[_builtins.str] oci_url: The HTTPS link to the VM cluster resource in OCI.
        :param pulumi.Input[_builtins.str] ocid: The OCID (Oracle Cloud Identifier) of the VM cluster.
        :param pulumi.Input[_builtins.str] odb_network_id: The unique identifier of the ODB network for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.float] percent_progress: The percentage of progress made on the current operation for the VM cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] scan_dns_name: The fully qualified domain name (FQDN) for the SCAN IP addresses associated with the VM cluster.
        :param pulumi.Input[_builtins.str] scan_dns_record_id: The OCID of the DNS record for the SCAN IPs linked to the VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scan_ip_ids: The list of OCIDs for SCAN IP addresses associated with the VM cluster.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp: The port number for TCP connections to the single client access name (SCAN) listener. Valid values: 1024–8999, except 2484, 6100, 6200, 7060, 7070, 7085, and 7879. Default: 1521. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] shape: The hardware model name of the Exadata infrastructure running the VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] status: The current lifecycle status of the VM cluster.
        :param pulumi.Input[_builtins.str] status_reason: Additional information regarding the current status of the VM cluster.
        :param pulumi.Input[_builtins.int] storage_size_in_gbs: The local node storage allocated to the VM cluster, in gigabytes (GB).
        :param pulumi.Input[_builtins.str] system_version: The operating system version of the image chosen for the VM cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: The combined set of user-defined and provider-defined tags.
        :param pulumi.Input[_builtins.str] timezone: The configured time zone of the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vip_ids: The virtual IP (VIP) addresses assigned to the VM cluster. CRS assigns one VIP per node for failover support.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if cloud_exadata_infrastructure_id is not None:
            pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers is not None:
            pulumi.set(__self__, "db_servers", db_servers)
        if disk_redundancy is not None:
            pulumi.set(__self__, "disk_redundancy", disk_redundancy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if gi_version is not None:
            pulumi.set(__self__, "gi_version", gi_version)
        if gi_version_computed is not None:
            pulumi.set(__self__, "gi_version_computed", gi_version_computed)
        if hostname_prefix is not None:
            pulumi.set(__self__, "hostname_prefix", hostname_prefix)
        if hostname_prefix_computed is not None:
            pulumi.set(__self__, "hostname_prefix_computed", hostname_prefix_computed)
        if iorm_config_caches is not None:
            pulumi.set(__self__, "iorm_config_caches", iorm_config_caches)
        if is_local_backup_enabled is not None:
            pulumi.set(__self__, "is_local_backup_enabled", is_local_backup_enabled)
        if is_sparse_diskgroup_enabled is not None:
            pulumi.set(__self__, "is_sparse_diskgroup_enabled", is_sparse_diskgroup_enabled)
        if last_update_history_entry_id is not None:
            pulumi.set(__self__, "last_update_history_entry_id", last_update_history_entry_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if oci_resource_anchor_name is not None:
            pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        if oci_url is not None:
            pulumi.set(__self__, "oci_url", oci_url)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if odb_network_id is not None:
            pulumi.set(__self__, "odb_network_id", odb_network_id)
        if percent_progress is not None:
            pulumi.set(__self__, "percent_progress", percent_progress)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scan_dns_name is not None:
            pulumi.set(__self__, "scan_dns_name", scan_dns_name)
        if scan_dns_record_id is not None:
            pulumi.set(__self__, "scan_dns_record_id", scan_dns_record_id)
        if scan_ip_ids is not None:
            pulumi.set(__self__, "scan_ip_ids", scan_ip_ids)
        if scan_listener_port_tcp is not None:
            pulumi.set(__self__, "scan_listener_port_tcp", scan_listener_port_tcp)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if ssh_public_keys is not None:
            pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if storage_size_in_gbs is not None:
            pulumi.set(__self__, "storage_size_in_gbs", storage_size_in_gbs)
        if system_version is not None:
            pulumi.set(__self__, "system_version", system_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if vip_ids is not None:
            pulumi.set(__self__, "vip_ids", vip_ids)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the cloud vm cluster.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the Exadata infrastructure for this VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Grid Infrastructure (GI) cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute model used when the instance is created or cloned — either ECPU or OCPU. ECPU is a virtualized compute unit; OCPU is a physical processor core with hyper-threading.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_model", value)

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of CPU cores to enable on the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_core_count", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the VM cluster was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]:
        """
        The set of preferences for the various diagnostic collection options for the VM cluster.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['CloudVmClusterDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The size of the data disk group, in terabytes (TBs), to allocate for the VM cluster. Changing this will create a new resource.

        The following arguments are optional:
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of local node storage, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of database servers for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "db_servers", value)

    @_builtins.property
    @pulumi.getter(name="diskRedundancy")
    def disk_redundancy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of redundancy for the VM cluster: NORMAL (2-way) or HIGH (3-way).
        * `AttrDomain` - The domain name associated with the VM cluster.
        """
        return pulumi.get(self, "disk_redundancy")

    @disk_redundancy.setter
    def disk_redundancy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_redundancy", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-friendly name for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name associated with the VM cluster.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A valid software version of Oracle Grid Infrastructure (GI). To get the list of valid values, use the ListGiVersions operation and specify the shape of the Exadata infrastructure. Example: 19.0.0.0 Changing this will create a new resource.
        """
        return pulumi.get(self, "gi_version")

    @gi_version.setter
    def gi_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gi_version", value)

    @_builtins.property
    @pulumi.getter(name="giVersionComputed")
    def gi_version_computed(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A complete software version of Oracle Grid Infrastructure (GI).
        """
        return pulumi.get(self, "gi_version_computed")

    @gi_version_computed.setter
    def gi_version_computed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gi_version_computed", value)

    @_builtins.property
    @pulumi.getter(name="hostnamePrefix")
    def hostname_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host name prefix for the VM cluster. Constraints: - Can't be "localhost" or "hostname". - Can't contain "-version". - The maximum length of the combined hostname and domain is 63 characters. - The hostname must be unique within the subnet. Changing this will create a new resource.
        """
        return pulumi.get(self, "hostname_prefix")

    @hostname_prefix.setter
    def hostname_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname_prefix", value)

    @_builtins.property
    @pulumi.getter(name="hostnamePrefixComputed")
    def hostname_prefix_computed(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host name for the VM cluster. Constraints: - Can't be "localhost" or "hostname". - Can't contain "-version". - The maximum length of the combined hostname and domain is 63 characters. - The hostname must be unique within the subnet. This member is required. Changing this will create a new resource.
        """
        return pulumi.get(self, "hostname_prefix_computed")

    @hostname_prefix_computed.setter
    def hostname_prefix_computed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname_prefix_computed", value)

    @_builtins.property
    @pulumi.getter(name="iormConfigCaches")
    def iorm_config_caches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterIormConfigCachArgs']]]]:
        """
        The Exadata IORM (I/O Resource Manager) configuration cache details for the VM cluster.
        """
        return pulumi.get(self, "iorm_config_caches")

    @iorm_config_caches.setter
    def iorm_config_caches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudVmClusterIormConfigCachArgs']]]]):
        pulumi.set(self, "iorm_config_caches", value)

    @_builtins.property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable database backups to local Exadata storage for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @is_local_backup_enabled.setter
    def is_local_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_local_backup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to create a sparse disk group for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @is_sparse_diskgroup_enabled.setter
    def is_sparse_diskgroup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_sparse_diskgroup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdateHistoryEntryId")
    def last_update_history_entry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the most recent maintenance update history entry.
        """
        return pulumi.get(self, "last_update_history_entry_id")

    @last_update_history_entry_id.setter
    def last_update_history_entry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_update_history_entry_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Oracle license model to apply to the VM cluster. Default: LICENSE_INCLUDED. Changing this will create a new resource.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_model", value)

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The listener port number configured on the VM cluster.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "listener_port", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total number of nodes in the VM cluster.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the OCI resource anchor associated with the VM cluster.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @oci_resource_anchor_name.setter
    def oci_resource_anchor_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_resource_anchor_name", value)

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTPS link to the VM cluster resource in OCI.
        """
        return pulumi.get(self, "oci_url")

    @oci_url.setter
    def oci_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oci_url", value)

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID (Oracle Cloud Identifier) of the VM cluster.
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocid", value)

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the ODB network for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "odb_network_id")

    @odb_network_id.setter
    def odb_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "odb_network_id", value)

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The percentage of progress made on the current operation for the VM cluster.
        """
        return pulumi.get(self, "percent_progress")

    @percent_progress.setter
    def percent_progress(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "percent_progress", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name (FQDN) for the SCAN IP addresses associated with the VM cluster.
        """
        return pulumi.get(self, "scan_dns_name")

    @scan_dns_name.setter
    def scan_dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scan_dns_name", value)

    @_builtins.property
    @pulumi.getter(name="scanDnsRecordId")
    def scan_dns_record_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the DNS record for the SCAN IPs linked to the VM cluster.
        """
        return pulumi.get(self, "scan_dns_record_id")

    @scan_dns_record_id.setter
    def scan_dns_record_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scan_dns_record_id", value)

    @_builtins.property
    @pulumi.getter(name="scanIpIds")
    def scan_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of OCIDs for SCAN IP addresses associated with the VM cluster.
        """
        return pulumi.get(self, "scan_ip_ids")

    @scan_ip_ids.setter
    def scan_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scan_ip_ids", value)

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number for TCP connections to the single client access name (SCAN) listener. Valid values: 1024–8999, except 2484, 6100, 6200, 7060, 7070, 7085, and 7879. Default: 1521. Changing this will create a new resource.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @scan_listener_port_tcp.setter
    def scan_listener_port_tcp(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "scan_listener_port_tcp", value)

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hardware model name of the Exadata infrastructure running the VM cluster.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shape", value)

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The public key portion of one or more key pairs used for SSH access to the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle status of the VM cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information regarding the current status of the VM cluster.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_reason", value)

    @_builtins.property
    @pulumi.getter(name="storageSizeInGbs")
    def storage_size_in_gbs(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The local node storage allocated to the VM cluster, in gigabytes (GB).
        """
        return pulumi.get(self, "storage_size_in_gbs")

    @storage_size_in_gbs.setter
    def storage_size_in_gbs(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_size_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating system version of the image chosen for the VM cluster.
        """
        return pulumi.get(self, "system_version")

    @system_version.setter
    def system_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_version", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combined set of user-defined and provider-defined tags.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['CloudVmClusterTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['CloudVmClusterTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The configured time zone of the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="vipIds")
    def vip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The virtual IP (VIP) addresses assigned to the VM cluster. CRS assigns one VIP per node for failover support.
        """
        return pulumi.get(self, "vip_ids")

    @vip_ids.setter
    def vip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vip_ids", value)


@pulumi.type_token("aws:odb/cloudVmCluster:CloudVmCluster")
class CloudVmCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_collection_options: Optional[pulumi.Input[Union['CloudVmClusterDataCollectionOptionsArgs', 'CloudVmClusterDataCollectionOptionsArgsDict']]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gi_version: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[_builtins.int]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudVmClusterTimeoutsArgs', 'CloudVmClusterTimeoutsArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        with_minimum_parameter = aws.odb.CloudVmCluster("with_minimum_parameter",
            display_name="my-exa-infra",
            cloud_exadata_infrastructure_id="exa_gjrmtxl4qk",
            cpu_core_count=6,
            gi_version="23.0.0.0",
            hostname_prefix="apollo12",
            ssh_public_keys=["public-ssh-key"],
            odb_network_id="odbnet_3l9st3litg",
            is_local_backup_enabled=True,
            is_sparse_diskgroup_enabled=True,
            license_model="LICENSE_INCLUDED",
            data_storage_size_in_tbs=20,
            db_servers=[
                "db-server-1",
                "db-server-2",
            ],
            db_node_storage_size_in_gbs=120,
            memory_size_in_gbs=60,
            data_collection_options={
                "is_diagnostics_events_enabled": False,
                "is_health_monitoring_enabled": False,
                "is_incident_logs_enabled": False,
            })
        with_all_parameters = aws.odb.CloudVmCluster("with_all_parameters",
            display_name="my-vmc",
            cloud_exadata_infrastructure_id="exa_gjrmtxl4qk",
            cpu_core_count=6,
            gi_version="23.0.0.0",
            hostname_prefix="apollo12",
            ssh_public_keys=["my-ssh-key"],
            odb_network_id="odbnet_3l9st3litg",
            is_local_backup_enabled=True,
            is_sparse_diskgroup_enabled=True,
            license_model="LICENSE_INCLUDED",
            data_storage_size_in_tbs=20,
            db_servers=[
                "my-dbserver-1",
                "my-db-server-2",
            ],
            db_node_storage_size_in_gbs=120,
            memory_size_in_gbs=60,
            cluster_name="julia-13",
            timezone="UTC",
            scan_listener_port_tcp=1521,
            tags={
                "env": "dev",
            },
            data_collection_options={
                "is_diagnostics_events_enabled": True,
                "is_health_monitoring_enabled": True,
                "is_incident_logs_enabled": True,
            })
        ```

        ## Import

        Using `pulumi import`, import cloud vm cluster using the `id`. For example:

        ```sh
        $ pulumi import aws:odb/cloudVmCluster:CloudVmCluster example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The unique identifier of the Exadata infrastructure for this VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Grid Infrastructure (GI) cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] cpu_core_count: The number of CPU cores to enable on the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[Union['CloudVmClusterDataCollectionOptionsArgs', 'CloudVmClusterDataCollectionOptionsArgsDict']] data_collection_options: The set of preferences for the various diagnostic collection options for the VM cluster.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The size of the data disk group, in terabytes (TBs), to allocate for the VM cluster. Changing this will create a new resource.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The amount of local node storage, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of database servers for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] gi_version: A valid software version of Oracle Grid Infrastructure (GI). To get the list of valid values, use the ListGiVersions operation and specify the shape of the Exadata infrastructure. Example: 19.0.0.0 Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] hostname_prefix: The host name prefix for the VM cluster. Constraints: - Can't be "localhost" or "hostname". - Can't contain "-version". - The maximum length of the combined hostname and domain is 63 characters. - The hostname must be unique within the subnet. Changing this will create a new resource.
        :param pulumi.Input[_builtins.bool] is_local_backup_enabled: Specifies whether to enable database backups to local Exadata storage for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.bool] is_sparse_diskgroup_enabled: Specifies whether to create a sparse disk group for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model to apply to the VM cluster. Default: LICENSE_INCLUDED. Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The amount of memory, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] odb_network_id: The unique identifier of the ODB network for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp: The port number for TCP connections to the single client access name (SCAN) listener. Valid values: 1024–8999, except 2484, 6100, 6200, 7060, 7070, 7085, and 7879. Default: 1521. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] timezone: The configured time zone of the VM cluster. Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudVmClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        with_minimum_parameter = aws.odb.CloudVmCluster("with_minimum_parameter",
            display_name="my-exa-infra",
            cloud_exadata_infrastructure_id="exa_gjrmtxl4qk",
            cpu_core_count=6,
            gi_version="23.0.0.0",
            hostname_prefix="apollo12",
            ssh_public_keys=["public-ssh-key"],
            odb_network_id="odbnet_3l9st3litg",
            is_local_backup_enabled=True,
            is_sparse_diskgroup_enabled=True,
            license_model="LICENSE_INCLUDED",
            data_storage_size_in_tbs=20,
            db_servers=[
                "db-server-1",
                "db-server-2",
            ],
            db_node_storage_size_in_gbs=120,
            memory_size_in_gbs=60,
            data_collection_options={
                "is_diagnostics_events_enabled": False,
                "is_health_monitoring_enabled": False,
                "is_incident_logs_enabled": False,
            })
        with_all_parameters = aws.odb.CloudVmCluster("with_all_parameters",
            display_name="my-vmc",
            cloud_exadata_infrastructure_id="exa_gjrmtxl4qk",
            cpu_core_count=6,
            gi_version="23.0.0.0",
            hostname_prefix="apollo12",
            ssh_public_keys=["my-ssh-key"],
            odb_network_id="odbnet_3l9st3litg",
            is_local_backup_enabled=True,
            is_sparse_diskgroup_enabled=True,
            license_model="LICENSE_INCLUDED",
            data_storage_size_in_tbs=20,
            db_servers=[
                "my-dbserver-1",
                "my-db-server-2",
            ],
            db_node_storage_size_in_gbs=120,
            memory_size_in_gbs=60,
            cluster_name="julia-13",
            timezone="UTC",
            scan_listener_port_tcp=1521,
            tags={
                "env": "dev",
            },
            data_collection_options={
                "is_diagnostics_events_enabled": True,
                "is_health_monitoring_enabled": True,
                "is_incident_logs_enabled": True,
            })
        ```

        ## Import

        Using `pulumi import`, import cloud vm cluster using the `id`. For example:

        ```sh
        $ pulumi import aws:odb/cloudVmCluster:CloudVmCluster example example
        ```

        :param str resource_name: The name of the resource.
        :param CloudVmClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudVmClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
                 data_collection_options: Optional[pulumi.Input[Union['CloudVmClusterDataCollectionOptionsArgs', 'CloudVmClusterDataCollectionOptionsArgsDict']]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gi_version: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 license_model: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
                 odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_listener_port_tcp: Optional[pulumi.Input[_builtins.int]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['CloudVmClusterTimeoutsArgs', 'CloudVmClusterTimeoutsArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudVmClusterArgs.__new__(CloudVmClusterArgs)

            if cloud_exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_exadata_infrastructure_id'")
            __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
            __props__.__dict__["cluster_name"] = cluster_name
            if cpu_core_count is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_core_count'")
            __props__.__dict__["cpu_core_count"] = cpu_core_count
            __props__.__dict__["data_collection_options"] = data_collection_options
            if data_storage_size_in_tbs is None and not opts.urn:
                raise TypeError("Missing required property 'data_storage_size_in_tbs'")
            __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
            __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
            if db_servers is None and not opts.urn:
                raise TypeError("Missing required property 'db_servers'")
            __props__.__dict__["db_servers"] = db_servers
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if gi_version is None and not opts.urn:
                raise TypeError("Missing required property 'gi_version'")
            __props__.__dict__["gi_version"] = gi_version
            if hostname_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'hostname_prefix'")
            __props__.__dict__["hostname_prefix"] = hostname_prefix
            __props__.__dict__["is_local_backup_enabled"] = is_local_backup_enabled
            __props__.__dict__["is_sparse_diskgroup_enabled"] = is_sparse_diskgroup_enabled
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
            if odb_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'odb_network_id'")
            __props__.__dict__["odb_network_id"] = odb_network_id
            __props__.__dict__["region"] = region
            __props__.__dict__["scan_listener_port_tcp"] = scan_listener_port_tcp
            if ssh_public_keys is None and not opts.urn:
                raise TypeError("Missing required property 'ssh_public_keys'")
            __props__.__dict__["ssh_public_keys"] = ssh_public_keys
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["arn"] = None
            __props__.__dict__["compute_model"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["disk_redundancy"] = None
            __props__.__dict__["domain"] = None
            __props__.__dict__["gi_version_computed"] = None
            __props__.__dict__["hostname_prefix_computed"] = None
            __props__.__dict__["iorm_config_caches"] = None
            __props__.__dict__["last_update_history_entry_id"] = None
            __props__.__dict__["listener_port"] = None
            __props__.__dict__["node_count"] = None
            __props__.__dict__["oci_resource_anchor_name"] = None
            __props__.__dict__["oci_url"] = None
            __props__.__dict__["ocid"] = None
            __props__.__dict__["percent_progress"] = None
            __props__.__dict__["scan_dns_name"] = None
            __props__.__dict__["scan_dns_record_id"] = None
            __props__.__dict__["scan_ip_ids"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_reason"] = None
            __props__.__dict__["storage_size_in_gbs"] = None
            __props__.__dict__["system_version"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["vip_ids"] = None
        super(CloudVmCluster, __self__).__init__(
            'aws:odb/cloudVmCluster:CloudVmCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            compute_model: Optional[pulumi.Input[_builtins.str]] = None,
            cpu_core_count: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            data_collection_options: Optional[pulumi.Input[Union['CloudVmClusterDataCollectionOptionsArgs', 'CloudVmClusterDataCollectionOptionsArgsDict']]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            disk_redundancy: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            gi_version: Optional[pulumi.Input[_builtins.str]] = None,
            gi_version_computed: Optional[pulumi.Input[_builtins.str]] = None,
            hostname_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            hostname_prefix_computed: Optional[pulumi.Input[_builtins.str]] = None,
            iorm_config_caches: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudVmClusterIormConfigCachArgs', 'CloudVmClusterIormConfigCachArgsDict']]]]] = None,
            is_local_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_sparse_diskgroup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            last_update_history_entry_id: Optional[pulumi.Input[_builtins.str]] = None,
            license_model: Optional[pulumi.Input[_builtins.str]] = None,
            listener_port: Optional[pulumi.Input[_builtins.int]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            node_count: Optional[pulumi.Input[_builtins.int]] = None,
            oci_resource_anchor_name: Optional[pulumi.Input[_builtins.str]] = None,
            oci_url: Optional[pulumi.Input[_builtins.str]] = None,
            ocid: Optional[pulumi.Input[_builtins.str]] = None,
            odb_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            percent_progress: Optional[pulumi.Input[_builtins.float]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scan_dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            scan_dns_record_id: Optional[pulumi.Input[_builtins.str]] = None,
            scan_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            scan_listener_port_tcp: Optional[pulumi.Input[_builtins.int]] = None,
            shape: Optional[pulumi.Input[_builtins.str]] = None,
            ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            status_reason: Optional[pulumi.Input[_builtins.str]] = None,
            storage_size_in_gbs: Optional[pulumi.Input[_builtins.int]] = None,
            system_version: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['CloudVmClusterTimeoutsArgs', 'CloudVmClusterTimeoutsArgsDict']]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            vip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'CloudVmCluster':
        """
        Get an existing CloudVmCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) for the cloud vm cluster.
        :param pulumi.Input[_builtins.str] cloud_exadata_infrastructure_id: The unique identifier of the Exadata infrastructure for this VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the Grid Infrastructure (GI) cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] compute_model: The compute model used when the instance is created or cloned — either ECPU or OCPU. ECPU is a virtualized compute unit; OCPU is a physical processor core with hyper-threading.
        :param pulumi.Input[_builtins.int] cpu_core_count: The number of CPU cores to enable on the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the VM cluster was created.
        :param pulumi.Input[Union['CloudVmClusterDataCollectionOptionsArgs', 'CloudVmClusterDataCollectionOptionsArgsDict']] data_collection_options: The set of preferences for the various diagnostic collection options for the VM cluster.
        :param pulumi.Input[_builtins.float] data_storage_size_in_tbs: The size of the data disk group, in terabytes (TBs), to allocate for the VM cluster. Changing this will create a new resource.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] db_node_storage_size_in_gbs: The amount of local node storage, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] db_servers: The list of database servers for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] disk_redundancy: The type of redundancy for the VM cluster: NORMAL (2-way) or HIGH (3-way).
               * `AttrDomain` - The domain name associated with the VM cluster.
        :param pulumi.Input[_builtins.str] display_name: A user-friendly name for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] domain: The domain name associated with the VM cluster.
        :param pulumi.Input[_builtins.str] gi_version: A valid software version of Oracle Grid Infrastructure (GI). To get the list of valid values, use the ListGiVersions operation and specify the shape of the Exadata infrastructure. Example: 19.0.0.0 Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] gi_version_computed: A complete software version of Oracle Grid Infrastructure (GI).
        :param pulumi.Input[_builtins.str] hostname_prefix: The host name prefix for the VM cluster. Constraints: - Can't be "localhost" or "hostname". - Can't contain "-version". - The maximum length of the combined hostname and domain is 63 characters. - The hostname must be unique within the subnet. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] hostname_prefix_computed: The host name for the VM cluster. Constraints: - Can't be "localhost" or "hostname". - Can't contain "-version". - The maximum length of the combined hostname and domain is 63 characters. - The hostname must be unique within the subnet. This member is required. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudVmClusterIormConfigCachArgs', 'CloudVmClusterIormConfigCachArgsDict']]]] iorm_config_caches: The Exadata IORM (I/O Resource Manager) configuration cache details for the VM cluster.
        :param pulumi.Input[_builtins.bool] is_local_backup_enabled: Specifies whether to enable database backups to local Exadata storage for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.bool] is_sparse_diskgroup_enabled: Specifies whether to create a sparse disk group for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] last_update_history_entry_id: The OCID of the most recent maintenance update history entry.
        :param pulumi.Input[_builtins.str] license_model: The Oracle license model to apply to the VM cluster. Default: LICENSE_INCLUDED. Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] listener_port: The listener port number configured on the VM cluster.
        :param pulumi.Input[_builtins.int] memory_size_in_gbs: The amount of memory, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.int] node_count: The total number of nodes in the VM cluster.
        :param pulumi.Input[_builtins.str] oci_resource_anchor_name: The name of the OCI resource anchor associated with the VM cluster.
        :param pulumi.Input[_builtins.str] oci_url: The HTTPS link to the VM cluster resource in OCI.
        :param pulumi.Input[_builtins.str] ocid: The OCID (Oracle Cloud Identifier) of the VM cluster.
        :param pulumi.Input[_builtins.str] odb_network_id: The unique identifier of the ODB network for the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.float] percent_progress: The percentage of progress made on the current operation for the VM cluster.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] scan_dns_name: The fully qualified domain name (FQDN) for the SCAN IP addresses associated with the VM cluster.
        :param pulumi.Input[_builtins.str] scan_dns_record_id: The OCID of the DNS record for the SCAN IPs linked to the VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scan_ip_ids: The list of OCIDs for SCAN IP addresses associated with the VM cluster.
        :param pulumi.Input[_builtins.int] scan_listener_port_tcp: The port number for TCP connections to the single client access name (SCAN) listener. Valid values: 1024–8999, except 2484, 6100, 6200, 7060, 7070, 7085, and 7879. Default: 1521. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] shape: The hardware model name of the Exadata infrastructure running the VM cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] status: The current lifecycle status of the VM cluster.
        :param pulumi.Input[_builtins.str] status_reason: Additional information regarding the current status of the VM cluster.
        :param pulumi.Input[_builtins.int] storage_size_in_gbs: The local node storage allocated to the VM cluster, in gigabytes (GB).
        :param pulumi.Input[_builtins.str] system_version: The operating system version of the image chosen for the VM cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: The combined set of user-defined and provider-defined tags.
        :param pulumi.Input[_builtins.str] timezone: The configured time zone of the VM cluster. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vip_ids: The virtual IP (VIP) addresses assigned to the VM cluster. CRS assigns one VIP per node for failover support.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudVmClusterState.__new__(_CloudVmClusterState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["data_collection_options"] = data_collection_options
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_servers"] = db_servers
        __props__.__dict__["disk_redundancy"] = disk_redundancy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain"] = domain
        __props__.__dict__["gi_version"] = gi_version
        __props__.__dict__["gi_version_computed"] = gi_version_computed
        __props__.__dict__["hostname_prefix"] = hostname_prefix
        __props__.__dict__["hostname_prefix_computed"] = hostname_prefix_computed
        __props__.__dict__["iorm_config_caches"] = iorm_config_caches
        __props__.__dict__["is_local_backup_enabled"] = is_local_backup_enabled
        __props__.__dict__["is_sparse_diskgroup_enabled"] = is_sparse_diskgroup_enabled
        __props__.__dict__["last_update_history_entry_id"] = last_update_history_entry_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["listener_port"] = listener_port
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["oci_resource_anchor_name"] = oci_resource_anchor_name
        __props__.__dict__["oci_url"] = oci_url
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["odb_network_id"] = odb_network_id
        __props__.__dict__["percent_progress"] = percent_progress
        __props__.__dict__["region"] = region
        __props__.__dict__["scan_dns_name"] = scan_dns_name
        __props__.__dict__["scan_dns_record_id"] = scan_dns_record_id
        __props__.__dict__["scan_ip_ids"] = scan_ip_ids
        __props__.__dict__["scan_listener_port_tcp"] = scan_listener_port_tcp
        __props__.__dict__["shape"] = shape
        __props__.__dict__["ssh_public_keys"] = ssh_public_keys
        __props__.__dict__["status"] = status
        __props__.__dict__["status_reason"] = status_reason
        __props__.__dict__["storage_size_in_gbs"] = storage_size_in_gbs
        __props__.__dict__["system_version"] = system_version
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["vip_ids"] = vip_ids
        return CloudVmCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) for the cloud vm cluster.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the Exadata infrastructure for this VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Grid Infrastructure (GI) cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[_builtins.str]:
        """
        The compute model used when the instance is created or cloned — either ECPU or OCPU. ECPU is a virtualized compute unit; OCPU is a physical processor core with hyper-threading.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of CPU cores to enable on the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the VM cluster was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> pulumi.Output[Optional['outputs.CloudVmClusterDataCollectionOptions']]:
        """
        The set of preferences for the various diagnostic collection options for the VM cluster.
        """
        return pulumi.get(self, "data_collection_options")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        The size of the data disk group, in terabytes (TBs), to allocate for the VM cluster. Changing this will create a new resource.

        The following arguments are optional:
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of local node storage, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of database servers for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "db_servers")

    @_builtins.property
    @pulumi.getter(name="diskRedundancy")
    def disk_redundancy(self) -> pulumi.Output[_builtins.str]:
        """
        The type of redundancy for the VM cluster: NORMAL (2-way) or HIGH (3-way).
        * `AttrDomain` - The domain name associated with the VM cluster.
        """
        return pulumi.get(self, "disk_redundancy")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-friendly name for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name associated with the VM cluster.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="giVersion")
    def gi_version(self) -> pulumi.Output[_builtins.str]:
        """
        A valid software version of Oracle Grid Infrastructure (GI). To get the list of valid values, use the ListGiVersions operation and specify the shape of the Exadata infrastructure. Example: 19.0.0.0 Changing this will create a new resource.
        """
        return pulumi.get(self, "gi_version")

    @_builtins.property
    @pulumi.getter(name="giVersionComputed")
    def gi_version_computed(self) -> pulumi.Output[_builtins.str]:
        """
        A complete software version of Oracle Grid Infrastructure (GI).
        """
        return pulumi.get(self, "gi_version_computed")

    @_builtins.property
    @pulumi.getter(name="hostnamePrefix")
    def hostname_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The host name prefix for the VM cluster. Constraints: - Can't be "localhost" or "hostname". - Can't contain "-version". - The maximum length of the combined hostname and domain is 63 characters. - The hostname must be unique within the subnet. Changing this will create a new resource.
        """
        return pulumi.get(self, "hostname_prefix")

    @_builtins.property
    @pulumi.getter(name="hostnamePrefixComputed")
    def hostname_prefix_computed(self) -> pulumi.Output[_builtins.str]:
        """
        The host name for the VM cluster. Constraints: - Can't be "localhost" or "hostname". - Can't contain "-version". - The maximum length of the combined hostname and domain is 63 characters. - The hostname must be unique within the subnet. This member is required. Changing this will create a new resource.
        """
        return pulumi.get(self, "hostname_prefix_computed")

    @_builtins.property
    @pulumi.getter(name="iormConfigCaches")
    def iorm_config_caches(self) -> pulumi.Output[Sequence['outputs.CloudVmClusterIormConfigCach']]:
        """
        The Exadata IORM (I/O Resource Manager) configuration cache details for the VM cluster.
        """
        return pulumi.get(self, "iorm_config_caches")

    @_builtins.property
    @pulumi.getter(name="isLocalBackupEnabled")
    def is_local_backup_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable database backups to local Exadata storage for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "is_local_backup_enabled")

    @_builtins.property
    @pulumi.getter(name="isSparseDiskgroupEnabled")
    def is_sparse_diskgroup_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to create a sparse disk group for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "is_sparse_diskgroup_enabled")

    @_builtins.property
    @pulumi.getter(name="lastUpdateHistoryEntryId")
    def last_update_history_entry_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the most recent maintenance update history entry.
        """
        return pulumi.get(self, "last_update_history_entry_id")

    @_builtins.property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[_builtins.str]:
        """
        The Oracle license model to apply to the VM cluster. Default: LICENSE_INCLUDED. Changing this will create a new resource.
        """
        return pulumi.get(self, "license_model")

    @_builtins.property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Output[_builtins.int]:
        """
        The listener port number configured on the VM cluster.
        """
        return pulumi.get(self, "listener_port")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of memory, in gigabytes (GBs), to allocate for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[_builtins.int]:
        """
        The total number of nodes in the VM cluster.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the OCI resource anchor associated with the VM cluster.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> pulumi.Output[_builtins.str]:
        """
        The HTTPS link to the VM cluster resource in OCI.
        """
        return pulumi.get(self, "oci_url")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID (Oracle Cloud Identifier) of the VM cluster.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="odbNetworkId")
    def odb_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the ODB network for the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "odb_network_id")

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> pulumi.Output[_builtins.float]:
        """
        The percentage of progress made on the current operation for the VM cluster.
        """
        return pulumi.get(self, "percent_progress")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified domain name (FQDN) for the SCAN IP addresses associated with the VM cluster.
        """
        return pulumi.get(self, "scan_dns_name")

    @_builtins.property
    @pulumi.getter(name="scanDnsRecordId")
    def scan_dns_record_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the DNS record for the SCAN IPs linked to the VM cluster.
        """
        return pulumi.get(self, "scan_dns_record_id")

    @_builtins.property
    @pulumi.getter(name="scanIpIds")
    def scan_ip_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of OCIDs for SCAN IP addresses associated with the VM cluster.
        """
        return pulumi.get(self, "scan_ip_ids")

    @_builtins.property
    @pulumi.getter(name="scanListenerPortTcp")
    def scan_listener_port_tcp(self) -> pulumi.Output[_builtins.int]:
        """
        The port number for TCP connections to the single client access name (SCAN) listener. Valid values: 1024–8999, except 2484, 6100, 6200, 7060, 7070, 7085, and 7879. Default: 1521. Changing this will create a new resource.
        """
        return pulumi.get(self, "scan_listener_port_tcp")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> pulumi.Output[_builtins.str]:
        """
        The hardware model name of the Exadata infrastructure running the VM cluster.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The public key portion of one or more key pairs used for SSH access to the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "ssh_public_keys")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle status of the VM cluster.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information regarding the current status of the VM cluster.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter(name="storageSizeInGbs")
    def storage_size_in_gbs(self) -> pulumi.Output[_builtins.int]:
        """
        The local node storage allocated to the VM cluster, in gigabytes (GB).
        """
        return pulumi.get(self, "storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> pulumi.Output[_builtins.str]:
        """
        The operating system version of the image chosen for the VM cluster.
        """
        return pulumi.get(self, "system_version")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combined set of user-defined and provider-defined tags.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.CloudVmClusterTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[_builtins.str]:
        """
        The configured time zone of the VM cluster. Changing this will create a new resource.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="vipIds")
    def vip_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The virtual IP (VIP) addresses assigned to the VM cluster. CRS assigns one VIP per node for failover support.
        """
        return pulumi.get(self, "vip_ids")

