# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudExadataInfrastructureResult',
    'AwaitableGetCloudExadataInfrastructureResult',
    'get_cloud_exadata_infrastructure',
    'get_cloud_exadata_infrastructure_output',
]

@pulumi.output_type
class GetCloudExadataInfrastructureResult:
    """
    A collection of values returned by getCloudExadataInfrastructure.
    """
    def __init__(__self__, activated_storage_count=None, additional_storage_count=None, arn=None, availability_zone=None, availability_zone_id=None, available_storage_size_in_gbs=None, compute_count=None, compute_model=None, cpu_count=None, created_at=None, customer_contacts_to_send_to_ocis=None, data_storage_size_in_tbs=None, database_server_type=None, db_node_storage_size_in_gbs=None, db_server_version=None, display_name=None, id=None, last_maintenance_run_id=None, maintenance_windows=None, max_cpu_count=None, max_data_storage_in_tbs=None, max_db_node_storage_size_in_gbs=None, max_memory_in_gbs=None, memory_size_in_gbs=None, monthly_db_server_version=None, monthly_storage_server_version=None, next_maintenance_run_id=None, oci_resource_anchor_name=None, oci_url=None, ocid=None, percent_progress=None, region=None, shape=None, status=None, status_reason=None, storage_count=None, storage_server_type=None, storage_server_version=None, tags=None, total_storage_size_in_gbs=None):
        if activated_storage_count and not isinstance(activated_storage_count, int):
            raise TypeError("Expected argument 'activated_storage_count' to be a int")
        pulumi.set(__self__, "activated_storage_count", activated_storage_count)
        if additional_storage_count and not isinstance(additional_storage_count, int):
            raise TypeError("Expected argument 'additional_storage_count' to be a int")
        pulumi.set(__self__, "additional_storage_count", additional_storage_count)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_id and not isinstance(availability_zone_id, str):
            raise TypeError("Expected argument 'availability_zone_id' to be a str")
        pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if available_storage_size_in_gbs and not isinstance(available_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'available_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "available_storage_size_in_gbs", available_storage_size_in_gbs)
        if compute_count and not isinstance(compute_count, int):
            raise TypeError("Expected argument 'compute_count' to be a int")
        pulumi.set(__self__, "compute_count", compute_count)
        if compute_model and not isinstance(compute_model, str):
            raise TypeError("Expected argument 'compute_model' to be a str")
        pulumi.set(__self__, "compute_model", compute_model)
        if cpu_count and not isinstance(cpu_count, int):
            raise TypeError("Expected argument 'cpu_count' to be a int")
        pulumi.set(__self__, "cpu_count", cpu_count)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if customer_contacts_to_send_to_ocis and not isinstance(customer_contacts_to_send_to_ocis, list):
            raise TypeError("Expected argument 'customer_contacts_to_send_to_ocis' to be a list")
        pulumi.set(__self__, "customer_contacts_to_send_to_ocis", customer_contacts_to_send_to_ocis)
        if data_storage_size_in_tbs and not isinstance(data_storage_size_in_tbs, float):
            raise TypeError("Expected argument 'data_storage_size_in_tbs' to be a float")
        pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if database_server_type and not isinstance(database_server_type, str):
            raise TypeError("Expected argument 'database_server_type' to be a str")
        pulumi.set(__self__, "database_server_type", database_server_type)
        if db_node_storage_size_in_gbs and not isinstance(db_node_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'db_node_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_version and not isinstance(db_server_version, str):
            raise TypeError("Expected argument 'db_server_version' to be a str")
        pulumi.set(__self__, "db_server_version", db_server_version)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_maintenance_run_id and not isinstance(last_maintenance_run_id, str):
            raise TypeError("Expected argument 'last_maintenance_run_id' to be a str")
        pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if maintenance_windows and not isinstance(maintenance_windows, list):
            raise TypeError("Expected argument 'maintenance_windows' to be a list")
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if max_cpu_count and not isinstance(max_cpu_count, int):
            raise TypeError("Expected argument 'max_cpu_count' to be a int")
        pulumi.set(__self__, "max_cpu_count", max_cpu_count)
        if max_data_storage_in_tbs and not isinstance(max_data_storage_in_tbs, float):
            raise TypeError("Expected argument 'max_data_storage_in_tbs' to be a float")
        pulumi.set(__self__, "max_data_storage_in_tbs", max_data_storage_in_tbs)
        if max_db_node_storage_size_in_gbs and not isinstance(max_db_node_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'max_db_node_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "max_db_node_storage_size_in_gbs", max_db_node_storage_size_in_gbs)
        if max_memory_in_gbs and not isinstance(max_memory_in_gbs, int):
            raise TypeError("Expected argument 'max_memory_in_gbs' to be a int")
        pulumi.set(__self__, "max_memory_in_gbs", max_memory_in_gbs)
        if memory_size_in_gbs and not isinstance(memory_size_in_gbs, int):
            raise TypeError("Expected argument 'memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if monthly_db_server_version and not isinstance(monthly_db_server_version, str):
            raise TypeError("Expected argument 'monthly_db_server_version' to be a str")
        pulumi.set(__self__, "monthly_db_server_version", monthly_db_server_version)
        if monthly_storage_server_version and not isinstance(monthly_storage_server_version, str):
            raise TypeError("Expected argument 'monthly_storage_server_version' to be a str")
        pulumi.set(__self__, "monthly_storage_server_version", monthly_storage_server_version)
        if next_maintenance_run_id and not isinstance(next_maintenance_run_id, str):
            raise TypeError("Expected argument 'next_maintenance_run_id' to be a str")
        pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if oci_resource_anchor_name and not isinstance(oci_resource_anchor_name, str):
            raise TypeError("Expected argument 'oci_resource_anchor_name' to be a str")
        pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        if oci_url and not isinstance(oci_url, str):
            raise TypeError("Expected argument 'oci_url' to be a str")
        pulumi.set(__self__, "oci_url", oci_url)
        if ocid and not isinstance(ocid, str):
            raise TypeError("Expected argument 'ocid' to be a str")
        pulumi.set(__self__, "ocid", ocid)
        if percent_progress and not isinstance(percent_progress, float):
            raise TypeError("Expected argument 'percent_progress' to be a float")
        pulumi.set(__self__, "percent_progress", percent_progress)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if storage_count and not isinstance(storage_count, int):
            raise TypeError("Expected argument 'storage_count' to be a int")
        pulumi.set(__self__, "storage_count", storage_count)
        if storage_server_type and not isinstance(storage_server_type, str):
            raise TypeError("Expected argument 'storage_server_type' to be a str")
        pulumi.set(__self__, "storage_server_type", storage_server_type)
        if storage_server_version and not isinstance(storage_server_version, str):
            raise TypeError("Expected argument 'storage_server_version' to be a str")
        pulumi.set(__self__, "storage_server_version", storage_server_version)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if total_storage_size_in_gbs and not isinstance(total_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'total_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "total_storage_size_in_gbs", total_storage_size_in_gbs)

    @_builtins.property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> _builtins.int:
        """
        The number of storage servers requested for the Exadata infrastructure.
        """
        return pulumi.get(self, "activated_storage_count")

    @_builtins.property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> _builtins.int:
        """
        The number of storage servers requested for the Exadata infrastructure.
        """
        return pulumi.get(self, "additional_storage_count")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) for the Exadata infrastructure.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> _builtins.str:
        """
        The AZ ID of the AZ where the Exadata infrastructure is located.
        """
        return pulumi.get(self, "availability_zone_id")

    @_builtins.property
    @pulumi.getter(name="availableStorageSizeInGbs")
    def available_storage_size_in_gbs(self) -> _builtins.int:
        return pulumi.get(self, "available_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> _builtins.int:
        """
        The number of database servers for the Exadata infrastructure.
        """
        return pulumi.get(self, "compute_count")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> _builtins.str:
        """
        The OCI compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on the physical core of a processor with hyper-threading enabled.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> _builtins.int:
        """
        The total number of CPU cores that are allocated to the Exadata infrastructure.
        """
        return pulumi.get(self, "cpu_count")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The time when the Exadata infrastructure was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customerContactsToSendToOcis")
    def customer_contacts_to_send_to_ocis(self) -> Sequence['outputs.GetCloudExadataInfrastructureCustomerContactsToSendToOciResult']:
        return pulumi.get(self, "customer_contacts_to_send_to_ocis")

    @_builtins.property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> _builtins.float:
        """
        The size of the Exadata infrastructure's data disk group, in terabytes (TB).
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="databaseServerType")
    def database_server_type(self) -> _builtins.str:
        """
        The database server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation.
        """
        return pulumi.get(self, "database_server_type")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> _builtins.int:
        """
        The size of the storage available on each database node, in gigabytes (GB).
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dbServerVersion")
    def db_server_version(self) -> _builtins.str:
        """
        The version of the Exadata infrastructure.
        """
        return pulumi.get(self, "db_server_version")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the Exadata infrastructure.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier of the Exadata infrastructure.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> _builtins.str:
        """
        The Oracle Cloud Identifier (OCID) of the last maintenance run for the Exadata infrastructure.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetCloudExadataInfrastructureMaintenanceWindowResult']:
        """
        The scheduling details of the maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @_builtins.property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> _builtins.int:
        """
        The total number of CPU cores available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_cpu_count")

    @_builtins.property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> _builtins.float:
        """
        The total amount of data disk group storage, in terabytes (TB), that's available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_data_storage_in_tbs")

    @_builtins.property
    @pulumi.getter(name="maxDbNodeStorageSizeInGbs")
    def max_db_node_storage_size_in_gbs(self) -> _builtins.int:
        """
        The total amount of local node storage, in gigabytes (GB), that's available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> _builtins.int:
        """
        The total amount of memory, in gigabytes (GB), that's available on the Exadata infrastructure.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> _builtins.int:
        """
        The amount of memory, in gigabytes (GB), that's allocated on the Exadata infrastructure.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="monthlyDbServerVersion")
    def monthly_db_server_version(self) -> _builtins.str:
        """
        The monthly software version of the database servers installed on the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_db_server_version")

    @_builtins.property
    @pulumi.getter(name="monthlyStorageServerVersion")
    def monthly_storage_server_version(self) -> _builtins.str:
        """
        The monthly software version of the storage servers installed on the Exadata infrastructure.
        """
        return pulumi.get(self, "monthly_storage_server_version")

    @_builtins.property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> _builtins.str:
        """
        The OCID of the next maintenance run for the Exadata infrastructure.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> _builtins.str:
        """
        The name of the OCI resource anchor for the Exadata infrastructure.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter(name="ociUrl")
    def oci_url(self) -> _builtins.str:
        """
        The HTTPS link to the Exadata infrastructure in OCI.
        """
        return pulumi.get(self, "oci_url")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> _builtins.str:
        """
        The OCID of the Exadata infrastructure in OCI.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter(name="percentProgress")
    def percent_progress(self) -> _builtins.float:
        """
        The amount of progress made on the current operation on the Exadata infrastructure expressed as a percentage.
        """
        return pulumi.get(self, "percent_progress")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> _builtins.str:
        """
        The model name of the Exadata infrastructure.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Exadata infrastructure.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        Additional information about the status of the Exadata infrastructure.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> _builtins.int:
        """
        The number of storage servers that are activated for the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_count")

    @_builtins.property
    @pulumi.getter(name="storageServerType")
    def storage_server_type(self) -> _builtins.str:
        """
        The storage server model type of the Exadata infrastructure. For the list of valid model names, use the ListDbSystemShapes operation.
        """
        return pulumi.get(self, "storage_server_type")

    @_builtins.property
    @pulumi.getter(name="storageServerVersion")
    def storage_server_version(self) -> _builtins.str:
        """
        The software version of the storage servers on the Exadata infrastructure.
        """
        return pulumi.get(self, "storage_server_version")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        (Optional) A map of tags to assign to the exadata infrastructure. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="totalStorageSizeInGbs")
    def total_storage_size_in_gbs(self) -> _builtins.int:
        """
        The total amount of storage, in gigabytes (GB), on the Exadata infrastructure.
        """
        return pulumi.get(self, "total_storage_size_in_gbs")


class AwaitableGetCloudExadataInfrastructureResult(GetCloudExadataInfrastructureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudExadataInfrastructureResult(
            activated_storage_count=self.activated_storage_count,
            additional_storage_count=self.additional_storage_count,
            arn=self.arn,
            availability_zone=self.availability_zone,
            availability_zone_id=self.availability_zone_id,
            available_storage_size_in_gbs=self.available_storage_size_in_gbs,
            compute_count=self.compute_count,
            compute_model=self.compute_model,
            cpu_count=self.cpu_count,
            created_at=self.created_at,
            customer_contacts_to_send_to_ocis=self.customer_contacts_to_send_to_ocis,
            data_storage_size_in_tbs=self.data_storage_size_in_tbs,
            database_server_type=self.database_server_type,
            db_node_storage_size_in_gbs=self.db_node_storage_size_in_gbs,
            db_server_version=self.db_server_version,
            display_name=self.display_name,
            id=self.id,
            last_maintenance_run_id=self.last_maintenance_run_id,
            maintenance_windows=self.maintenance_windows,
            max_cpu_count=self.max_cpu_count,
            max_data_storage_in_tbs=self.max_data_storage_in_tbs,
            max_db_node_storage_size_in_gbs=self.max_db_node_storage_size_in_gbs,
            max_memory_in_gbs=self.max_memory_in_gbs,
            memory_size_in_gbs=self.memory_size_in_gbs,
            monthly_db_server_version=self.monthly_db_server_version,
            monthly_storage_server_version=self.monthly_storage_server_version,
            next_maintenance_run_id=self.next_maintenance_run_id,
            oci_resource_anchor_name=self.oci_resource_anchor_name,
            oci_url=self.oci_url,
            ocid=self.ocid,
            percent_progress=self.percent_progress,
            region=self.region,
            shape=self.shape,
            status=self.status,
            status_reason=self.status_reason,
            storage_count=self.storage_count,
            storage_server_type=self.storage_server_type,
            storage_server_version=self.storage_server_version,
            tags=self.tags,
            total_storage_size_in_gbs=self.total_storage_size_in_gbs)


def get_cloud_exadata_infrastructure(id: Optional[_builtins.str] = None,
                                     region: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudExadataInfrastructureResult:
    """
    Data source for exadata infrastructure resource in AWS for Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_cloud_exadata_infrastructure(id="example")
    ```


    :param _builtins.str id: The unique identifier of the Exadata infrastructure.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:odb/getCloudExadataInfrastructure:getCloudExadataInfrastructure', __args__, opts=opts, typ=GetCloudExadataInfrastructureResult).value

    return AwaitableGetCloudExadataInfrastructureResult(
        activated_storage_count=pulumi.get(__ret__, 'activated_storage_count'),
        additional_storage_count=pulumi.get(__ret__, 'additional_storage_count'),
        arn=pulumi.get(__ret__, 'arn'),
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        availability_zone_id=pulumi.get(__ret__, 'availability_zone_id'),
        available_storage_size_in_gbs=pulumi.get(__ret__, 'available_storage_size_in_gbs'),
        compute_count=pulumi.get(__ret__, 'compute_count'),
        compute_model=pulumi.get(__ret__, 'compute_model'),
        cpu_count=pulumi.get(__ret__, 'cpu_count'),
        created_at=pulumi.get(__ret__, 'created_at'),
        customer_contacts_to_send_to_ocis=pulumi.get(__ret__, 'customer_contacts_to_send_to_ocis'),
        data_storage_size_in_tbs=pulumi.get(__ret__, 'data_storage_size_in_tbs'),
        database_server_type=pulumi.get(__ret__, 'database_server_type'),
        db_node_storage_size_in_gbs=pulumi.get(__ret__, 'db_node_storage_size_in_gbs'),
        db_server_version=pulumi.get(__ret__, 'db_server_version'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        last_maintenance_run_id=pulumi.get(__ret__, 'last_maintenance_run_id'),
        maintenance_windows=pulumi.get(__ret__, 'maintenance_windows'),
        max_cpu_count=pulumi.get(__ret__, 'max_cpu_count'),
        max_data_storage_in_tbs=pulumi.get(__ret__, 'max_data_storage_in_tbs'),
        max_db_node_storage_size_in_gbs=pulumi.get(__ret__, 'max_db_node_storage_size_in_gbs'),
        max_memory_in_gbs=pulumi.get(__ret__, 'max_memory_in_gbs'),
        memory_size_in_gbs=pulumi.get(__ret__, 'memory_size_in_gbs'),
        monthly_db_server_version=pulumi.get(__ret__, 'monthly_db_server_version'),
        monthly_storage_server_version=pulumi.get(__ret__, 'monthly_storage_server_version'),
        next_maintenance_run_id=pulumi.get(__ret__, 'next_maintenance_run_id'),
        oci_resource_anchor_name=pulumi.get(__ret__, 'oci_resource_anchor_name'),
        oci_url=pulumi.get(__ret__, 'oci_url'),
        ocid=pulumi.get(__ret__, 'ocid'),
        percent_progress=pulumi.get(__ret__, 'percent_progress'),
        region=pulumi.get(__ret__, 'region'),
        shape=pulumi.get(__ret__, 'shape'),
        status=pulumi.get(__ret__, 'status'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        storage_count=pulumi.get(__ret__, 'storage_count'),
        storage_server_type=pulumi.get(__ret__, 'storage_server_type'),
        storage_server_version=pulumi.get(__ret__, 'storage_server_version'),
        tags=pulumi.get(__ret__, 'tags'),
        total_storage_size_in_gbs=pulumi.get(__ret__, 'total_storage_size_in_gbs'))
def get_cloud_exadata_infrastructure_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudExadataInfrastructureResult]:
    """
    Data source for exadata infrastructure resource in AWS for Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_cloud_exadata_infrastructure(id="example")
    ```


    :param _builtins.str id: The unique identifier of the Exadata infrastructure.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:odb/getCloudExadataInfrastructure:getCloudExadataInfrastructure', __args__, opts=opts, typ=GetCloudExadataInfrastructureResult)
    return __ret__.apply(lambda __response__: GetCloudExadataInfrastructureResult(
        activated_storage_count=pulumi.get(__response__, 'activated_storage_count'),
        additional_storage_count=pulumi.get(__response__, 'additional_storage_count'),
        arn=pulumi.get(__response__, 'arn'),
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        availability_zone_id=pulumi.get(__response__, 'availability_zone_id'),
        available_storage_size_in_gbs=pulumi.get(__response__, 'available_storage_size_in_gbs'),
        compute_count=pulumi.get(__response__, 'compute_count'),
        compute_model=pulumi.get(__response__, 'compute_model'),
        cpu_count=pulumi.get(__response__, 'cpu_count'),
        created_at=pulumi.get(__response__, 'created_at'),
        customer_contacts_to_send_to_ocis=pulumi.get(__response__, 'customer_contacts_to_send_to_ocis'),
        data_storage_size_in_tbs=pulumi.get(__response__, 'data_storage_size_in_tbs'),
        database_server_type=pulumi.get(__response__, 'database_server_type'),
        db_node_storage_size_in_gbs=pulumi.get(__response__, 'db_node_storage_size_in_gbs'),
        db_server_version=pulumi.get(__response__, 'db_server_version'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        last_maintenance_run_id=pulumi.get(__response__, 'last_maintenance_run_id'),
        maintenance_windows=pulumi.get(__response__, 'maintenance_windows'),
        max_cpu_count=pulumi.get(__response__, 'max_cpu_count'),
        max_data_storage_in_tbs=pulumi.get(__response__, 'max_data_storage_in_tbs'),
        max_db_node_storage_size_in_gbs=pulumi.get(__response__, 'max_db_node_storage_size_in_gbs'),
        max_memory_in_gbs=pulumi.get(__response__, 'max_memory_in_gbs'),
        memory_size_in_gbs=pulumi.get(__response__, 'memory_size_in_gbs'),
        monthly_db_server_version=pulumi.get(__response__, 'monthly_db_server_version'),
        monthly_storage_server_version=pulumi.get(__response__, 'monthly_storage_server_version'),
        next_maintenance_run_id=pulumi.get(__response__, 'next_maintenance_run_id'),
        oci_resource_anchor_name=pulumi.get(__response__, 'oci_resource_anchor_name'),
        oci_url=pulumi.get(__response__, 'oci_url'),
        ocid=pulumi.get(__response__, 'ocid'),
        percent_progress=pulumi.get(__response__, 'percent_progress'),
        region=pulumi.get(__response__, 'region'),
        shape=pulumi.get(__response__, 'shape'),
        status=pulumi.get(__response__, 'status'),
        status_reason=pulumi.get(__response__, 'status_reason'),
        storage_count=pulumi.get(__response__, 'storage_count'),
        storage_server_type=pulumi.get(__response__, 'storage_server_type'),
        storage_server_version=pulumi.get(__response__, 'storage_server_version'),
        tags=pulumi.get(__response__, 'tags'),
        total_storage_size_in_gbs=pulumi.get(__response__, 'total_storage_size_in_gbs')))
