# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbServerResult',
    'AwaitableGetDbServerResult',
    'get_db_server',
    'get_db_server_output',
]

@pulumi.output_type
class GetDbServerResult:
    """
    A collection of values returned by getDbServer.
    """
    def __init__(__self__, autonomous_virtual_machine_ids=None, autonomous_vm_cluster_ids=None, cloud_exadata_infrastructure_id=None, compute_model=None, cpu_core_count=None, created_at=None, db_node_storage_size_in_gbs=None, db_server_patching_details=None, display_name=None, exadata_infrastructure_id=None, id=None, max_cpu_count=None, max_db_node_storage_in_gbs=None, max_memory_in_gbs=None, memory_size_in_gbs=None, oci_resource_anchor_name=None, ocid=None, region=None, shape=None, status=None, status_reason=None, vm_cluster_ids=None):
        if autonomous_virtual_machine_ids and not isinstance(autonomous_virtual_machine_ids, list):
            raise TypeError("Expected argument 'autonomous_virtual_machine_ids' to be a list")
        pulumi.set(__self__, "autonomous_virtual_machine_ids", autonomous_virtual_machine_ids)
        if autonomous_vm_cluster_ids and not isinstance(autonomous_vm_cluster_ids, list):
            raise TypeError("Expected argument 'autonomous_vm_cluster_ids' to be a list")
        pulumi.set(__self__, "autonomous_vm_cluster_ids", autonomous_vm_cluster_ids)
        if cloud_exadata_infrastructure_id and not isinstance(cloud_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'cloud_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if compute_model and not isinstance(compute_model, str):
            raise TypeError("Expected argument 'compute_model' to be a str")
        pulumi.set(__self__, "compute_model", compute_model)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if db_node_storage_size_in_gbs and not isinstance(db_node_storage_size_in_gbs, int):
            raise TypeError("Expected argument 'db_node_storage_size_in_gbs' to be a int")
        pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_server_patching_details and not isinstance(db_server_patching_details, list):
            raise TypeError("Expected argument 'db_server_patching_details' to be a list")
        pulumi.set(__self__, "db_server_patching_details", db_server_patching_details)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id and not isinstance(exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_cpu_count and not isinstance(max_cpu_count, int):
            raise TypeError("Expected argument 'max_cpu_count' to be a int")
        pulumi.set(__self__, "max_cpu_count", max_cpu_count)
        if max_db_node_storage_in_gbs and not isinstance(max_db_node_storage_in_gbs, int):
            raise TypeError("Expected argument 'max_db_node_storage_in_gbs' to be a int")
        pulumi.set(__self__, "max_db_node_storage_in_gbs", max_db_node_storage_in_gbs)
        if max_memory_in_gbs and not isinstance(max_memory_in_gbs, int):
            raise TypeError("Expected argument 'max_memory_in_gbs' to be a int")
        pulumi.set(__self__, "max_memory_in_gbs", max_memory_in_gbs)
        if memory_size_in_gbs and not isinstance(memory_size_in_gbs, int):
            raise TypeError("Expected argument 'memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if oci_resource_anchor_name and not isinstance(oci_resource_anchor_name, str):
            raise TypeError("Expected argument 'oci_resource_anchor_name' to be a str")
        pulumi.set(__self__, "oci_resource_anchor_name", oci_resource_anchor_name)
        if ocid and not isinstance(ocid, str):
            raise TypeError("Expected argument 'ocid' to be a str")
        pulumi.set(__self__, "ocid", ocid)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reason and not isinstance(status_reason, str):
            raise TypeError("Expected argument 'status_reason' to be a str")
        pulumi.set(__self__, "status_reason", status_reason)
        if vm_cluster_ids and not isinstance(vm_cluster_ids, list):
            raise TypeError("Expected argument 'vm_cluster_ids' to be a list")
        pulumi.set(__self__, "vm_cluster_ids", vm_cluster_ids)

    @_builtins.property
    @pulumi.getter(name="autonomousVirtualMachineIds")
    def autonomous_virtual_machine_ids(self) -> Sequence[_builtins.str]:
        """
        The list of unique identifiers for the Autonomous VMs associated with this database server.
        """
        return pulumi.get(self, "autonomous_virtual_machine_ids")

    @_builtins.property
    @pulumi.getter(name="autonomousVmClusterIds")
    def autonomous_vm_cluster_ids(self) -> Sequence[_builtins.str]:
        """
        The OCID of the autonomous VM clusters that are associated with the database server.
        """
        return pulumi.get(self, "autonomous_vm_cluster_ids")

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> _builtins.str:
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> _builtins.str:
        """
        The compute model of the database server.
        """
        return pulumi.get(self, "compute_model")

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> _builtins.int:
        """
        The number of CPU cores enabled on the database server.
        """
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time when the database server was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> _builtins.int:
        """
        The allocated local node storage in GBs on the database server.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="dbServerPatchingDetails")
    def db_server_patching_details(self) -> Sequence['outputs.GetDbServerDbServerPatchingDetailResult']:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "db_server_patching_details")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the database server.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> _builtins.str:
        """
        The exadata infrastructure ID of the database server.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> _builtins.int:
        """
        The total number of CPU cores available.
        """
        return pulumi.get(self, "max_cpu_count")

    @_builtins.property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> _builtins.int:
        """
        The total local node storage available in GBs.
        """
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @_builtins.property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> _builtins.int:
        """
        The total memory available in GBs.
        """
        return pulumi.get(self, "max_memory_in_gbs")

    @_builtins.property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> _builtins.int:
        """
        The allocated memory in GBs on the database server.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @_builtins.property
    @pulumi.getter(name="ociResourceAnchorName")
    def oci_resource_anchor_name(self) -> _builtins.str:
        """
        The name of the OCI resource anchor.
        """
        return pulumi.get(self, "oci_resource_anchor_name")

    @_builtins.property
    @pulumi.getter
    def ocid(self) -> _builtins.str:
        """
        The OCID of the database server to retrieve information about.
        """
        return pulumi.get(self, "ocid")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> _builtins.str:
        """
        The shape of the database server. The shape determines the amount of CPU, storage, and memory resources available.
        """
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the database server.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> _builtins.str:
        """
        Additional information about the current status of the database server.
        """
        return pulumi.get(self, "status_reason")

    @_builtins.property
    @pulumi.getter(name="vmClusterIds")
    def vm_cluster_ids(self) -> Sequence[_builtins.str]:
        """
        The OCID of the VM clusters that are associated with the database server.
        """
        return pulumi.get(self, "vm_cluster_ids")


class AwaitableGetDbServerResult(GetDbServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbServerResult(
            autonomous_virtual_machine_ids=self.autonomous_virtual_machine_ids,
            autonomous_vm_cluster_ids=self.autonomous_vm_cluster_ids,
            cloud_exadata_infrastructure_id=self.cloud_exadata_infrastructure_id,
            compute_model=self.compute_model,
            cpu_core_count=self.cpu_core_count,
            created_at=self.created_at,
            db_node_storage_size_in_gbs=self.db_node_storage_size_in_gbs,
            db_server_patching_details=self.db_server_patching_details,
            display_name=self.display_name,
            exadata_infrastructure_id=self.exadata_infrastructure_id,
            id=self.id,
            max_cpu_count=self.max_cpu_count,
            max_db_node_storage_in_gbs=self.max_db_node_storage_in_gbs,
            max_memory_in_gbs=self.max_memory_in_gbs,
            memory_size_in_gbs=self.memory_size_in_gbs,
            oci_resource_anchor_name=self.oci_resource_anchor_name,
            ocid=self.ocid,
            region=self.region,
            shape=self.shape,
            status=self.status,
            status_reason=self.status_reason,
            vm_cluster_ids=self.vm_cluster_ids)


def get_db_server(cloud_exadata_infrastructure_id: Optional[_builtins.str] = None,
                  id: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbServerResult:
    """
    Data source for manging db server linked to exadata infrastructure of Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_db_server(cloud_exadata_infrastructure_id="exadata_infra_id",
        id="db_server_id")
    ```


    :param _builtins.str cloud_exadata_infrastructure_id: The unique identifier of the cloud vm cluster.
    :param _builtins.str id: The unique identifier of db node associated with vm cluster.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['cloudExadataInfrastructureId'] = cloud_exadata_infrastructure_id
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:odb/getDbServer:getDbServer', __args__, opts=opts, typ=GetDbServerResult).value

    return AwaitableGetDbServerResult(
        autonomous_virtual_machine_ids=pulumi.get(__ret__, 'autonomous_virtual_machine_ids'),
        autonomous_vm_cluster_ids=pulumi.get(__ret__, 'autonomous_vm_cluster_ids'),
        cloud_exadata_infrastructure_id=pulumi.get(__ret__, 'cloud_exadata_infrastructure_id'),
        compute_model=pulumi.get(__ret__, 'compute_model'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        created_at=pulumi.get(__ret__, 'created_at'),
        db_node_storage_size_in_gbs=pulumi.get(__ret__, 'db_node_storage_size_in_gbs'),
        db_server_patching_details=pulumi.get(__ret__, 'db_server_patching_details'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__ret__, 'exadata_infrastructure_id'),
        id=pulumi.get(__ret__, 'id'),
        max_cpu_count=pulumi.get(__ret__, 'max_cpu_count'),
        max_db_node_storage_in_gbs=pulumi.get(__ret__, 'max_db_node_storage_in_gbs'),
        max_memory_in_gbs=pulumi.get(__ret__, 'max_memory_in_gbs'),
        memory_size_in_gbs=pulumi.get(__ret__, 'memory_size_in_gbs'),
        oci_resource_anchor_name=pulumi.get(__ret__, 'oci_resource_anchor_name'),
        ocid=pulumi.get(__ret__, 'ocid'),
        region=pulumi.get(__ret__, 'region'),
        shape=pulumi.get(__ret__, 'shape'),
        status=pulumi.get(__ret__, 'status'),
        status_reason=pulumi.get(__ret__, 'status_reason'),
        vm_cluster_ids=pulumi.get(__ret__, 'vm_cluster_ids'))
def get_db_server_output(cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                         id: Optional[pulumi.Input[_builtins.str]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbServerResult]:
    """
    Data source for manging db server linked to exadata infrastructure of Oracle Database@AWS.

    You can find out more about Oracle Database@AWS from [User Guide](https://docs.aws.amazon.com/odb/latest/UserGuide/what-is-odb.html).

    ## Example Usage

    ### Basic Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.odb.get_db_server(cloud_exadata_infrastructure_id="exadata_infra_id",
        id="db_server_id")
    ```


    :param _builtins.str cloud_exadata_infrastructure_id: The unique identifier of the cloud vm cluster.
    :param _builtins.str id: The unique identifier of db node associated with vm cluster.
           
           The following arguments are optional:
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['cloudExadataInfrastructureId'] = cloud_exadata_infrastructure_id
    __args__['id'] = id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:odb/getDbServer:getDbServer', __args__, opts=opts, typ=GetDbServerResult)
    return __ret__.apply(lambda __response__: GetDbServerResult(
        autonomous_virtual_machine_ids=pulumi.get(__response__, 'autonomous_virtual_machine_ids'),
        autonomous_vm_cluster_ids=pulumi.get(__response__, 'autonomous_vm_cluster_ids'),
        cloud_exadata_infrastructure_id=pulumi.get(__response__, 'cloud_exadata_infrastructure_id'),
        compute_model=pulumi.get(__response__, 'compute_model'),
        cpu_core_count=pulumi.get(__response__, 'cpu_core_count'),
        created_at=pulumi.get(__response__, 'created_at'),
        db_node_storage_size_in_gbs=pulumi.get(__response__, 'db_node_storage_size_in_gbs'),
        db_server_patching_details=pulumi.get(__response__, 'db_server_patching_details'),
        display_name=pulumi.get(__response__, 'display_name'),
        exadata_infrastructure_id=pulumi.get(__response__, 'exadata_infrastructure_id'),
        id=pulumi.get(__response__, 'id'),
        max_cpu_count=pulumi.get(__response__, 'max_cpu_count'),
        max_db_node_storage_in_gbs=pulumi.get(__response__, 'max_db_node_storage_in_gbs'),
        max_memory_in_gbs=pulumi.get(__response__, 'max_memory_in_gbs'),
        memory_size_in_gbs=pulumi.get(__response__, 'memory_size_in_gbs'),
        oci_resource_anchor_name=pulumi.get(__response__, 'oci_resource_anchor_name'),
        ocid=pulumi.get(__response__, 'ocid'),
        region=pulumi.get(__response__, 'region'),
        shape=pulumi.get(__response__, 'shape'),
        status=pulumi.get(__response__, 'status'),
        status_reason=pulumi.get(__response__, 'status_reason'),
        vm_cluster_ids=pulumi.get(__response__, 'vm_cluster_ids')))
