# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AuthorizeVpcEndpointAccessAuthorizedPrincipal',
    'DomainAdvancedSecurityOptions',
    'DomainAdvancedSecurityOptionsMasterUserOptions',
    'DomainAimlOptions',
    'DomainAimlOptionsNaturalLanguageQueryGenerationOptions',
    'DomainAimlOptionsS3VectorsEngine',
    'DomainAutoTuneOptions',
    'DomainAutoTuneOptionsMaintenanceSchedule',
    'DomainAutoTuneOptionsMaintenanceScheduleDuration',
    'DomainClusterConfig',
    'DomainClusterConfigColdStorageOptions',
    'DomainClusterConfigNodeOption',
    'DomainClusterConfigNodeOptionNodeConfig',
    'DomainClusterConfigZoneAwarenessConfig',
    'DomainCognitoOptions',
    'DomainDomainEndpointOptions',
    'DomainEbsOptions',
    'DomainEncryptAtRest',
    'DomainLogPublishingOption',
    'DomainNodeToNodeEncryption',
    'DomainOffPeakWindowOptions',
    'DomainOffPeakWindowOptionsOffPeakWindow',
    'DomainOffPeakWindowOptionsOffPeakWindowWindowStartTime',
    'DomainSamlOptionsSamlOptions',
    'DomainSamlOptionsSamlOptionsIdp',
    'DomainSnapshotOptions',
    'DomainSoftwareUpdateOptions',
    'DomainVpcOptions',
    'OutboundConnectionConnectionProperties',
    'OutboundConnectionConnectionPropertiesCrossClusterSearch',
    'OutboundConnectionLocalDomainInfo',
    'OutboundConnectionRemoteDomainInfo',
    'PackagePackageSource',
    'ServerlessCollectionTimeouts',
    'ServerlessSecurityConfigSamlOptions',
    'ServerlessVpcEndpointTimeouts',
    'VpcEndpointVpcOptions',
    'GetDomainAdvancedSecurityOptionResult',
    'GetDomainAutoTuneOptionResult',
    'GetDomainAutoTuneOptionMaintenanceScheduleResult',
    'GetDomainAutoTuneOptionMaintenanceScheduleDurationResult',
    'GetDomainClusterConfigResult',
    'GetDomainClusterConfigColdStorageOptionResult',
    'GetDomainClusterConfigNodeOptionResult',
    'GetDomainClusterConfigNodeOptionNodeConfigResult',
    'GetDomainClusterConfigZoneAwarenessConfigResult',
    'GetDomainCognitoOptionResult',
    'GetDomainEbsOptionResult',
    'GetDomainEncryptionAtRestResult',
    'GetDomainLogPublishingOptionResult',
    'GetDomainNodeToNodeEncryptionResult',
    'GetDomainOffPeakWindowOptionsResult',
    'GetDomainOffPeakWindowOptionsOffPeakWindowResult',
    'GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeResult',
    'GetDomainSnapshotOptionResult',
    'GetDomainSoftwareUpdateOptionResult',
    'GetDomainVpcOptionResult',
    'GetServerlessSecurityConfigSamlOptionResult',
]

@pulumi.output_type
class AuthorizeVpcEndpointAccessAuthorizedPrincipal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalType":
            suggest = "principal_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizeVpcEndpointAccessAuthorizedPrincipal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizeVpcEndpointAccessAuthorizedPrincipal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizeVpcEndpointAccessAuthorizedPrincipal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal: _builtins.str,
                 principal_type: _builtins.str):
        """
        :param _builtins.str principal: IAM principal that is allowed to access to the domain.
        :param _builtins.str principal_type: Type of principal.
        """
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "principal_type", principal_type)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> _builtins.str:
        """
        IAM principal that is allowed to access to the domain.
        """
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> _builtins.str:
        """
        Type of principal.
        """
        return pulumi.get(self, "principal_type")


@pulumi.output_type
class DomainAdvancedSecurityOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anonymousAuthEnabled":
            suggest = "anonymous_auth_enabled"
        elif key == "internalUserDatabaseEnabled":
            suggest = "internal_user_database_enabled"
        elif key == "masterUserOptions":
            suggest = "master_user_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAdvancedSecurityOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAdvancedSecurityOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAdvancedSecurityOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 anonymous_auth_enabled: Optional[_builtins.bool] = None,
                 internal_user_database_enabled: Optional[_builtins.bool] = None,
                 master_user_options: Optional['outputs.DomainAdvancedSecurityOptionsMasterUserOptions'] = None):
        """
        :param _builtins.bool enabled: Whether advanced security is enabled.
        :param _builtins.bool anonymous_auth_enabled: Whether Anonymous auth is enabled. Enables fine-grained access control on an existing domain. Ignored unless `advanced_security_options` are enabled. _Can only be enabled on an existing domain._
        :param _builtins.bool internal_user_database_enabled: Whether the internal user database is enabled. Default is `false`.
        :param 'DomainAdvancedSecurityOptionsMasterUserOptionsArgs' master_user_options: Configuration block for the main user. Detailed below.
        """
        pulumi.set(__self__, "enabled", enabled)
        if anonymous_auth_enabled is not None:
            pulumi.set(__self__, "anonymous_auth_enabled", anonymous_auth_enabled)
        if internal_user_database_enabled is not None:
            pulumi.set(__self__, "internal_user_database_enabled", internal_user_database_enabled)
        if master_user_options is not None:
            pulumi.set(__self__, "master_user_options", master_user_options)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether advanced security is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="anonymousAuthEnabled")
    def anonymous_auth_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether Anonymous auth is enabled. Enables fine-grained access control on an existing domain. Ignored unless `advanced_security_options` are enabled. _Can only be enabled on an existing domain._
        """
        return pulumi.get(self, "anonymous_auth_enabled")

    @_builtins.property
    @pulumi.getter(name="internalUserDatabaseEnabled")
    def internal_user_database_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the internal user database is enabled. Default is `false`.
        """
        return pulumi.get(self, "internal_user_database_enabled")

    @_builtins.property
    @pulumi.getter(name="masterUserOptions")
    def master_user_options(self) -> Optional['outputs.DomainAdvancedSecurityOptionsMasterUserOptions']:
        """
        Configuration block for the main user. Detailed below.
        """
        return pulumi.get(self, "master_user_options")


@pulumi.output_type
class DomainAdvancedSecurityOptionsMasterUserOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterUserArn":
            suggest = "master_user_arn"
        elif key == "masterUserName":
            suggest = "master_user_name"
        elif key == "masterUserPassword":
            suggest = "master_user_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAdvancedSecurityOptionsMasterUserOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAdvancedSecurityOptionsMasterUserOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAdvancedSecurityOptionsMasterUserOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_user_arn: Optional[_builtins.str] = None,
                 master_user_name: Optional[_builtins.str] = None,
                 master_user_password: Optional[_builtins.str] = None):
        """
        :param _builtins.str master_user_arn: ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
        :param _builtins.str master_user_name: Main user's username, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        :param _builtins.str master_user_password: Main user's password, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        if master_user_arn is not None:
            pulumi.set(__self__, "master_user_arn", master_user_arn)
        if master_user_name is not None:
            pulumi.set(__self__, "master_user_name", master_user_name)
        if master_user_password is not None:
            pulumi.set(__self__, "master_user_password", master_user_password)

    @_builtins.property
    @pulumi.getter(name="masterUserArn")
    def master_user_arn(self) -> Optional[_builtins.str]:
        """
        ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
        """
        return pulumi.get(self, "master_user_arn")

    @_builtins.property
    @pulumi.getter(name="masterUserName")
    def master_user_name(self) -> Optional[_builtins.str]:
        """
        Main user's username, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        return pulumi.get(self, "master_user_name")

    @_builtins.property
    @pulumi.getter(name="masterUserPassword")
    def master_user_password(self) -> Optional[_builtins.str]:
        """
        Main user's password, which is stored in the Amazon OpenSearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
        """
        return pulumi.get(self, "master_user_password")


@pulumi.output_type
class DomainAimlOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "naturalLanguageQueryGenerationOptions":
            suggest = "natural_language_query_generation_options"
        elif key == "s3VectorsEngine":
            suggest = "s3_vectors_engine"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAimlOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAimlOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAimlOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 natural_language_query_generation_options: Optional['outputs.DomainAimlOptionsNaturalLanguageQueryGenerationOptions'] = None,
                 s3_vectors_engine: Optional['outputs.DomainAimlOptionsS3VectorsEngine'] = None):
        if natural_language_query_generation_options is not None:
            pulumi.set(__self__, "natural_language_query_generation_options", natural_language_query_generation_options)
        if s3_vectors_engine is not None:
            pulumi.set(__self__, "s3_vectors_engine", s3_vectors_engine)

    @_builtins.property
    @pulumi.getter(name="naturalLanguageQueryGenerationOptions")
    def natural_language_query_generation_options(self) -> Optional['outputs.DomainAimlOptionsNaturalLanguageQueryGenerationOptions']:
        return pulumi.get(self, "natural_language_query_generation_options")

    @_builtins.property
    @pulumi.getter(name="s3VectorsEngine")
    def s3_vectors_engine(self) -> Optional['outputs.DomainAimlOptionsS3VectorsEngine']:
        return pulumi.get(self, "s3_vectors_engine")


@pulumi.output_type
class DomainAimlOptionsNaturalLanguageQueryGenerationOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredState":
            suggest = "desired_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAimlOptionsNaturalLanguageQueryGenerationOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAimlOptionsNaturalLanguageQueryGenerationOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAimlOptionsNaturalLanguageQueryGenerationOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_state: Optional[_builtins.str] = None):
        """
        :param _builtins.str desired_state: Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        """
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[_builtins.str]:
        """
        Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "desired_state")


@pulumi.output_type
class DomainAimlOptionsS3VectorsEngine(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DomainAutoTuneOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredState":
            suggest = "desired_state"
        elif key == "maintenanceSchedules":
            suggest = "maintenance_schedules"
        elif key == "rollbackOnDisable":
            suggest = "rollback_on_disable"
        elif key == "useOffPeakWindow":
            suggest = "use_off_peak_window"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAutoTuneOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAutoTuneOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAutoTuneOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_state: _builtins.str,
                 maintenance_schedules: Optional[Sequence['outputs.DomainAutoTuneOptionsMaintenanceSchedule']] = None,
                 rollback_on_disable: Optional[_builtins.str] = None,
                 use_off_peak_window: Optional[_builtins.bool] = None):
        """
        :param _builtins.str desired_state: Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        :param Sequence['DomainAutoTuneOptionsMaintenanceScheduleArgs'] maintenance_schedules: Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
               
               **NOTE:** Maintenance windows are deprecated and have been replaced with [off-peak windows](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html). Consequently, `maintenance_schedule` configuration blocks cannot be specified when `use_off_peak_window` is set to `true`.
        :param _builtins.str rollback_on_disable: Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
        :param _builtins.bool use_off_peak_window: Whether to schedule Auto-Tune optimizations that require blue/green deployments during the domain's configured daily off-peak window. Defaults to `false`.
        """
        pulumi.set(__self__, "desired_state", desired_state)
        if maintenance_schedules is not None:
            pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        if rollback_on_disable is not None:
            pulumi.set(__self__, "rollback_on_disable", rollback_on_disable)
        if use_off_peak_window is not None:
            pulumi.set(__self__, "use_off_peak_window", use_off_peak_window)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> _builtins.str:
        """
        Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "desired_state")

    @_builtins.property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Optional[Sequence['outputs.DomainAutoTuneOptionsMaintenanceSchedule']]:
        """
        Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.

        **NOTE:** Maintenance windows are deprecated and have been replaced with [off-peak windows](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html). Consequently, `maintenance_schedule` configuration blocks cannot be specified when `use_off_peak_window` is set to `true`.
        """
        return pulumi.get(self, "maintenance_schedules")

    @_builtins.property
    @pulumi.getter(name="rollbackOnDisable")
    def rollback_on_disable(self) -> Optional[_builtins.str]:
        """
        Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
        """
        return pulumi.get(self, "rollback_on_disable")

    @_builtins.property
    @pulumi.getter(name="useOffPeakWindow")
    def use_off_peak_window(self) -> Optional[_builtins.bool]:
        """
        Whether to schedule Auto-Tune optimizations that require blue/green deployments during the domain's configured daily off-peak window. Defaults to `false`.
        """
        return pulumi.get(self, "use_off_peak_window")


@pulumi.output_type
class DomainAutoTuneOptionsMaintenanceSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpressionForRecurrence":
            suggest = "cron_expression_for_recurrence"
        elif key == "startAt":
            suggest = "start_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainAutoTuneOptionsMaintenanceSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainAutoTuneOptionsMaintenanceSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainAutoTuneOptionsMaintenanceSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression_for_recurrence: _builtins.str,
                 duration: 'outputs.DomainAutoTuneOptionsMaintenanceScheduleDuration',
                 start_at: _builtins.str):
        """
        :param _builtins.str cron_expression_for_recurrence: A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
        :param 'DomainAutoTuneOptionsMaintenanceScheduleDurationArgs' duration: Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
        :param _builtins.str start_at: Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        pulumi.set(__self__, "cron_expression_for_recurrence", cron_expression_for_recurrence)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_at", start_at)

    @_builtins.property
    @pulumi.getter(name="cronExpressionForRecurrence")
    def cron_expression_for_recurrence(self) -> _builtins.str:
        """
        A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
        """
        return pulumi.get(self, "cron_expression_for_recurrence")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> 'outputs.DomainAutoTuneOptionsMaintenanceScheduleDuration':
        """
        Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="startAt")
    def start_at(self) -> _builtins.str:
        """
        Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "start_at")


@pulumi.output_type
class DomainAutoTuneOptionsMaintenanceScheduleDuration(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.int):
        """
        :param _builtins.str unit: Unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
        :param _builtins.int value: An integer specifying the value of the duration of an Auto-Tune maintenance window.
        """
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        """
        Unit of time specifying the duration of an Auto-Tune maintenance window. Valid values: `HOURS`.
        """
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        """
        An integer specifying the value of the duration of an Auto-Tune maintenance window.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DomainClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coldStorageOptions":
            suggest = "cold_storage_options"
        elif key == "dedicatedMasterCount":
            suggest = "dedicated_master_count"
        elif key == "dedicatedMasterEnabled":
            suggest = "dedicated_master_enabled"
        elif key == "dedicatedMasterType":
            suggest = "dedicated_master_type"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceType":
            suggest = "instance_type"
        elif key == "multiAzWithStandbyEnabled":
            suggest = "multi_az_with_standby_enabled"
        elif key == "nodeOptions":
            suggest = "node_options"
        elif key == "warmCount":
            suggest = "warm_count"
        elif key == "warmEnabled":
            suggest = "warm_enabled"
        elif key == "warmType":
            suggest = "warm_type"
        elif key == "zoneAwarenessConfig":
            suggest = "zone_awareness_config"
        elif key == "zoneAwarenessEnabled":
            suggest = "zone_awareness_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cold_storage_options: Optional['outputs.DomainClusterConfigColdStorageOptions'] = None,
                 dedicated_master_count: Optional[_builtins.int] = None,
                 dedicated_master_enabled: Optional[_builtins.bool] = None,
                 dedicated_master_type: Optional[_builtins.str] = None,
                 instance_count: Optional[_builtins.int] = None,
                 instance_type: Optional[_builtins.str] = None,
                 multi_az_with_standby_enabled: Optional[_builtins.bool] = None,
                 node_options: Optional[Sequence['outputs.DomainClusterConfigNodeOption']] = None,
                 warm_count: Optional[_builtins.int] = None,
                 warm_enabled: Optional[_builtins.bool] = None,
                 warm_type: Optional[_builtins.str] = None,
                 zone_awareness_config: Optional['outputs.DomainClusterConfigZoneAwarenessConfig'] = None,
                 zone_awareness_enabled: Optional[_builtins.bool] = None):
        """
        :param 'DomainClusterConfigColdStorageOptionsArgs' cold_storage_options: Configuration block containing cold storage configuration. Detailed below.
        :param _builtins.int dedicated_master_count: Number of dedicated main nodes in the cluster.
        :param _builtins.bool dedicated_master_enabled: Whether dedicated main nodes are enabled for the cluster.
        :param _builtins.str dedicated_master_type: Instance type of the dedicated main nodes in the cluster.
        :param _builtins.int instance_count: Number of instances in the cluster.
        :param _builtins.str instance_type: Instance type of data nodes in the cluster.
        :param _builtins.bool multi_az_with_standby_enabled: Whether a multi-AZ domain is turned on with a standby AZ. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html).
        :param Sequence['DomainClusterConfigNodeOptionArgs'] node_options: List of node options for the domain.
        :param _builtins.int warm_count: Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
        :param _builtins.bool warm_enabled: Whether to enable warm storage.
        :param _builtins.str warm_type: Instance type for the OpenSearch cluster's warm nodes. Valid values are `ultrawarm1.medium.search`, `ultrawarm1.large.search` and `ultrawarm1.xlarge.search`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
        :param 'DomainClusterConfigZoneAwarenessConfigArgs' zone_awareness_config: Configuration block containing zone awareness settings. Detailed below.
        :param _builtins.bool zone_awareness_enabled: Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
        """
        if cold_storage_options is not None:
            pulumi.set(__self__, "cold_storage_options", cold_storage_options)
        if dedicated_master_count is not None:
            pulumi.set(__self__, "dedicated_master_count", dedicated_master_count)
        if dedicated_master_enabled is not None:
            pulumi.set(__self__, "dedicated_master_enabled", dedicated_master_enabled)
        if dedicated_master_type is not None:
            pulumi.set(__self__, "dedicated_master_type", dedicated_master_type)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if multi_az_with_standby_enabled is not None:
            pulumi.set(__self__, "multi_az_with_standby_enabled", multi_az_with_standby_enabled)
        if node_options is not None:
            pulumi.set(__self__, "node_options", node_options)
        if warm_count is not None:
            pulumi.set(__self__, "warm_count", warm_count)
        if warm_enabled is not None:
            pulumi.set(__self__, "warm_enabled", warm_enabled)
        if warm_type is not None:
            pulumi.set(__self__, "warm_type", warm_type)
        if zone_awareness_config is not None:
            pulumi.set(__self__, "zone_awareness_config", zone_awareness_config)
        if zone_awareness_enabled is not None:
            pulumi.set(__self__, "zone_awareness_enabled", zone_awareness_enabled)

    @_builtins.property
    @pulumi.getter(name="coldStorageOptions")
    def cold_storage_options(self) -> Optional['outputs.DomainClusterConfigColdStorageOptions']:
        """
        Configuration block containing cold storage configuration. Detailed below.
        """
        return pulumi.get(self, "cold_storage_options")

    @_builtins.property
    @pulumi.getter(name="dedicatedMasterCount")
    def dedicated_master_count(self) -> Optional[_builtins.int]:
        """
        Number of dedicated main nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_count")

    @_builtins.property
    @pulumi.getter(name="dedicatedMasterEnabled")
    def dedicated_master_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether dedicated main nodes are enabled for the cluster.
        """
        return pulumi.get(self, "dedicated_master_enabled")

    @_builtins.property
    @pulumi.getter(name="dedicatedMasterType")
    def dedicated_master_type(self) -> Optional[_builtins.str]:
        """
        Instance type of the dedicated main nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_type")

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[_builtins.int]:
        """
        Number of instances in the cluster.
        """
        return pulumi.get(self, "instance_count")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[_builtins.str]:
        """
        Instance type of data nodes in the cluster.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="multiAzWithStandbyEnabled")
    def multi_az_with_standby_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether a multi-AZ domain is turned on with a standby AZ. For more information, see [Configuring a multi-AZ domain in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html).
        """
        return pulumi.get(self, "multi_az_with_standby_enabled")

    @_builtins.property
    @pulumi.getter(name="nodeOptions")
    def node_options(self) -> Optional[Sequence['outputs.DomainClusterConfigNodeOption']]:
        """
        List of node options for the domain.
        """
        return pulumi.get(self, "node_options")

    @_builtins.property
    @pulumi.getter(name="warmCount")
    def warm_count(self) -> Optional[_builtins.int]:
        """
        Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
        """
        return pulumi.get(self, "warm_count")

    @_builtins.property
    @pulumi.getter(name="warmEnabled")
    def warm_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable warm storage.
        """
        return pulumi.get(self, "warm_enabled")

    @_builtins.property
    @pulumi.getter(name="warmType")
    def warm_type(self) -> Optional[_builtins.str]:
        """
        Instance type for the OpenSearch cluster's warm nodes. Valid values are `ultrawarm1.medium.search`, `ultrawarm1.large.search` and `ultrawarm1.xlarge.search`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
        """
        return pulumi.get(self, "warm_type")

    @_builtins.property
    @pulumi.getter(name="zoneAwarenessConfig")
    def zone_awareness_config(self) -> Optional['outputs.DomainClusterConfigZoneAwarenessConfig']:
        """
        Configuration block containing zone awareness settings. Detailed below.
        """
        return pulumi.get(self, "zone_awareness_config")

    @_builtins.property
    @pulumi.getter(name="zoneAwarenessEnabled")
    def zone_awareness_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
        """
        return pulumi.get(self, "zone_awareness_enabled")


@pulumi.output_type
class DomainClusterConfigColdStorageOptions(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: Boolean to enable cold storage for an OpenSearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Boolean to enable cold storage for an OpenSearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DomainClusterConfigNodeOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeConfig":
            suggest = "node_config"
        elif key == "nodeType":
            suggest = "node_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainClusterConfigNodeOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainClusterConfigNodeOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainClusterConfigNodeOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_config: Optional['outputs.DomainClusterConfigNodeOptionNodeConfig'] = None,
                 node_type: Optional[_builtins.str] = None):
        """
        :param 'DomainClusterConfigNodeOptionNodeConfigArgs' node_config: Container to specify sizing of a node type.
        :param _builtins.str node_type: Type of node this configuration describes. Valid values: `coordinator`.
        """
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)

    @_builtins.property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional['outputs.DomainClusterConfigNodeOptionNodeConfig']:
        """
        Container to specify sizing of a node type.
        """
        return pulumi.get(self, "node_config")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[_builtins.str]:
        """
        Type of node this configuration describes. Valid values: `coordinator`.
        """
        return pulumi.get(self, "node_type")


@pulumi.output_type
class DomainClusterConfigNodeOptionNodeConfig(dict):
    def __init__(__self__, *,
                 count: Optional[_builtins.int] = None,
                 enabled: Optional[_builtins.bool] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int count: Number of nodes of a particular node type in the cluster.
        :param _builtins.bool enabled: Whether a particular node type is enabled.
        :param _builtins.str type: The instance type of a particular node type in the cluster.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def count(self) -> Optional[_builtins.int]:
        """
        Number of nodes of a particular node type in the cluster.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether a particular node type is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The instance type of a particular node type in the cluster.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DomainClusterConfigZoneAwarenessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZoneCount":
            suggest = "availability_zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainClusterConfigZoneAwarenessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainClusterConfigZoneAwarenessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainClusterConfigZoneAwarenessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone_count: Optional[_builtins.int] = None):
        """
        :param _builtins.int availability_zone_count: Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
        """
        if availability_zone_count is not None:
            pulumi.set(__self__, "availability_zone_count", availability_zone_count)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneCount")
    def availability_zone_count(self) -> Optional[_builtins.int]:
        """
        Number of Availability Zones for the domain to use with `zone_awareness_enabled`. Defaults to `2`. Valid values: `2` or `3`.
        """
        return pulumi.get(self, "availability_zone_count")


@pulumi.output_type
class DomainCognitoOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityPoolId":
            suggest = "identity_pool_id"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "userPoolId":
            suggest = "user_pool_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainCognitoOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainCognitoOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainCognitoOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_pool_id: _builtins.str,
                 role_arn: _builtins.str,
                 user_pool_id: _builtins.str,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str identity_pool_id: ID of the Cognito Identity Pool to use.
        :param _builtins.str role_arn: ARN of the IAM role that has the AmazonOpenSearchServiceCognitoAccess policy attached.
        :param _builtins.str user_pool_id: ID of the Cognito User Pool to use.
        :param _builtins.bool enabled: Whether Amazon Cognito authentication with Dashboard is enabled or not. Default is `false`.
        """
        pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> _builtins.str:
        """
        ID of the Cognito Identity Pool to use.
        """
        return pulumi.get(self, "identity_pool_id")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        ARN of the IAM role that has the AmazonOpenSearchServiceCognitoAccess policy attached.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> _builtins.str:
        """
        ID of the Cognito User Pool to use.
        """
        return pulumi.get(self, "user_pool_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether Amazon Cognito authentication with Dashboard is enabled or not. Default is `false`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DomainDomainEndpointOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customEndpoint":
            suggest = "custom_endpoint"
        elif key == "customEndpointCertificateArn":
            suggest = "custom_endpoint_certificate_arn"
        elif key == "customEndpointEnabled":
            suggest = "custom_endpoint_enabled"
        elif key == "enforceHttps":
            suggest = "enforce_https"
        elif key == "tlsSecurityPolicy":
            suggest = "tls_security_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainDomainEndpointOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainDomainEndpointOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainDomainEndpointOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_endpoint: Optional[_builtins.str] = None,
                 custom_endpoint_certificate_arn: Optional[_builtins.str] = None,
                 custom_endpoint_enabled: Optional[_builtins.bool] = None,
                 enforce_https: Optional[_builtins.bool] = None,
                 tls_security_policy: Optional[_builtins.str] = None):
        """
        :param _builtins.str custom_endpoint: Fully qualified domain for your custom endpoint.
        :param _builtins.str custom_endpoint_certificate_arn: ACM certificate ARN for your custom endpoint.
        :param _builtins.bool custom_endpoint_enabled: Whether to enable custom endpoint for the OpenSearch domain.
        :param _builtins.bool enforce_https: Whether or not to require HTTPS. Defaults to `true`.
        :param _builtins.str tls_security_policy: Name of the TLS security policy that needs to be applied to the HTTPS endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DomainEndpointOptions.html#opensearchservice-Type-DomainEndpointOptions-TLSSecurityPolicy). Pulumi will only perform drift detection if a configuration value is provided.
        """
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if custom_endpoint_certificate_arn is not None:
            pulumi.set(__self__, "custom_endpoint_certificate_arn", custom_endpoint_certificate_arn)
        if custom_endpoint_enabled is not None:
            pulumi.set(__self__, "custom_endpoint_enabled", custom_endpoint_enabled)
        if enforce_https is not None:
            pulumi.set(__self__, "enforce_https", enforce_https)
        if tls_security_policy is not None:
            pulumi.set(__self__, "tls_security_policy", tls_security_policy)

    @_builtins.property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[_builtins.str]:
        """
        Fully qualified domain for your custom endpoint.
        """
        return pulumi.get(self, "custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="customEndpointCertificateArn")
    def custom_endpoint_certificate_arn(self) -> Optional[_builtins.str]:
        """
        ACM certificate ARN for your custom endpoint.
        """
        return pulumi.get(self, "custom_endpoint_certificate_arn")

    @_builtins.property
    @pulumi.getter(name="customEndpointEnabled")
    def custom_endpoint_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable custom endpoint for the OpenSearch domain.
        """
        return pulumi.get(self, "custom_endpoint_enabled")

    @_builtins.property
    @pulumi.getter(name="enforceHttps")
    def enforce_https(self) -> Optional[_builtins.bool]:
        """
        Whether or not to require HTTPS. Defaults to `true`.
        """
        return pulumi.get(self, "enforce_https")

    @_builtins.property
    @pulumi.getter(name="tlsSecurityPolicy")
    def tls_security_policy(self) -> Optional[_builtins.str]:
        """
        Name of the TLS security policy that needs to be applied to the HTTPS endpoint. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_DomainEndpointOptions.html#opensearchservice-Type-DomainEndpointOptions-TLSSecurityPolicy). Pulumi will only perform drift detection if a configuration value is provided.
        """
        return pulumi.get(self, "tls_security_policy")


@pulumi.output_type
class DomainEbsOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ebsEnabled":
            suggest = "ebs_enabled"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainEbsOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainEbsOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainEbsOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ebs_enabled: _builtins.bool,
                 iops: Optional[_builtins.int] = None,
                 throughput: Optional[_builtins.int] = None,
                 volume_size: Optional[_builtins.int] = None,
                 volume_type: Optional[_builtins.str] = None):
        """
        :param _builtins.bool ebs_enabled: Whether EBS volumes are attached to data nodes in the domain.
        :param _builtins.int iops: Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
        :param _builtins.int throughput: Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
        :param _builtins.int volume_size: Size of EBS volumes attached to data nodes (in GiB).
        :param _builtins.str volume_type: Type of EBS volumes attached to data nodes.
        """
        pulumi.set(__self__, "ebs_enabled", ebs_enabled)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="ebsEnabled")
    def ebs_enabled(self) -> _builtins.bool:
        """
        Whether EBS volumes are attached to data nodes in the domain.
        """
        return pulumi.get(self, "ebs_enabled")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[_builtins.int]:
        """
        Baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the GP3 and Provisioned IOPS EBS volume types.
        """
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[_builtins.int]:
        """
        Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the gp3 volume type.
        """
        return pulumi.get(self, "throughput")

    @_builtins.property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[_builtins.int]:
        """
        Size of EBS volumes attached to data nodes (in GiB).
        """
        return pulumi.get(self, "volume_size")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[_builtins.str]:
        """
        Type of EBS volumes attached to data nodes.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class DomainEncryptAtRest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainEncryptAtRest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainEncryptAtRest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainEncryptAtRest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 kms_key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Whether to enable encryption at rest. If the `encrypt_at_rest` block is not provided then this defaults to `false`. Enabling encryption on new domains requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_5.1` or greater.
        :param _builtins.str kms_key_id: KMS key ARN to encrypt the Elasticsearch domain with. If not specified then it defaults to using the `aws/es` service KMS key. Note that KMS will accept a KMS key ID but will return the key ARN. To prevent the provider detecting unwanted changes, use the key ARN instead.
        """
        pulumi.set(__self__, "enabled", enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether to enable encryption at rest. If the `encrypt_at_rest` block is not provided then this defaults to `false`. Enabling encryption on new domains requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_5.1` or greater.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        KMS key ARN to encrypt the Elasticsearch domain with. If not specified then it defaults to using the `aws/es` service KMS key. Note that KMS will accept a KMS key ID but will return the key ARN. To prevent the provider detecting unwanted changes, use the key ARN instead.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class DomainLogPublishingOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogGroupArn":
            suggest = "cloudwatch_log_group_arn"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainLogPublishingOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainLogPublishingOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainLogPublishingOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_log_group_arn: _builtins.str,
                 log_type: _builtins.str,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str cloudwatch_log_group_arn: ARN of the Cloudwatch log group to which log needs to be published.
        :param _builtins.str log_type: Type of OpenSearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
        :param _builtins.bool enabled: Whether given log publishing option is enabled or not.
        """
        pulumi.set(__self__, "cloudwatch_log_group_arn", cloudwatch_log_group_arn)
        pulumi.set(__self__, "log_type", log_type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> _builtins.str:
        """
        ARN of the Cloudwatch log group to which log needs to be published.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @_builtins.property
    @pulumi.getter(name="logType")
    def log_type(self) -> _builtins.str:
        """
        Type of OpenSearch log. Valid values: `INDEX_SLOW_LOGS`, `SEARCH_SLOW_LOGS`, `ES_APPLICATION_LOGS`, `AUDIT_LOGS`.
        """
        return pulumi.get(self, "log_type")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether given log publishing option is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DomainNodeToNodeEncryption(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_6.0` or greater.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether to enable node-to-node encryption. If the `node_to_node_encryption` block is not provided then this defaults to `false`. Enabling node-to-node encryption of a new domain requires an `engine_version` of `OpenSearch_X.Y` or `Elasticsearch_6.0` or greater.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DomainOffPeakWindowOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "offPeakWindow":
            suggest = "off_peak_window"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainOffPeakWindowOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainOffPeakWindowOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainOffPeakWindowOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 off_peak_window: Optional['outputs.DomainOffPeakWindowOptionsOffPeakWindow'] = None):
        """
        :param _builtins.bool enabled: Enabled disabled toggle for off-peak update window.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if off_peak_window is not None:
            pulumi.set(__self__, "off_peak_window", off_peak_window)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enabled disabled toggle for off-peak update window.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="offPeakWindow")
    def off_peak_window(self) -> Optional['outputs.DomainOffPeakWindowOptionsOffPeakWindow']:
        return pulumi.get(self, "off_peak_window")


@pulumi.output_type
class DomainOffPeakWindowOptionsOffPeakWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "windowStartTime":
            suggest = "window_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainOffPeakWindowOptionsOffPeakWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainOffPeakWindowOptionsOffPeakWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainOffPeakWindowOptionsOffPeakWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 window_start_time: Optional['outputs.DomainOffPeakWindowOptionsOffPeakWindowWindowStartTime'] = None):
        """
        :param 'DomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs' window_start_time: 10h window for updates
        """
        if window_start_time is not None:
            pulumi.set(__self__, "window_start_time", window_start_time)

    @_builtins.property
    @pulumi.getter(name="windowStartTime")
    def window_start_time(self) -> Optional['outputs.DomainOffPeakWindowOptionsOffPeakWindowWindowStartTime']:
        """
        10h window for updates
        """
        return pulumi.get(self, "window_start_time")


@pulumi.output_type
class DomainOffPeakWindowOptionsOffPeakWindowWindowStartTime(dict):
    def __init__(__self__, *,
                 hours: Optional[_builtins.int] = None,
                 minutes: Optional[_builtins.int] = None):
        """
        :param _builtins.int hours: Starting hour of the 10-hour window for updates
        :param _builtins.int minutes: Starting minute of the 10-hour window for updates
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> Optional[_builtins.int]:
        """
        Starting hour of the 10-hour window for updates
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> Optional[_builtins.int]:
        """
        Starting minute of the 10-hour window for updates
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class DomainSamlOptionsSamlOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterBackendRole":
            suggest = "master_backend_role"
        elif key == "masterUserName":
            suggest = "master_user_name"
        elif key == "rolesKey":
            suggest = "roles_key"
        elif key == "sessionTimeoutMinutes":
            suggest = "session_timeout_minutes"
        elif key == "subjectKey":
            suggest = "subject_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSamlOptionsSamlOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSamlOptionsSamlOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSamlOptionsSamlOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 idp: Optional['outputs.DomainSamlOptionsSamlOptionsIdp'] = None,
                 master_backend_role: Optional[_builtins.str] = None,
                 master_user_name: Optional[_builtins.str] = None,
                 roles_key: Optional[_builtins.str] = None,
                 session_timeout_minutes: Optional[_builtins.int] = None,
                 subject_key: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Whether SAML authentication is enabled.
        :param 'DomainSamlOptionsSamlOptionsIdpArgs' idp: Information from your identity provider.
        :param _builtins.str master_backend_role: This backend role from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        :param _builtins.str master_user_name: This username from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        :param _builtins.str roles_key: Element of the SAML assertion to use for backend roles. Default is roles.
        :param _builtins.int session_timeout_minutes: Duration of a session in minutes after a user logs in. Default is 60. Maximum value is 1,440.
        :param _builtins.str subject_key: Element of the SAML assertion to use for username. Default is NameID.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp is not None:
            pulumi.set(__self__, "idp", idp)
        if master_backend_role is not None:
            pulumi.set(__self__, "master_backend_role", master_backend_role)
        if master_user_name is not None:
            pulumi.set(__self__, "master_user_name", master_user_name)
        if roles_key is not None:
            pulumi.set(__self__, "roles_key", roles_key)
        if session_timeout_minutes is not None:
            pulumi.set(__self__, "session_timeout_minutes", session_timeout_minutes)
        if subject_key is not None:
            pulumi.set(__self__, "subject_key", subject_key)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether SAML authentication is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def idp(self) -> Optional['outputs.DomainSamlOptionsSamlOptionsIdp']:
        """
        Information from your identity provider.
        """
        return pulumi.get(self, "idp")

    @_builtins.property
    @pulumi.getter(name="masterBackendRole")
    def master_backend_role(self) -> Optional[_builtins.str]:
        """
        This backend role from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        return pulumi.get(self, "master_backend_role")

    @_builtins.property
    @pulumi.getter(name="masterUserName")
    def master_user_name(self) -> Optional[_builtins.str]:
        """
        This username from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
        """
        return pulumi.get(self, "master_user_name")

    @_builtins.property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> Optional[_builtins.str]:
        """
        Element of the SAML assertion to use for backend roles. Default is roles.
        """
        return pulumi.get(self, "roles_key")

    @_builtins.property
    @pulumi.getter(name="sessionTimeoutMinutes")
    def session_timeout_minutes(self) -> Optional[_builtins.int]:
        """
        Duration of a session in minutes after a user logs in. Default is 60. Maximum value is 1,440.
        """
        return pulumi.get(self, "session_timeout_minutes")

    @_builtins.property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> Optional[_builtins.str]:
        """
        Element of the SAML assertion to use for username. Default is NameID.
        """
        return pulumi.get(self, "subject_key")


@pulumi.output_type
class DomainSamlOptionsSamlOptionsIdp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityId":
            suggest = "entity_id"
        elif key == "metadataContent":
            suggest = "metadata_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSamlOptionsSamlOptionsIdp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSamlOptionsSamlOptionsIdp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSamlOptionsSamlOptionsIdp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_id: _builtins.str,
                 metadata_content: _builtins.str):
        """
        :param _builtins.str entity_id: Unique Entity ID of the application in SAML Identity Provider.
        :param _builtins.str metadata_content: Metadata of the SAML application in xml format.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "metadata_content", metadata_content)

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> _builtins.str:
        """
        Unique Entity ID of the application in SAML Identity Provider.
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="metadataContent")
    def metadata_content(self) -> _builtins.str:
        """
        Metadata of the SAML application in xml format.
        """
        return pulumi.get(self, "metadata_content")


@pulumi.output_type
class DomainSnapshotOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automatedSnapshotStartHour":
            suggest = "automated_snapshot_start_hour"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSnapshotOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSnapshotOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSnapshotOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automated_snapshot_start_hour: _builtins.int):
        """
        :param _builtins.int automated_snapshot_start_hour: Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        pulumi.set(__self__, "automated_snapshot_start_hour", automated_snapshot_start_hour)

    @_builtins.property
    @pulumi.getter(name="automatedSnapshotStartHour")
    def automated_snapshot_start_hour(self) -> _builtins.int:
        """
        Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        return pulumi.get(self, "automated_snapshot_start_hour")


@pulumi.output_type
class DomainSoftwareUpdateOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoSoftwareUpdateEnabled":
            suggest = "auto_software_update_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSoftwareUpdateOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSoftwareUpdateOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSoftwareUpdateOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_software_update_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool auto_software_update_enabled: Whether automatic service software updates are enabled for the domain. Defaults to `false`.
        """
        if auto_software_update_enabled is not None:
            pulumi.set(__self__, "auto_software_update_enabled", auto_software_update_enabled)

    @_builtins.property
    @pulumi.getter(name="autoSoftwareUpdateEnabled")
    def auto_software_update_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether automatic service software updates are enabled for the domain. Defaults to `false`.
        """
        return pulumi.get(self, "auto_software_update_enabled")


@pulumi.output_type
class DomainVpcOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZones":
            suggest = "availability_zones"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainVpcOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainVpcOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainVpcOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zones: Optional[Sequence[_builtins.str]] = None,
                 security_group_ids: Optional[Sequence[_builtins.str]] = None,
                 subnet_ids: Optional[Sequence[_builtins.str]] = None,
                 vpc_id: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] availability_zones: If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        :param Sequence[_builtins.str] security_group_ids: List of VPC Security Group IDs to be applied to the OpenSearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
        :param Sequence[_builtins.str] subnet_ids: List of VPC Subnet IDs for the OpenSearch domain endpoints to be created in.
        :param _builtins.str vpc_id: If the domain was created inside a VPC, the ID of the VPC.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[Sequence[_builtins.str]]:
        """
        If the domain was created inside a VPC, the names of the availability zones the configured `subnet_ids` were created inside.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of VPC Security Group IDs to be applied to the OpenSearch domain endpoints. If omitted, the default Security Group for the VPC will be used.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of VPC Subnet IDs for the OpenSearch domain endpoints to be created in.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        If the domain was created inside a VPC, the ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class OutboundConnectionConnectionProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crossClusterSearch":
            suggest = "cross_cluster_search"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutboundConnectionConnectionProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutboundConnectionConnectionProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutboundConnectionConnectionProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cross_cluster_search: Optional['outputs.OutboundConnectionConnectionPropertiesCrossClusterSearch'] = None,
                 endpoint: Optional[_builtins.str] = None):
        """
        :param 'OutboundConnectionConnectionPropertiesCrossClusterSearchArgs' cross_cluster_search: Configuration block for cross cluster search.
        :param _builtins.str endpoint: The endpoint of the remote domain, is only set when `connection_mode` is `VPC_ENDPOINT` and `accept_connection` is `TRUE`.
        """
        if cross_cluster_search is not None:
            pulumi.set(__self__, "cross_cluster_search", cross_cluster_search)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)

    @_builtins.property
    @pulumi.getter(name="crossClusterSearch")
    def cross_cluster_search(self) -> Optional['outputs.OutboundConnectionConnectionPropertiesCrossClusterSearch']:
        """
        Configuration block for cross cluster search.
        """
        return pulumi.get(self, "cross_cluster_search")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[_builtins.str]:
        """
        The endpoint of the remote domain, is only set when `connection_mode` is `VPC_ENDPOINT` and `accept_connection` is `TRUE`.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class OutboundConnectionConnectionPropertiesCrossClusterSearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "skipUnavailable":
            suggest = "skip_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutboundConnectionConnectionPropertiesCrossClusterSearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutboundConnectionConnectionPropertiesCrossClusterSearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutboundConnectionConnectionPropertiesCrossClusterSearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 skip_unavailable: Optional[_builtins.str] = None):
        """
        :param _builtins.str skip_unavailable: Skips unavailable clusters and can only be used for cross-cluster searches. Accepted values are `ENABLED` or `DISABLED`.
        """
        if skip_unavailable is not None:
            pulumi.set(__self__, "skip_unavailable", skip_unavailable)

    @_builtins.property
    @pulumi.getter(name="skipUnavailable")
    def skip_unavailable(self) -> Optional[_builtins.str]:
        """
        Skips unavailable clusters and can only be used for cross-cluster searches. Accepted values are `ENABLED` or `DISABLED`.
        """
        return pulumi.get(self, "skip_unavailable")


@pulumi.output_type
class OutboundConnectionLocalDomainInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "ownerId":
            suggest = "owner_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutboundConnectionLocalDomainInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutboundConnectionLocalDomainInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutboundConnectionLocalDomainInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 owner_id: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str domain_name: The name of the local domain.
        :param _builtins.str owner_id: The Account ID of the owner of the local domain.
        :param _builtins.str region: The region of the local domain.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The name of the local domain.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.str:
        """
        The Account ID of the owner of the local domain.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region of the local domain.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class OutboundConnectionRemoteDomainInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "ownerId":
            suggest = "owner_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutboundConnectionRemoteDomainInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutboundConnectionRemoteDomainInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutboundConnectionRemoteDomainInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: _builtins.str,
                 owner_id: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str domain_name: The name of the remote domain.
        :param _builtins.str owner_id: The Account ID of the owner of the remote domain.
        :param _builtins.str region: The region of the remote domain.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The name of the remote domain.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.str:
        """
        The Account ID of the owner of the remote domain.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region of the remote domain.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class PackagePackageSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3Key":
            suggest = "s3_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagePackageSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagePackageSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagePackageSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket_name: _builtins.str,
                 s3_key: _builtins.str):
        """
        :param _builtins.str s3_bucket_name: The name of the Amazon S3 bucket containing the package.
        :param _builtins.str s3_key: Key (file name) of the package.
        """
        pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        pulumi.set(__self__, "s3_key", s3_key)

    @_builtins.property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> _builtins.str:
        """
        The name of the Amazon S3 bucket containing the package.
        """
        return pulumi.get(self, "s3_bucket_name")

    @_builtins.property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> _builtins.str:
        """
        Key (file name) of the package.
        """
        return pulumi.get(self, "s3_key")


@pulumi.output_type
class ServerlessCollectionTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class ServerlessSecurityConfigSamlOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupAttribute":
            suggest = "group_attribute"
        elif key == "sessionTimeout":
            suggest = "session_timeout"
        elif key == "userAttribute":
            suggest = "user_attribute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessSecurityConfigSamlOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessSecurityConfigSamlOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessSecurityConfigSamlOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata: _builtins.str,
                 group_attribute: Optional[_builtins.str] = None,
                 session_timeout: Optional[_builtins.int] = None,
                 user_attribute: Optional[_builtins.str] = None):
        """
        :param _builtins.str metadata: The XML IdP metadata file generated from your identity provider.
        :param _builtins.str group_attribute: Group attribute for this SAML integration.
        :param _builtins.int session_timeout: Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
        :param _builtins.str user_attribute: User attribute for this SAML integration.
        """
        pulumi.set(__self__, "metadata", metadata)
        if group_attribute is not None:
            pulumi.set(__self__, "group_attribute", group_attribute)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)
        if user_attribute is not None:
            pulumi.set(__self__, "user_attribute", user_attribute)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> _builtins.str:
        """
        The XML IdP metadata file generated from your identity provider.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="groupAttribute")
    def group_attribute(self) -> Optional[_builtins.str]:
        """
        Group attribute for this SAML integration.
        """
        return pulumi.get(self, "group_attribute")

    @_builtins.property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[_builtins.int]:
        """
        Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
        """
        return pulumi.get(self, "session_timeout")

    @_builtins.property
    @pulumi.getter(name="userAttribute")
    def user_attribute(self) -> Optional[_builtins.str]:
        """
        User attribute for this SAML integration.
        """
        return pulumi.get(self, "user_attribute")


@pulumi.output_type
class ServerlessVpcEndpointTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class VpcEndpointVpcOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "availabilityZones":
            suggest = "availability_zones"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpcEndpointVpcOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpcEndpointVpcOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpcEndpointVpcOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[_builtins.str],
                 availability_zones: Optional[Sequence[_builtins.str]] = None,
                 security_group_ids: Optional[Sequence[_builtins.str]] = None,
                 vpc_id: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] subnet_ids: A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
        :param Sequence[_builtins.str] security_group_ids: The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, OpenSearch Service uses the default security group for the VPC.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[_builtins.str]:
        """
        A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, OpenSearch Service uses the default security group for the VPC.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetDomainAdvancedSecurityOptionResult(dict):
    def __init__(__self__, *,
                 anonymous_auth_enabled: _builtins.bool,
                 enabled: _builtins.bool,
                 internal_user_database_enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Enabled disabled toggle for off-peak update window
        :param _builtins.bool internal_user_database_enabled: Whether the internal user database is enabled.
        """
        pulumi.set(__self__, "anonymous_auth_enabled", anonymous_auth_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "internal_user_database_enabled", internal_user_database_enabled)

    @_builtins.property
    @pulumi.getter(name="anonymousAuthEnabled")
    def anonymous_auth_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "anonymous_auth_enabled")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enabled disabled toggle for off-peak update window
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="internalUserDatabaseEnabled")
    def internal_user_database_enabled(self) -> _builtins.bool:
        """
        Whether the internal user database is enabled.
        """
        return pulumi.get(self, "internal_user_database_enabled")


@pulumi.output_type
class GetDomainAutoTuneOptionResult(dict):
    def __init__(__self__, *,
                 desired_state: _builtins.str,
                 maintenance_schedules: Sequence['outputs.GetDomainAutoTuneOptionMaintenanceScheduleResult'],
                 rollback_on_disable: _builtins.str,
                 use_off_peak_window: _builtins.bool):
        """
        :param _builtins.str desired_state: Auto-Tune desired state for the domain.
        :param Sequence['GetDomainAutoTuneOptionMaintenanceScheduleArgs'] maintenance_schedules: A list of the nested configurations for the Auto-Tune maintenance windows of the domain.
        :param _builtins.str rollback_on_disable: Whether the domain is set to roll back to default Auto-Tune settings when disabling Auto-Tune.
        :param _builtins.bool use_off_peak_window: Whether to schedule Auto-Tune optimizations that require blue/green deployments during the domain's configured daily off-peak window.
        """
        pulumi.set(__self__, "desired_state", desired_state)
        pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        pulumi.set(__self__, "rollback_on_disable", rollback_on_disable)
        pulumi.set(__self__, "use_off_peak_window", use_off_peak_window)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> _builtins.str:
        """
        Auto-Tune desired state for the domain.
        """
        return pulumi.get(self, "desired_state")

    @_builtins.property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Sequence['outputs.GetDomainAutoTuneOptionMaintenanceScheduleResult']:
        """
        A list of the nested configurations for the Auto-Tune maintenance windows of the domain.
        """
        return pulumi.get(self, "maintenance_schedules")

    @_builtins.property
    @pulumi.getter(name="rollbackOnDisable")
    def rollback_on_disable(self) -> _builtins.str:
        """
        Whether the domain is set to roll back to default Auto-Tune settings when disabling Auto-Tune.
        """
        return pulumi.get(self, "rollback_on_disable")

    @_builtins.property
    @pulumi.getter(name="useOffPeakWindow")
    def use_off_peak_window(self) -> _builtins.bool:
        """
        Whether to schedule Auto-Tune optimizations that require blue/green deployments during the domain's configured daily off-peak window.
        """
        return pulumi.get(self, "use_off_peak_window")


@pulumi.output_type
class GetDomainAutoTuneOptionMaintenanceScheduleResult(dict):
    def __init__(__self__, *,
                 cron_expression_for_recurrence: _builtins.str,
                 durations: Sequence['outputs.GetDomainAutoTuneOptionMaintenanceScheduleDurationResult'],
                 start_at: _builtins.str):
        """
        :param _builtins.str cron_expression_for_recurrence: Cron expression for an Auto-Tune maintenance schedule.
        :param Sequence['GetDomainAutoTuneOptionMaintenanceScheduleDurationArgs'] durations: Configuration block for the duration of the Auto-Tune maintenance window.
        :param _builtins.str start_at: Date and time at which the Auto-Tune maintenance schedule starts in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        pulumi.set(__self__, "cron_expression_for_recurrence", cron_expression_for_recurrence)
        pulumi.set(__self__, "durations", durations)
        pulumi.set(__self__, "start_at", start_at)

    @_builtins.property
    @pulumi.getter(name="cronExpressionForRecurrence")
    def cron_expression_for_recurrence(self) -> _builtins.str:
        """
        Cron expression for an Auto-Tune maintenance schedule.
        """
        return pulumi.get(self, "cron_expression_for_recurrence")

    @_builtins.property
    @pulumi.getter
    def durations(self) -> Sequence['outputs.GetDomainAutoTuneOptionMaintenanceScheduleDurationResult']:
        """
        Configuration block for the duration of the Auto-Tune maintenance window.
        """
        return pulumi.get(self, "durations")

    @_builtins.property
    @pulumi.getter(name="startAt")
    def start_at(self) -> _builtins.str:
        """
        Date and time at which the Auto-Tune maintenance schedule starts in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "start_at")


@pulumi.output_type
class GetDomainAutoTuneOptionMaintenanceScheduleDurationResult(dict):
    def __init__(__self__, *,
                 unit: _builtins.str,
                 value: _builtins.int):
        """
        :param _builtins.str unit: Unit of time.
        :param _builtins.int value: Duration of an Auto-Tune maintenance window.
        """
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        """
        Unit of time.
        """
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        """
        Duration of an Auto-Tune maintenance window.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDomainClusterConfigResult(dict):
    def __init__(__self__, *,
                 cold_storage_options: Sequence['outputs.GetDomainClusterConfigColdStorageOptionResult'],
                 dedicated_master_count: _builtins.int,
                 dedicated_master_enabled: _builtins.bool,
                 dedicated_master_type: _builtins.str,
                 instance_count: _builtins.int,
                 instance_type: _builtins.str,
                 multi_az_with_standby_enabled: _builtins.bool,
                 node_options: Sequence['outputs.GetDomainClusterConfigNodeOptionResult'],
                 warm_count: _builtins.int,
                 warm_type: _builtins.str,
                 zone_awareness_configs: Sequence['outputs.GetDomainClusterConfigZoneAwarenessConfigResult'],
                 zone_awareness_enabled: _builtins.bool,
                 warm_enabled: Optional[_builtins.bool] = None):
        """
        :param Sequence['GetDomainClusterConfigColdStorageOptionArgs'] cold_storage_options: Configuration block containing cold storage configuration.
        :param _builtins.int dedicated_master_count: Number of dedicated master nodes in the cluster.
        :param _builtins.bool dedicated_master_enabled: Indicates whether dedicated master nodes are enabled for the cluster.
        :param _builtins.str dedicated_master_type: Instance type of the dedicated master nodes in the cluster.
        :param _builtins.int instance_count: Number of instances in the cluster.
        :param _builtins.str instance_type: Instance type of data nodes in the cluster.
        :param _builtins.bool multi_az_with_standby_enabled: Whether a multi-AZ domain is turned on with a standby AZ.
        :param Sequence['GetDomainClusterConfigNodeOptionArgs'] node_options: List of node options for the domain.
        :param _builtins.int warm_count: Number of warm nodes in the cluster.
        :param _builtins.str warm_type: Instance type for the OpenSearch cluster's warm nodes.
        :param Sequence['GetDomainClusterConfigZoneAwarenessConfigArgs'] zone_awareness_configs: Configuration block containing zone awareness settings.
        :param _builtins.bool zone_awareness_enabled: Indicates whether zone awareness is enabled.
        :param _builtins.bool warm_enabled: Warm storage is enabled.
        """
        pulumi.set(__self__, "cold_storage_options", cold_storage_options)
        pulumi.set(__self__, "dedicated_master_count", dedicated_master_count)
        pulumi.set(__self__, "dedicated_master_enabled", dedicated_master_enabled)
        pulumi.set(__self__, "dedicated_master_type", dedicated_master_type)
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "multi_az_with_standby_enabled", multi_az_with_standby_enabled)
        pulumi.set(__self__, "node_options", node_options)
        pulumi.set(__self__, "warm_count", warm_count)
        pulumi.set(__self__, "warm_type", warm_type)
        pulumi.set(__self__, "zone_awareness_configs", zone_awareness_configs)
        pulumi.set(__self__, "zone_awareness_enabled", zone_awareness_enabled)
        if warm_enabled is not None:
            pulumi.set(__self__, "warm_enabled", warm_enabled)

    @_builtins.property
    @pulumi.getter(name="coldStorageOptions")
    def cold_storage_options(self) -> Sequence['outputs.GetDomainClusterConfigColdStorageOptionResult']:
        """
        Configuration block containing cold storage configuration.
        """
        return pulumi.get(self, "cold_storage_options")

    @_builtins.property
    @pulumi.getter(name="dedicatedMasterCount")
    def dedicated_master_count(self) -> _builtins.int:
        """
        Number of dedicated master nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_count")

    @_builtins.property
    @pulumi.getter(name="dedicatedMasterEnabled")
    def dedicated_master_enabled(self) -> _builtins.bool:
        """
        Indicates whether dedicated master nodes are enabled for the cluster.
        """
        return pulumi.get(self, "dedicated_master_enabled")

    @_builtins.property
    @pulumi.getter(name="dedicatedMasterType")
    def dedicated_master_type(self) -> _builtins.str:
        """
        Instance type of the dedicated master nodes in the cluster.
        """
        return pulumi.get(self, "dedicated_master_type")

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> _builtins.int:
        """
        Number of instances in the cluster.
        """
        return pulumi.get(self, "instance_count")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        """
        Instance type of data nodes in the cluster.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="multiAzWithStandbyEnabled")
    def multi_az_with_standby_enabled(self) -> _builtins.bool:
        """
        Whether a multi-AZ domain is turned on with a standby AZ.
        """
        return pulumi.get(self, "multi_az_with_standby_enabled")

    @_builtins.property
    @pulumi.getter(name="nodeOptions")
    def node_options(self) -> Sequence['outputs.GetDomainClusterConfigNodeOptionResult']:
        """
        List of node options for the domain.
        """
        return pulumi.get(self, "node_options")

    @_builtins.property
    @pulumi.getter(name="warmCount")
    def warm_count(self) -> _builtins.int:
        """
        Number of warm nodes in the cluster.
        """
        return pulumi.get(self, "warm_count")

    @_builtins.property
    @pulumi.getter(name="warmType")
    def warm_type(self) -> _builtins.str:
        """
        Instance type for the OpenSearch cluster's warm nodes.
        """
        return pulumi.get(self, "warm_type")

    @_builtins.property
    @pulumi.getter(name="zoneAwarenessConfigs")
    def zone_awareness_configs(self) -> Sequence['outputs.GetDomainClusterConfigZoneAwarenessConfigResult']:
        """
        Configuration block containing zone awareness settings.
        """
        return pulumi.get(self, "zone_awareness_configs")

    @_builtins.property
    @pulumi.getter(name="zoneAwarenessEnabled")
    def zone_awareness_enabled(self) -> _builtins.bool:
        """
        Indicates whether zone awareness is enabled.
        """
        return pulumi.get(self, "zone_awareness_enabled")

    @_builtins.property
    @pulumi.getter(name="warmEnabled")
    def warm_enabled(self) -> Optional[_builtins.bool]:
        """
        Warm storage is enabled.
        """
        return pulumi.get(self, "warm_enabled")


@pulumi.output_type
class GetDomainClusterConfigColdStorageOptionResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Enabled disabled toggle for off-peak update window
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enabled disabled toggle for off-peak update window
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetDomainClusterConfigNodeOptionResult(dict):
    def __init__(__self__, *,
                 node_configs: Sequence['outputs.GetDomainClusterConfigNodeOptionNodeConfigResult'],
                 node_type: _builtins.str):
        """
        :param Sequence['GetDomainClusterConfigNodeOptionNodeConfigArgs'] node_configs: Sizing of a node type.
        :param _builtins.str node_type: Type of node this configuration describes.
        """
        pulumi.set(__self__, "node_configs", node_configs)
        pulumi.set(__self__, "node_type", node_type)

    @_builtins.property
    @pulumi.getter(name="nodeConfigs")
    def node_configs(self) -> Sequence['outputs.GetDomainClusterConfigNodeOptionNodeConfigResult']:
        """
        Sizing of a node type.
        """
        return pulumi.get(self, "node_configs")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> _builtins.str:
        """
        Type of node this configuration describes.
        """
        return pulumi.get(self, "node_type")


@pulumi.output_type
class GetDomainClusterConfigNodeOptionNodeConfigResult(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 enabled: _builtins.bool,
                 type: _builtins.str):
        """
        :param _builtins.int count: Number of nodes of a particular node type in the cluster.
        :param _builtins.bool enabled: Enabled disabled toggle for off-peak update window
        :param _builtins.str type: The instance type of a particular node type in the cluster.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        Number of nodes of a particular node type in the cluster.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enabled disabled toggle for off-peak update window
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The instance type of a particular node type in the cluster.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDomainClusterConfigZoneAwarenessConfigResult(dict):
    def __init__(__self__, *,
                 availability_zone_count: _builtins.int):
        """
        :param _builtins.int availability_zone_count: Number of availability zones used.
        """
        pulumi.set(__self__, "availability_zone_count", availability_zone_count)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneCount")
    def availability_zone_count(self) -> _builtins.int:
        """
        Number of availability zones used.
        """
        return pulumi.get(self, "availability_zone_count")


@pulumi.output_type
class GetDomainCognitoOptionResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 identity_pool_id: _builtins.str,
                 role_arn: _builtins.str,
                 user_pool_id: _builtins.str):
        """
        :param _builtins.bool enabled: Enabled disabled toggle for off-peak update window
        :param _builtins.str identity_pool_id: Cognito Identity pool used by the domain.
        :param _builtins.str role_arn: IAM Role with the AmazonOpenSearchServiceCognitoAccess policy attached.
        :param _builtins.str user_pool_id: Cognito User pool used by the domain.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "identity_pool_id", identity_pool_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "user_pool_id", user_pool_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enabled disabled toggle for off-peak update window
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="identityPoolId")
    def identity_pool_id(self) -> _builtins.str:
        """
        Cognito Identity pool used by the domain.
        """
        return pulumi.get(self, "identity_pool_id")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> _builtins.str:
        """
        IAM Role with the AmazonOpenSearchServiceCognitoAccess policy attached.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> _builtins.str:
        """
        Cognito User pool used by the domain.
        """
        return pulumi.get(self, "user_pool_id")


@pulumi.output_type
class GetDomainEbsOptionResult(dict):
    def __init__(__self__, *,
                 ebs_enabled: _builtins.bool,
                 iops: _builtins.int,
                 throughput: _builtins.int,
                 volume_size: _builtins.int,
                 volume_type: _builtins.str):
        """
        :param _builtins.bool ebs_enabled: Whether EBS volumes are attached to data nodes in the domain.
        :param _builtins.int iops: Baseline input/output (I/O) performance of EBS volumes attached to data nodes.
        :param _builtins.int throughput: The throughput (in MiB/s) of the EBS volumes attached to data nodes.
        :param _builtins.int volume_size: Size of EBS volumes attached to data nodes (in GB).
        :param _builtins.str volume_type: Type of EBS volumes attached to data nodes.
        """
        pulumi.set(__self__, "ebs_enabled", ebs_enabled)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "throughput", throughput)
        pulumi.set(__self__, "volume_size", volume_size)
        pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="ebsEnabled")
    def ebs_enabled(self) -> _builtins.bool:
        """
        Whether EBS volumes are attached to data nodes in the domain.
        """
        return pulumi.get(self, "ebs_enabled")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> _builtins.int:
        """
        Baseline input/output (I/O) performance of EBS volumes attached to data nodes.
        """
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> _builtins.int:
        """
        The throughput (in MiB/s) of the EBS volumes attached to data nodes.
        """
        return pulumi.get(self, "throughput")

    @_builtins.property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> _builtins.int:
        """
        Size of EBS volumes attached to data nodes (in GB).
        """
        return pulumi.get(self, "volume_size")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> _builtins.str:
        """
        Type of EBS volumes attached to data nodes.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class GetDomainEncryptionAtRestResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 kms_key_id: _builtins.str):
        """
        :param _builtins.bool enabled: Enabled disabled toggle for off-peak update window
        :param _builtins.str kms_key_id: KMS key id used to encrypt data at rest.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "kms_key_id", kms_key_id)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enabled disabled toggle for off-peak update window
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        KMS key id used to encrypt data at rest.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class GetDomainLogPublishingOptionResult(dict):
    def __init__(__self__, *,
                 cloudwatch_log_group_arn: _builtins.str,
                 enabled: _builtins.bool,
                 log_type: _builtins.str):
        """
        :param _builtins.str cloudwatch_log_group_arn: CloudWatch Log Group where the logs are published.
        :param _builtins.bool enabled: Enabled disabled toggle for off-peak update window
        :param _builtins.str log_type: Type of OpenSearch log being published.
        """
        pulumi.set(__self__, "cloudwatch_log_group_arn", cloudwatch_log_group_arn)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "log_type", log_type)

    @_builtins.property
    @pulumi.getter(name="cloudwatchLogGroupArn")
    def cloudwatch_log_group_arn(self) -> _builtins.str:
        """
        CloudWatch Log Group where the logs are published.
        """
        return pulumi.get(self, "cloudwatch_log_group_arn")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enabled disabled toggle for off-peak update window
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="logType")
    def log_type(self) -> _builtins.str:
        """
        Type of OpenSearch log being published.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GetDomainNodeToNodeEncryptionResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Enabled disabled toggle for off-peak update window
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enabled disabled toggle for off-peak update window
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetDomainOffPeakWindowOptionsResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 off_peak_windows: Sequence['outputs.GetDomainOffPeakWindowOptionsOffPeakWindowResult']):
        """
        :param _builtins.bool enabled: Enabled disabled toggle for off-peak update window
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "off_peak_windows", off_peak_windows)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enabled disabled toggle for off-peak update window
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="offPeakWindows")
    def off_peak_windows(self) -> Sequence['outputs.GetDomainOffPeakWindowOptionsOffPeakWindowResult']:
        return pulumi.get(self, "off_peak_windows")


@pulumi.output_type
class GetDomainOffPeakWindowOptionsOffPeakWindowResult(dict):
    def __init__(__self__, *,
                 window_start_times: Sequence['outputs.GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeResult']):
        """
        :param Sequence['GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeArgs'] window_start_times: 10h window for updates
        """
        pulumi.set(__self__, "window_start_times", window_start_times)

    @_builtins.property
    @pulumi.getter(name="windowStartTimes")
    def window_start_times(self) -> Sequence['outputs.GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeResult']:
        """
        10h window for updates
        """
        return pulumi.get(self, "window_start_times")


@pulumi.output_type
class GetDomainOffPeakWindowOptionsOffPeakWindowWindowStartTimeResult(dict):
    def __init__(__self__, *,
                 hours: _builtins.int,
                 minutes: _builtins.int):
        """
        :param _builtins.int hours: Starting hour of the 10-hour window for updates
        :param _builtins.int minutes: Starting minute of the 10-hour window for updates
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> _builtins.int:
        """
        Starting hour of the 10-hour window for updates
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> _builtins.int:
        """
        Starting minute of the 10-hour window for updates
        """
        return pulumi.get(self, "minutes")


@pulumi.output_type
class GetDomainSnapshotOptionResult(dict):
    def __init__(__self__, *,
                 automated_snapshot_start_hour: _builtins.int):
        """
        :param _builtins.int automated_snapshot_start_hour: Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        pulumi.set(__self__, "automated_snapshot_start_hour", automated_snapshot_start_hour)

    @_builtins.property
    @pulumi.getter(name="automatedSnapshotStartHour")
    def automated_snapshot_start_hour(self) -> _builtins.int:
        """
        Hour during which the service takes an automated daily snapshot of the indices in the domain.
        """
        return pulumi.get(self, "automated_snapshot_start_hour")


@pulumi.output_type
class GetDomainSoftwareUpdateOptionResult(dict):
    def __init__(__self__, *,
                 auto_software_update_enabled: _builtins.bool):
        """
        :param _builtins.bool auto_software_update_enabled: Enabled or disabled.
        """
        pulumi.set(__self__, "auto_software_update_enabled", auto_software_update_enabled)

    @_builtins.property
    @pulumi.getter(name="autoSoftwareUpdateEnabled")
    def auto_software_update_enabled(self) -> _builtins.bool:
        """
        Enabled or disabled.
        """
        return pulumi.get(self, "auto_software_update_enabled")


@pulumi.output_type
class GetDomainVpcOptionResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[_builtins.str],
                 security_group_ids: Sequence[_builtins.str],
                 subnet_ids: Sequence[_builtins.str],
                 vpc_id: _builtins.str):
        """
        :param Sequence[_builtins.str] availability_zones: Availability zones used by the domain.
        :param Sequence[_builtins.str] security_group_ids: Security groups used by the domain.
        :param Sequence[_builtins.str] subnet_ids: Subnets used by the domain.
        :param _builtins.str vpc_id: VPC used by the domain.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[_builtins.str]:
        """
        Availability zones used by the domain.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        Security groups used by the domain.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[_builtins.str]:
        """
        Subnets used by the domain.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        VPC used by the domain.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetServerlessSecurityConfigSamlOptionResult(dict):
    def __init__(__self__, *,
                 group_attribute: _builtins.str,
                 metadata: _builtins.str,
                 session_timeout: _builtins.int,
                 user_attribute: _builtins.str):
        """
        :param _builtins.str group_attribute: Group attribute for this SAML integration.
        :param _builtins.str metadata: The XML IdP metadata file generated from your identity provider.
        :param _builtins.int session_timeout: Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
        :param _builtins.str user_attribute: User attribute for this SAML integration.
        """
        pulumi.set(__self__, "group_attribute", group_attribute)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "session_timeout", session_timeout)
        pulumi.set(__self__, "user_attribute", user_attribute)

    @_builtins.property
    @pulumi.getter(name="groupAttribute")
    def group_attribute(self) -> _builtins.str:
        """
        Group attribute for this SAML integration.
        """
        return pulumi.get(self, "group_attribute")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> _builtins.str:
        """
        The XML IdP metadata file generated from your identity provider.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> _builtins.int:
        """
        Session timeout, in minutes. Minimum is 5 minutes and maximum is 720 minutes (12 hours). Default is 60 minutes.
        """
        return pulumi.get(self, "session_timeout")

    @_builtins.property
    @pulumi.getter(name="userAttribute")
    def user_attribute(self) -> _builtins.str:
        """
        User attribute for this SAML integration.
        """
        return pulumi.get(self, "user_attribute")


