# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'KeyKeyAttributeArgs',
    'KeyKeyAttributeArgsDict',
    'KeyKeyAttributeKeyModesOfUseArgs',
    'KeyKeyAttributeKeyModesOfUseArgsDict',
    'KeyTimeoutsArgs',
    'KeyTimeoutsArgsDict',
]

MYPY = False

if not MYPY:
    class KeyKeyAttributeArgsDict(TypedDict):
        key_algorithm: pulumi.Input[_builtins.str]
        """
        Key algorithm to be use during creation of an AWS Payment Cryptography key.
        """
        key_class: pulumi.Input[_builtins.str]
        """
        Type of AWS Payment Cryptography key to create.
        """
        key_usage: pulumi.Input[_builtins.str]
        """
        Cryptographic usage of an AWS Payment Cryptography key as defined in section A.5.2 of the TR-31 spec.
        """
        key_modes_of_uses: NotRequired[pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeKeyModesOfUseArgsDict']]]]
        """
        List of cryptographic operations that you can perform using the key.
        """
elif False:
    KeyKeyAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyKeyAttributeArgs:
    def __init__(__self__, *,
                 key_algorithm: pulumi.Input[_builtins.str],
                 key_class: pulumi.Input[_builtins.str],
                 key_usage: pulumi.Input[_builtins.str],
                 key_modes_of_uses: Optional[pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeKeyModesOfUseArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] key_algorithm: Key algorithm to be use during creation of an AWS Payment Cryptography key.
        :param pulumi.Input[_builtins.str] key_class: Type of AWS Payment Cryptography key to create.
        :param pulumi.Input[_builtins.str] key_usage: Cryptographic usage of an AWS Payment Cryptography key as defined in section A.5.2 of the TR-31 spec.
        :param pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeKeyModesOfUseArgs']]] key_modes_of_uses: List of cryptographic operations that you can perform using the key.
        """
        pulumi.set(__self__, "key_algorithm", key_algorithm)
        pulumi.set(__self__, "key_class", key_class)
        pulumi.set(__self__, "key_usage", key_usage)
        if key_modes_of_uses is not None:
            pulumi.set(__self__, "key_modes_of_uses", key_modes_of_uses)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        Key algorithm to be use during creation of an AWS Payment Cryptography key.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="keyClass")
    def key_class(self) -> pulumi.Input[_builtins.str]:
        """
        Type of AWS Payment Cryptography key to create.
        """
        return pulumi.get(self, "key_class")

    @key_class.setter
    def key_class(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_class", value)

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> pulumi.Input[_builtins.str]:
        """
        Cryptographic usage of an AWS Payment Cryptography key as defined in section A.5.2 of the TR-31 spec.
        """
        return pulumi.get(self, "key_usage")

    @key_usage.setter
    def key_usage(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_usage", value)

    @_builtins.property
    @pulumi.getter(name="keyModesOfUses")
    def key_modes_of_uses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeKeyModesOfUseArgs']]]]:
        """
        List of cryptographic operations that you can perform using the key.
        """
        return pulumi.get(self, "key_modes_of_uses")

    @key_modes_of_uses.setter
    def key_modes_of_uses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeKeyModesOfUseArgs']]]]):
        pulumi.set(self, "key_modes_of_uses", value)


if not MYPY:
    class KeyKeyAttributeKeyModesOfUseArgsDict(TypedDict):
        decrypt: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether an AWS Payment Cryptography key can be used to decrypt data.
        """
        derive_key: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether an AWS Payment Cryptography key can be used to derive new keys.
        """
        encrypt: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether an AWS Payment Cryptography key can be used to encrypt data.
        """
        generate: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
        """
        no_restrictions: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by KeyUsage.
        """
        sign: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether an AWS Payment Cryptography key can be used for signing.
        """
        unwrap: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether an AWS Payment Cryptography key can be used to unwrap other keys.
        """
        verify: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether an AWS Payment Cryptography key can be used to verify signatures.
        """
        wrap: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether an AWS Payment Cryptography key can be used to wrap other keys.
        """
elif False:
    KeyKeyAttributeKeyModesOfUseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyKeyAttributeKeyModesOfUseArgs:
    def __init__(__self__, *,
                 decrypt: Optional[pulumi.Input[_builtins.bool]] = None,
                 derive_key: Optional[pulumi.Input[_builtins.bool]] = None,
                 encrypt: Optional[pulumi.Input[_builtins.bool]] = None,
                 generate: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_restrictions: Optional[pulumi.Input[_builtins.bool]] = None,
                 sign: Optional[pulumi.Input[_builtins.bool]] = None,
                 unwrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 wrap: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] decrypt: Whether an AWS Payment Cryptography key can be used to decrypt data.
        :param pulumi.Input[_builtins.bool] derive_key: Whether an AWS Payment Cryptography key can be used to derive new keys.
        :param pulumi.Input[_builtins.bool] encrypt: Whether an AWS Payment Cryptography key can be used to encrypt data.
        :param pulumi.Input[_builtins.bool] generate: Whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
        :param pulumi.Input[_builtins.bool] no_restrictions: Whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by KeyUsage.
        :param pulumi.Input[_builtins.bool] sign: Whether an AWS Payment Cryptography key can be used for signing.
        :param pulumi.Input[_builtins.bool] unwrap: Whether an AWS Payment Cryptography key can be used to unwrap other keys.
        :param pulumi.Input[_builtins.bool] verify: Whether an AWS Payment Cryptography key can be used to verify signatures.
        :param pulumi.Input[_builtins.bool] wrap: Whether an AWS Payment Cryptography key can be used to wrap other keys.
        """
        if decrypt is not None:
            pulumi.set(__self__, "decrypt", decrypt)
        if derive_key is not None:
            pulumi.set(__self__, "derive_key", derive_key)
        if encrypt is not None:
            pulumi.set(__self__, "encrypt", encrypt)
        if generate is not None:
            pulumi.set(__self__, "generate", generate)
        if no_restrictions is not None:
            pulumi.set(__self__, "no_restrictions", no_restrictions)
        if sign is not None:
            pulumi.set(__self__, "sign", sign)
        if unwrap is not None:
            pulumi.set(__self__, "unwrap", unwrap)
        if verify is not None:
            pulumi.set(__self__, "verify", verify)
        if wrap is not None:
            pulumi.set(__self__, "wrap", wrap)

    @_builtins.property
    @pulumi.getter
    def decrypt(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an AWS Payment Cryptography key can be used to decrypt data.
        """
        return pulumi.get(self, "decrypt")

    @decrypt.setter
    def decrypt(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "decrypt", value)

    @_builtins.property
    @pulumi.getter(name="deriveKey")
    def derive_key(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an AWS Payment Cryptography key can be used to derive new keys.
        """
        return pulumi.get(self, "derive_key")

    @derive_key.setter
    def derive_key(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "derive_key", value)

    @_builtins.property
    @pulumi.getter
    def encrypt(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an AWS Payment Cryptography key can be used to encrypt data.
        """
        return pulumi.get(self, "encrypt")

    @encrypt.setter
    def encrypt(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypt", value)

    @_builtins.property
    @pulumi.getter
    def generate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
        """
        return pulumi.get(self, "generate")

    @generate.setter
    def generate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "generate", value)

    @_builtins.property
    @pulumi.getter(name="noRestrictions")
    def no_restrictions(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by KeyUsage.
        """
        return pulumi.get(self, "no_restrictions")

    @no_restrictions.setter
    def no_restrictions(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_restrictions", value)

    @_builtins.property
    @pulumi.getter
    def sign(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an AWS Payment Cryptography key can be used for signing.
        """
        return pulumi.get(self, "sign")

    @sign.setter
    def sign(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sign", value)

    @_builtins.property
    @pulumi.getter
    def unwrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an AWS Payment Cryptography key can be used to unwrap other keys.
        """
        return pulumi.get(self, "unwrap")

    @unwrap.setter
    def unwrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unwrap", value)

    @_builtins.property
    @pulumi.getter
    def verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an AWS Payment Cryptography key can be used to verify signatures.
        """
        return pulumi.get(self, "verify")

    @verify.setter
    def verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "verify", value)

    @_builtins.property
    @pulumi.getter
    def wrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether an AWS Payment Cryptography key can be used to wrap other keys.
        """
        return pulumi.get(self, "wrap")

    @wrap.setter
    def wrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wrap", value)


if not MYPY:
    class KeyTimeoutsArgsDict(TypedDict):
        create: NotRequired[pulumi.Input[_builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        delete: NotRequired[pulumi.Input[_builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        update: NotRequired[pulumi.Input[_builtins.str]]
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
elif False:
    KeyTimeoutsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KeyTimeoutsArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[_builtins.str]] = None,
                 delete: Optional[pulumi.Input[_builtins.str]] = None,
                 update: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param pulumi.Input[_builtins.str] delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param pulumi.Input[_builtins.str] update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create", value)

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete", value)

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update", value)


