# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KeyArgs', 'Key']

@pulumi.input_type
class KeyArgs:
    def __init__(__self__, *,
                 exportable: pulumi.Input[_builtins.bool],
                 deletion_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeArgs']]]] = None,
                 key_check_value_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['KeyTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a Key resource.
        :param pulumi.Input[_builtins.bool] exportable: Whether the key is exportable from the service.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable the key.
        :param pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeArgs']]] key_attributes: Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] key_check_value_algorithm: Algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "exportable", exportable)
        if deletion_window_in_days is not None:
            pulumi.set(__self__, "deletion_window_in_days", deletion_window_in_days)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if key_attributes is not None:
            pulumi.set(__self__, "key_attributes", key_attributes)
        if key_check_value_algorithm is not None:
            pulumi.set(__self__, "key_check_value_algorithm", key_check_value_algorithm)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def exportable(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the key is exportable from the service.
        """
        return pulumi.get(self, "exportable")

    @exportable.setter
    def exportable(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "exportable", value)

    @_builtins.property
    @pulumi.getter(name="deletionWindowInDays")
    def deletion_window_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "deletion_window_in_days")

    @deletion_window_in_days.setter
    def deletion_window_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deletion_window_in_days", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the key.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="keyAttributes")
    def key_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeArgs']]]]:
        """
        Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.

        The following arguments are optional:
        """
        return pulumi.get(self, "key_attributes")

    @key_attributes.setter
    def key_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeArgs']]]]):
        pulumi.set(self, "key_attributes", value)

    @_builtins.property
    @pulumi.getter(name="keyCheckValueAlgorithm")
    def key_check_value_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
        """
        return pulumi.get(self, "key_check_value_algorithm")

    @key_check_value_algorithm.setter
    def key_check_value_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_check_value_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['KeyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['KeyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _KeyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exportable: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeArgs']]]] = None,
                 key_check_value: Optional[pulumi.Input[_builtins.str]] = None,
                 key_check_value_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 key_origin: Optional[pulumi.Input[_builtins.str]] = None,
                 key_state: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['KeyTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering Key resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the key.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable the key.
        :param pulumi.Input[_builtins.bool] exportable: Whether the key is exportable from the service.
        :param pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeArgs']]] key_attributes: Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] key_check_value: Key check value (KCV) is used to check if all parties holding a given key have the same key or to detect that a key has changed.
        :param pulumi.Input[_builtins.str] key_check_value_algorithm: Algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
        :param pulumi.Input[_builtins.str] key_origin: Source of the key material.
        :param pulumi.Input[_builtins.str] key_state: State of key that is being created or deleted.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if deletion_window_in_days is not None:
            pulumi.set(__self__, "deletion_window_in_days", deletion_window_in_days)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if exportable is not None:
            pulumi.set(__self__, "exportable", exportable)
        if key_attributes is not None:
            pulumi.set(__self__, "key_attributes", key_attributes)
        if key_check_value is not None:
            pulumi.set(__self__, "key_check_value", key_check_value)
        if key_check_value_algorithm is not None:
            pulumi.set(__self__, "key_check_value_algorithm", key_check_value_algorithm)
        if key_origin is not None:
            pulumi.set(__self__, "key_origin", key_origin)
        if key_state is not None:
            pulumi.set(__self__, "key_state", key_state)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the key.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="deletionWindowInDays")
    def deletion_window_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "deletion_window_in_days")

    @deletion_window_in_days.setter
    def deletion_window_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deletion_window_in_days", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the key.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def exportable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the key is exportable from the service.
        """
        return pulumi.get(self, "exportable")

    @exportable.setter
    def exportable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exportable", value)

    @_builtins.property
    @pulumi.getter(name="keyAttributes")
    def key_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeArgs']]]]:
        """
        Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.

        The following arguments are optional:
        """
        return pulumi.get(self, "key_attributes")

    @key_attributes.setter
    def key_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyKeyAttributeArgs']]]]):
        pulumi.set(self, "key_attributes", value)

    @_builtins.property
    @pulumi.getter(name="keyCheckValue")
    def key_check_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Key check value (KCV) is used to check if all parties holding a given key have the same key or to detect that a key has changed.
        """
        return pulumi.get(self, "key_check_value")

    @key_check_value.setter
    def key_check_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_check_value", value)

    @_builtins.property
    @pulumi.getter(name="keyCheckValueAlgorithm")
    def key_check_value_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
        """
        return pulumi.get(self, "key_check_value_algorithm")

    @key_check_value_algorithm.setter
    def key_check_value_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_check_value_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="keyOrigin")
    def key_origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source of the key material.
        """
        return pulumi.get(self, "key_origin")

    @key_origin.setter
    def key_origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_origin", value)

    @_builtins.property
    @pulumi.getter(name="keyState")
    def key_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of key that is being created or deleted.
        """
        return pulumi.get(self, "key_state")

    @key_state.setter
    def key_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_state", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['KeyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['KeyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:paymentcryptography/key:Key")
class Key(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exportable: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyKeyAttributeArgs', 'KeyKeyAttributeArgsDict']]]]] = None,
                 key_check_value_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['KeyTimeoutsArgs', 'KeyTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Payment Cryptography Control Plane Key.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.paymentcryptography.Key("test",
            exportable=True,
            key_attributes=[{
                "key_algorithm": "TDES_3KEY",
                "key_class": "SYMMETRIC_KEY",
                "key_usage": "TR31_P0_PIN_ENCRYPTION_KEY",
                "key_modes_of_uses": [{
                    "decrypt": True,
                    "encrypt": True,
                    "wrap": True,
                    "unwrap": True,
                }],
            }])
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the Payment Cryptography key.

        Using `pulumi import`, import Payment Cryptography Control Plane Key using the `arn:aws:payment-cryptography:us-east-1:123456789012:key/qtbojf64yshyvyzf`. For example:

        console

        % pulumi import aws_paymentcryptography_key.example arn:aws:payment-cryptography:us-east-1:123456789012:key/qtbojf64yshyvyzf

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable the key.
        :param pulumi.Input[_builtins.bool] exportable: Whether the key is exportable from the service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyKeyAttributeArgs', 'KeyKeyAttributeArgsDict']]]] key_attributes: Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] key_check_value_algorithm: Algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Payment Cryptography Control Plane Key.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.paymentcryptography.Key("test",
            exportable=True,
            key_attributes=[{
                "key_algorithm": "TDES_3KEY",
                "key_class": "SYMMETRIC_KEY",
                "key_usage": "TR31_P0_PIN_ENCRYPTION_KEY",
                "key_modes_of_uses": [{
                    "decrypt": True,
                    "encrypt": True,
                    "wrap": True,
                    "unwrap": True,
                }],
            }])
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the Payment Cryptography key.

        Using `pulumi import`, import Payment Cryptography Control Plane Key using the `arn:aws:payment-cryptography:us-east-1:123456789012:key/qtbojf64yshyvyzf`. For example:

        console

        % pulumi import aws_paymentcryptography_key.example arn:aws:payment-cryptography:us-east-1:123456789012:key/qtbojf64yshyvyzf

        :param str resource_name: The name of the resource.
        :param KeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exportable: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyKeyAttributeArgs', 'KeyKeyAttributeArgsDict']]]]] = None,
                 key_check_value_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['KeyTimeoutsArgs', 'KeyTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyArgs.__new__(KeyArgs)

            __props__.__dict__["deletion_window_in_days"] = deletion_window_in_days
            __props__.__dict__["enabled"] = enabled
            if exportable is None and not opts.urn:
                raise TypeError("Missing required property 'exportable'")
            __props__.__dict__["exportable"] = exportable
            __props__.__dict__["key_attributes"] = key_attributes
            __props__.__dict__["key_check_value_algorithm"] = key_check_value_algorithm
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["key_check_value"] = None
            __props__.__dict__["key_origin"] = None
            __props__.__dict__["key_state"] = None
            __props__.__dict__["tags_all"] = None
        super(Key, __self__).__init__(
            'aws:paymentcryptography/key:Key',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_window_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            exportable: Optional[pulumi.Input[_builtins.bool]] = None,
            key_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyKeyAttributeArgs', 'KeyKeyAttributeArgsDict']]]]] = None,
            key_check_value: Optional[pulumi.Input[_builtins.str]] = None,
            key_check_value_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            key_origin: Optional[pulumi.Input[_builtins.str]] = None,
            key_state: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['KeyTimeoutsArgs', 'KeyTimeoutsArgsDict']]] = None) -> 'Key':
        """
        Get an existing Key resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the key.
        :param pulumi.Input[_builtins.bool] enabled: Whether to enable the key.
        :param pulumi.Input[_builtins.bool] exportable: Whether the key is exportable from the service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyKeyAttributeArgs', 'KeyKeyAttributeArgsDict']]]] key_attributes: Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] key_check_value: Key check value (KCV) is used to check if all parties holding a given key have the same key or to detect that a key has changed.
        :param pulumi.Input[_builtins.str] key_check_value_algorithm: Algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
        :param pulumi.Input[_builtins.str] key_origin: Source of the key material.
        :param pulumi.Input[_builtins.str] key_state: State of key that is being created or deleted.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyState.__new__(_KeyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["deletion_window_in_days"] = deletion_window_in_days
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["exportable"] = exportable
        __props__.__dict__["key_attributes"] = key_attributes
        __props__.__dict__["key_check_value"] = key_check_value
        __props__.__dict__["key_check_value_algorithm"] = key_check_value_algorithm
        __props__.__dict__["key_origin"] = key_origin
        __props__.__dict__["key_state"] = key_state
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return Key(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the key.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="deletionWindowInDays")
    def deletion_window_in_days(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "deletion_window_in_days")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to enable the key.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def exportable(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the key is exportable from the service.
        """
        return pulumi.get(self, "exportable")

    @_builtins.property
    @pulumi.getter(name="keyAttributes")
    def key_attributes(self) -> pulumi.Output[Optional[Sequence['outputs.KeyKeyAttribute']]]:
        """
        Role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.

        The following arguments are optional:
        """
        return pulumi.get(self, "key_attributes")

    @_builtins.property
    @pulumi.getter(name="keyCheckValue")
    def key_check_value(self) -> pulumi.Output[_builtins.str]:
        """
        Key check value (KCV) is used to check if all parties holding a given key have the same key or to detect that a key has changed.
        """
        return pulumi.get(self, "key_check_value")

    @_builtins.property
    @pulumi.getter(name="keyCheckValueAlgorithm")
    def key_check_value_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        Algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
        """
        return pulumi.get(self, "key_check_value_algorithm")

    @_builtins.property
    @pulumi.getter(name="keyOrigin")
    def key_origin(self) -> pulumi.Output[_builtins.str]:
        """
        Source of the key material.
        """
        return pulumi.get(self, "key_origin")

    @_builtins.property
    @pulumi.getter(name="keyState")
    def key_state(self) -> pulumi.Output[_builtins.str]:
        """
        State of key that is being created or deleted.
        """
        return pulumi.get(self, "key_state")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.KeyTimeouts']]:
        return pulumi.get(self, "timeouts")

