# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KeyAliasArgs', 'KeyAlias']

@pulumi.input_type
class KeyAliasArgs:
    def __init__(__self__, *,
                 alias_name: pulumi.Input[_builtins.str],
                 key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KeyAlias resource.
        :param pulumi.Input[_builtins.str] alias_name: Name of the Key Alias.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] key_arn: ARN of the key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "alias_name", alias_name)
        if key_arn is not None:
            pulumi.set(__self__, "key_arn", key_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Key Alias.

        The following arguments are optional:
        """
        return pulumi.get(self, "alias_name")

    @alias_name.setter
    def alias_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alias_name", value)

    @_builtins.property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the key.
        """
        return pulumi.get(self, "key_arn")

    @key_arn.setter
    def key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _KeyAliasState:
    def __init__(__self__, *,
                 alias_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KeyAlias resources.
        :param pulumi.Input[_builtins.str] alias_name: Name of the Key Alias.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] key_arn: ARN of the key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if alias_name is not None:
            pulumi.set(__self__, "alias_name", alias_name)
        if key_arn is not None:
            pulumi.set(__self__, "key_arn", key_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Key Alias.

        The following arguments are optional:
        """
        return pulumi.get(self, "alias_name")

    @alias_name.setter
    def alias_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias_name", value)

    @_builtins.property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the key.
        """
        return pulumi.get(self, "key_arn")

    @key_arn.setter
    def key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:paymentcryptography/keyAlias:KeyAlias")
class KeyAlias(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Payment Cryptography Control Plane Key Alias.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.paymentcryptography.Key("test",
            exportable=True,
            key_attributes=[{
                "key_algorithm": "TDES_3KEY",
                "key_class": "SYMMETRIC_KEY",
                "key_usage": "TR31_P0_PIN_ENCRYPTION_KEY",
                "key_modes_of_uses": [{
                    "decrypt": True,
                    "encrypt": True,
                    "wrap": True,
                    "unwrap": True,
                }],
            }])
        test_key_alias = aws.paymentcryptography.KeyAlias("test",
            alias_name="alias/test-alias",
            key_arn=test.arn)
        ```

        ## Import

        Using `pulumi import`, import Payment Cryptography Control Plane Key Alias using the `alias/4681482429376900170`. For example:

        ```sh
        $ pulumi import aws:paymentcryptography/keyAlias:KeyAlias example alias/4681482429376900170
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias_name: Name of the Key Alias.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] key_arn: ARN of the key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyAliasArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Payment Cryptography Control Plane Key Alias.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.paymentcryptography.Key("test",
            exportable=True,
            key_attributes=[{
                "key_algorithm": "TDES_3KEY",
                "key_class": "SYMMETRIC_KEY",
                "key_usage": "TR31_P0_PIN_ENCRYPTION_KEY",
                "key_modes_of_uses": [{
                    "decrypt": True,
                    "encrypt": True,
                    "wrap": True,
                    "unwrap": True,
                }],
            }])
        test_key_alias = aws.paymentcryptography.KeyAlias("test",
            alias_name="alias/test-alias",
            key_arn=test.arn)
        ```

        ## Import

        Using `pulumi import`, import Payment Cryptography Control Plane Key Alias using the `alias/4681482429376900170`. For example:

        ```sh
        $ pulumi import aws:paymentcryptography/keyAlias:KeyAlias example alias/4681482429376900170
        ```

        :param str resource_name: The name of the resource.
        :param KeyAliasArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyAliasArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyAliasArgs.__new__(KeyAliasArgs)

            if alias_name is None and not opts.urn:
                raise TypeError("Missing required property 'alias_name'")
            __props__.__dict__["alias_name"] = alias_name
            __props__.__dict__["key_arn"] = key_arn
            __props__.__dict__["region"] = region
        super(KeyAlias, __self__).__init__(
            'aws:paymentcryptography/keyAlias:KeyAlias',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_arn: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'KeyAlias':
        """
        Get an existing KeyAlias resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias_name: Name of the Key Alias.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] key_arn: ARN of the key.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyAliasState.__new__(_KeyAliasState)

        __props__.__dict__["alias_name"] = alias_name
        __props__.__dict__["key_arn"] = key_arn
        __props__.__dict__["region"] = region
        return KeyAlias(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aliasName")
    def alias_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Key Alias.

        The following arguments are optional:
        """
        return pulumi.get(self, "alias_name")

    @_builtins.property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the key.
        """
        return pulumi.get(self, "key_arn")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

