# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GcmChannelArgs', 'GcmChannel']

@pulumi.input_type
class GcmChannelArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[_builtins.str],
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 default_authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_json: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GcmChannel resource.
        :param pulumi.Input[_builtins.str] application_id: The application ID.
        :param pulumi.Input[_builtins.str] api_key: Platform credential API key from Google.
        :param pulumi.Input[_builtins.bool] enabled: Whether the channel is enabled or disabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "application_id", application_id)
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if default_authentication_method is not None:
            pulumi.set(__self__, "default_authentication_method", default_authentication_method)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_json is not None:
            pulumi.set(__self__, "service_json", service_json)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[_builtins.str]:
        """
        The application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Platform credential API key from Google.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="defaultAuthenticationMethod")
    def default_authentication_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "default_authentication_method")

    @default_authentication_method.setter
    def default_authentication_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_authentication_method", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the channel is enabled or disabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceJson")
    def service_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "service_json")

    @service_json.setter
    def service_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_json", value)


@pulumi.input_type
class _GcmChannelState:
    def __init__(__self__, *,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_json: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GcmChannel resources.
        :param pulumi.Input[_builtins.str] api_key: Platform credential API key from Google.
        :param pulumi.Input[_builtins.str] application_id: The application ID.
        :param pulumi.Input[_builtins.bool] enabled: Whether the channel is enabled or disabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if default_authentication_method is not None:
            pulumi.set(__self__, "default_authentication_method", default_authentication_method)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_json is not None:
            pulumi.set(__self__, "service_json", service_json)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Platform credential API key from Google.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_key", value)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application ID.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultAuthenticationMethod")
    def default_authentication_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "default_authentication_method")

    @default_authentication_method.setter
    def default_authentication_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_authentication_method", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the channel is enabled or disabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="serviceJson")
    def service_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "service_json")

    @service_json.setter
    def service_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_json", value)


@pulumi.type_token("aws:pinpoint/gcmChannel:GcmChannel")
class GcmChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_json: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Pinpoint GCM Channel resource.

        > **Note:** Credentials (Service Account JSON and API Key) will be stored in the raw state as plain-text.
        ## Import

        Using `pulumi import`, import Pinpoint GCM Channel using the `application-id`. For example:

        ```sh
        $ pulumi import aws:pinpoint/gcmChannel:GcmChannel gcm application-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: Platform credential API key from Google.
        :param pulumi.Input[_builtins.str] application_id: The application ID.
        :param pulumi.Input[_builtins.bool] enabled: Whether the channel is enabled or disabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GcmChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Pinpoint GCM Channel resource.

        > **Note:** Credentials (Service Account JSON and API Key) will be stored in the raw state as plain-text.
        ## Import

        Using `pulumi import`, import Pinpoint GCM Channel using the `application-id`. For example:

        ```sh
        $ pulumi import aws:pinpoint/gcmChannel:GcmChannel gcm application-id
        ```

        :param str resource_name: The name of the resource.
        :param GcmChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GcmChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[_builtins.str]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 service_json: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GcmChannelArgs.__new__(GcmChannelArgs)

            __props__.__dict__["api_key"] = None if api_key is None else pulumi.Output.secret(api_key)
            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["default_authentication_method"] = default_authentication_method
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["region"] = region
            __props__.__dict__["service_json"] = None if service_json is None else pulumi.Output.secret(service_json)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["apiKey", "serviceJson"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GcmChannel, __self__).__init__(
            'aws:pinpoint/gcmChannel:GcmChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key: Optional[pulumi.Input[_builtins.str]] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_authentication_method: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            service_json: Optional[pulumi.Input[_builtins.str]] = None) -> 'GcmChannel':
        """
        Get an existing GcmChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_key: Platform credential API key from Google.
        :param pulumi.Input[_builtins.str] application_id: The application ID.
        :param pulumi.Input[_builtins.bool] enabled: Whether the channel is enabled or disabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GcmChannelState.__new__(_GcmChannelState)

        __props__.__dict__["api_key"] = api_key
        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["default_authentication_method"] = default_authentication_method
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["region"] = region
        __props__.__dict__["service_json"] = service_json
        return GcmChannel(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Platform credential API key from Google.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        The application ID.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="defaultAuthenticationMethod")
    def default_authentication_method(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "default_authentication_method")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the channel is enabled or disabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="serviceJson")
    def service_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "service_json")

