# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipeArgs', 'Pipe']

@pulumi.input_type
class PipeArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[_builtins.str],
                 source: pulumi.Input[_builtins.str],
                 target: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 enrichment: Optional[pulumi.Input[_builtins.str]] = None,
                 enrichment_parameters: Optional[pulumi.Input['PipeEnrichmentParametersArgs']] = None,
                 kms_key_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 log_configuration: Optional[pulumi.Input['PipeLogConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_parameters: Optional[pulumi.Input['PipeSourceParametersArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_parameters: Optional[pulumi.Input['PipeTargetParametersArgs']] = None):
        """
        The set of arguments for constructing a Pipe resource.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the role that allows the pipe to send data to the target.
        :param pulumi.Input[_builtins.str] source: Source resource of the pipe. This field typically requires an ARN (Amazon Resource Name). However, when using a self-managed Kafka cluster, you should use a different format. Instead of an ARN, use 'smk://' followed by the bootstrap server's address.
        :param pulumi.Input[_builtins.str] target: Target resource of the pipe (typically an ARN).
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: A description of the pipe. At most 512 characters.
        :param pulumi.Input[_builtins.str] desired_state: The state the pipe should be in. One of: `RUNNING`, `STOPPED`.
        :param pulumi.Input[_builtins.str] enrichment: Enrichment resource of the pipe (typically an ARN). Read more about enrichment in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-enrichment).
        :param pulumi.Input['PipeEnrichmentParametersArgs'] enrichment_parameters: Parameters to configure enrichment for your pipe. Detailed below.
        :param pulumi.Input[_builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN. If not set, EventBridge uses an AWS owned key to encrypt pipe data.
        :param pulumi.Input['PipeLogConfigurationArgs'] log_configuration: Logging configuration settings for the pipe. Detailed below.
        :param pulumi.Input[_builtins.str] name: Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['PipeSourceParametersArgs'] source_parameters: Parameters to configure a source for the pipe. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['PipeTargetParametersArgs'] target_parameters: Parameters to configure a target for your pipe. Detailed below.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if enrichment is not None:
            pulumi.set(__self__, "enrichment", enrichment)
        if enrichment_parameters is not None:
            pulumi.set(__self__, "enrichment_parameters", enrichment_parameters)
        if kms_key_identifier is not None:
            pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_parameters is not None:
            pulumi.set(__self__, "source_parameters", source_parameters)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_parameters is not None:
            pulumi.set(__self__, "target_parameters", target_parameters)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the role that allows the pipe to send data to the target.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        Source resource of the pipe. This field typically requires an ARN (Amazon Resource Name). However, when using a self-managed Kafka cluster, you should use a different format. Instead of an ARN, use 'smk://' followed by the bootstrap server's address.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Input[_builtins.str]:
        """
        Target resource of the pipe (typically an ARN).

        The following arguments are optional:
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the pipe. At most 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state the pipe should be in. One of: `RUNNING`, `STOPPED`.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter
    def enrichment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enrichment resource of the pipe (typically an ARN). Read more about enrichment in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-enrichment).
        """
        return pulumi.get(self, "enrichment")

    @enrichment.setter
    def enrichment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enrichment", value)

    @_builtins.property
    @pulumi.getter(name="enrichmentParameters")
    def enrichment_parameters(self) -> Optional[pulumi.Input['PipeEnrichmentParametersArgs']]:
        """
        Parameters to configure enrichment for your pipe. Detailed below.
        """
        return pulumi.get(self, "enrichment_parameters")

    @enrichment_parameters.setter
    def enrichment_parameters(self, value: Optional[pulumi.Input['PipeEnrichmentParametersArgs']]):
        pulumi.set(self, "enrichment_parameters", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN. If not set, EventBridge uses an AWS owned key to encrypt pipe data.
        """
        return pulumi.get(self, "kms_key_identifier")

    @kms_key_identifier.setter
    def kms_key_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_identifier", value)

    @_builtins.property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional[pulumi.Input['PipeLogConfigurationArgs']]:
        """
        Logging configuration settings for the pipe. Detailed below.
        """
        return pulumi.get(self, "log_configuration")

    @log_configuration.setter
    def log_configuration(self, value: Optional[pulumi.Input['PipeLogConfigurationArgs']]):
        pulumi.set(self, "log_configuration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourceParameters")
    def source_parameters(self) -> Optional[pulumi.Input['PipeSourceParametersArgs']]:
        """
        Parameters to configure a source for the pipe. Detailed below.
        """
        return pulumi.get(self, "source_parameters")

    @source_parameters.setter
    def source_parameters(self, value: Optional[pulumi.Input['PipeSourceParametersArgs']]):
        pulumi.set(self, "source_parameters", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetParameters")
    def target_parameters(self) -> Optional[pulumi.Input['PipeTargetParametersArgs']]:
        """
        Parameters to configure a target for your pipe. Detailed below.
        """
        return pulumi.get(self, "target_parameters")

    @target_parameters.setter
    def target_parameters(self, value: Optional[pulumi.Input['PipeTargetParametersArgs']]):
        pulumi.set(self, "target_parameters", value)


@pulumi.input_type
class _PipeState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 enrichment: Optional[pulumi.Input[_builtins.str]] = None,
                 enrichment_parameters: Optional[pulumi.Input['PipeEnrichmentParametersArgs']] = None,
                 kms_key_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 log_configuration: Optional[pulumi.Input['PipeLogConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_parameters: Optional[pulumi.Input['PipeSourceParametersArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 target_parameters: Optional[pulumi.Input['PipeTargetParametersArgs']] = None):
        """
        Input properties used for looking up and filtering Pipe resources.
        :param pulumi.Input[_builtins.str] arn: ARN of this pipe.
        :param pulumi.Input[_builtins.str] description: A description of the pipe. At most 512 characters.
        :param pulumi.Input[_builtins.str] desired_state: The state the pipe should be in. One of: `RUNNING`, `STOPPED`.
        :param pulumi.Input[_builtins.str] enrichment: Enrichment resource of the pipe (typically an ARN). Read more about enrichment in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-enrichment).
        :param pulumi.Input['PipeEnrichmentParametersArgs'] enrichment_parameters: Parameters to configure enrichment for your pipe. Detailed below.
        :param pulumi.Input[_builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN. If not set, EventBridge uses an AWS owned key to encrypt pipe data.
        :param pulumi.Input['PipeLogConfigurationArgs'] log_configuration: Logging configuration settings for the pipe. Detailed below.
        :param pulumi.Input[_builtins.str] name: Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the role that allows the pipe to send data to the target.
        :param pulumi.Input[_builtins.str] source: Source resource of the pipe. This field typically requires an ARN (Amazon Resource Name). However, when using a self-managed Kafka cluster, you should use a different format. Instead of an ARN, use 'smk://' followed by the bootstrap server's address.
        :param pulumi.Input['PipeSourceParametersArgs'] source_parameters: Parameters to configure a source for the pipe. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] target: Target resource of the pipe (typically an ARN).
               
               The following arguments are optional:
        :param pulumi.Input['PipeTargetParametersArgs'] target_parameters: Parameters to configure a target for your pipe. Detailed below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if enrichment is not None:
            pulumi.set(__self__, "enrichment", enrichment)
        if enrichment_parameters is not None:
            pulumi.set(__self__, "enrichment_parameters", enrichment_parameters)
        if kms_key_identifier is not None:
            pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_parameters is not None:
            pulumi.set(__self__, "source_parameters", source_parameters)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if target_parameters is not None:
            pulumi.set(__self__, "target_parameters", target_parameters)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of this pipe.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the pipe. At most 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state the pipe should be in. One of: `RUNNING`, `STOPPED`.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter
    def enrichment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enrichment resource of the pipe (typically an ARN). Read more about enrichment in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-enrichment).
        """
        return pulumi.get(self, "enrichment")

    @enrichment.setter
    def enrichment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enrichment", value)

    @_builtins.property
    @pulumi.getter(name="enrichmentParameters")
    def enrichment_parameters(self) -> Optional[pulumi.Input['PipeEnrichmentParametersArgs']]:
        """
        Parameters to configure enrichment for your pipe. Detailed below.
        """
        return pulumi.get(self, "enrichment_parameters")

    @enrichment_parameters.setter
    def enrichment_parameters(self, value: Optional[pulumi.Input['PipeEnrichmentParametersArgs']]):
        pulumi.set(self, "enrichment_parameters", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN. If not set, EventBridge uses an AWS owned key to encrypt pipe data.
        """
        return pulumi.get(self, "kms_key_identifier")

    @kms_key_identifier.setter
    def kms_key_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_identifier", value)

    @_builtins.property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional[pulumi.Input['PipeLogConfigurationArgs']]:
        """
        Logging configuration settings for the pipe. Detailed below.
        """
        return pulumi.get(self, "log_configuration")

    @log_configuration.setter
    def log_configuration(self, value: Optional[pulumi.Input['PipeLogConfigurationArgs']]):
        pulumi.set(self, "log_configuration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the role that allows the pipe to send data to the target.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source resource of the pipe. This field typically requires an ARN (Amazon Resource Name). However, when using a self-managed Kafka cluster, you should use a different format. Instead of an ARN, use 'smk://' followed by the bootstrap server's address.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceParameters")
    def source_parameters(self) -> Optional[pulumi.Input['PipeSourceParametersArgs']]:
        """
        Parameters to configure a source for the pipe. Detailed below.
        """
        return pulumi.get(self, "source_parameters")

    @source_parameters.setter
    def source_parameters(self, value: Optional[pulumi.Input['PipeSourceParametersArgs']]):
        pulumi.set(self, "source_parameters", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target resource of the pipe (typically an ARN).

        The following arguments are optional:
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)

    @_builtins.property
    @pulumi.getter(name="targetParameters")
    def target_parameters(self) -> Optional[pulumi.Input['PipeTargetParametersArgs']]:
        """
        Parameters to configure a target for your pipe. Detailed below.
        """
        return pulumi.get(self, "target_parameters")

    @target_parameters.setter
    def target_parameters(self, value: Optional[pulumi.Input['PipeTargetParametersArgs']]):
        pulumi.set(self, "target_parameters", value)


@pulumi.type_token("aws:pipes/pipe:Pipe")
class Pipe(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 enrichment: Optional[pulumi.Input[_builtins.str]] = None,
                 enrichment_parameters: Optional[pulumi.Input[Union['PipeEnrichmentParametersArgs', 'PipeEnrichmentParametersArgsDict']]] = None,
                 kms_key_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 log_configuration: Optional[pulumi.Input[Union['PipeLogConfigurationArgs', 'PipeLogConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_parameters: Optional[pulumi.Input[Union['PipeSourceParametersArgs', 'PipeSourceParametersArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 target_parameters: Optional[pulumi.Input[Union['PipeTargetParametersArgs', 'PipeTargetParametersArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS EventBridge Pipes Pipe.

        You can find out more about EventBridge Pipes in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html).

        EventBridge Pipes are very configurable, and may require IAM permissions to work correctly. More information on the configuration options and IAM permissions can be found in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html).

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        main = aws.get_caller_identity()
        example = aws.iam.Role("example", assume_role_policy=json.dumps({
            "Version": "2012-10-17",
            "Statement": {
                "Effect": "Allow",
                "Action": "sts:AssumeRole",
                "Principal": {
                    "Service": "pipes.amazonaws.com",
                },
                "Condition": {
                    "StringEquals": {
                        "aws:SourceAccount": main.account_id,
                    },
                },
            },
        }))
        source_queue = aws.sqs.Queue("source")
        source = aws.iam.RolePolicy("source",
            role=example.id,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Action": [
                        "sqs:DeleteMessage",
                        "sqs:GetQueueAttributes",
                        "sqs:ReceiveMessage",
                    ],
                    "Resource": [source_queue.arn],
                }],
            }))
        target_queue = aws.sqs.Queue("target")
        target = aws.iam.RolePolicy("target",
            role=example.id,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Action": ["sqs:SendMessage"],
                    "Resource": [target_queue.arn],
                }],
            }))
        example_pipe = aws.pipes.Pipe("example",
            name="example-pipe",
            role_arn=example.arn,
            source=source_queue.arn,
            target=target_queue.arn,
            opts = pulumi.ResourceOptions(depends_on=[
                    source,
                    target,
                ]))
        ```

        ### Enrichment Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.pipes.Pipe("example",
            name="example-pipe",
            role_arn=example_aws_iam_role["arn"],
            source=source["arn"],
            target=target["arn"],
            enrichment=example_aws_cloudwatch_event_api_destination["arn"],
            enrichment_parameters={
                "http_parameters": {
                    "path_parameter_values": "example-path-param",
                    "header_parameters": {
                        "example-header": "example-value",
                        "second-example-header": "second-example-value",
                    },
                    "query_string_parameters": {
                        "example-query-string": "example-value",
                        "second-example-query-string": "second-example-value",
                    },
                },
            })
        ```

        ### Filter Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.pipes.Pipe("example",
            name="example-pipe",
            role_arn=example_aws_iam_role["arn"],
            source=source["arn"],
            target=target["arn"],
            source_parameters={
                "filter_criteria": {
                    "filters": [{
                        "pattern": json.dumps({
                            "source": ["event-source"],
                        }),
                    }],
                },
            })
        ```

        ### CloudWatch Logs Logging Configuration Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogGroup("example", name="example-pipe-target")
        example_pipe = aws.pipes.Pipe("example",
            name="example-pipe",
            role_arn=example_aws_iam_role["arn"],
            source=source_aws_sqs_queue["arn"],
            target=target_aws_sqs_queue["arn"],
            log_configuration={
                "include_execution_datas": ["ALL"],
                "level": "INFO",
                "cloudwatch_logs_log_destination": {
                    "log_group_arn": target_aws_cloudwatch_log_group["arn"],
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    source,
                    target,
                ]))
        ```

        ### SQS Source and Target Configuration Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.pipes.Pipe("example",
            name="example-pipe",
            role_arn=example_aws_iam_role["arn"],
            source=source["arn"],
            target=target["arn"],
            source_parameters={
                "sqs_queue_parameters": {
                    "batch_size": 1,
                    "maximum_batching_window_in_seconds": 2,
                },
            },
            target_parameters={
                "sqs_queue_parameters": {
                    "message_deduplication_id": "example-dedupe",
                    "message_group_id": "example-group",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import pipes using the `name`. For example:

        ```sh
        $ pulumi import aws:pipes/pipe:Pipe example my-pipe
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the pipe. At most 512 characters.
        :param pulumi.Input[_builtins.str] desired_state: The state the pipe should be in. One of: `RUNNING`, `STOPPED`.
        :param pulumi.Input[_builtins.str] enrichment: Enrichment resource of the pipe (typically an ARN). Read more about enrichment in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-enrichment).
        :param pulumi.Input[Union['PipeEnrichmentParametersArgs', 'PipeEnrichmentParametersArgsDict']] enrichment_parameters: Parameters to configure enrichment for your pipe. Detailed below.
        :param pulumi.Input[_builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN. If not set, EventBridge uses an AWS owned key to encrypt pipe data.
        :param pulumi.Input[Union['PipeLogConfigurationArgs', 'PipeLogConfigurationArgsDict']] log_configuration: Logging configuration settings for the pipe. Detailed below.
        :param pulumi.Input[_builtins.str] name: Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the role that allows the pipe to send data to the target.
        :param pulumi.Input[_builtins.str] source: Source resource of the pipe. This field typically requires an ARN (Amazon Resource Name). However, when using a self-managed Kafka cluster, you should use a different format. Instead of an ARN, use 'smk://' followed by the bootstrap server's address.
        :param pulumi.Input[Union['PipeSourceParametersArgs', 'PipeSourceParametersArgsDict']] source_parameters: Parameters to configure a source for the pipe. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] target: Target resource of the pipe (typically an ARN).
               
               The following arguments are optional:
        :param pulumi.Input[Union['PipeTargetParametersArgs', 'PipeTargetParametersArgsDict']] target_parameters: Parameters to configure a target for your pipe. Detailed below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS EventBridge Pipes Pipe.

        You can find out more about EventBridge Pipes in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html).

        EventBridge Pipes are very configurable, and may require IAM permissions to work correctly. More information on the configuration options and IAM permissions can be found in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html).

        > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        main = aws.get_caller_identity()
        example = aws.iam.Role("example", assume_role_policy=json.dumps({
            "Version": "2012-10-17",
            "Statement": {
                "Effect": "Allow",
                "Action": "sts:AssumeRole",
                "Principal": {
                    "Service": "pipes.amazonaws.com",
                },
                "Condition": {
                    "StringEquals": {
                        "aws:SourceAccount": main.account_id,
                    },
                },
            },
        }))
        source_queue = aws.sqs.Queue("source")
        source = aws.iam.RolePolicy("source",
            role=example.id,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Action": [
                        "sqs:DeleteMessage",
                        "sqs:GetQueueAttributes",
                        "sqs:ReceiveMessage",
                    ],
                    "Resource": [source_queue.arn],
                }],
            }))
        target_queue = aws.sqs.Queue("target")
        target = aws.iam.RolePolicy("target",
            role=example.id,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Action": ["sqs:SendMessage"],
                    "Resource": [target_queue.arn],
                }],
            }))
        example_pipe = aws.pipes.Pipe("example",
            name="example-pipe",
            role_arn=example.arn,
            source=source_queue.arn,
            target=target_queue.arn,
            opts = pulumi.ResourceOptions(depends_on=[
                    source,
                    target,
                ]))
        ```

        ### Enrichment Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.pipes.Pipe("example",
            name="example-pipe",
            role_arn=example_aws_iam_role["arn"],
            source=source["arn"],
            target=target["arn"],
            enrichment=example_aws_cloudwatch_event_api_destination["arn"],
            enrichment_parameters={
                "http_parameters": {
                    "path_parameter_values": "example-path-param",
                    "header_parameters": {
                        "example-header": "example-value",
                        "second-example-header": "second-example-value",
                    },
                    "query_string_parameters": {
                        "example-query-string": "example-value",
                        "second-example-query-string": "second-example-value",
                    },
                },
            })
        ```

        ### Filter Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.pipes.Pipe("example",
            name="example-pipe",
            role_arn=example_aws_iam_role["arn"],
            source=source["arn"],
            target=target["arn"],
            source_parameters={
                "filter_criteria": {
                    "filters": [{
                        "pattern": json.dumps({
                            "source": ["event-source"],
                        }),
                    }],
                },
            })
        ```

        ### CloudWatch Logs Logging Configuration Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.LogGroup("example", name="example-pipe-target")
        example_pipe = aws.pipes.Pipe("example",
            name="example-pipe",
            role_arn=example_aws_iam_role["arn"],
            source=source_aws_sqs_queue["arn"],
            target=target_aws_sqs_queue["arn"],
            log_configuration={
                "include_execution_datas": ["ALL"],
                "level": "INFO",
                "cloudwatch_logs_log_destination": {
                    "log_group_arn": target_aws_cloudwatch_log_group["arn"],
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    source,
                    target,
                ]))
        ```

        ### SQS Source and Target Configuration Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.pipes.Pipe("example",
            name="example-pipe",
            role_arn=example_aws_iam_role["arn"],
            source=source["arn"],
            target=target["arn"],
            source_parameters={
                "sqs_queue_parameters": {
                    "batch_size": 1,
                    "maximum_batching_window_in_seconds": 2,
                },
            },
            target_parameters={
                "sqs_queue_parameters": {
                    "message_deduplication_id": "example-dedupe",
                    "message_group_id": "example-group",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import pipes using the `name`. For example:

        ```sh
        $ pulumi import aws:pipes/pipe:Pipe example my-pipe
        ```

        :param str resource_name: The name of the resource.
        :param PipeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 enrichment: Optional[pulumi.Input[_builtins.str]] = None,
                 enrichment_parameters: Optional[pulumi.Input[Union['PipeEnrichmentParametersArgs', 'PipeEnrichmentParametersArgsDict']]] = None,
                 kms_key_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 log_configuration: Optional[pulumi.Input[Union['PipeLogConfigurationArgs', 'PipeLogConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 source_parameters: Optional[pulumi.Input[Union['PipeSourceParametersArgs', 'PipeSourceParametersArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target: Optional[pulumi.Input[_builtins.str]] = None,
                 target_parameters: Optional[pulumi.Input[Union['PipeTargetParametersArgs', 'PipeTargetParametersArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipeArgs.__new__(PipeArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["desired_state"] = desired_state
            __props__.__dict__["enrichment"] = enrichment
            __props__.__dict__["enrichment_parameters"] = enrichment_parameters
            __props__.__dict__["kms_key_identifier"] = kms_key_identifier
            __props__.__dict__["log_configuration"] = log_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["region"] = region
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["source_parameters"] = source_parameters
            __props__.__dict__["tags"] = tags
            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__.__dict__["target"] = target
            __props__.__dict__["target_parameters"] = target_parameters
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Pipe, __self__).__init__(
            'aws:pipes/pipe:Pipe',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            desired_state: Optional[pulumi.Input[_builtins.str]] = None,
            enrichment: Optional[pulumi.Input[_builtins.str]] = None,
            enrichment_parameters: Optional[pulumi.Input[Union['PipeEnrichmentParametersArgs', 'PipeEnrichmentParametersArgsDict']]] = None,
            kms_key_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            log_configuration: Optional[pulumi.Input[Union['PipeLogConfigurationArgs', 'PipeLogConfigurationArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[_builtins.str]] = None,
            source_parameters: Optional[pulumi.Input[Union['PipeSourceParametersArgs', 'PipeSourceParametersArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target: Optional[pulumi.Input[_builtins.str]] = None,
            target_parameters: Optional[pulumi.Input[Union['PipeTargetParametersArgs', 'PipeTargetParametersArgsDict']]] = None) -> 'Pipe':
        """
        Get an existing Pipe resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of this pipe.
        :param pulumi.Input[_builtins.str] description: A description of the pipe. At most 512 characters.
        :param pulumi.Input[_builtins.str] desired_state: The state the pipe should be in. One of: `RUNNING`, `STOPPED`.
        :param pulumi.Input[_builtins.str] enrichment: Enrichment resource of the pipe (typically an ARN). Read more about enrichment in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-enrichment).
        :param pulumi.Input[Union['PipeEnrichmentParametersArgs', 'PipeEnrichmentParametersArgsDict']] enrichment_parameters: Parameters to configure enrichment for your pipe. Detailed below.
        :param pulumi.Input[_builtins.str] kms_key_identifier: Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN. If not set, EventBridge uses an AWS owned key to encrypt pipe data.
        :param pulumi.Input[Union['PipeLogConfigurationArgs', 'PipeLogConfigurationArgsDict']] log_configuration: Logging configuration settings for the pipe. Detailed below.
        :param pulumi.Input[_builtins.str] name: Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] role_arn: ARN of the role that allows the pipe to send data to the target.
        :param pulumi.Input[_builtins.str] source: Source resource of the pipe. This field typically requires an ARN (Amazon Resource Name). However, when using a self-managed Kafka cluster, you should use a different format. Instead of an ARN, use 'smk://' followed by the bootstrap server's address.
        :param pulumi.Input[Union['PipeSourceParametersArgs', 'PipeSourceParametersArgsDict']] source_parameters: Parameters to configure a source for the pipe. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] target: Target resource of the pipe (typically an ARN).
               
               The following arguments are optional:
        :param pulumi.Input[Union['PipeTargetParametersArgs', 'PipeTargetParametersArgsDict']] target_parameters: Parameters to configure a target for your pipe. Detailed below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipeState.__new__(_PipeState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["desired_state"] = desired_state
        __props__.__dict__["enrichment"] = enrichment
        __props__.__dict__["enrichment_parameters"] = enrichment_parameters
        __props__.__dict__["kms_key_identifier"] = kms_key_identifier
        __props__.__dict__["log_configuration"] = log_configuration
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["region"] = region
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["source"] = source
        __props__.__dict__["source_parameters"] = source_parameters
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["target"] = target
        __props__.__dict__["target_parameters"] = target_parameters
        return Pipe(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of this pipe.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the pipe. At most 512 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The state the pipe should be in. One of: `RUNNING`, `STOPPED`.
        """
        return pulumi.get(self, "desired_state")

    @_builtins.property
    @pulumi.getter
    def enrichment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Enrichment resource of the pipe (typically an ARN). Read more about enrichment in the [User Guide](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-enrichment).
        """
        return pulumi.get(self, "enrichment")

    @_builtins.property
    @pulumi.getter(name="enrichmentParameters")
    def enrichment_parameters(self) -> pulumi.Output[Optional['outputs.PipeEnrichmentParameters']]:
        """
        Parameters to configure enrichment for your pipe. Detailed below.
        """
        return pulumi.get(self, "enrichment_parameters")

    @_builtins.property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt pipe data. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN. If not set, EventBridge uses an AWS owned key to encrypt pipe data.
        """
        return pulumi.get(self, "kms_key_identifier")

    @_builtins.property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> pulumi.Output[Optional['outputs.PipeLogConfiguration']]:
        """
        Logging configuration settings for the pipe. Detailed below.
        """
        return pulumi.get(self, "log_configuration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the pipe. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the role that allows the pipe to send data to the target.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output[_builtins.str]:
        """
        Source resource of the pipe. This field typically requires an ARN (Amazon Resource Name). However, when using a self-managed Kafka cluster, you should use a different format. Instead of an ARN, use 'smk://' followed by the bootstrap server's address.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceParameters")
    def source_parameters(self) -> pulumi.Output['outputs.PipeSourceParameters']:
        """
        Parameters to configure a source for the pipe. Detailed below.
        """
        return pulumi.get(self, "source_parameters")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def target(self) -> pulumi.Output[_builtins.str]:
        """
        Target resource of the pipe (typically an ARN).

        The following arguments are optional:
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="targetParameters")
    def target_parameters(self) -> pulumi.Output[Optional['outputs.PipeTargetParameters']]:
        """
        Parameters to configure a target for your pipe. Detailed below.
        """
        return pulumi.get(self, "target_parameters")

