# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetResourceShareResult',
    'AwaitableGetResourceShareResult',
    'get_resource_share',
    'get_resource_share_output',
]

@pulumi.output_type
class GetResourceShareResult:
    """
    A collection of values returned by getResourceShare.
    """
    def __init__(__self__, arn=None, filters=None, id=None, name=None, owning_account_id=None, region=None, resource_arns=None, resource_owner=None, resource_share_status=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owning_account_id and not isinstance(owning_account_id, str):
            raise TypeError("Expected argument 'owning_account_id' to be a str")
        pulumi.set(__self__, "owning_account_id", owning_account_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource_arns and not isinstance(resource_arns, list):
            raise TypeError("Expected argument 'resource_arns' to be a list")
        pulumi.set(__self__, "resource_arns", resource_arns)
        if resource_owner and not isinstance(resource_owner, str):
            raise TypeError("Expected argument 'resource_owner' to be a str")
        pulumi.set(__self__, "resource_owner", resource_owner)
        if resource_share_status and not isinstance(resource_share_status, str):
            raise TypeError("Expected argument 'resource_share_status' to be a str")
        pulumi.set(__self__, "resource_share_status", resource_share_status)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the resource share.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetResourceShareFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="owningAccountId")
    def owning_account_id(self) -> _builtins.str:
        """
        ID of the AWS account that owns the resource share.
        """
        return pulumi.get(self, "owning_account_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceArns")
    def resource_arns(self) -> Sequence[_builtins.str]:
        """
        A list of resource ARNs associated with the resource share.
        """
        return pulumi.get(self, "resource_arns")

    @_builtins.property
    @pulumi.getter(name="resourceOwner")
    def resource_owner(self) -> _builtins.str:
        return pulumi.get(self, "resource_owner")

    @_builtins.property
    @pulumi.getter(name="resourceShareStatus")
    def resource_share_status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_share_status")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Status of the resource share.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Tags attached to the resource share.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResourceShareResult(GetResourceShareResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceShareResult(
            arn=self.arn,
            filters=self.filters,
            id=self.id,
            name=self.name,
            owning_account_id=self.owning_account_id,
            region=self.region,
            resource_arns=self.resource_arns,
            resource_owner=self.resource_owner,
            resource_share_status=self.resource_share_status,
            status=self.status,
            tags=self.tags)


def get_resource_share(filters: Optional[Sequence[Union['GetResourceShareFilterArgs', 'GetResourceShareFilterArgsDict']]] = None,
                       name: Optional[_builtins.str] = None,
                       region: Optional[_builtins.str] = None,
                       resource_owner: Optional[_builtins.str] = None,
                       resource_share_status: Optional[_builtins.str] = None,
                       tags: Optional[Mapping[str, _builtins.str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceShareResult:
    """
    `ram.ResourceShare` Retrieve information about a RAM Resource Share.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ram.get_resource_share(name="example",
        resource_owner="SELF")
    ```

    ## Search by filters

    ```python
    import pulumi
    import pulumi_aws as aws

    tag_filter = aws.ram.get_resource_share(resource_owner="SELF",
        filters=[{
            "name": "NameOfTag",
            "values": ["exampleNameTagValue"],
        }])
    ```


    :param Sequence[Union['GetResourceShareFilterArgs', 'GetResourceShareFilterArgsDict']] filters: Filter used to scope the list of owned shares e.g., by tags. See [related docs] (https://docs.aws.amazon.com/ram/latest/APIReference/API_TagFilter.html).
    :param _builtins.str name: Name of the resource share to retrieve.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str resource_owner: Owner of the resource share. Valid values are `SELF` or `OTHER-ACCOUNTS`.
    :param _builtins.str resource_share_status: Specifies that you want to retrieve details of only those resource shares that have this status. Valid values are `PENDING`, `ACTIVE`, `FAILED`, `DELETING`, and `DELETED`.
    :param Mapping[str, _builtins.str] tags: Tags attached to the resource share.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['region'] = region
    __args__['resourceOwner'] = resource_owner
    __args__['resourceShareStatus'] = resource_share_status
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:ram/getResourceShare:getResourceShare', __args__, opts=opts, typ=GetResourceShareResult).value

    return AwaitableGetResourceShareResult(
        arn=pulumi.get(__ret__, 'arn'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        owning_account_id=pulumi.get(__ret__, 'owning_account_id'),
        region=pulumi.get(__ret__, 'region'),
        resource_arns=pulumi.get(__ret__, 'resource_arns'),
        resource_owner=pulumi.get(__ret__, 'resource_owner'),
        resource_share_status=pulumi.get(__ret__, 'resource_share_status'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resource_share_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetResourceShareFilterArgs', 'GetResourceShareFilterArgsDict']]]]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              resource_owner: Optional[pulumi.Input[_builtins.str]] = None,
                              resource_share_status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceShareResult]:
    """
    `ram.ResourceShare` Retrieve information about a RAM Resource Share.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.ram.get_resource_share(name="example",
        resource_owner="SELF")
    ```

    ## Search by filters

    ```python
    import pulumi
    import pulumi_aws as aws

    tag_filter = aws.ram.get_resource_share(resource_owner="SELF",
        filters=[{
            "name": "NameOfTag",
            "values": ["exampleNameTagValue"],
        }])
    ```


    :param Sequence[Union['GetResourceShareFilterArgs', 'GetResourceShareFilterArgsDict']] filters: Filter used to scope the list of owned shares e.g., by tags. See [related docs] (https://docs.aws.amazon.com/ram/latest/APIReference/API_TagFilter.html).
    :param _builtins.str name: Name of the resource share to retrieve.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str resource_owner: Owner of the resource share. Valid values are `SELF` or `OTHER-ACCOUNTS`.
    :param _builtins.str resource_share_status: Specifies that you want to retrieve details of only those resource shares that have this status. Valid values are `PENDING`, `ACTIVE`, `FAILED`, `DELETING`, and `DELETED`.
    :param Mapping[str, _builtins.str] tags: Tags attached to the resource share.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['region'] = region
    __args__['resourceOwner'] = resource_owner
    __args__['resourceShareStatus'] = resource_share_status
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:ram/getResourceShare:getResourceShare', __args__, opts=opts, typ=GetResourceShareResult)
    return __ret__.apply(lambda __response__: GetResourceShareResult(
        arn=pulumi.get(__response__, 'arn'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        owning_account_id=pulumi.get(__response__, 'owning_account_id'),
        region=pulumi.get(__response__, 'region'),
        resource_arns=pulumi.get(__response__, 'resource_arns'),
        resource_owner=pulumi.get(__response__, 'resource_owner'),
        resource_share_status=pulumi.get(__response__, 'resource_share_status'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
