# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ClusterMasterUserSecret',
    'ClusterParameterGroupParameter',
    'ClusterRestoreToPointInTime',
    'ClusterS3Import',
    'ClusterScalingConfiguration',
    'ClusterServerlessv2ScalingConfiguration',
    'ClusterSnapshotCopyTimeouts',
    'ExportTaskTimeouts',
    'GlobalClusterGlobalClusterMember',
    'InstanceBlueGreenUpdate',
    'InstanceDesiredStateTimeouts',
    'InstanceListenerEndpoint',
    'InstanceMasterUserSecret',
    'InstanceRestoreToPointInTime',
    'InstanceS3Import',
    'IntegrationTimeouts',
    'OptionGroupOption',
    'OptionGroupOptionOptionSetting',
    'ParameterGroupParameter',
    'ProxyAuth',
    'ProxyDefaultTargetGroupConnectionPoolConfig',
    'ReservedInstanceRecurringCharge',
    'ShardGroupTimeouts',
    'GetClusterMasterUserSecretResult',
    'GetClustersFilterResult',
    'GetEngineVersionFilterResult',
    'GetInstanceMasterUserSecretResult',
    'GetInstancesFilterResult',
    'GetProxyAuthResult',
]

@pulumi.output_type
class ClusterMasterUserSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "secretArn":
            suggest = "secret_arn"
        elif key == "secretStatus":
            suggest = "secret_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMasterUserSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMasterUserSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMasterUserSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[_builtins.str] = None,
                 secret_arn: Optional[_builtins.str] = None,
                 secret_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_id: ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        :param _builtins.str secret_arn: Amazon Resource Name (ARN) of the secret.
        :param _builtins.str secret_status: Status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if secret_status is not None:
            pulumi.set(__self__, "secret_status", secret_status)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        ARN for the KMS encryption key. When specifying `kms_key_id`, `storage_encrypted` needs to be set to true.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the secret.
        """
        return pulumi.get(self, "secret_arn")

    @_builtins.property
    @pulumi.getter(name="secretStatus")
    def secret_status(self) -> Optional[_builtins.str]:
        """
        Status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        return pulumi.get(self, "secret_status")


@pulumi.output_type
class ClusterParameterGroupParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyMethod":
            suggest = "apply_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterParameterGroupParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterParameterGroupParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterParameterGroupParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str,
                 apply_method: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the DB parameter.
        :param _builtins.str value: The value of the DB parameter.
        :param _builtins.str apply_method: "immediate" (default), or "pending-reboot". Some
               engines can't apply some parameters without a reboot, and you will need to
               specify "pending-reboot" here.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the DB parameter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the DB parameter.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[_builtins.str]:
        """
        "immediate" (default), or "pending-reboot". Some
        engines can't apply some parameters without a reboot, and you will need to
        specify "pending-reboot" here.
        """
        return pulumi.get(self, "apply_method")


@pulumi.output_type
class ClusterRestoreToPointInTime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restoreToTime":
            suggest = "restore_to_time"
        elif key == "restoreType":
            suggest = "restore_type"
        elif key == "sourceClusterIdentifier":
            suggest = "source_cluster_identifier"
        elif key == "sourceClusterResourceId":
            suggest = "source_cluster_resource_id"
        elif key == "useLatestRestorableTime":
            suggest = "use_latest_restorable_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRestoreToPointInTime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRestoreToPointInTime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRestoreToPointInTime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 restore_to_time: Optional[_builtins.str] = None,
                 restore_type: Optional[_builtins.str] = None,
                 source_cluster_identifier: Optional[_builtins.str] = None,
                 source_cluster_resource_id: Optional[_builtins.str] = None,
                 use_latest_restorable_time: Optional[_builtins.bool] = None):
        """
        :param _builtins.str restore_to_time: Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
        :param _builtins.str restore_type: Type of restore to be performed.
               Valid options are `full-copy` (default) and `copy-on-write`.
        :param _builtins.str source_cluster_identifier: Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
        :param _builtins.str source_cluster_resource_id: Cluster resource ID of the source database cluster from which to restore. To be used for restoring a deleted cluster in the same account which still has a retained automatic backup available.
        :param _builtins.bool use_latest_restorable_time: Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
        """
        if restore_to_time is not None:
            pulumi.set(__self__, "restore_to_time", restore_to_time)
        if restore_type is not None:
            pulumi.set(__self__, "restore_type", restore_type)
        if source_cluster_identifier is not None:
            pulumi.set(__self__, "source_cluster_identifier", source_cluster_identifier)
        if source_cluster_resource_id is not None:
            pulumi.set(__self__, "source_cluster_resource_id", source_cluster_resource_id)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)

    @_builtins.property
    @pulumi.getter(name="restoreToTime")
    def restore_to_time(self) -> Optional[_builtins.str]:
        """
        Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
        """
        return pulumi.get(self, "restore_to_time")

    @_builtins.property
    @pulumi.getter(name="restoreType")
    def restore_type(self) -> Optional[_builtins.str]:
        """
        Type of restore to be performed.
        Valid options are `full-copy` (default) and `copy-on-write`.
        """
        return pulumi.get(self, "restore_type")

    @_builtins.property
    @pulumi.getter(name="sourceClusterIdentifier")
    def source_cluster_identifier(self) -> Optional[_builtins.str]:
        """
        Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
        """
        return pulumi.get(self, "source_cluster_identifier")

    @_builtins.property
    @pulumi.getter(name="sourceClusterResourceId")
    def source_cluster_resource_id(self) -> Optional[_builtins.str]:
        """
        Cluster resource ID of the source database cluster from which to restore. To be used for restoring a deleted cluster in the same account which still has a retained automatic backup available.
        """
        return pulumi.get(self, "source_cluster_resource_id")

    @_builtins.property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[_builtins.bool]:
        """
        Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
        """
        return pulumi.get(self, "use_latest_restorable_time")


@pulumi.output_type
class ClusterS3Import(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "ingestionRole":
            suggest = "ingestion_role"
        elif key == "sourceEngine":
            suggest = "source_engine"
        elif key == "sourceEngineVersion":
            suggest = "source_engine_version"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterS3Import. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterS3Import.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterS3Import.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 ingestion_role: _builtins.str,
                 source_engine: _builtins.str,
                 source_engine_version: _builtins.str,
                 bucket_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: Bucket name where your backup is stored
        :param _builtins.str ingestion_role: Role applied to load the data.
        :param _builtins.str source_engine: Source engine for the backup
        :param _builtins.str source_engine_version: Version of the source engine used to make the backup
               
               This will not recreate the resource if the S3 object changes in some way. It's only used to initialize the database. This only works currently with the aurora engine. See AWS for currently supported engines and options. See [Aurora S3 Migration Docs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3).
        :param _builtins.str bucket_prefix: Can be blank, but is the path to your backup
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "ingestion_role", ingestion_role)
        pulumi.set(__self__, "source_engine", source_engine)
        pulumi.set(__self__, "source_engine_version", source_engine_version)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        Bucket name where your backup is stored
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="ingestionRole")
    def ingestion_role(self) -> _builtins.str:
        """
        Role applied to load the data.
        """
        return pulumi.get(self, "ingestion_role")

    @_builtins.property
    @pulumi.getter(name="sourceEngine")
    def source_engine(self) -> _builtins.str:
        """
        Source engine for the backup
        """
        return pulumi.get(self, "source_engine")

    @_builtins.property
    @pulumi.getter(name="sourceEngineVersion")
    def source_engine_version(self) -> _builtins.str:
        """
        Version of the source engine used to make the backup

        This will not recreate the resource if the S3 object changes in some way. It's only used to initialize the database. This only works currently with the aurora engine. See AWS for currently supported engines and options. See [Aurora S3 Migration Docs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3).
        """
        return pulumi.get(self, "source_engine_version")

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[_builtins.str]:
        """
        Can be blank, but is the path to your backup
        """
        return pulumi.get(self, "bucket_prefix")


@pulumi.output_type
class ClusterScalingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoPause":
            suggest = "auto_pause"
        elif key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "secondsBeforeTimeout":
            suggest = "seconds_before_timeout"
        elif key == "secondsUntilAutoPause":
            suggest = "seconds_until_auto_pause"
        elif key == "timeoutAction":
            suggest = "timeout_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterScalingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterScalingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterScalingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_pause: Optional[_builtins.bool] = None,
                 max_capacity: Optional[_builtins.int] = None,
                 min_capacity: Optional[_builtins.int] = None,
                 seconds_before_timeout: Optional[_builtins.int] = None,
                 seconds_until_auto_pause: Optional[_builtins.int] = None,
                 timeout_action: Optional[_builtins.str] = None):
        """
        :param _builtins.bool auto_pause: Whether to enable automatic pause. A DB cluster can be paused only when it's idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
        :param _builtins.int max_capacity: Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
        :param _builtins.int min_capacity: Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
        :param _builtins.int seconds_before_timeout: Amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. Valid values are `60` through `600`. Defaults to `300`.
        :param _builtins.int seconds_until_auto_pause: Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
        :param _builtins.str timeout_action: Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v1.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
        """
        if auto_pause is not None:
            pulumi.set(__self__, "auto_pause", auto_pause)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if seconds_before_timeout is not None:
            pulumi.set(__self__, "seconds_before_timeout", seconds_before_timeout)
        if seconds_until_auto_pause is not None:
            pulumi.set(__self__, "seconds_until_auto_pause", seconds_until_auto_pause)
        if timeout_action is not None:
            pulumi.set(__self__, "timeout_action", timeout_action)

    @_builtins.property
    @pulumi.getter(name="autoPause")
    def auto_pause(self) -> Optional[_builtins.bool]:
        """
        Whether to enable automatic pause. A DB cluster can be paused only when it's idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
        """
        return pulumi.get(self, "auto_pause")

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[_builtins.int]:
        """
        Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
        """
        return pulumi.get(self, "max_capacity")

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[_builtins.int]:
        """
        Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
        """
        return pulumi.get(self, "min_capacity")

    @_builtins.property
    @pulumi.getter(name="secondsBeforeTimeout")
    def seconds_before_timeout(self) -> Optional[_builtins.int]:
        """
        Amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. Valid values are `60` through `600`. Defaults to `300`.
        """
        return pulumi.get(self, "seconds_before_timeout")

    @_builtins.property
    @pulumi.getter(name="secondsUntilAutoPause")
    def seconds_until_auto_pause(self) -> Optional[_builtins.int]:
        """
        Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
        """
        return pulumi.get(self, "seconds_until_auto_pause")

    @_builtins.property
    @pulumi.getter(name="timeoutAction")
    def timeout_action(self) -> Optional[_builtins.str]:
        """
        Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v1.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
        """
        return pulumi.get(self, "timeout_action")


@pulumi.output_type
class ClusterServerlessv2ScalingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "secondsUntilAutoPause":
            suggest = "seconds_until_auto_pause"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServerlessv2ScalingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServerlessv2ScalingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServerlessv2ScalingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: _builtins.float,
                 min_capacity: _builtins.float,
                 seconds_until_auto_pause: Optional[_builtins.int] = None):
        """
        :param _builtins.float max_capacity: Maximum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid capacity values are in a range of `0` up to `256` in steps of `0.5`.
        :param _builtins.float min_capacity: Minimum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid capacity values are in a range of `0` up to `256` in steps of `0.5`.
        :param _builtins.int seconds_until_auto_pause: Time, in seconds, before an Aurora DB cluster in `provisioned` DB engine mode is paused. Valid values are `300` through `86400`.
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        if seconds_until_auto_pause is not None:
            pulumi.set(__self__, "seconds_until_auto_pause", seconds_until_auto_pause)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> _builtins.float:
        """
        Maximum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid capacity values are in a range of `0` up to `256` in steps of `0.5`.
        """
        return pulumi.get(self, "max_capacity")

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> _builtins.float:
        """
        Minimum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid capacity values are in a range of `0` up to `256` in steps of `0.5`.
        """
        return pulumi.get(self, "min_capacity")

    @_builtins.property
    @pulumi.getter(name="secondsUntilAutoPause")
    def seconds_until_auto_pause(self) -> Optional[_builtins.int]:
        """
        Time, in seconds, before an Aurora DB cluster in `provisioned` DB engine mode is paused. Valid values are `300` through `86400`.
        """
        return pulumi.get(self, "seconds_until_auto_pause")


@pulumi.output_type
class ClusterSnapshotCopyTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")


@pulumi.output_type
class ExportTaskTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class GlobalClusterGlobalClusterMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbClusterArn":
            suggest = "db_cluster_arn"
        elif key == "isWriter":
            suggest = "is_writer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalClusterGlobalClusterMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalClusterGlobalClusterMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalClusterGlobalClusterMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 db_cluster_arn: Optional[_builtins.str] = None,
                 is_writer: Optional[_builtins.bool] = None):
        """
        :param _builtins.str db_cluster_arn: Amazon Resource Name (ARN) of member DB Cluster.
        :param _builtins.bool is_writer: Whether the member is the primary DB Cluster.
        """
        if db_cluster_arn is not None:
            pulumi.set(__self__, "db_cluster_arn", db_cluster_arn)
        if is_writer is not None:
            pulumi.set(__self__, "is_writer", is_writer)

    @_builtins.property
    @pulumi.getter(name="dbClusterArn")
    def db_cluster_arn(self) -> Optional[_builtins.str]:
        """
        Amazon Resource Name (ARN) of member DB Cluster.
        """
        return pulumi.get(self, "db_cluster_arn")

    @_builtins.property
    @pulumi.getter(name="isWriter")
    def is_writer(self) -> Optional[_builtins.bool]:
        """
        Whether the member is the primary DB Cluster.
        """
        return pulumi.get(self, "is_writer")


@pulumi.output_type
class InstanceBlueGreenUpdate(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: Enables low-downtime updates when `true`.
               Default is `false`.
               
               [instance-replication]:
               https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Replication.html
               [instance-maintenance]:
               https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html
               [blue-green]:
               https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Enables low-downtime updates when `true`.
        Default is `false`.

        [instance-replication]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Replication.html
        [instance-maintenance]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html
        [blue-green]:
        https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class InstanceDesiredStateTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class InstanceListenerEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostedZoneId":
            suggest = "hosted_zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceListenerEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceListenerEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceListenerEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 hosted_zone_id: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.str address: Specifies the DNS address of the DB instance.
        :param _builtins.str hosted_zone_id: Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        :param _builtins.int port: The port on which the DB accepts connections.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        Specifies the DNS address of the DB instance.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port on which the DB accepts connections.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class InstanceMasterUserSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "secretArn":
            suggest = "secret_arn"
        elif key == "secretStatus":
            suggest = "secret_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMasterUserSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMasterUserSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMasterUserSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[_builtins.str] = None,
                 secret_arn: Optional[_builtins.str] = None,
                 secret_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_id: The ARN for the KMS encryption key. If creating an
               encrypted replica, set this to the destination KMS ARN.
        :param _builtins.str secret_arn: The Amazon Resource Name (ARN) of the secret.
        :param _builtins.str secret_status: The status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if secret_status is not None:
            pulumi.set(__self__, "secret_status", secret_status)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        The ARN for the KMS encryption key. If creating an
        encrypted replica, set this to the destination KMS ARN.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the secret.
        """
        return pulumi.get(self, "secret_arn")

    @_builtins.property
    @pulumi.getter(name="secretStatus")
    def secret_status(self) -> Optional[_builtins.str]:
        """
        The status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        return pulumi.get(self, "secret_status")


@pulumi.output_type
class InstanceRestoreToPointInTime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restoreTime":
            suggest = "restore_time"
        elif key == "sourceDbInstanceAutomatedBackupsArn":
            suggest = "source_db_instance_automated_backups_arn"
        elif key == "sourceDbInstanceIdentifier":
            suggest = "source_db_instance_identifier"
        elif key == "sourceDbiResourceId":
            suggest = "source_dbi_resource_id"
        elif key == "useLatestRestorableTime":
            suggest = "use_latest_restorable_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceRestoreToPointInTime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceRestoreToPointInTime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceRestoreToPointInTime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 restore_time: Optional[_builtins.str] = None,
                 source_db_instance_automated_backups_arn: Optional[_builtins.str] = None,
                 source_db_instance_identifier: Optional[_builtins.str] = None,
                 source_dbi_resource_id: Optional[_builtins.str] = None,
                 use_latest_restorable_time: Optional[_builtins.bool] = None):
        """
        :param _builtins.str restore_time: The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        :param _builtins.str source_db_instance_automated_backups_arn: The ARN of the automated backup from which to restore. Required if `source_db_instance_identifier` or `source_dbi_resource_id` is not specified.
        :param _builtins.str source_db_instance_identifier: The identifier of the source DB instance from which to restore. Must match the identifier of an existing DB instance. Required if `source_db_instance_automated_backups_arn` or `source_dbi_resource_id` is not specified.
        :param _builtins.str source_dbi_resource_id: The resource ID of the source DB instance from which to restore. Required if `source_db_instance_identifier` or `source_db_instance_automated_backups_arn` is not specified.
        :param _builtins.bool use_latest_restorable_time: A boolean value that indicates whether the DB instance is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_time`.
        """
        if restore_time is not None:
            pulumi.set(__self__, "restore_time", restore_time)
        if source_db_instance_automated_backups_arn is not None:
            pulumi.set(__self__, "source_db_instance_automated_backups_arn", source_db_instance_automated_backups_arn)
        if source_db_instance_identifier is not None:
            pulumi.set(__self__, "source_db_instance_identifier", source_db_instance_identifier)
        if source_dbi_resource_id is not None:
            pulumi.set(__self__, "source_dbi_resource_id", source_dbi_resource_id)
        if use_latest_restorable_time is not None:
            pulumi.set(__self__, "use_latest_restorable_time", use_latest_restorable_time)

    @_builtins.property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> Optional[_builtins.str]:
        """
        The date and time to restore from. Value must be a time in Universal Coordinated Time (UTC) format and must be before the latest restorable time for the DB instance. Cannot be specified with `use_latest_restorable_time`.
        """
        return pulumi.get(self, "restore_time")

    @_builtins.property
    @pulumi.getter(name="sourceDbInstanceAutomatedBackupsArn")
    def source_db_instance_automated_backups_arn(self) -> Optional[_builtins.str]:
        """
        The ARN of the automated backup from which to restore. Required if `source_db_instance_identifier` or `source_dbi_resource_id` is not specified.
        """
        return pulumi.get(self, "source_db_instance_automated_backups_arn")

    @_builtins.property
    @pulumi.getter(name="sourceDbInstanceIdentifier")
    def source_db_instance_identifier(self) -> Optional[_builtins.str]:
        """
        The identifier of the source DB instance from which to restore. Must match the identifier of an existing DB instance. Required if `source_db_instance_automated_backups_arn` or `source_dbi_resource_id` is not specified.
        """
        return pulumi.get(self, "source_db_instance_identifier")

    @_builtins.property
    @pulumi.getter(name="sourceDbiResourceId")
    def source_dbi_resource_id(self) -> Optional[_builtins.str]:
        """
        The resource ID of the source DB instance from which to restore. Required if `source_db_instance_identifier` or `source_db_instance_automated_backups_arn` is not specified.
        """
        return pulumi.get(self, "source_dbi_resource_id")

    @_builtins.property
    @pulumi.getter(name="useLatestRestorableTime")
    def use_latest_restorable_time(self) -> Optional[_builtins.bool]:
        """
        A boolean value that indicates whether the DB instance is restored from the latest backup time. Defaults to `false`. Cannot be specified with `restore_time`.
        """
        return pulumi.get(self, "use_latest_restorable_time")


@pulumi.output_type
class InstanceS3Import(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "ingestionRole":
            suggest = "ingestion_role"
        elif key == "sourceEngine":
            suggest = "source_engine"
        elif key == "sourceEngineVersion":
            suggest = "source_engine_version"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceS3Import. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceS3Import.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceS3Import.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 ingestion_role: _builtins.str,
                 source_engine: _builtins.str,
                 source_engine_version: _builtins.str,
                 bucket_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: The bucket name where your backup is stored
        :param _builtins.str ingestion_role: Role applied to load the data.
        :param _builtins.str source_engine: Source engine for the backup
        :param _builtins.str source_engine_version: Version of the source engine used to make the backup
               
               This will not recreate the resource if the S3 object changes in some way.  It's only used to initialize the database.
        :param _builtins.str bucket_prefix: Can be blank, but is the path to your backup
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "ingestion_role", ingestion_role)
        pulumi.set(__self__, "source_engine", source_engine)
        pulumi.set(__self__, "source_engine_version", source_engine_version)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        The bucket name where your backup is stored
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="ingestionRole")
    def ingestion_role(self) -> _builtins.str:
        """
        Role applied to load the data.
        """
        return pulumi.get(self, "ingestion_role")

    @_builtins.property
    @pulumi.getter(name="sourceEngine")
    def source_engine(self) -> _builtins.str:
        """
        Source engine for the backup
        """
        return pulumi.get(self, "source_engine")

    @_builtins.property
    @pulumi.getter(name="sourceEngineVersion")
    def source_engine_version(self) -> _builtins.str:
        """
        Version of the source engine used to make the backup

        This will not recreate the resource if the S3 object changes in some way.  It's only used to initialize the database.
        """
        return pulumi.get(self, "source_engine_version")

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[_builtins.str]:
        """
        Can be blank, but is the path to your backup
        """
        return pulumi.get(self, "bucket_prefix")


@pulumi.output_type
class IntegrationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")


@pulumi.output_type
class OptionGroupOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "optionName":
            suggest = "option_name"
        elif key == "dbSecurityGroupMemberships":
            suggest = "db_security_group_memberships"
        elif key == "optionSettings":
            suggest = "option_settings"
        elif key == "vpcSecurityGroupMemberships":
            suggest = "vpc_security_group_memberships"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OptionGroupOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OptionGroupOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OptionGroupOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 option_name: _builtins.str,
                 db_security_group_memberships: Optional[Sequence[_builtins.str]] = None,
                 option_settings: Optional[Sequence['outputs.OptionGroupOptionOptionSetting']] = None,
                 port: Optional[_builtins.int] = None,
                 version: Optional[_builtins.str] = None,
                 vpc_security_group_memberships: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str option_name: Name of the option (e.g., MEMCACHED).
        :param Sequence[_builtins.str] db_security_group_memberships: List of DB Security Groups for which the option is enabled.
        :param Sequence['OptionGroupOptionOptionSettingArgs'] option_settings: The option settings to apply. See `option_settings` Block below for more details.
        :param _builtins.int port: Port number when connecting to the option (e.g., 11211). Leaving out or removing `port` from your configuration does not remove or clear a port from the option in AWS. AWS may assign a default port. Not including `port` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any port changes.
        :param _builtins.str version: Version of the option (e.g., 13.1.0.0). Leaving out or removing `version` from your configuration does not remove or clear a version from the option in AWS. AWS may assign a default version. Not including `version` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any version changes.
        :param Sequence[_builtins.str] vpc_security_group_memberships: List of VPC Security Groups for which the option is enabled.
        """
        pulumi.set(__self__, "option_name", option_name)
        if db_security_group_memberships is not None:
            pulumi.set(__self__, "db_security_group_memberships", db_security_group_memberships)
        if option_settings is not None:
            pulumi.set(__self__, "option_settings", option_settings)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_security_group_memberships is not None:
            pulumi.set(__self__, "vpc_security_group_memberships", vpc_security_group_memberships)

    @_builtins.property
    @pulumi.getter(name="optionName")
    def option_name(self) -> _builtins.str:
        """
        Name of the option (e.g., MEMCACHED).
        """
        return pulumi.get(self, "option_name")

    @_builtins.property
    @pulumi.getter(name="dbSecurityGroupMemberships")
    def db_security_group_memberships(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of DB Security Groups for which the option is enabled.
        """
        return pulumi.get(self, "db_security_group_memberships")

    @_builtins.property
    @pulumi.getter(name="optionSettings")
    def option_settings(self) -> Optional[Sequence['outputs.OptionGroupOptionOptionSetting']]:
        """
        The option settings to apply. See `option_settings` Block below for more details.
        """
        return pulumi.get(self, "option_settings")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number when connecting to the option (e.g., 11211). Leaving out or removing `port` from your configuration does not remove or clear a port from the option in AWS. AWS may assign a default port. Not including `port` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any port changes.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version of the option (e.g., 13.1.0.0). Leaving out or removing `version` from your configuration does not remove or clear a version from the option in AWS. AWS may assign a default version. Not including `version` in your configuration means that the AWS provider will ignore a previously set value, a value set by AWS, and any version changes.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcSecurityGroupMemberships")
    def vpc_security_group_memberships(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of VPC Security Groups for which the option is enabled.
        """
        return pulumi.get(self, "vpc_security_group_memberships")


@pulumi.output_type
class OptionGroupOptionOptionSetting(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the setting.
        :param _builtins.str value: Value of the setting.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the setting.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the setting.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ParameterGroupParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applyMethod":
            suggest = "apply_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterGroupParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterGroupParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterGroupParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str,
                 apply_method: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the DB parameter.
        :param _builtins.str value: The value of the DB parameter.
        :param _builtins.str apply_method: "immediate" (default), or "pending-reboot". Some
               engines can't apply some parameters without a reboot, and you will need to
               specify "pending-reboot" here.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if apply_method is None:
            apply_method = 'immediate'
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the DB parameter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the DB parameter.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[_builtins.str]:
        """
        "immediate" (default), or "pending-reboot". Some
        engines can't apply some parameters without a reboot, and you will need to
        specify "pending-reboot" here.
        """
        return pulumi.get(self, "apply_method")


@pulumi.output_type
class ProxyAuth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authScheme":
            suggest = "auth_scheme"
        elif key == "clientPasswordAuthType":
            suggest = "client_password_auth_type"
        elif key == "iamAuth":
            suggest = "iam_auth"
        elif key == "secretArn":
            suggest = "secret_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProxyAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProxyAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProxyAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_scheme: Optional[_builtins.str] = None,
                 client_password_auth_type: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 iam_auth: Optional[_builtins.str] = None,
                 secret_arn: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_scheme: The type of authentication that the proxy uses for connections from the proxy to the underlying database. One of `SECRETS`.
        :param _builtins.str client_password_auth_type: The type of authentication the proxy uses for connections from clients. Valid values are `MYSQL_CACHING_SHA2_PASSWORD`, `MYSQL_NATIVE_PASSWORD`, `POSTGRES_SCRAM_SHA_256`, `POSTGRES_MD5`, and `SQL_SERVER_AUTHENTICATION`.
        :param _builtins.str description: A user-specified description about the authentication used by a proxy to log in as a specific database user.
        :param _builtins.str iam_auth: Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. One of `DISABLED`, `REQUIRED`.
        :param _builtins.str secret_arn: The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
        :param _builtins.str username: The name of the database user to which the proxy connects.
        """
        if auth_scheme is not None:
            pulumi.set(__self__, "auth_scheme", auth_scheme)
        if client_password_auth_type is not None:
            pulumi.set(__self__, "client_password_auth_type", client_password_auth_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if iam_auth is not None:
            pulumi.set(__self__, "iam_auth", iam_auth)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="authScheme")
    def auth_scheme(self) -> Optional[_builtins.str]:
        """
        The type of authentication that the proxy uses for connections from the proxy to the underlying database. One of `SECRETS`.
        """
        return pulumi.get(self, "auth_scheme")

    @_builtins.property
    @pulumi.getter(name="clientPasswordAuthType")
    def client_password_auth_type(self) -> Optional[_builtins.str]:
        """
        The type of authentication the proxy uses for connections from clients. Valid values are `MYSQL_CACHING_SHA2_PASSWORD`, `MYSQL_NATIVE_PASSWORD`, `POSTGRES_SCRAM_SHA_256`, `POSTGRES_MD5`, and `SQL_SERVER_AUTHENTICATION`.
        """
        return pulumi.get(self, "client_password_auth_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A user-specified description about the authentication used by a proxy to log in as a specific database user.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="iamAuth")
    def iam_auth(self) -> Optional[_builtins.str]:
        """
        Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. One of `DISABLED`, `REQUIRED`.
        """
        return pulumi.get(self, "iam_auth")

    @_builtins.property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
        """
        return pulumi.get(self, "secret_arn")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The name of the database user to which the proxy connects.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ProxyDefaultTargetGroupConnectionPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionBorrowTimeout":
            suggest = "connection_borrow_timeout"
        elif key == "initQuery":
            suggest = "init_query"
        elif key == "maxConnectionsPercent":
            suggest = "max_connections_percent"
        elif key == "maxIdleConnectionsPercent":
            suggest = "max_idle_connections_percent"
        elif key == "sessionPinningFilters":
            suggest = "session_pinning_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProxyDefaultTargetGroupConnectionPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProxyDefaultTargetGroupConnectionPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProxyDefaultTargetGroupConnectionPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_borrow_timeout: Optional[_builtins.int] = None,
                 init_query: Optional[_builtins.str] = None,
                 max_connections_percent: Optional[_builtins.int] = None,
                 max_idle_connections_percent: Optional[_builtins.int] = None,
                 session_pinning_filters: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int connection_borrow_timeout: The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
        :param _builtins.str init_query: One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
        :param _builtins.int max_connections_percent: The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        :param _builtins.int max_idle_connections_percent: Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        :param Sequence[_builtins.str] session_pinning_filters: Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
        """
        if connection_borrow_timeout is not None:
            pulumi.set(__self__, "connection_borrow_timeout", connection_borrow_timeout)
        if init_query is not None:
            pulumi.set(__self__, "init_query", init_query)
        if max_connections_percent is not None:
            pulumi.set(__self__, "max_connections_percent", max_connections_percent)
        if max_idle_connections_percent is not None:
            pulumi.set(__self__, "max_idle_connections_percent", max_idle_connections_percent)
        if session_pinning_filters is not None:
            pulumi.set(__self__, "session_pinning_filters", session_pinning_filters)

    @_builtins.property
    @pulumi.getter(name="connectionBorrowTimeout")
    def connection_borrow_timeout(self) -> Optional[_builtins.int]:
        """
        The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
        """
        return pulumi.get(self, "connection_borrow_timeout")

    @_builtins.property
    @pulumi.getter(name="initQuery")
    def init_query(self) -> Optional[_builtins.str]:
        """
        One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
        """
        return pulumi.get(self, "init_query")

    @_builtins.property
    @pulumi.getter(name="maxConnectionsPercent")
    def max_connections_percent(self) -> Optional[_builtins.int]:
        """
        The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        """
        return pulumi.get(self, "max_connections_percent")

    @_builtins.property
    @pulumi.getter(name="maxIdleConnectionsPercent")
    def max_idle_connections_percent(self) -> Optional[_builtins.int]:
        """
        Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
        """
        return pulumi.get(self, "max_idle_connections_percent")

    @_builtins.property
    @pulumi.getter(name="sessionPinningFilters")
    def session_pinning_filters(self) -> Optional[Sequence[_builtins.str]]:
        """
        Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
        """
        return pulumi.get(self, "session_pinning_filters")


@pulumi.output_type
class ReservedInstanceRecurringCharge(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recurringChargeAmount":
            suggest = "recurring_charge_amount"
        elif key == "recurringChargeFrequency":
            suggest = "recurring_charge_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReservedInstanceRecurringCharge. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReservedInstanceRecurringCharge.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReservedInstanceRecurringCharge.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recurring_charge_amount: Optional[_builtins.int] = None,
                 recurring_charge_frequency: Optional[_builtins.str] = None):
        if recurring_charge_amount is not None:
            pulumi.set(__self__, "recurring_charge_amount", recurring_charge_amount)
        if recurring_charge_frequency is not None:
            pulumi.set(__self__, "recurring_charge_frequency", recurring_charge_frequency)

    @_builtins.property
    @pulumi.getter(name="recurringChargeAmount")
    def recurring_charge_amount(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "recurring_charge_amount")

    @_builtins.property
    @pulumi.getter(name="recurringChargeFrequency")
    def recurring_charge_frequency(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "recurring_charge_frequency")


@pulumi.output_type
class ShardGroupTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class GetClusterMasterUserSecretResult(dict):
    def __init__(__self__, *,
                 kms_key_id: _builtins.str,
                 secret_arn: _builtins.str,
                 secret_status: _builtins.str):
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "secret_arn", secret_arn)
        pulumi.set(__self__, "secret_status", secret_status)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> _builtins.str:
        return pulumi.get(self, "secret_arn")

    @_builtins.property
    @pulumi.getter(name="secretStatus")
    def secret_status(self) -> _builtins.str:
        return pulumi.get(self, "secret_status")


@pulumi.output_type
class GetClustersFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html).
        :param Sequence[_builtins.str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetEngineVersionFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class GetInstanceMasterUserSecretResult(dict):
    def __init__(__self__, *,
                 kms_key_id: _builtins.str,
                 secret_arn: _builtins.str,
                 secret_status: _builtins.str):
        """
        :param _builtins.str kms_key_id: The Amazon Web Services KMS key identifier that is used to encrypt the secret.
        :param _builtins.str secret_arn: The Amazon Resource Name (ARN) of the secret.
        :param _builtins.str secret_status: The status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "secret_arn", secret_arn)
        pulumi.set(__self__, "secret_status", secret_status)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        The Amazon Web Services KMS key identifier that is used to encrypt the secret.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) of the secret.
        """
        return pulumi.get(self, "secret_arn")

    @_builtins.property
    @pulumi.getter(name="secretStatus")
    def secret_status(self) -> _builtins.str:
        """
        The status of the secret. Valid Values: `creating` | `active` | `rotating` | `impaired`.
        """
        return pulumi.get(self, "secret_status")


@pulumi.output_type
class GetInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html) or [RDS DescribeDBInstances API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html).
        :param Sequence[_builtins.str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the filter field. Valid values can be found in the [RDS DescribeDBClusters API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBClusters.html) or [RDS DescribeDBInstances API Reference](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBInstances.html).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetProxyAuthResult(dict):
    def __init__(__self__, *,
                 auth_scheme: _builtins.str,
                 client_password_auth_type: _builtins.str,
                 description: _builtins.str,
                 iam_auth: _builtins.str,
                 secret_arn: _builtins.str,
                 username: _builtins.str):
        pulumi.set(__self__, "auth_scheme", auth_scheme)
        pulumi.set(__self__, "client_password_auth_type", client_password_auth_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "iam_auth", iam_auth)
        pulumi.set(__self__, "secret_arn", secret_arn)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="authScheme")
    def auth_scheme(self) -> _builtins.str:
        return pulumi.get(self, "auth_scheme")

    @_builtins.property
    @pulumi.getter(name="clientPasswordAuthType")
    def client_password_auth_type(self) -> _builtins.str:
        return pulumi.get(self, "client_password_auth_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="iamAuth")
    def iam_auth(self) -> _builtins.str:
        return pulumi.get(self, "iam_auth")

    @_builtins.property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> _builtins.str:
        return pulumi.get(self, "secret_arn")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        return pulumi.get(self, "username")


