# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProxyDefaultTargetGroupArgs', 'ProxyDefaultTargetGroup']

@pulumi.input_type
class ProxyDefaultTargetGroupArgs:
    def __init__(__self__, *,
                 db_proxy_name: pulumi.Input[_builtins.str],
                 connection_pool_config: Optional[pulumi.Input['ProxyDefaultTargetGroupConnectionPoolConfigArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProxyDefaultTargetGroup resource.
        :param pulumi.Input[_builtins.str] db_proxy_name: Name of the RDS DB Proxy.
        :param pulumi.Input['ProxyDefaultTargetGroupConnectionPoolConfigArgs'] connection_pool_config: The settings that determine the size and behavior of the connection pool for the target group.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "db_proxy_name", db_proxy_name)
        if connection_pool_config is not None:
            pulumi.set(__self__, "connection_pool_config", connection_pool_config)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="dbProxyName")
    def db_proxy_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the RDS DB Proxy.
        """
        return pulumi.get(self, "db_proxy_name")

    @db_proxy_name.setter
    def db_proxy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_proxy_name", value)

    @_builtins.property
    @pulumi.getter(name="connectionPoolConfig")
    def connection_pool_config(self) -> Optional[pulumi.Input['ProxyDefaultTargetGroupConnectionPoolConfigArgs']]:
        """
        The settings that determine the size and behavior of the connection pool for the target group.
        """
        return pulumi.get(self, "connection_pool_config")

    @connection_pool_config.setter
    def connection_pool_config(self, value: Optional[pulumi.Input['ProxyDefaultTargetGroupConnectionPoolConfigArgs']]):
        pulumi.set(self, "connection_pool_config", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ProxyDefaultTargetGroupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_pool_config: Optional[pulumi.Input['ProxyDefaultTargetGroupConnectionPoolConfigArgs']] = None,
                 db_proxy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProxyDefaultTargetGroup resources.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) representing the target group.
        :param pulumi.Input['ProxyDefaultTargetGroupConnectionPoolConfigArgs'] connection_pool_config: The settings that determine the size and behavior of the connection pool for the target group.
        :param pulumi.Input[_builtins.str] db_proxy_name: Name of the RDS DB Proxy.
        :param pulumi.Input[_builtins.str] name: The name of the default target group.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if connection_pool_config is not None:
            pulumi.set(__self__, "connection_pool_config", connection_pool_config)
        if db_proxy_name is not None:
            pulumi.set(__self__, "db_proxy_name", db_proxy_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) representing the target group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="connectionPoolConfig")
    def connection_pool_config(self) -> Optional[pulumi.Input['ProxyDefaultTargetGroupConnectionPoolConfigArgs']]:
        """
        The settings that determine the size and behavior of the connection pool for the target group.
        """
        return pulumi.get(self, "connection_pool_config")

    @connection_pool_config.setter
    def connection_pool_config(self, value: Optional[pulumi.Input['ProxyDefaultTargetGroupConnectionPoolConfigArgs']]):
        pulumi.set(self, "connection_pool_config", value)

    @_builtins.property
    @pulumi.getter(name="dbProxyName")
    def db_proxy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the RDS DB Proxy.
        """
        return pulumi.get(self, "db_proxy_name")

    @db_proxy_name.setter
    def db_proxy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_proxy_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the default target group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:rds/proxyDefaultTargetGroup:ProxyDefaultTargetGroup")
class ProxyDefaultTargetGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_pool_config: Optional[pulumi.Input[Union['ProxyDefaultTargetGroupConnectionPoolConfigArgs', 'ProxyDefaultTargetGroupConnectionPoolConfigArgsDict']]] = None,
                 db_proxy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to manage an RDS DB proxy default target group resource.

        The `rds.ProxyDefaultTargetGroup` behaves differently from normal resources, in that the provider does not _create_ or _destroy_ this resource, since it implicitly exists as part of an RDS DB Proxy. On the provider resource creation it is automatically imported and on resource destruction, the provider performs no actions in RDS.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.Proxy("example",
            name="example",
            debug_logging=False,
            engine_family="MYSQL",
            idle_client_timeout=1800,
            require_tls=True,
            role_arn=example_aws_iam_role["arn"],
            vpc_security_group_ids=[example_aws_security_group["id"]],
            vpc_subnet_ids=[example_aws_subnet["id"]],
            auths=[{
                "auth_scheme": "SECRETS",
                "description": "example",
                "iam_auth": "DISABLED",
                "secret_arn": example_aws_secretsmanager_secret["arn"],
            }],
            tags={
                "Name": "example",
                "Key": "value",
            })
        example_proxy_default_target_group = aws.rds.ProxyDefaultTargetGroup("example",
            db_proxy_name=example.name,
            connection_pool_config={
                "connection_borrow_timeout": 120,
                "init_query": "SET x=1, y=2",
                "max_connections_percent": 100,
                "max_idle_connections_percent": 50,
                "session_pinning_filters": ["EXCLUDE_VARIABLE_SETS"],
            })
        ```

        ## Import

        Using `pulumi import`, import DB proxy default target groups using the `db_proxy_name`. For example:

        ```sh
        $ pulumi import aws:rds/proxyDefaultTargetGroup:ProxyDefaultTargetGroup example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProxyDefaultTargetGroupConnectionPoolConfigArgs', 'ProxyDefaultTargetGroupConnectionPoolConfigArgsDict']] connection_pool_config: The settings that determine the size and behavior of the connection pool for the target group.
        :param pulumi.Input[_builtins.str] db_proxy_name: Name of the RDS DB Proxy.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProxyDefaultTargetGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage an RDS DB proxy default target group resource.

        The `rds.ProxyDefaultTargetGroup` behaves differently from normal resources, in that the provider does not _create_ or _destroy_ this resource, since it implicitly exists as part of an RDS DB Proxy. On the provider resource creation it is automatically imported and on resource destruction, the provider performs no actions in RDS.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rds.Proxy("example",
            name="example",
            debug_logging=False,
            engine_family="MYSQL",
            idle_client_timeout=1800,
            require_tls=True,
            role_arn=example_aws_iam_role["arn"],
            vpc_security_group_ids=[example_aws_security_group["id"]],
            vpc_subnet_ids=[example_aws_subnet["id"]],
            auths=[{
                "auth_scheme": "SECRETS",
                "description": "example",
                "iam_auth": "DISABLED",
                "secret_arn": example_aws_secretsmanager_secret["arn"],
            }],
            tags={
                "Name": "example",
                "Key": "value",
            })
        example_proxy_default_target_group = aws.rds.ProxyDefaultTargetGroup("example",
            db_proxy_name=example.name,
            connection_pool_config={
                "connection_borrow_timeout": 120,
                "init_query": "SET x=1, y=2",
                "max_connections_percent": 100,
                "max_idle_connections_percent": 50,
                "session_pinning_filters": ["EXCLUDE_VARIABLE_SETS"],
            })
        ```

        ## Import

        Using `pulumi import`, import DB proxy default target groups using the `db_proxy_name`. For example:

        ```sh
        $ pulumi import aws:rds/proxyDefaultTargetGroup:ProxyDefaultTargetGroup example example
        ```

        :param str resource_name: The name of the resource.
        :param ProxyDefaultTargetGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProxyDefaultTargetGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_pool_config: Optional[pulumi.Input[Union['ProxyDefaultTargetGroupConnectionPoolConfigArgs', 'ProxyDefaultTargetGroupConnectionPoolConfigArgsDict']]] = None,
                 db_proxy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProxyDefaultTargetGroupArgs.__new__(ProxyDefaultTargetGroupArgs)

            __props__.__dict__["connection_pool_config"] = connection_pool_config
            if db_proxy_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_proxy_name'")
            __props__.__dict__["db_proxy_name"] = db_proxy_name
            __props__.__dict__["region"] = region
            __props__.__dict__["arn"] = None
            __props__.__dict__["name"] = None
        super(ProxyDefaultTargetGroup, __self__).__init__(
            'aws:rds/proxyDefaultTargetGroup:ProxyDefaultTargetGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            connection_pool_config: Optional[pulumi.Input[Union['ProxyDefaultTargetGroupConnectionPoolConfigArgs', 'ProxyDefaultTargetGroupConnectionPoolConfigArgsDict']]] = None,
            db_proxy_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProxyDefaultTargetGroup':
        """
        Get an existing ProxyDefaultTargetGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) representing the target group.
        :param pulumi.Input[Union['ProxyDefaultTargetGroupConnectionPoolConfigArgs', 'ProxyDefaultTargetGroupConnectionPoolConfigArgsDict']] connection_pool_config: The settings that determine the size and behavior of the connection pool for the target group.
        :param pulumi.Input[_builtins.str] db_proxy_name: Name of the RDS DB Proxy.
        :param pulumi.Input[_builtins.str] name: The name of the default target group.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProxyDefaultTargetGroupState.__new__(_ProxyDefaultTargetGroupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["connection_pool_config"] = connection_pool_config
        __props__.__dict__["db_proxy_name"] = db_proxy_name
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return ProxyDefaultTargetGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) representing the target group.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="connectionPoolConfig")
    def connection_pool_config(self) -> pulumi.Output['outputs.ProxyDefaultTargetGroupConnectionPoolConfig']:
        """
        The settings that determine the size and behavior of the connection pool for the target group.
        """
        return pulumi.get(self, "connection_pool_config")

    @_builtins.property
    @pulumi.getter(name="dbProxyName")
    def db_proxy_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the RDS DB Proxy.
        """
        return pulumi.get(self, "db_proxy_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the default target group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

