# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SnapshotArgs', 'Snapshot']

@pulumi.input_type
class SnapshotArgs:
    def __init__(__self__, *,
                 namespace_name: pulumi.Input[_builtins.str],
                 snapshot_name: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Snapshot resource.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace to create a snapshot for.
        :param pulumi.Input[_builtins.str] snapshot_name: The name of the snapshot.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] retention_period: How long to retain the created snapshot. Default value is `-1`.
        """
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "snapshot_name", snapshot_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Input[_builtins.str]:
        """
        The namespace to create a snapshot for.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "snapshot_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long to retain the created snapshot. Default value is `-1`.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period", value)


@pulumi.input_type
class _SnapshotState:
    def __init__(__self__, *,
                 accounts_with_provisioned_restore_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 accounts_with_restore_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 admin_username: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_account: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Snapshot resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] accounts_with_provisioned_restore_accesses: All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] accounts_with_restore_accesses: All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
        :param pulumi.Input[_builtins.str] admin_username: The username of the database within a snapshot.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the snapshot.
        :param pulumi.Input[_builtins.str] kms_key_id: The unique identifier of the KMS key used to encrypt the snapshot.
        :param pulumi.Input[_builtins.str] namespace_arn: The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace to create a snapshot for.
        :param pulumi.Input[_builtins.str] owner_account: The owner Amazon Web Services; account of the snapshot.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] retention_period: How long to retain the created snapshot. Default value is `-1`.
        :param pulumi.Input[_builtins.str] snapshot_name: The name of the snapshot.
        """
        if accounts_with_provisioned_restore_accesses is not None:
            pulumi.set(__self__, "accounts_with_provisioned_restore_accesses", accounts_with_provisioned_restore_accesses)
        if accounts_with_restore_accesses is not None:
            pulumi.set(__self__, "accounts_with_restore_accesses", accounts_with_restore_accesses)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if namespace_arn is not None:
            pulumi.set(__self__, "namespace_arn", namespace_arn)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if owner_account is not None:
            pulumi.set(__self__, "owner_account", owner_account)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)

    @_builtins.property
    @pulumi.getter(name="accountsWithProvisionedRestoreAccesses")
    def accounts_with_provisioned_restore_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
        """
        return pulumi.get(self, "accounts_with_provisioned_restore_accesses")

    @accounts_with_provisioned_restore_accesses.setter
    def accounts_with_provisioned_restore_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "accounts_with_provisioned_restore_accesses", value)

    @_builtins.property
    @pulumi.getter(name="accountsWithRestoreAccesses")
    def accounts_with_restore_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
        """
        return pulumi.get(self, "accounts_with_restore_accesses")

    @accounts_with_restore_accesses.setter
    def accounts_with_restore_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "accounts_with_restore_accesses", value)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the database within a snapshot.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_username", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the snapshot.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier of the KMS key used to encrypt the snapshot.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="namespaceArn")
    def namespace_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
        """
        return pulumi.get(self, "namespace_arn")

    @namespace_arn.setter
    def namespace_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_arn", value)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace to create a snapshot for.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter(name="ownerAccount")
    def owner_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owner Amazon Web Services; account of the snapshot.
        """
        return pulumi.get(self, "owner_account")

    @owner_account.setter
    def owner_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_account", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        How long to retain the created snapshot. Default value is `-1`.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period", value)

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_name", value)


@pulumi.type_token("aws:redshiftserverless/snapshot:Snapshot")
class Snapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a new Amazon Redshift Serverless Snapshot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshiftserverless.Snapshot("example",
            namespace_name=example_aws_redshiftserverless_workgroup["namespaceName"],
            snapshot_name="example")
        ```

        ## Import

        Using `pulumi import`, import Redshift Serverless Snapshots using the `snapshot_name`. For example:

        ```sh
        $ pulumi import aws:redshiftserverless/snapshot:Snapshot example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace to create a snapshot for.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] retention_period: How long to retain the created snapshot. Default value is `-1`.
        :param pulumi.Input[_builtins.str] snapshot_name: The name of the snapshot.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Amazon Redshift Serverless Snapshot.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshiftserverless.Snapshot("example",
            namespace_name=example_aws_redshiftserverless_workgroup["namespaceName"],
            snapshot_name="example")
        ```

        ## Import

        Using `pulumi import`, import Redshift Serverless Snapshots using the `snapshot_name`. For example:

        ```sh
        $ pulumi import aws:redshiftserverless/snapshot:Snapshot example example
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotArgs.__new__(SnapshotArgs)

            if namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_name'")
            __props__.__dict__["namespace_name"] = namespace_name
            __props__.__dict__["region"] = region
            __props__.__dict__["retention_period"] = retention_period
            if snapshot_name is None and not opts.urn:
                raise TypeError("Missing required property 'snapshot_name'")
            __props__.__dict__["snapshot_name"] = snapshot_name
            __props__.__dict__["accounts_with_provisioned_restore_accesses"] = None
            __props__.__dict__["accounts_with_restore_accesses"] = None
            __props__.__dict__["admin_username"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["kms_key_id"] = None
            __props__.__dict__["namespace_arn"] = None
            __props__.__dict__["owner_account"] = None
        super(Snapshot, __self__).__init__(
            'aws:redshiftserverless/snapshot:Snapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accounts_with_provisioned_restore_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            accounts_with_restore_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            admin_username: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_arn: Optional[pulumi.Input[_builtins.str]] = None,
            namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_account: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Snapshot':
        """
        Get an existing Snapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] accounts_with_provisioned_restore_accesses: All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] accounts_with_restore_accesses: All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
        :param pulumi.Input[_builtins.str] admin_username: The username of the database within a snapshot.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) of the snapshot.
        :param pulumi.Input[_builtins.str] kms_key_id: The unique identifier of the KMS key used to encrypt the snapshot.
        :param pulumi.Input[_builtins.str] namespace_arn: The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
        :param pulumi.Input[_builtins.str] namespace_name: The namespace to create a snapshot for.
        :param pulumi.Input[_builtins.str] owner_account: The owner Amazon Web Services; account of the snapshot.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] retention_period: How long to retain the created snapshot. Default value is `-1`.
        :param pulumi.Input[_builtins.str] snapshot_name: The name of the snapshot.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotState.__new__(_SnapshotState)

        __props__.__dict__["accounts_with_provisioned_restore_accesses"] = accounts_with_provisioned_restore_accesses
        __props__.__dict__["accounts_with_restore_accesses"] = accounts_with_restore_accesses
        __props__.__dict__["admin_username"] = admin_username
        __props__.__dict__["arn"] = arn
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["namespace_arn"] = namespace_arn
        __props__.__dict__["namespace_name"] = namespace_name
        __props__.__dict__["owner_account"] = owner_account
        __props__.__dict__["region"] = region
        __props__.__dict__["retention_period"] = retention_period
        __props__.__dict__["snapshot_name"] = snapshot_name
        return Snapshot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountsWithProvisionedRestoreAccesses")
    def accounts_with_provisioned_restore_accesses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
        """
        return pulumi.get(self, "accounts_with_provisioned_restore_accesses")

    @_builtins.property
    @pulumi.getter(name="accountsWithRestoreAccesses")
    def accounts_with_restore_accesses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
        """
        return pulumi.get(self, "accounts_with_restore_accesses")

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the database within a snapshot.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the snapshot.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier of the KMS key used to encrypt the snapshot.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="namespaceArn")
    def namespace_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
        """
        return pulumi.get(self, "namespace_arn")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[_builtins.str]:
        """
        The namespace to create a snapshot for.
        """
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter(name="ownerAccount")
    def owner_account(self) -> pulumi.Output[_builtins.str]:
        """
        The owner Amazon Web Services; account of the snapshot.
        """
        return pulumi.get(self, "owner_account")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        How long to retain the created snapshot. Default value is `-1`.
        """
        return pulumi.get(self, "retention_period")

    @_builtins.property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "snapshot_name")

