# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkgroupArgs', 'Workgroup']

@pulumi.input_type
class WorkgroupArgs:
    def __init__(__self__, *,
                 namespace_name: pulumi.Input[_builtins.str],
                 workgroup_name: pulumi.Input[_builtins.str],
                 base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 config_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 price_performance_target: Optional[pulumi.Input['WorkgroupPricePerformanceTargetArgs']] = None,
                 publicly_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 track_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Workgroup resource.
        :param pulumi.Input[_builtins.str] namespace_name: The name of the namespace.
        :param pulumi.Input[_builtins.str] workgroup_name: The name of the workgroup.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.int] base_capacity: The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
        :param pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]] config_parameters: An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
        :param pulumi.Input[_builtins.bool] enhanced_vpc_routing: The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
        :param pulumi.Input[_builtins.int] max_capacity: The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries, specified in Redshift Processing Units (RPUs).
        :param pulumi.Input[_builtins.int] port: The port number on which the cluster accepts incoming connections.
        :param pulumi.Input['WorkgroupPricePerformanceTargetArgs'] price_performance_target: Price-performance scaling for the workgroup. See `Price Performance Target` below.
        :param pulumi.Input[_builtins.bool] publicly_accessible: A value that specifies whether the workgroup can be accessed from a public network.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: An array of security group IDs to associate with the workgroup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] track_name: The name of the track for the workgroup. If it is `current`, you get the most up-to-date certified release version with the latest features, security updates, and performance enhancements. If it is `trailing`, you will be on the previous certified release. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/tracks.html).
        """
        pulumi.set(__self__, "namespace_name", namespace_name)
        pulumi.set(__self__, "workgroup_name", workgroup_name)
        if base_capacity is not None:
            pulumi.set(__self__, "base_capacity", base_capacity)
        if config_parameters is not None:
            pulumi.set(__self__, "config_parameters", config_parameters)
        if enhanced_vpc_routing is not None:
            pulumi.set(__self__, "enhanced_vpc_routing", enhanced_vpc_routing)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if price_performance_target is not None:
            pulumi.set(__self__, "price_performance_target", price_performance_target)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if track_name is not None:
            pulumi.set(__self__, "track_name", track_name)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the workgroup.

        The following arguments are optional:
        """
        return pulumi.get(self, "workgroup_name")

    @workgroup_name.setter
    def workgroup_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workgroup_name", value)

    @_builtins.property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
        """
        return pulumi.get(self, "base_capacity")

    @base_capacity.setter
    def base_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="configParameters")
    def config_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]]:
        """
        An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
        """
        return pulumi.get(self, "config_parameters")

    @config_parameters.setter
    def config_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]]):
        pulumi.set(self, "config_parameters", value)

    @_builtins.property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @enhanced_vpc_routing.setter
    def enhanced_vpc_routing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enhanced_vpc_routing", value)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries, specified in Redshift Processing Units (RPUs).
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_capacity", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number on which the cluster accepts incoming connections.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="pricePerformanceTarget")
    def price_performance_target(self) -> Optional[pulumi.Input['WorkgroupPricePerformanceTargetArgs']]:
        """
        Price-performance scaling for the workgroup. See `Price Performance Target` below.
        """
        return pulumi.get(self, "price_performance_target")

    @price_performance_target.setter
    def price_performance_target(self, value: Optional[pulumi.Input['WorkgroupPricePerformanceTargetArgs']]):
        pulumi.set(self, "price_performance_target", value)

    @_builtins.property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A value that specifies whether the workgroup can be accessed from a public network.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of security group IDs to associate with the workgroup.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trackName")
    def track_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the track for the workgroup. If it is `current`, you get the most up-to-date certified release version with the latest features, security updates, and performance enhancements. If it is `trailing`, you will be on the previous certified release. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/tracks.html).
        """
        return pulumi.get(self, "track_name")

    @track_name.setter
    def track_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "track_name", value)


@pulumi.input_type
class _WorkgroupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 config_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupEndpointArgs']]]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 price_performance_target: Optional[pulumi.Input['WorkgroupPricePerformanceTargetArgs']] = None,
                 publicly_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 track_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workgroup_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workgroup_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Workgroup resources.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the Redshift Serverless Workgroup.
        :param pulumi.Input[_builtins.int] base_capacity: The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
        :param pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]] config_parameters: An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
        :param pulumi.Input[Sequence[pulumi.Input['WorkgroupEndpointArgs']]] endpoints: The endpoint that is created from the workgroup. See `Endpoint` below.
        :param pulumi.Input[_builtins.bool] enhanced_vpc_routing: The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
        :param pulumi.Input[_builtins.int] max_capacity: The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries, specified in Redshift Processing Units (RPUs).
        :param pulumi.Input[_builtins.str] namespace_name: The name of the namespace.
        :param pulumi.Input[_builtins.int] port: The port number on which the cluster accepts incoming connections.
        :param pulumi.Input['WorkgroupPricePerformanceTargetArgs'] price_performance_target: Price-performance scaling for the workgroup. See `Price Performance Target` below.
        :param pulumi.Input[_builtins.bool] publicly_accessible: A value that specifies whether the workgroup can be accessed from a public network.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: An array of security group IDs to associate with the workgroup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] track_name: The name of the track for the workgroup. If it is `current`, you get the most up-to-date certified release version with the latest features, security updates, and performance enhancements. If it is `trailing`, you will be on the previous certified release. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/tracks.html).
        :param pulumi.Input[_builtins.str] workgroup_id: The Redshift Workgroup ID.
        :param pulumi.Input[_builtins.str] workgroup_name: The name of the workgroup.
               
               The following arguments are optional:
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if base_capacity is not None:
            pulumi.set(__self__, "base_capacity", base_capacity)
        if config_parameters is not None:
            pulumi.set(__self__, "config_parameters", config_parameters)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if enhanced_vpc_routing is not None:
            pulumi.set(__self__, "enhanced_vpc_routing", enhanced_vpc_routing)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if namespace_name is not None:
            pulumi.set(__self__, "namespace_name", namespace_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if price_performance_target is not None:
            pulumi.set(__self__, "price_performance_target", price_performance_target)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if track_name is not None:
            pulumi.set(__self__, "track_name", track_name)
        if workgroup_id is not None:
            pulumi.set(__self__, "workgroup_id", workgroup_id)
        if workgroup_name is not None:
            pulumi.set(__self__, "workgroup_name", workgroup_name)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the Redshift Serverless Workgroup.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
        """
        return pulumi.get(self, "base_capacity")

    @base_capacity.setter
    def base_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "base_capacity", value)

    @_builtins.property
    @pulumi.getter(name="configParameters")
    def config_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]]:
        """
        An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
        """
        return pulumi.get(self, "config_parameters")

    @config_parameters.setter
    def config_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupConfigParameterArgs']]]]):
        pulumi.set(self, "config_parameters", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupEndpointArgs']]]]:
        """
        The endpoint that is created from the workgroup. See `Endpoint` below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkgroupEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @enhanced_vpc_routing.setter
    def enhanced_vpc_routing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enhanced_vpc_routing", value)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries, specified in Redshift Processing Units (RPUs).
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_capacity", value)

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "namespace_name")

    @namespace_name.setter
    def namespace_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace_name", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number on which the cluster accepts incoming connections.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="pricePerformanceTarget")
    def price_performance_target(self) -> Optional[pulumi.Input['WorkgroupPricePerformanceTargetArgs']]:
        """
        Price-performance scaling for the workgroup. See `Price Performance Target` below.
        """
        return pulumi.get(self, "price_performance_target")

    @price_performance_target.setter
    def price_performance_target(self, value: Optional[pulumi.Input['WorkgroupPricePerformanceTargetArgs']]):
        pulumi.set(self, "price_performance_target", value)

    @_builtins.property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A value that specifies whether the workgroup can be accessed from a public network.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of security group IDs to associate with the workgroup.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="trackName")
    def track_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the track for the workgroup. If it is `current`, you get the most up-to-date certified release version with the latest features, security updates, and performance enhancements. If it is `trailing`, you will be on the previous certified release. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/tracks.html).
        """
        return pulumi.get(self, "track_name")

    @track_name.setter
    def track_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "track_name", value)

    @_builtins.property
    @pulumi.getter(name="workgroupId")
    def workgroup_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Redshift Workgroup ID.
        """
        return pulumi.get(self, "workgroup_id")

    @workgroup_id.setter
    def workgroup_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workgroup_id", value)

    @_builtins.property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the workgroup.

        The following arguments are optional:
        """
        return pulumi.get(self, "workgroup_name")

    @workgroup_name.setter
    def workgroup_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workgroup_name", value)


@pulumi.type_token("aws:redshiftserverless/workgroup:Workgroup")
class Workgroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 config_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkgroupConfigParameterArgs', 'WorkgroupConfigParameterArgsDict']]]]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 price_performance_target: Optional[pulumi.Input[Union['WorkgroupPricePerformanceTargetArgs', 'WorkgroupPricePerformanceTargetArgsDict']]] = None,
                 publicly_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 track_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workgroup_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a new Amazon Redshift Serverless Workgroup.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshiftserverless.Workgroup("example",
            namespace_name="concurrency-scaling",
            workgroup_name="concurrency-scaling")
        ```

        ## Import

        Using `pulumi import`, import Redshift Serverless Workgroups using the `workgroup_name`. For example:

        ```sh
        $ pulumi import aws:redshiftserverless/workgroup:Workgroup example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] base_capacity: The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkgroupConfigParameterArgs', 'WorkgroupConfigParameterArgsDict']]]] config_parameters: An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
        :param pulumi.Input[_builtins.bool] enhanced_vpc_routing: The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
        :param pulumi.Input[_builtins.int] max_capacity: The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries, specified in Redshift Processing Units (RPUs).
        :param pulumi.Input[_builtins.str] namespace_name: The name of the namespace.
        :param pulumi.Input[_builtins.int] port: The port number on which the cluster accepts incoming connections.
        :param pulumi.Input[Union['WorkgroupPricePerformanceTargetArgs', 'WorkgroupPricePerformanceTargetArgsDict']] price_performance_target: Price-performance scaling for the workgroup. See `Price Performance Target` below.
        :param pulumi.Input[_builtins.bool] publicly_accessible: A value that specifies whether the workgroup can be accessed from a public network.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: An array of security group IDs to associate with the workgroup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] track_name: The name of the track for the workgroup. If it is `current`, you get the most up-to-date certified release version with the latest features, security updates, and performance enhancements. If it is `trailing`, you will be on the previous certified release. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/tracks.html).
        :param pulumi.Input[_builtins.str] workgroup_name: The name of the workgroup.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkgroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Amazon Redshift Serverless Workgroup.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.redshiftserverless.Workgroup("example",
            namespace_name="concurrency-scaling",
            workgroup_name="concurrency-scaling")
        ```

        ## Import

        Using `pulumi import`, import Redshift Serverless Workgroups using the `workgroup_name`. For example:

        ```sh
        $ pulumi import aws:redshiftserverless/workgroup:Workgroup example example
        ```

        :param str resource_name: The name of the resource.
        :param WorkgroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkgroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 config_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkgroupConfigParameterArgs', 'WorkgroupConfigParameterArgsDict']]]]] = None,
                 enhanced_vpc_routing: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 price_performance_target: Optional[pulumi.Input[Union['WorkgroupPricePerformanceTargetArgs', 'WorkgroupPricePerformanceTargetArgsDict']]] = None,
                 publicly_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 track_name: Optional[pulumi.Input[_builtins.str]] = None,
                 workgroup_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkgroupArgs.__new__(WorkgroupArgs)

            __props__.__dict__["base_capacity"] = base_capacity
            __props__.__dict__["config_parameters"] = config_parameters
            __props__.__dict__["enhanced_vpc_routing"] = enhanced_vpc_routing
            __props__.__dict__["max_capacity"] = max_capacity
            if namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_name'")
            __props__.__dict__["namespace_name"] = namespace_name
            __props__.__dict__["port"] = port
            __props__.__dict__["price_performance_target"] = price_performance_target
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["track_name"] = track_name
            if workgroup_name is None and not opts.urn:
                raise TypeError("Missing required property 'workgroup_name'")
            __props__.__dict__["workgroup_name"] = workgroup_name
            __props__.__dict__["arn"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["workgroup_id"] = None
        super(Workgroup, __self__).__init__(
            'aws:redshiftserverless/workgroup:Workgroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            base_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            config_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkgroupConfigParameterArgs', 'WorkgroupConfigParameterArgsDict']]]]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkgroupEndpointArgs', 'WorkgroupEndpointArgsDict']]]]] = None,
            enhanced_vpc_routing: Optional[pulumi.Input[_builtins.bool]] = None,
            max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            namespace_name: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            price_performance_target: Optional[pulumi.Input[Union['WorkgroupPricePerformanceTargetArgs', 'WorkgroupPricePerformanceTargetArgsDict']]] = None,
            publicly_accessible: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            track_name: Optional[pulumi.Input[_builtins.str]] = None,
            workgroup_id: Optional[pulumi.Input[_builtins.str]] = None,
            workgroup_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Workgroup':
        """
        Get an existing Workgroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the Redshift Serverless Workgroup.
        :param pulumi.Input[_builtins.int] base_capacity: The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkgroupConfigParameterArgs', 'WorkgroupConfigParameterArgsDict']]]] config_parameters: An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkgroupEndpointArgs', 'WorkgroupEndpointArgsDict']]]] endpoints: The endpoint that is created from the workgroup. See `Endpoint` below.
        :param pulumi.Input[_builtins.bool] enhanced_vpc_routing: The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
        :param pulumi.Input[_builtins.int] max_capacity: The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries, specified in Redshift Processing Units (RPUs).
        :param pulumi.Input[_builtins.str] namespace_name: The name of the namespace.
        :param pulumi.Input[_builtins.int] port: The port number on which the cluster accepts incoming connections.
        :param pulumi.Input[Union['WorkgroupPricePerformanceTargetArgs', 'WorkgroupPricePerformanceTargetArgsDict']] price_performance_target: Price-performance scaling for the workgroup. See `Price Performance Target` below.
        :param pulumi.Input[_builtins.bool] publicly_accessible: A value that specifies whether the workgroup can be accessed from a public network.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: An array of security group IDs to associate with the workgroup.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] track_name: The name of the track for the workgroup. If it is `current`, you get the most up-to-date certified release version with the latest features, security updates, and performance enhancements. If it is `trailing`, you will be on the previous certified release. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/tracks.html).
        :param pulumi.Input[_builtins.str] workgroup_id: The Redshift Workgroup ID.
        :param pulumi.Input[_builtins.str] workgroup_name: The name of the workgroup.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkgroupState.__new__(_WorkgroupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["base_capacity"] = base_capacity
        __props__.__dict__["config_parameters"] = config_parameters
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["enhanced_vpc_routing"] = enhanced_vpc_routing
        __props__.__dict__["max_capacity"] = max_capacity
        __props__.__dict__["namespace_name"] = namespace_name
        __props__.__dict__["port"] = port
        __props__.__dict__["price_performance_target"] = price_performance_target
        __props__.__dict__["publicly_accessible"] = publicly_accessible
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["track_name"] = track_name
        __props__.__dict__["workgroup_id"] = workgroup_id
        __props__.__dict__["workgroup_name"] = workgroup_name
        return Workgroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the Redshift Serverless Workgroup.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="baseCapacity")
    def base_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
        """
        return pulumi.get(self, "base_capacity")

    @_builtins.property
    @pulumi.getter(name="configParameters")
    def config_parameters(self) -> pulumi.Output[Sequence['outputs.WorkgroupConfigParameter']]:
        """
        An array of parameters to set for more control over a serverless database. See `Config Parameter` below.
        """
        return pulumi.get(self, "config_parameters")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.WorkgroupEndpoint']]:
        """
        The endpoint that is created from the workgroup. See `Endpoint` below.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="enhancedVpcRouting")
    def enhanced_vpc_routing(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.
        """
        return pulumi.get(self, "enhanced_vpc_routing")

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries, specified in Redshift Processing Units (RPUs).
        """
        return pulumi.get(self, "max_capacity")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the namespace.
        """
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The port number on which the cluster accepts incoming connections.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="pricePerformanceTarget")
    def price_performance_target(self) -> pulumi.Output['outputs.WorkgroupPricePerformanceTarget']:
        """
        Price-performance scaling for the workgroup. See `Price Performance Target` below.
        """
        return pulumi.get(self, "price_performance_target")

    @_builtins.property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A value that specifies whether the workgroup can be accessed from a public network.
        """
        return pulumi.get(self, "publicly_accessible")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An array of security group IDs to associate with the workgroup.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An array of VPC subnet IDs to associate with the workgroup. When set, must contain at least three subnets spanning three Availability Zones. A minimum number of IP addresses is required and scales with the Base Capacity. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-known-issues.html).
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="trackName")
    def track_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the track for the workgroup. If it is `current`, you get the most up-to-date certified release version with the latest features, security updates, and performance enhancements. If it is `trailing`, you will be on the previous certified release. For more information, see the following [AWS document](https://docs.aws.amazon.com/redshift/latest/mgmt/tracks.html).
        """
        return pulumi.get(self, "track_name")

    @_builtins.property
    @pulumi.getter(name="workgroupId")
    def workgroup_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Redshift Workgroup ID.
        """
        return pulumi.get(self, "workgroup_id")

    @_builtins.property
    @pulumi.getter(name="workgroupName")
    def workgroup_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the workgroup.

        The following arguments are optional:
        """
        return pulumi.get(self, "workgroup_name")

