# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamProcessorArgs', 'StreamProcessor']

@pulumi.input_type
class StreamProcessorArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[_builtins.str],
                 data_sharing_preference: Optional[pulumi.Input['StreamProcessorDataSharingPreferenceArgs']] = None,
                 input: Optional[pulumi.Input['StreamProcessorInputArgs']] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_channel: Optional[pulumi.Input['StreamProcessorNotificationChannelArgs']] = None,
                 output: Optional[pulumi.Input['StreamProcessorOutputArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 regions_of_interests: Optional[pulumi.Input[Sequence[pulumi.Input['StreamProcessorRegionsOfInterestArgs']]]] = None,
                 settings: Optional[pulumi.Input['StreamProcessorSettingsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['StreamProcessorTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a StreamProcessor resource.
        :param pulumi.Input[_builtins.str] role_arn: The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.
        :param pulumi.Input['StreamProcessorDataSharingPreferenceArgs'] data_sharing_preference: See `data_sharing_preference`.
        :param pulumi.Input['StreamProcessorInputArgs'] input: Input video stream. See `input`.
        :param pulumi.Input[_builtins.str] kms_key_id: Optional parameter for label detection stream processors.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Processor.
        :param pulumi.Input['StreamProcessorNotificationChannelArgs'] notification_channel: The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status. See `notification_channel`.
        :param pulumi.Input['StreamProcessorOutputArgs'] output: Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. See `output`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['StreamProcessorRegionsOfInterestArgs']]] regions_of_interests: Specifies locations in the frames where Amazon Rekognition checks for objects or people. See `regions_of_interest`.
        :param pulumi.Input['StreamProcessorSettingsArgs'] settings: Input parameters used in a streaming video analyzed by a stream processor. See `settings`.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if data_sharing_preference is not None:
            pulumi.set(__self__, "data_sharing_preference", data_sharing_preference)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_channel is not None:
            pulumi.set(__self__, "notification_channel", notification_channel)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if regions_of_interests is not None:
            pulumi.set(__self__, "regions_of_interests", regions_of_interests)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter(name="dataSharingPreference")
    def data_sharing_preference(self) -> Optional[pulumi.Input['StreamProcessorDataSharingPreferenceArgs']]:
        """
        See `data_sharing_preference`.
        """
        return pulumi.get(self, "data_sharing_preference")

    @data_sharing_preference.setter
    def data_sharing_preference(self, value: Optional[pulumi.Input['StreamProcessorDataSharingPreferenceArgs']]):
        pulumi.set(self, "data_sharing_preference", value)

    @_builtins.property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['StreamProcessorInputArgs']]:
        """
        Input video stream. See `input`.
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['StreamProcessorInputArgs']]):
        pulumi.set(self, "input", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional parameter for label detection stream processors.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Processor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationChannel")
    def notification_channel(self) -> Optional[pulumi.Input['StreamProcessorNotificationChannelArgs']]:
        """
        The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status. See `notification_channel`.
        """
        return pulumi.get(self, "notification_channel")

    @notification_channel.setter
    def notification_channel(self, value: Optional[pulumi.Input['StreamProcessorNotificationChannelArgs']]):
        pulumi.set(self, "notification_channel", value)

    @_builtins.property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input['StreamProcessorOutputArgs']]:
        """
        Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. See `output`.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input['StreamProcessorOutputArgs']]):
        pulumi.set(self, "output", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="regionsOfInterests")
    def regions_of_interests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StreamProcessorRegionsOfInterestArgs']]]]:
        """
        Specifies locations in the frames where Amazon Rekognition checks for objects or people. See `regions_of_interest`.
        """
        return pulumi.get(self, "regions_of_interests")

    @regions_of_interests.setter
    def regions_of_interests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StreamProcessorRegionsOfInterestArgs']]]]):
        pulumi.set(self, "regions_of_interests", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['StreamProcessorSettingsArgs']]:
        """
        Input parameters used in a streaming video analyzed by a stream processor. See `settings`.

        The following arguments are optional:
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['StreamProcessorSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['StreamProcessorTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['StreamProcessorTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _StreamProcessorState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 data_sharing_preference: Optional[pulumi.Input['StreamProcessorDataSharingPreferenceArgs']] = None,
                 input: Optional[pulumi.Input['StreamProcessorInputArgs']] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_channel: Optional[pulumi.Input['StreamProcessorNotificationChannelArgs']] = None,
                 output: Optional[pulumi.Input['StreamProcessorOutputArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 regions_of_interests: Optional[pulumi.Input[Sequence[pulumi.Input['StreamProcessorRegionsOfInterestArgs']]]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input['StreamProcessorSettingsArgs']] = None,
                 stream_processor_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['StreamProcessorTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering StreamProcessor resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the Stream Processor.
        :param pulumi.Input['StreamProcessorDataSharingPreferenceArgs'] data_sharing_preference: See `data_sharing_preference`.
        :param pulumi.Input['StreamProcessorInputArgs'] input: Input video stream. See `input`.
        :param pulumi.Input[_builtins.str] kms_key_id: Optional parameter for label detection stream processors.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Processor.
        :param pulumi.Input['StreamProcessorNotificationChannelArgs'] notification_channel: The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status. See `notification_channel`.
        :param pulumi.Input['StreamProcessorOutputArgs'] output: Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. See `output`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['StreamProcessorRegionsOfInterestArgs']]] regions_of_interests: Specifies locations in the frames where Amazon Rekognition checks for objects or people. See `regions_of_interest`.
        :param pulumi.Input[_builtins.str] role_arn: The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.
        :param pulumi.Input['StreamProcessorSettingsArgs'] settings: Input parameters used in a streaming video analyzed by a stream processor. See `settings`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] stream_processor_arn: (**Deprecated**) ARN of the Stream Processor.
               Use `arn` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if data_sharing_preference is not None:
            pulumi.set(__self__, "data_sharing_preference", data_sharing_preference)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_channel is not None:
            pulumi.set(__self__, "notification_channel", notification_channel)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if regions_of_interests is not None:
            pulumi.set(__self__, "regions_of_interests", regions_of_interests)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if stream_processor_arn is not None:
            warnings.warn("""Use 'arn' instead. This attribute will be removed in a future version of the provider.""", DeprecationWarning)
            pulumi.log.warn("""stream_processor_arn is deprecated: Use 'arn' instead. This attribute will be removed in a future version of the provider.""")
        if stream_processor_arn is not None:
            pulumi.set(__self__, "stream_processor_arn", stream_processor_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Stream Processor.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="dataSharingPreference")
    def data_sharing_preference(self) -> Optional[pulumi.Input['StreamProcessorDataSharingPreferenceArgs']]:
        """
        See `data_sharing_preference`.
        """
        return pulumi.get(self, "data_sharing_preference")

    @data_sharing_preference.setter
    def data_sharing_preference(self, value: Optional[pulumi.Input['StreamProcessorDataSharingPreferenceArgs']]):
        pulumi.set(self, "data_sharing_preference", value)

    @_builtins.property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input['StreamProcessorInputArgs']]:
        """
        Input video stream. See `input`.
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input['StreamProcessorInputArgs']]):
        pulumi.set(self, "input", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional parameter for label detection stream processors.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Processor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationChannel")
    def notification_channel(self) -> Optional[pulumi.Input['StreamProcessorNotificationChannelArgs']]:
        """
        The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status. See `notification_channel`.
        """
        return pulumi.get(self, "notification_channel")

    @notification_channel.setter
    def notification_channel(self, value: Optional[pulumi.Input['StreamProcessorNotificationChannelArgs']]):
        pulumi.set(self, "notification_channel", value)

    @_builtins.property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input['StreamProcessorOutputArgs']]:
        """
        Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. See `output`.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input['StreamProcessorOutputArgs']]):
        pulumi.set(self, "output", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="regionsOfInterests")
    def regions_of_interests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StreamProcessorRegionsOfInterestArgs']]]]:
        """
        Specifies locations in the frames where Amazon Rekognition checks for objects or people. See `regions_of_interest`.
        """
        return pulumi.get(self, "regions_of_interests")

    @regions_of_interests.setter
    def regions_of_interests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StreamProcessorRegionsOfInterestArgs']]]]):
        pulumi.set(self, "regions_of_interests", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['StreamProcessorSettingsArgs']]:
        """
        Input parameters used in a streaming video analyzed by a stream processor. See `settings`.

        The following arguments are optional:
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['StreamProcessorSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @_builtins.property
    @pulumi.getter(name="streamProcessorArn")
    @_utilities.deprecated("""Use 'arn' instead. This attribute will be removed in a future version of the provider.""")
    def stream_processor_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (**Deprecated**) ARN of the Stream Processor.
        Use `arn` instead.
        """
        return pulumi.get(self, "stream_processor_arn")

    @stream_processor_arn.setter
    def stream_processor_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_processor_arn", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['StreamProcessorTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['StreamProcessorTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:rekognition/streamProcessor:StreamProcessor")
class StreamProcessor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_sharing_preference: Optional[pulumi.Input[Union['StreamProcessorDataSharingPreferenceArgs', 'StreamProcessorDataSharingPreferenceArgsDict']]] = None,
                 input: Optional[pulumi.Input[Union['StreamProcessorInputArgs', 'StreamProcessorInputArgsDict']]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_channel: Optional[pulumi.Input[Union['StreamProcessorNotificationChannelArgs', 'StreamProcessorNotificationChannelArgsDict']]] = None,
                 output: Optional[pulumi.Input[Union['StreamProcessorOutputArgs', 'StreamProcessorOutputArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 regions_of_interests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamProcessorRegionsOfInterestArgs', 'StreamProcessorRegionsOfInterestArgsDict']]]]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['StreamProcessorSettingsArgs', 'StreamProcessorSettingsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['StreamProcessorTimeoutsArgs', 'StreamProcessorTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Rekognition Stream Processor.

        > This resource must be configured specifically for your use case, and not all options are compatible with one another. See [Stream Processor API documentation](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor.html#rekognition-CreateStreamProcessor-request-Input) for configuration information.

        > Stream Processors configured for Face Recognition cannot have _any_ properties updated after the fact, and it will result in an AWS API error.

        ## Example Usage

        ### Label Detection

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.s3.Bucket("example", bucket="example-bucket")
        example_topic = aws.sns.Topic("example", name="example-topic")
        example_video_stream = aws.kinesis.VideoStream("example",
            name="example-kinesis-input",
            data_retention_in_hours=1,
            device_name="kinesis-video-device-name",
            media_type="video/h264")
        example_role = aws.iam.Role("example",
            name="example-role",
            inline_policies=[{
                "name": "Rekognition-Access",
                "policy": pulumi.Output.json_dumps({
                    "Version": "2012-10-17",
                    "Statement": [
                        {
                            "Action": ["s3:PutObject"],
                            "Effect": "Allow",
                            "Resource": [example.arn.apply(lambda arn: f"{arn}/*")],
                        },
                        {
                            "Action": ["sns:Publish"],
                            "Effect": "Allow",
                            "Resource": [example_topic.arn],
                        },
                        {
                            "Action": [
                                "kinesis:Get*",
                                "kinesis:DescribeStreamSummary",
                            ],
                            "Effect": "Allow",
                            "Resource": [example_video_stream.arn],
                        },
                    ],
                }),
            }],
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "rekognition.amazonaws.com",
                    },
                }],
            }))
        example_stream_processor = aws.rekognition.StreamProcessor("example",
            role_arn=example_role.arn,
            name="example-processor",
            data_sharing_preference={
                "opt_in": False,
            },
            output={
                "s3_destination": {
                    "bucket": example.bucket,
                },
            },
            settings={
                "connected_home": {
                    "labels": [
                        "PERSON",
                        "PET",
                    ],
                },
            },
            input={
                "kinesis_video_stream": {
                    "arn": example_video_stream.arn,
                },
            },
            notification_channel={
                "sns_topic_arn": example_topic.arn,
            })
        ```

        ### Face Detection Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.kinesis.VideoStream("example",
            name="example-kinesis-input",
            data_retention_in_hours=1,
            device_name="kinesis-video-device-name",
            media_type="video/h264")
        example_stream = aws.kinesis.Stream("example",
            name="pulumi-kinesis-example",
            shard_count=1)
        example_role = aws.iam.Role("example",
            name="example-role",
            inline_policies=[{
                "name": "Rekognition-Access",
                "policy": pulumi.Output.json_dumps({
                    "Version": "2012-10-17",
                    "Statement": [
                        {
                            "Action": [
                                "kinesis:Get*",
                                "kinesis:DescribeStreamSummary",
                            ],
                            "Effect": "Allow",
                            "Resource": [example.arn],
                        },
                        {
                            "Action": ["kinesis:PutRecord"],
                            "Effect": "Allow",
                            "Resource": [example_stream.arn],
                        },
                    ],
                }),
            }],
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "rekognition.amazonaws.com",
                    },
                }],
            }))
        example_collection = aws.rekognition.Collection("example", collection_id="example-collection")
        example_stream_processor = aws.rekognition.StreamProcessor("example",
            role_arn=example_role.arn,
            name="example-processor",
            data_sharing_preference={
                "opt_in": False,
            },
            regions_of_interests=[{
                "polygons": [
                    {
                        "x": 0.5,
                        "y": 0.5,
                    },
                    {
                        "x": 0.5,
                        "y": 0.5,
                    },
                    {
                        "x": 0.5,
                        "y": 0.5,
                    },
                ],
            }],
            input={
                "kinesis_video_stream": {
                    "arn": example.arn,
                },
            },
            output={
                "kinesis_data_stream": {
                    "arn": example_stream.arn,
                },
            },
            settings={
                "face_search": {
                    "collection_id": example_collection.id,
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Rekognition Stream Processor using the `name`. For example:

        ```sh
        $ pulumi import aws:rekognition/streamProcessor:StreamProcessor example my-stream
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['StreamProcessorDataSharingPreferenceArgs', 'StreamProcessorDataSharingPreferenceArgsDict']] data_sharing_preference: See `data_sharing_preference`.
        :param pulumi.Input[Union['StreamProcessorInputArgs', 'StreamProcessorInputArgsDict']] input: Input video stream. See `input`.
        :param pulumi.Input[_builtins.str] kms_key_id: Optional parameter for label detection stream processors.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Processor.
        :param pulumi.Input[Union['StreamProcessorNotificationChannelArgs', 'StreamProcessorNotificationChannelArgsDict']] notification_channel: The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status. See `notification_channel`.
        :param pulumi.Input[Union['StreamProcessorOutputArgs', 'StreamProcessorOutputArgsDict']] output: Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. See `output`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StreamProcessorRegionsOfInterestArgs', 'StreamProcessorRegionsOfInterestArgsDict']]]] regions_of_interests: Specifies locations in the frames where Amazon Rekognition checks for objects or people. See `regions_of_interest`.
        :param pulumi.Input[_builtins.str] role_arn: The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.
        :param pulumi.Input[Union['StreamProcessorSettingsArgs', 'StreamProcessorSettingsArgsDict']] settings: Input parameters used in a streaming video analyzed by a stream processor. See `settings`.
               
               The following arguments are optional:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamProcessorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Rekognition Stream Processor.

        > This resource must be configured specifically for your use case, and not all options are compatible with one another. See [Stream Processor API documentation](https://docs.aws.amazon.com/rekognition/latest/APIReference/API_CreateStreamProcessor.html#rekognition-CreateStreamProcessor-request-Input) for configuration information.

        > Stream Processors configured for Face Recognition cannot have _any_ properties updated after the fact, and it will result in an AWS API error.

        ## Example Usage

        ### Label Detection

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.s3.Bucket("example", bucket="example-bucket")
        example_topic = aws.sns.Topic("example", name="example-topic")
        example_video_stream = aws.kinesis.VideoStream("example",
            name="example-kinesis-input",
            data_retention_in_hours=1,
            device_name="kinesis-video-device-name",
            media_type="video/h264")
        example_role = aws.iam.Role("example",
            name="example-role",
            inline_policies=[{
                "name": "Rekognition-Access",
                "policy": pulumi.Output.json_dumps({
                    "Version": "2012-10-17",
                    "Statement": [
                        {
                            "Action": ["s3:PutObject"],
                            "Effect": "Allow",
                            "Resource": [example.arn.apply(lambda arn: f"{arn}/*")],
                        },
                        {
                            "Action": ["sns:Publish"],
                            "Effect": "Allow",
                            "Resource": [example_topic.arn],
                        },
                        {
                            "Action": [
                                "kinesis:Get*",
                                "kinesis:DescribeStreamSummary",
                            ],
                            "Effect": "Allow",
                            "Resource": [example_video_stream.arn],
                        },
                    ],
                }),
            }],
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "rekognition.amazonaws.com",
                    },
                }],
            }))
        example_stream_processor = aws.rekognition.StreamProcessor("example",
            role_arn=example_role.arn,
            name="example-processor",
            data_sharing_preference={
                "opt_in": False,
            },
            output={
                "s3_destination": {
                    "bucket": example.bucket,
                },
            },
            settings={
                "connected_home": {
                    "labels": [
                        "PERSON",
                        "PET",
                    ],
                },
            },
            input={
                "kinesis_video_stream": {
                    "arn": example_video_stream.arn,
                },
            },
            notification_channel={
                "sns_topic_arn": example_topic.arn,
            })
        ```

        ### Face Detection Usage

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.kinesis.VideoStream("example",
            name="example-kinesis-input",
            data_retention_in_hours=1,
            device_name="kinesis-video-device-name",
            media_type="video/h264")
        example_stream = aws.kinesis.Stream("example",
            name="pulumi-kinesis-example",
            shard_count=1)
        example_role = aws.iam.Role("example",
            name="example-role",
            inline_policies=[{
                "name": "Rekognition-Access",
                "policy": pulumi.Output.json_dumps({
                    "Version": "2012-10-17",
                    "Statement": [
                        {
                            "Action": [
                                "kinesis:Get*",
                                "kinesis:DescribeStreamSummary",
                            ],
                            "Effect": "Allow",
                            "Resource": [example.arn],
                        },
                        {
                            "Action": ["kinesis:PutRecord"],
                            "Effect": "Allow",
                            "Resource": [example_stream.arn],
                        },
                    ],
                }),
            }],
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "rekognition.amazonaws.com",
                    },
                }],
            }))
        example_collection = aws.rekognition.Collection("example", collection_id="example-collection")
        example_stream_processor = aws.rekognition.StreamProcessor("example",
            role_arn=example_role.arn,
            name="example-processor",
            data_sharing_preference={
                "opt_in": False,
            },
            regions_of_interests=[{
                "polygons": [
                    {
                        "x": 0.5,
                        "y": 0.5,
                    },
                    {
                        "x": 0.5,
                        "y": 0.5,
                    },
                    {
                        "x": 0.5,
                        "y": 0.5,
                    },
                ],
            }],
            input={
                "kinesis_video_stream": {
                    "arn": example.arn,
                },
            },
            output={
                "kinesis_data_stream": {
                    "arn": example_stream.arn,
                },
            },
            settings={
                "face_search": {
                    "collection_id": example_collection.id,
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Rekognition Stream Processor using the `name`. For example:

        ```sh
        $ pulumi import aws:rekognition/streamProcessor:StreamProcessor example my-stream
        ```

        :param str resource_name: The name of the resource.
        :param StreamProcessorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamProcessorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_sharing_preference: Optional[pulumi.Input[Union['StreamProcessorDataSharingPreferenceArgs', 'StreamProcessorDataSharingPreferenceArgsDict']]] = None,
                 input: Optional[pulumi.Input[Union['StreamProcessorInputArgs', 'StreamProcessorInputArgsDict']]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_channel: Optional[pulumi.Input[Union['StreamProcessorNotificationChannelArgs', 'StreamProcessorNotificationChannelArgsDict']]] = None,
                 output: Optional[pulumi.Input[Union['StreamProcessorOutputArgs', 'StreamProcessorOutputArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 regions_of_interests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamProcessorRegionsOfInterestArgs', 'StreamProcessorRegionsOfInterestArgsDict']]]]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['StreamProcessorSettingsArgs', 'StreamProcessorSettingsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['StreamProcessorTimeoutsArgs', 'StreamProcessorTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamProcessorArgs.__new__(StreamProcessorArgs)

            __props__.__dict__["data_sharing_preference"] = data_sharing_preference
            __props__.__dict__["input"] = input
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_channel"] = notification_channel
            __props__.__dict__["output"] = output
            __props__.__dict__["region"] = region
            __props__.__dict__["regions_of_interests"] = regions_of_interests
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["settings"] = settings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["stream_processor_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(StreamProcessor, __self__).__init__(
            'aws:rekognition/streamProcessor:StreamProcessor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            data_sharing_preference: Optional[pulumi.Input[Union['StreamProcessorDataSharingPreferenceArgs', 'StreamProcessorDataSharingPreferenceArgsDict']]] = None,
            input: Optional[pulumi.Input[Union['StreamProcessorInputArgs', 'StreamProcessorInputArgsDict']]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_channel: Optional[pulumi.Input[Union['StreamProcessorNotificationChannelArgs', 'StreamProcessorNotificationChannelArgsDict']]] = None,
            output: Optional[pulumi.Input[Union['StreamProcessorOutputArgs', 'StreamProcessorOutputArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            regions_of_interests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamProcessorRegionsOfInterestArgs', 'StreamProcessorRegionsOfInterestArgsDict']]]]] = None,
            role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            settings: Optional[pulumi.Input[Union['StreamProcessorSettingsArgs', 'StreamProcessorSettingsArgsDict']]] = None,
            stream_processor_arn: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['StreamProcessorTimeoutsArgs', 'StreamProcessorTimeoutsArgsDict']]] = None) -> 'StreamProcessor':
        """
        Get an existing StreamProcessor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the Stream Processor.
        :param pulumi.Input[Union['StreamProcessorDataSharingPreferenceArgs', 'StreamProcessorDataSharingPreferenceArgsDict']] data_sharing_preference: See `data_sharing_preference`.
        :param pulumi.Input[Union['StreamProcessorInputArgs', 'StreamProcessorInputArgsDict']] input: Input video stream. See `input`.
        :param pulumi.Input[_builtins.str] kms_key_id: Optional parameter for label detection stream processors.
        :param pulumi.Input[_builtins.str] name: The name of the Stream Processor.
        :param pulumi.Input[Union['StreamProcessorNotificationChannelArgs', 'StreamProcessorNotificationChannelArgsDict']] notification_channel: The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status. See `notification_channel`.
        :param pulumi.Input[Union['StreamProcessorOutputArgs', 'StreamProcessorOutputArgsDict']] output: Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. See `output`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StreamProcessorRegionsOfInterestArgs', 'StreamProcessorRegionsOfInterestArgsDict']]]] regions_of_interests: Specifies locations in the frames where Amazon Rekognition checks for objects or people. See `regions_of_interest`.
        :param pulumi.Input[_builtins.str] role_arn: The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.
        :param pulumi.Input[Union['StreamProcessorSettingsArgs', 'StreamProcessorSettingsArgsDict']] settings: Input parameters used in a streaming video analyzed by a stream processor. See `settings`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] stream_processor_arn: (**Deprecated**) ARN of the Stream Processor.
               Use `arn` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamProcessorState.__new__(_StreamProcessorState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["data_sharing_preference"] = data_sharing_preference
        __props__.__dict__["input"] = input
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_channel"] = notification_channel
        __props__.__dict__["output"] = output
        __props__.__dict__["region"] = region
        __props__.__dict__["regions_of_interests"] = regions_of_interests
        __props__.__dict__["role_arn"] = role_arn
        __props__.__dict__["settings"] = settings
        __props__.__dict__["stream_processor_arn"] = stream_processor_arn
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return StreamProcessor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Stream Processor.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="dataSharingPreference")
    def data_sharing_preference(self) -> pulumi.Output[Optional['outputs.StreamProcessorDataSharingPreference']]:
        """
        See `data_sharing_preference`.
        """
        return pulumi.get(self, "data_sharing_preference")

    @_builtins.property
    @pulumi.getter
    def input(self) -> pulumi.Output[Optional['outputs.StreamProcessorInput']]:
        """
        Input video stream. See `input`.
        """
        return pulumi.get(self, "input")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional parameter for label detection stream processors.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Stream Processor.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationChannel")
    def notification_channel(self) -> pulumi.Output[Optional['outputs.StreamProcessorNotificationChannel']]:
        """
        The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status. See `notification_channel`.
        """
        return pulumi.get(self, "notification_channel")

    @_builtins.property
    @pulumi.getter
    def output(self) -> pulumi.Output[Optional['outputs.StreamProcessorOutput']]:
        """
        Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition Video puts the analysis results. See `output`.
        """
        return pulumi.get(self, "output")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="regionsOfInterests")
    def regions_of_interests(self) -> pulumi.Output[Optional[Sequence['outputs.StreamProcessorRegionsOfInterest']]]:
        """
        Specifies locations in the frames where Amazon Rekognition checks for objects or people. See `regions_of_interest`.
        """
        return pulumi.get(self, "regions_of_interests")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Number (ARN) of the IAM role that allows access to the stream processor. The IAM role provides Rekognition read permissions for a Kinesis stream. It also provides write permissions to an Amazon S3 bucket and Amazon Simple Notification Service topic for a label detection stream processor. This is required for both face search and label detection stream processors.
        """
        return pulumi.get(self, "role_arn")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional['outputs.StreamProcessorSettings']]:
        """
        Input parameters used in a streaming video analyzed by a stream processor. See `settings`.

        The following arguments are optional:
        """
        return pulumi.get(self, "settings")

    @_builtins.property
    @pulumi.getter(name="streamProcessorArn")
    @_utilities.deprecated("""Use 'arn' instead. This attribute will be removed in a future version of the provider.""")
    def stream_processor_arn(self) -> pulumi.Output[_builtins.str]:
        """
        (**Deprecated**) ARN of the Stream Processor.
        Use `arn` instead.
        """
        return pulumi.get(self, "stream_processor_arn")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.StreamProcessorTimeouts']]:
        return pulumi.get(self, "timeouts")

