# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResiliencyPolicyArgs', 'ResiliencyPolicy']

@pulumi.input_type
class ResiliencyPolicyArgs:
    def __init__(__self__, *,
                 tier: pulumi.Input[_builtins.str],
                 data_location_constraint: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input['ResiliencyPolicyPolicyArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['ResiliencyPolicyTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a ResiliencyPolicy resource.
        :param pulumi.Input[_builtins.str] tier: Resiliency Policy Tier.
               Valid values are `MissionCritical`, `Critical`, `Important`, `CoreServices`, `NonCritical`, and `NotApplicable`.
        :param pulumi.Input[_builtins.str] data_location_constraint: Data Location Constraint of the Policy.
               Valid values are `AnyLocation`, `SameContinent`, and `SameCountry`.
        :param pulumi.Input[_builtins.str] description: Description of Resiliency Policy.
        :param pulumi.Input[_builtins.str] name: Name of Resiliency Policy.
               Must be between 2 and 60 characters long.
               Must start with an alphanumeric character and contain alphanumeric characters, underscores, or hyphens.
        :param pulumi.Input['ResiliencyPolicyPolicyArgs'] policy: The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds. See `policy`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "tier", tier)
        if data_location_constraint is not None:
            pulumi.set(__self__, "data_location_constraint", data_location_constraint)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Input[_builtins.str]:
        """
        Resiliency Policy Tier.
        Valid values are `MissionCritical`, `Critical`, `Important`, `CoreServices`, `NonCritical`, and `NotApplicable`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter(name="dataLocationConstraint")
    def data_location_constraint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Location Constraint of the Policy.
        Valid values are `AnyLocation`, `SameContinent`, and `SameCountry`.
        """
        return pulumi.get(self, "data_location_constraint")

    @data_location_constraint.setter
    def data_location_constraint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_location_constraint", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of Resiliency Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of Resiliency Policy.
        Must be between 2 and 60 characters long.
        Must start with an alphanumeric character and contain alphanumeric characters, underscores, or hyphens.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ResiliencyPolicyPolicyArgs']]:
        """
        The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds. See `policy`.

        The following arguments are optional:
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ResiliencyPolicyPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ResiliencyPolicyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ResiliencyPolicyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _ResiliencyPolicyState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 data_location_constraint: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 estimated_cost_tier: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input['ResiliencyPolicyPolicyArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['ResiliencyPolicyTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering ResiliencyPolicy resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the Resiliency Policy.
        :param pulumi.Input[_builtins.str] data_location_constraint: Data Location Constraint of the Policy.
               Valid values are `AnyLocation`, `SameContinent`, and `SameCountry`.
        :param pulumi.Input[_builtins.str] description: Description of Resiliency Policy.
        :param pulumi.Input[_builtins.str] estimated_cost_tier: Estimated Cost Tier of the Resiliency Policy.
        :param pulumi.Input[_builtins.str] name: Name of Resiliency Policy.
               Must be between 2 and 60 characters long.
               Must start with an alphanumeric character and contain alphanumeric characters, underscores, or hyphens.
        :param pulumi.Input['ResiliencyPolicyPolicyArgs'] policy: The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds. See `policy`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] tier: Resiliency Policy Tier.
               Valid values are `MissionCritical`, `Critical`, `Important`, `CoreServices`, `NonCritical`, and `NotApplicable`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if data_location_constraint is not None:
            pulumi.set(__self__, "data_location_constraint", data_location_constraint)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if estimated_cost_tier is not None:
            pulumi.set(__self__, "estimated_cost_tier", estimated_cost_tier)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Resiliency Policy.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="dataLocationConstraint")
    def data_location_constraint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data Location Constraint of the Policy.
        Valid values are `AnyLocation`, `SameContinent`, and `SameCountry`.
        """
        return pulumi.get(self, "data_location_constraint")

    @data_location_constraint.setter
    def data_location_constraint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_location_constraint", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of Resiliency Policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="estimatedCostTier")
    def estimated_cost_tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Estimated Cost Tier of the Resiliency Policy.
        """
        return pulumi.get(self, "estimated_cost_tier")

    @estimated_cost_tier.setter
    def estimated_cost_tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "estimated_cost_tier", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of Resiliency Policy.
        Must be between 2 and 60 characters long.
        Must start with an alphanumeric character and contain alphanumeric characters, underscores, or hyphens.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['ResiliencyPolicyPolicyArgs']]:
        """
        The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds. See `policy`.

        The following arguments are optional:
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['ResiliencyPolicyPolicyArgs']]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resiliency Policy Tier.
        Valid values are `MissionCritical`, `Critical`, `Important`, `CoreServices`, `NonCritical`, and `NotApplicable`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['ResiliencyPolicyTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['ResiliencyPolicyTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:resiliencehub/resiliencyPolicy:ResiliencyPolicy")
class ResiliencyPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_location_constraint: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[Union['ResiliencyPolicyPolicyArgs', 'ResiliencyPolicyPolicyArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ResiliencyPolicyTimeoutsArgs', 'ResiliencyPolicyTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Resilience Hub Resiliency Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.resiliencehub.ResiliencyPolicy("example",
            name="testexample",
            description="testexample",
            tier="NonCritical",
            data_location_constraint="AnyLocation",
            policy={
                "region": {
                    "rpo": "24h",
                    "rto": "24h",
                },
                "az": {
                    "rpo": "24h",
                    "rto": "24h",
                },
                "hardware": {
                    "rpo": "24h",
                    "rto": "24h",
                },
                "software": {
                    "rpo": "24h",
                    "rto": "24h",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Resilience Hub Resiliency Policy using the `arn`. For example:

        ```sh
        $ pulumi import aws:resiliencehub/resiliencyPolicy:ResiliencyPolicy example arn:aws:resiliencehub:us-east-1:123456789012:resiliency-policy/8c1cfa29-d1dd-4421-aa68-c9f64cced4c2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_location_constraint: Data Location Constraint of the Policy.
               Valid values are `AnyLocation`, `SameContinent`, and `SameCountry`.
        :param pulumi.Input[_builtins.str] description: Description of Resiliency Policy.
        :param pulumi.Input[_builtins.str] name: Name of Resiliency Policy.
               Must be between 2 and 60 characters long.
               Must start with an alphanumeric character and contain alphanumeric characters, underscores, or hyphens.
        :param pulumi.Input[Union['ResiliencyPolicyPolicyArgs', 'ResiliencyPolicyPolicyArgsDict']] policy: The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds. See `policy`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] tier: Resiliency Policy Tier.
               Valid values are `MissionCritical`, `Critical`, `Important`, `CoreServices`, `NonCritical`, and `NotApplicable`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResiliencyPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Resilience Hub Resiliency Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.resiliencehub.ResiliencyPolicy("example",
            name="testexample",
            description="testexample",
            tier="NonCritical",
            data_location_constraint="AnyLocation",
            policy={
                "region": {
                    "rpo": "24h",
                    "rto": "24h",
                },
                "az": {
                    "rpo": "24h",
                    "rto": "24h",
                },
                "hardware": {
                    "rpo": "24h",
                    "rto": "24h",
                },
                "software": {
                    "rpo": "24h",
                    "rto": "24h",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Resilience Hub Resiliency Policy using the `arn`. For example:

        ```sh
        $ pulumi import aws:resiliencehub/resiliencyPolicy:ResiliencyPolicy example arn:aws:resiliencehub:us-east-1:123456789012:resiliency-policy/8c1cfa29-d1dd-4421-aa68-c9f64cced4c2
        ```

        :param str resource_name: The name of the resource.
        :param ResiliencyPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResiliencyPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_location_constraint: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[Union['ResiliencyPolicyPolicyArgs', 'ResiliencyPolicyPolicyArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['ResiliencyPolicyTimeoutsArgs', 'ResiliencyPolicyTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResiliencyPolicyArgs.__new__(ResiliencyPolicyArgs)

            __props__.__dict__["data_location_constraint"] = data_location_constraint
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["policy"] = policy
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["arn"] = None
            __props__.__dict__["estimated_cost_tier"] = None
            __props__.__dict__["tags_all"] = None
        super(ResiliencyPolicy, __self__).__init__(
            'aws:resiliencehub/resiliencyPolicy:ResiliencyPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            data_location_constraint: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            estimated_cost_tier: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy: Optional[pulumi.Input[Union['ResiliencyPolicyPolicyArgs', 'ResiliencyPolicyPolicyArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tier: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['ResiliencyPolicyTimeoutsArgs', 'ResiliencyPolicyTimeoutsArgsDict']]] = None) -> 'ResiliencyPolicy':
        """
        Get an existing ResiliencyPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the Resiliency Policy.
        :param pulumi.Input[_builtins.str] data_location_constraint: Data Location Constraint of the Policy.
               Valid values are `AnyLocation`, `SameContinent`, and `SameCountry`.
        :param pulumi.Input[_builtins.str] description: Description of Resiliency Policy.
        :param pulumi.Input[_builtins.str] estimated_cost_tier: Estimated Cost Tier of the Resiliency Policy.
        :param pulumi.Input[_builtins.str] name: Name of Resiliency Policy.
               Must be between 2 and 60 characters long.
               Must start with an alphanumeric character and contain alphanumeric characters, underscores, or hyphens.
        :param pulumi.Input[Union['ResiliencyPolicyPolicyArgs', 'ResiliencyPolicyPolicyArgsDict']] policy: The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds. See `policy`.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] tier: Resiliency Policy Tier.
               Valid values are `MissionCritical`, `Critical`, `Important`, `CoreServices`, `NonCritical`, and `NotApplicable`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResiliencyPolicyState.__new__(_ResiliencyPolicyState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["data_location_constraint"] = data_location_constraint
        __props__.__dict__["description"] = description
        __props__.__dict__["estimated_cost_tier"] = estimated_cost_tier
        __props__.__dict__["name"] = name
        __props__.__dict__["policy"] = policy
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tier"] = tier
        __props__.__dict__["timeouts"] = timeouts
        return ResiliencyPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Resiliency Policy.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="dataLocationConstraint")
    def data_location_constraint(self) -> pulumi.Output[_builtins.str]:
        """
        Data Location Constraint of the Policy.
        Valid values are `AnyLocation`, `SameContinent`, and `SameCountry`.
        """
        return pulumi.get(self, "data_location_constraint")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of Resiliency Policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="estimatedCostTier")
    def estimated_cost_tier(self) -> pulumi.Output[_builtins.str]:
        """
        Estimated Cost Tier of the Resiliency Policy.
        """
        return pulumi.get(self, "estimated_cost_tier")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of Resiliency Policy.
        Must be between 2 and 60 characters long.
        Must start with an alphanumeric character and contain alphanumeric characters, underscores, or hyphens.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[Optional['outputs.ResiliencyPolicyPolicy']]:
        """
        The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds. See `policy`.

        The following arguments are optional:
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Output[_builtins.str]:
        """
        Resiliency Policy Tier.
        Valid values are `MissionCritical`, `Critical`, `Important`, `CoreServices`, `NonCritical`, and `NotApplicable`.
        """
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.ResiliencyPolicyTimeouts']]:
        return pulumi.get(self, "timeouts")

