# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResolverRuleResult',
    'AwaitableGetResolverRuleResult',
    'get_resolver_rule',
    'get_resolver_rule_output',
]

@pulumi.output_type
class GetResolverRuleResult:
    """
    A collection of values returned by getResolverRule.
    """
    def __init__(__self__, arn=None, domain_name=None, id=None, name=None, owner_id=None, region=None, resolver_endpoint_id=None, resolver_rule_id=None, rule_type=None, share_status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resolver_endpoint_id and not isinstance(resolver_endpoint_id, str):
            raise TypeError("Expected argument 'resolver_endpoint_id' to be a str")
        pulumi.set(__self__, "resolver_endpoint_id", resolver_endpoint_id)
        if resolver_rule_id and not isinstance(resolver_rule_id, str):
            raise TypeError("Expected argument 'resolver_rule_id' to be a str")
        pulumi.set(__self__, "resolver_rule_id", resolver_rule_id)
        if rule_type and not isinstance(rule_type, str):
            raise TypeError("Expected argument 'rule_type' to be a str")
        pulumi.set(__self__, "rule_type", rule_type)
        if share_status and not isinstance(share_status, str):
            raise TypeError("Expected argument 'share_status' to be a str")
        pulumi.set(__self__, "share_status", share_status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN (Amazon Resource Name) for the resolver rule.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> _builtins.str:
        """
        When a rule is shared with another AWS account, the account ID of the account that the rule is shared with.
        """
        return pulumi.get(self, "owner_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resolverEndpointId")
    def resolver_endpoint_id(self) -> _builtins.str:
        return pulumi.get(self, "resolver_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="resolverRuleId")
    def resolver_rule_id(self) -> _builtins.str:
        return pulumi.get(self, "resolver_rule_id")

    @_builtins.property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> _builtins.str:
        return pulumi.get(self, "rule_type")

    @_builtins.property
    @pulumi.getter(name="shareStatus")
    def share_status(self) -> _builtins.str:
        """
        Whether the rules is shared and, if so, whether the current account is sharing the rule with another account, or another account is sharing the rule with the current account.
        Values are `NOT_SHARED`, `SHARED_BY_ME` or `SHARED_WITH_ME`
        """
        return pulumi.get(self, "share_status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Map of tags assigned to the resolver rule.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResolverRuleResult(GetResolverRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResolverRuleResult(
            arn=self.arn,
            domain_name=self.domain_name,
            id=self.id,
            name=self.name,
            owner_id=self.owner_id,
            region=self.region,
            resolver_endpoint_id=self.resolver_endpoint_id,
            resolver_rule_id=self.resolver_rule_id,
            rule_type=self.rule_type,
            share_status=self.share_status,
            tags=self.tags)


def get_resolver_rule(domain_name: Optional[_builtins.str] = None,
                      name: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      resolver_endpoint_id: Optional[_builtins.str] = None,
                      resolver_rule_id: Optional[_builtins.str] = None,
                      rule_type: Optional[_builtins.str] = None,
                      tags: Optional[Mapping[str, _builtins.str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResolverRuleResult:
    """
    `route53.ResolverRule` provides details about a specific Route53 Resolver rule.

    ## Example Usage

    The following example shows how to get a Route53 Resolver rule based on its associated domain name and rule type.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_rule(domain_name="subdomain.example.com",
        rule_type="SYSTEM")
    ```


    :param _builtins.str domain_name: Domain name the desired resolver rule forwards DNS queries for. Conflicts with `resolver_rule_id`.
    :param _builtins.str name: Friendly name of the desired resolver rule. Conflicts with `resolver_rule_id`.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str resolver_endpoint_id: ID of the outbound resolver endpoint of the desired resolver rule. Conflicts with `resolver_rule_id`.
    :param _builtins.str resolver_rule_id: ID of the desired resolver rule. Conflicts with `domain_name`, `name`, `resolver_endpoint_id` and `rule_type`.
    :param _builtins.str rule_type: Rule type of the desired resolver rule. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`. Conflicts with `resolver_rule_id`.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the resolver rule.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    __args__['name'] = name
    __args__['region'] = region
    __args__['resolverEndpointId'] = resolver_endpoint_id
    __args__['resolverRuleId'] = resolver_rule_id
    __args__['ruleType'] = rule_type
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:route53/getResolverRule:getResolverRule', __args__, opts=opts, typ=GetResolverRuleResult).value

    return AwaitableGetResolverRuleResult(
        arn=pulumi.get(__ret__, 'arn'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        region=pulumi.get(__ret__, 'region'),
        resolver_endpoint_id=pulumi.get(__ret__, 'resolver_endpoint_id'),
        resolver_rule_id=pulumi.get(__ret__, 'resolver_rule_id'),
        rule_type=pulumi.get(__ret__, 'rule_type'),
        share_status=pulumi.get(__ret__, 'share_status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resolver_rule_output(domain_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             resolver_endpoint_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             resolver_rule_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             rule_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResolverRuleResult]:
    """
    `route53.ResolverRule` provides details about a specific Route53 Resolver rule.

    ## Example Usage

    The following example shows how to get a Route53 Resolver rule based on its associated domain name and rule type.

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.route53.get_resolver_rule(domain_name="subdomain.example.com",
        rule_type="SYSTEM")
    ```


    :param _builtins.str domain_name: Domain name the desired resolver rule forwards DNS queries for. Conflicts with `resolver_rule_id`.
    :param _builtins.str name: Friendly name of the desired resolver rule. Conflicts with `resolver_rule_id`.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str resolver_endpoint_id: ID of the outbound resolver endpoint of the desired resolver rule. Conflicts with `resolver_rule_id`.
    :param _builtins.str resolver_rule_id: ID of the desired resolver rule. Conflicts with `domain_name`, `name`, `resolver_endpoint_id` and `rule_type`.
    :param _builtins.str rule_type: Rule type of the desired resolver rule. Valid values are `FORWARD`, `SYSTEM` and `RECURSIVE`. Conflicts with `resolver_rule_id`.
    :param Mapping[str, _builtins.str] tags: Map of tags assigned to the resolver rule.
    """
    __args__ = dict()
    __args__['domainName'] = domain_name
    __args__['name'] = name
    __args__['region'] = region
    __args__['resolverEndpointId'] = resolver_endpoint_id
    __args__['resolverRuleId'] = resolver_rule_id
    __args__['ruleType'] = rule_type
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:route53/getResolverRule:getResolverRule', __args__, opts=opts, typ=GetResolverRuleResult)
    return __ret__.apply(lambda __response__: GetResolverRuleResult(
        arn=pulumi.get(__response__, 'arn'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        region=pulumi.get(__response__, 'region'),
        resolver_endpoint_id=pulumi.get(__response__, 'resolver_endpoint_id'),
        resolver_rule_id=pulumi.get(__response__, 'resolver_rule_id'),
        rule_type=pulumi.get(__response__, 'rule_type'),
        share_status=pulumi.get(__response__, 'share_status'),
        tags=pulumi.get(__response__, 'tags')))
