# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppMonitorArgs', 'AppMonitor']

@pulumi.input_type
class AppMonitorArgs:
    def __init__(__self__, *,
                 app_monitor_configuration: Optional[pulumi.Input['AppMonitorAppMonitorConfigurationArgs']] = None,
                 custom_events: Optional[pulumi.Input['AppMonitorCustomEventsArgs']] = None,
                 cw_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AppMonitor resource.
        :param pulumi.Input['AppMonitorAppMonitorConfigurationArgs'] app_monitor_configuration: configuration data for the app monitor. See app_monitor_configuration below.
        :param pulumi.Input['AppMonitorCustomEventsArgs'] custom_events: Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
        :param pulumi.Input[_builtins.bool] cw_log_enabled: Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges. Default value is `false`.
        :param pulumi.Input[_builtins.str] name: The name of the log stream.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if app_monitor_configuration is not None:
            pulumi.set(__self__, "app_monitor_configuration", app_monitor_configuration)
        if custom_events is not None:
            pulumi.set(__self__, "custom_events", custom_events)
        if cw_log_enabled is not None:
            pulumi.set(__self__, "cw_log_enabled", cw_log_enabled)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_lists is not None:
            pulumi.set(__self__, "domain_lists", domain_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="appMonitorConfiguration")
    def app_monitor_configuration(self) -> Optional[pulumi.Input['AppMonitorAppMonitorConfigurationArgs']]:
        """
        configuration data for the app monitor. See app_monitor_configuration below.
        """
        return pulumi.get(self, "app_monitor_configuration")

    @app_monitor_configuration.setter
    def app_monitor_configuration(self, value: Optional[pulumi.Input['AppMonitorAppMonitorConfigurationArgs']]):
        pulumi.set(self, "app_monitor_configuration", value)

    @_builtins.property
    @pulumi.getter(name="customEvents")
    def custom_events(self) -> Optional[pulumi.Input['AppMonitorCustomEventsArgs']]:
        """
        Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
        """
        return pulumi.get(self, "custom_events")

    @custom_events.setter
    def custom_events(self, value: Optional[pulumi.Input['AppMonitorCustomEventsArgs']]):
        pulumi.set(self, "custom_events", value)

    @_builtins.property
    @pulumi.getter(name="cwLogEnabled")
    def cw_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges. Default value is `false`.
        """
        return pulumi.get(self, "cw_log_enabled")

    @cw_log_enabled.setter
    def cw_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cw_log_enabled", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="domainLists")
    def domain_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "domain_lists")

    @domain_lists.setter
    def domain_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domain_lists", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the log stream.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AppMonitorState:
    def __init__(__self__, *,
                 app_monitor_configuration: Optional[pulumi.Input['AppMonitorAppMonitorConfigurationArgs']] = None,
                 app_monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_events: Optional[pulumi.Input['AppMonitorCustomEventsArgs']] = None,
                 cw_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cw_log_group: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AppMonitor resources.
        :param pulumi.Input['AppMonitorAppMonitorConfigurationArgs'] app_monitor_configuration: configuration data for the app monitor. See app_monitor_configuration below.
        :param pulumi.Input[_builtins.str] app_monitor_id: The unique ID of the app monitor. Useful for JS templates.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) specifying the app monitor.
        :param pulumi.Input['AppMonitorCustomEventsArgs'] custom_events: Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
        :param pulumi.Input[_builtins.bool] cw_log_enabled: Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges. Default value is `false`.
        :param pulumi.Input[_builtins.str] cw_log_group: The name of the log group where the copies are stored.
        :param pulumi.Input[_builtins.str] name: The name of the log stream.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if app_monitor_configuration is not None:
            pulumi.set(__self__, "app_monitor_configuration", app_monitor_configuration)
        if app_monitor_id is not None:
            pulumi.set(__self__, "app_monitor_id", app_monitor_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if custom_events is not None:
            pulumi.set(__self__, "custom_events", custom_events)
        if cw_log_enabled is not None:
            pulumi.set(__self__, "cw_log_enabled", cw_log_enabled)
        if cw_log_group is not None:
            pulumi.set(__self__, "cw_log_group", cw_log_group)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if domain_lists is not None:
            pulumi.set(__self__, "domain_lists", domain_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter(name="appMonitorConfiguration")
    def app_monitor_configuration(self) -> Optional[pulumi.Input['AppMonitorAppMonitorConfigurationArgs']]:
        """
        configuration data for the app monitor. See app_monitor_configuration below.
        """
        return pulumi.get(self, "app_monitor_configuration")

    @app_monitor_configuration.setter
    def app_monitor_configuration(self, value: Optional[pulumi.Input['AppMonitorAppMonitorConfigurationArgs']]):
        pulumi.set(self, "app_monitor_configuration", value)

    @_builtins.property
    @pulumi.getter(name="appMonitorId")
    def app_monitor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID of the app monitor. Useful for JS templates.
        """
        return pulumi.get(self, "app_monitor_id")

    @app_monitor_id.setter
    def app_monitor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_monitor_id", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon Resource Name (ARN) specifying the app monitor.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="customEvents")
    def custom_events(self) -> Optional[pulumi.Input['AppMonitorCustomEventsArgs']]:
        """
        Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
        """
        return pulumi.get(self, "custom_events")

    @custom_events.setter
    def custom_events(self, value: Optional[pulumi.Input['AppMonitorCustomEventsArgs']]):
        pulumi.set(self, "custom_events", value)

    @_builtins.property
    @pulumi.getter(name="cwLogEnabled")
    def cw_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges. Default value is `false`.
        """
        return pulumi.get(self, "cw_log_enabled")

    @cw_log_enabled.setter
    def cw_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cw_log_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cwLogGroup")
    def cw_log_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the log group where the copies are stored.
        """
        return pulumi.get(self, "cw_log_group")

    @cw_log_group.setter
    def cw_log_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cw_log_group", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter(name="domainLists")
    def domain_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "domain_lists")

    @domain_lists.setter
    def domain_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domain_lists", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the log stream.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:rum/appMonitor:AppMonitor")
class AppMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_monitor_configuration: Optional[pulumi.Input[Union['AppMonitorAppMonitorConfigurationArgs', 'AppMonitorAppMonitorConfigurationArgsDict']]] = None,
                 custom_events: Optional[pulumi.Input[Union['AppMonitorCustomEventsArgs', 'AppMonitorCustomEventsArgsDict']]] = None,
                 cw_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a CloudWatch RUM App Monitor resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rum.AppMonitor("example",
            name="example",
            domain="localhost")
        ```

        ## Import

        Using `pulumi import`, import Cloudwatch RUM App Monitor using the `name`. For example:

        ```sh
        $ pulumi import aws:rum/appMonitor:AppMonitor example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AppMonitorAppMonitorConfigurationArgs', 'AppMonitorAppMonitorConfigurationArgsDict']] app_monitor_configuration: configuration data for the app monitor. See app_monitor_configuration below.
        :param pulumi.Input[Union['AppMonitorCustomEventsArgs', 'AppMonitorCustomEventsArgsDict']] custom_events: Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
        :param pulumi.Input[_builtins.bool] cw_log_enabled: Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges. Default value is `false`.
        :param pulumi.Input[_builtins.str] name: The name of the log stream.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AppMonitorArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CloudWatch RUM App Monitor resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.rum.AppMonitor("example",
            name="example",
            domain="localhost")
        ```

        ## Import

        Using `pulumi import`, import Cloudwatch RUM App Monitor using the `name`. For example:

        ```sh
        $ pulumi import aws:rum/appMonitor:AppMonitor example example
        ```

        :param str resource_name: The name of the resource.
        :param AppMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_monitor_configuration: Optional[pulumi.Input[Union['AppMonitorAppMonitorConfigurationArgs', 'AppMonitorAppMonitorConfigurationArgsDict']]] = None,
                 custom_events: Optional[pulumi.Input[Union['AppMonitorCustomEventsArgs', 'AppMonitorCustomEventsArgsDict']]] = None,
                 cw_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppMonitorArgs.__new__(AppMonitorArgs)

            __props__.__dict__["app_monitor_configuration"] = app_monitor_configuration
            __props__.__dict__["custom_events"] = custom_events
            __props__.__dict__["cw_log_enabled"] = cw_log_enabled
            __props__.__dict__["domain"] = domain
            __props__.__dict__["domain_lists"] = domain_lists
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["app_monitor_id"] = None
            __props__.__dict__["arn"] = None
            __props__.__dict__["cw_log_group"] = None
            __props__.__dict__["tags_all"] = None
        super(AppMonitor, __self__).__init__(
            'aws:rum/appMonitor:AppMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_monitor_configuration: Optional[pulumi.Input[Union['AppMonitorAppMonitorConfigurationArgs', 'AppMonitorAppMonitorConfigurationArgsDict']]] = None,
            app_monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            custom_events: Optional[pulumi.Input[Union['AppMonitorCustomEventsArgs', 'AppMonitorCustomEventsArgsDict']]] = None,
            cw_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cw_log_group: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            domain_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'AppMonitor':
        """
        Get an existing AppMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AppMonitorAppMonitorConfigurationArgs', 'AppMonitorAppMonitorConfigurationArgsDict']] app_monitor_configuration: configuration data for the app monitor. See app_monitor_configuration below.
        :param pulumi.Input[_builtins.str] app_monitor_id: The unique ID of the app monitor. Useful for JS templates.
        :param pulumi.Input[_builtins.str] arn: The Amazon Resource Name (ARN) specifying the app monitor.
        :param pulumi.Input[Union['AppMonitorCustomEventsArgs', 'AppMonitorCustomEventsArgsDict']] custom_events: Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
        :param pulumi.Input[_builtins.bool] cw_log_enabled: Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges. Default value is `false`.
        :param pulumi.Input[_builtins.str] cw_log_group: The name of the log group where the copies are stored.
        :param pulumi.Input[_builtins.str] name: The name of the log stream.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppMonitorState.__new__(_AppMonitorState)

        __props__.__dict__["app_monitor_configuration"] = app_monitor_configuration
        __props__.__dict__["app_monitor_id"] = app_monitor_id
        __props__.__dict__["arn"] = arn
        __props__.__dict__["custom_events"] = custom_events
        __props__.__dict__["cw_log_enabled"] = cw_log_enabled
        __props__.__dict__["cw_log_group"] = cw_log_group
        __props__.__dict__["domain"] = domain
        __props__.__dict__["domain_lists"] = domain_lists
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return AppMonitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appMonitorConfiguration")
    def app_monitor_configuration(self) -> pulumi.Output['outputs.AppMonitorAppMonitorConfiguration']:
        """
        configuration data for the app monitor. See app_monitor_configuration below.
        """
        return pulumi.get(self, "app_monitor_configuration")

    @_builtins.property
    @pulumi.getter(name="appMonitorId")
    def app_monitor_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique ID of the app monitor. Useful for JS templates.
        """
        return pulumi.get(self, "app_monitor_id")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon Resource Name (ARN) specifying the app monitor.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="customEvents")
    def custom_events(self) -> pulumi.Output['outputs.AppMonitorCustomEvents']:
        """
        Specifies whether this app monitor allows the web client to define and send custom events. If you omit this parameter, custom events are `DISABLED`. See custom_events below.
        """
        return pulumi.get(self, "custom_events")

    @_builtins.property
    @pulumi.getter(name="cwLogEnabled")
    def cw_log_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Data collected by RUM is kept by RUM for 30 days and then deleted. This parameter specifies whether RUM sends a copy of this telemetry data to Amazon CloudWatch Logs in your account. This enables you to keep the telemetry data for more than 30 days, but it does incur Amazon CloudWatch Logs charges. Default value is `false`.
        """
        return pulumi.get(self, "cw_log_enabled")

    @_builtins.property
    @pulumi.getter(name="cwLogGroup")
    def cw_log_group(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the log group where the copies are stored.
        """
        return pulumi.get(self, "cw_log_group")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="domainLists")
    def domain_lists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "domain_lists")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the log stream.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

