# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import iam
from .. import iam as _iam
from ._enums import *
from ._inputs import *

__all__ = ['BucketArgs', 'Bucket']

@pulumi.input_type
class BucketArgs:
    def __init__(__self__, *,
                 acceleration_status: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[Union[_builtins.str, 'CannedAcl']]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['BucketGrantArgs']]]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]] = None,
                 logging: Optional[pulumi.Input['BucketLoggingArgs']] = None,
                 object_lock_configuration: Optional[pulumi.Input['BucketObjectLockConfigurationArgs']] = None,
                 object_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_configuration: Optional[pulumi.Input['BucketReplicationConfigurationArgs']] = None,
                 request_payer: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input['BucketServerSideEncryptionConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input['BucketVersioningArgs']] = None,
                 website: Optional[pulumi.Input['BucketWebsiteArgs']] = None):
        """
        The set of arguments for constructing a Bucket resource.
        :param pulumi.Input[_builtins.str] acceleration_status: Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketAccelerateConfiguration` instead.
        :param pulumi.Input[Union[_builtins.str, 'CannedAcl']] acl: The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html). The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.DirectoryBucket` resource to manage S3 Express buckets.
        :param pulumi.Input[_builtins.str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
        :param pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]] cors_rules: Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketCorsConfiguration` instead.
        :param pulumi.Input[_builtins.bool] force_destroy: Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input[Sequence[pulumi.Input['BucketGrantArgs']]] grants: An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]] lifecycle_rules: Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketLifecycleConfiguration` instead.
        :param pulumi.Input['BucketLoggingArgs'] logging: Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketLogging` instead.
        :param pulumi.Input['BucketObjectLockConfigurationArgs'] object_lock_configuration: Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
               The provider wil only perform drift detection if a configuration value is provided.
               Use the `object_lock_enabled` parameter and the resource `s3.BucketObjectLockConfiguration` instead.
        :param pulumi.Input[_builtins.bool] object_lock_enabled: Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
        :param pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']] policy: Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketPolicy` instead.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['BucketReplicationConfigurationArgs'] replication_configuration: Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketReplicationConfig` instead.
        :param pulumi.Input[_builtins.str] request_payer: Specifies who should bear the cost of Amazon S3 data transfer.
               Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
               See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketRequestPaymentConfiguration` instead.
        :param pulumi.Input['BucketServerSideEncryptionConfigurationArgs'] server_side_encryption_configuration: Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketServerSideEncryptionConfiguration` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               The following arguments are deprecated, and will be removed in a future major version:
        :param pulumi.Input['BucketVersioningArgs'] versioning: Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketVersioning` instead.
        :param pulumi.Input['BucketWebsiteArgs'] website: Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketWebsiteConfiguration` instead.
        """
        if acceleration_status is not None:
            warnings.warn("""acceleration_status is deprecated. Use the s3.BucketAccelerateConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""acceleration_status is deprecated: acceleration_status is deprecated. Use the s3.BucketAccelerateConfiguration resource instead.""")
        if acceleration_status is not None:
            pulumi.set(__self__, "acceleration_status", acceleration_status)
        if acl is not None:
            warnings.warn("""acl is deprecated. Use the s3.BucketAcl resource instead.""", DeprecationWarning)
            pulumi.log.warn("""acl is deprecated: acl is deprecated. Use the s3.BucketAcl resource instead.""")
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if cors_rules is not None:
            warnings.warn("""cors_rule is deprecated. Use the s3.BucketCorsConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""cors_rules is deprecated: cors_rule is deprecated. Use the s3.BucketCorsConfiguration resource instead.""")
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if grants is not None:
            warnings.warn("""grant is deprecated. Use the s3.BucketAcl resource instead.""", DeprecationWarning)
            pulumi.log.warn("""grants is deprecated: grant is deprecated. Use the s3.BucketAcl resource instead.""")
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if lifecycle_rules is not None:
            warnings.warn("""lifecycle_rule is deprecated. Use the s3.BucketLifecycleConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""lifecycle_rules is deprecated: lifecycle_rule is deprecated. Use the s3.BucketLifecycleConfiguration resource instead.""")
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if logging is not None:
            warnings.warn("""logging is deprecated. Use the s3.BucketLogging resource instead.""", DeprecationWarning)
            pulumi.log.warn("""logging is deprecated: logging is deprecated. Use the s3.BucketLogging resource instead.""")
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if object_lock_configuration is not None:
            warnings.warn("""object_lock_configuration is deprecated. Use the top-level parameter object_lock_enabled and the s3.BucketObjectLockConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""object_lock_configuration is deprecated: object_lock_configuration is deprecated. Use the top-level parameter object_lock_enabled and the s3.BucketObjectLockConfiguration resource instead.""")
        if object_lock_configuration is not None:
            pulumi.set(__self__, "object_lock_configuration", object_lock_configuration)
        if object_lock_enabled is not None:
            pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if policy is not None:
            warnings.warn("""policy is deprecated. Use the s3.BucketPolicy resource instead.""", DeprecationWarning)
            pulumi.log.warn("""policy is deprecated: policy is deprecated. Use the s3.BucketPolicy resource instead.""")
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_configuration is not None:
            warnings.warn("""replication_configuration is deprecated. Use the s3.BucketReplicationConfig resource instead.""", DeprecationWarning)
            pulumi.log.warn("""replication_configuration is deprecated: replication_configuration is deprecated. Use the s3.BucketReplicationConfig resource instead.""")
        if replication_configuration is not None:
            pulumi.set(__self__, "replication_configuration", replication_configuration)
        if request_payer is not None:
            warnings.warn("""request_payer is deprecated. Use the s3.BucketRequestPaymentConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""request_payer is deprecated: request_payer is deprecated. Use the s3.BucketRequestPaymentConfiguration resource instead.""")
        if request_payer is not None:
            pulumi.set(__self__, "request_payer", request_payer)
        if server_side_encryption_configuration is not None:
            warnings.warn("""server_side_encryption_configuration is deprecated. Use the s3.BucketServerSideEncryptionConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""server_side_encryption_configuration is deprecated: server_side_encryption_configuration is deprecated. Use the s3.BucketServerSideEncryptionConfiguration resource instead.""")
        if server_side_encryption_configuration is not None:
            pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versioning is not None:
            warnings.warn("""versioning is deprecated. Use the s3.BucketVersioning resource instead.""", DeprecationWarning)
            pulumi.log.warn("""versioning is deprecated: versioning is deprecated. Use the s3.BucketVersioning resource instead.""")
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            warnings.warn("""website is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""website is deprecated: website is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""")
        if website is not None:
            pulumi.set(__self__, "website", website)

    @_builtins.property
    @pulumi.getter(name="accelerationStatus")
    @_utilities.deprecated("""acceleration_status is deprecated. Use the s3.BucketAccelerateConfiguration resource instead.""")
    def acceleration_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketAccelerateConfiguration` instead.
        """
        return pulumi.get(self, "acceleration_status")

    @acceleration_status.setter
    def acceleration_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acceleration_status", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""acl is deprecated. Use the s3.BucketAcl resource instead.""")
    def acl(self) -> Optional[pulumi.Input[Union[_builtins.str, 'CannedAcl']]]:
        """
        The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[Union[_builtins.str, 'CannedAcl']]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html). The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.DirectoryBucket` resource to manage S3 Express buckets.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_prefix", value)

    @_builtins.property
    @pulumi.getter(name="corsRules")
    @_utilities.deprecated("""cors_rule is deprecated. Use the s3.BucketCorsConfiguration resource instead.""")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]:
        """
        Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketCorsConfiguration` instead.
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""grant is deprecated. Use the s3.BucketAcl resource instead.""")
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketGrantArgs']]]]:
        """
        An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketGrantArgs']]]]):
        pulumi.set(self, "grants", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    @_utilities.deprecated("""lifecycle_rule is deprecated. Use the s3.BucketLifecycleConfiguration resource instead.""")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]:
        """
        Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketLifecycleConfiguration` instead.
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""logging is deprecated. Use the s3.BucketLogging resource instead.""")
    def logging(self) -> Optional[pulumi.Input['BucketLoggingArgs']]:
        """
        Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketLogging` instead.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['BucketLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="objectLockConfiguration")
    @_utilities.deprecated("""object_lock_configuration is deprecated. Use the top-level parameter object_lock_enabled and the s3.BucketObjectLockConfiguration resource instead.""")
    def object_lock_configuration(self) -> Optional[pulumi.Input['BucketObjectLockConfigurationArgs']]:
        """
        Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
        The provider wil only perform drift detection if a configuration value is provided.
        Use the `object_lock_enabled` parameter and the resource `s3.BucketObjectLockConfiguration` instead.
        """
        return pulumi.get(self, "object_lock_configuration")

    @object_lock_configuration.setter
    def object_lock_configuration(self, value: Optional[pulumi.Input['BucketObjectLockConfigurationArgs']]):
        pulumi.set(self, "object_lock_configuration", value)

    @_builtins.property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
        """
        return pulumi.get(self, "object_lock_enabled")

    @object_lock_enabled.setter
    def object_lock_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "object_lock_enabled", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""policy is deprecated. Use the s3.BucketPolicy resource instead.""")
    def policy(self) -> Optional[pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']]]:
        """
        Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
        The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketPolicy` instead.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationConfiguration")
    @_utilities.deprecated("""replication_configuration is deprecated. Use the s3.BucketReplicationConfig resource instead.""")
    def replication_configuration(self) -> Optional[pulumi.Input['BucketReplicationConfigurationArgs']]:
        """
        Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketReplicationConfig` instead.
        """
        return pulumi.get(self, "replication_configuration")

    @replication_configuration.setter
    def replication_configuration(self, value: Optional[pulumi.Input['BucketReplicationConfigurationArgs']]):
        pulumi.set(self, "replication_configuration", value)

    @_builtins.property
    @pulumi.getter(name="requestPayer")
    @_utilities.deprecated("""request_payer is deprecated. Use the s3.BucketRequestPaymentConfiguration resource instead.""")
    def request_payer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies who should bear the cost of Amazon S3 data transfer.
        Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
        See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
        The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketRequestPaymentConfiguration` instead.
        """
        return pulumi.get(self, "request_payer")

    @request_payer.setter
    def request_payer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_payer", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    @_utilities.deprecated("""server_side_encryption_configuration is deprecated. Use the s3.BucketServerSideEncryptionConfiguration resource instead.""")
    def server_side_encryption_configuration(self) -> Optional[pulumi.Input['BucketServerSideEncryptionConfigurationArgs']]:
        """
        Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
        The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketServerSideEncryptionConfiguration` instead.
        """
        return pulumi.get(self, "server_side_encryption_configuration")

    @server_side_encryption_configuration.setter
    def server_side_encryption_configuration(self, value: Optional[pulumi.Input['BucketServerSideEncryptionConfigurationArgs']]):
        pulumi.set(self, "server_side_encryption_configuration", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        The following arguments are deprecated, and will be removed in a future major version:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""versioning is deprecated. Use the s3.BucketVersioning resource instead.""")
    def versioning(self) -> Optional[pulumi.Input['BucketVersioningArgs']]:
        """
        Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketVersioning` instead.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['BucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""website is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""")
    def website(self) -> Optional[pulumi.Input['BucketWebsiteArgs']]:
        """
        Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketWebsiteConfiguration` instead.
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['BucketWebsiteArgs']]):
        pulumi.set(self, "website", value)


@pulumi.input_type
class _BucketState:
    def __init__(__self__, *,
                 acceleration_status: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[Union[_builtins.str, 'CannedAcl']]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_region: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_regional_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['BucketGrantArgs']]]] = None,
                 hosted_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]] = None,
                 logging: Optional[pulumi.Input['BucketLoggingArgs']] = None,
                 object_lock_configuration: Optional[pulumi.Input['BucketObjectLockConfigurationArgs']] = None,
                 object_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_configuration: Optional[pulumi.Input['BucketReplicationConfigurationArgs']] = None,
                 request_payer: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input['BucketServerSideEncryptionConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input['BucketVersioningArgs']] = None,
                 website: Optional[pulumi.Input['BucketWebsiteArgs']] = None,
                 website_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 website_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Bucket resources.
        :param pulumi.Input[_builtins.str] acceleration_status: Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketAccelerateConfiguration` instead.
        :param pulumi.Input[Union[_builtins.str, 'CannedAcl']] acl: The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        :param pulumi.Input[_builtins.str] arn: ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html). The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.DirectoryBucket` resource to manage S3 Express buckets.
        :param pulumi.Input[_builtins.str] bucket_domain_name: Bucket domain name. Will be of format `bucketname.s3.amazonaws.com`.
        :param pulumi.Input[_builtins.str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
        :param pulumi.Input[_builtins.str] bucket_region: AWS region this bucket resides in.
        :param pulumi.Input[_builtins.str] bucket_regional_domain_name: The bucket region-specific domain name. The bucket domain name including the region name. Please refer to the [S3 endpoints reference](https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_region) for format. Note: AWS CloudFront allows specifying an S3 region-specific endpoint when creating an S3 origin. This will prevent redirect issues from CloudFront to the S3 Origin URL. For more information, see the [Virtual Hosted-Style Requests for Other Regions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/VirtualHosting.html#deprecated-global-endpoint) section in the AWS S3 User Guide.
        :param pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]] cors_rules: Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketCorsConfiguration` instead.
        :param pulumi.Input[_builtins.bool] force_destroy: Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input[Sequence[pulumi.Input['BucketGrantArgs']]] grants: An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        :param pulumi.Input[_builtins.str] hosted_zone_id: [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket's region.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]] lifecycle_rules: Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketLifecycleConfiguration` instead.
        :param pulumi.Input['BucketLoggingArgs'] logging: Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketLogging` instead.
        :param pulumi.Input['BucketObjectLockConfigurationArgs'] object_lock_configuration: Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
               The provider wil only perform drift detection if a configuration value is provided.
               Use the `object_lock_enabled` parameter and the resource `s3.BucketObjectLockConfiguration` instead.
        :param pulumi.Input[_builtins.bool] object_lock_enabled: Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
        :param pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']] policy: Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketPolicy` instead.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['BucketReplicationConfigurationArgs'] replication_configuration: Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketReplicationConfig` instead.
        :param pulumi.Input[_builtins.str] request_payer: Specifies who should bear the cost of Amazon S3 data transfer.
               Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
               See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketRequestPaymentConfiguration` instead.
        :param pulumi.Input['BucketServerSideEncryptionConfigurationArgs'] server_side_encryption_configuration: Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketServerSideEncryptionConfiguration` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               The following arguments are deprecated, and will be removed in a future major version:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input['BucketVersioningArgs'] versioning: Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketVersioning` instead.
        :param pulumi.Input['BucketWebsiteArgs'] website: Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketWebsiteConfiguration` instead.
        :param pulumi.Input[_builtins.str] website_domain: (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `s3.BucketWebsiteConfiguration` instead.
        :param pulumi.Input[_builtins.str] website_endpoint: (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `s3.BucketWebsiteConfiguration` instead.
        """
        if acceleration_status is not None:
            warnings.warn("""acceleration_status is deprecated. Use the s3.BucketAccelerateConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""acceleration_status is deprecated: acceleration_status is deprecated. Use the s3.BucketAccelerateConfiguration resource instead.""")
        if acceleration_status is not None:
            pulumi.set(__self__, "acceleration_status", acceleration_status)
        if acl is not None:
            warnings.warn("""acl is deprecated. Use the s3.BucketAcl resource instead.""", DeprecationWarning)
            pulumi.log.warn("""acl is deprecated: acl is deprecated. Use the s3.BucketAcl resource instead.""")
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if bucket_domain_name is not None:
            pulumi.set(__self__, "bucket_domain_name", bucket_domain_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if bucket_region is not None:
            pulumi.set(__self__, "bucket_region", bucket_region)
        if bucket_regional_domain_name is not None:
            pulumi.set(__self__, "bucket_regional_domain_name", bucket_regional_domain_name)
        if cors_rules is not None:
            warnings.warn("""cors_rule is deprecated. Use the s3.BucketCorsConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""cors_rules is deprecated: cors_rule is deprecated. Use the s3.BucketCorsConfiguration resource instead.""")
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if grants is not None:
            warnings.warn("""grant is deprecated. Use the s3.BucketAcl resource instead.""", DeprecationWarning)
            pulumi.log.warn("""grants is deprecated: grant is deprecated. Use the s3.BucketAcl resource instead.""")
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if lifecycle_rules is not None:
            warnings.warn("""lifecycle_rule is deprecated. Use the s3.BucketLifecycleConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""lifecycle_rules is deprecated: lifecycle_rule is deprecated. Use the s3.BucketLifecycleConfiguration resource instead.""")
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if logging is not None:
            warnings.warn("""logging is deprecated. Use the s3.BucketLogging resource instead.""", DeprecationWarning)
            pulumi.log.warn("""logging is deprecated: logging is deprecated. Use the s3.BucketLogging resource instead.""")
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if object_lock_configuration is not None:
            warnings.warn("""object_lock_configuration is deprecated. Use the top-level parameter object_lock_enabled and the s3.BucketObjectLockConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""object_lock_configuration is deprecated: object_lock_configuration is deprecated. Use the top-level parameter object_lock_enabled and the s3.BucketObjectLockConfiguration resource instead.""")
        if object_lock_configuration is not None:
            pulumi.set(__self__, "object_lock_configuration", object_lock_configuration)
        if object_lock_enabled is not None:
            pulumi.set(__self__, "object_lock_enabled", object_lock_enabled)
        if policy is not None:
            warnings.warn("""policy is deprecated. Use the s3.BucketPolicy resource instead.""", DeprecationWarning)
            pulumi.log.warn("""policy is deprecated: policy is deprecated. Use the s3.BucketPolicy resource instead.""")
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_configuration is not None:
            warnings.warn("""replication_configuration is deprecated. Use the s3.BucketReplicationConfig resource instead.""", DeprecationWarning)
            pulumi.log.warn("""replication_configuration is deprecated: replication_configuration is deprecated. Use the s3.BucketReplicationConfig resource instead.""")
        if replication_configuration is not None:
            pulumi.set(__self__, "replication_configuration", replication_configuration)
        if request_payer is not None:
            warnings.warn("""request_payer is deprecated. Use the s3.BucketRequestPaymentConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""request_payer is deprecated: request_payer is deprecated. Use the s3.BucketRequestPaymentConfiguration resource instead.""")
        if request_payer is not None:
            pulumi.set(__self__, "request_payer", request_payer)
        if server_side_encryption_configuration is not None:
            warnings.warn("""server_side_encryption_configuration is deprecated. Use the s3.BucketServerSideEncryptionConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""server_side_encryption_configuration is deprecated: server_side_encryption_configuration is deprecated. Use the s3.BucketServerSideEncryptionConfiguration resource instead.""")
        if server_side_encryption_configuration is not None:
            pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if versioning is not None:
            warnings.warn("""versioning is deprecated. Use the s3.BucketVersioning resource instead.""", DeprecationWarning)
            pulumi.log.warn("""versioning is deprecated: versioning is deprecated. Use the s3.BucketVersioning resource instead.""")
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            warnings.warn("""website is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""website is deprecated: website is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""")
        if website is not None:
            pulumi.set(__self__, "website", website)
        if website_domain is not None:
            warnings.warn("""website_domain is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""website_domain is deprecated: website_domain is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""")
        if website_domain is not None:
            pulumi.set(__self__, "website_domain", website_domain)
        if website_endpoint is not None:
            warnings.warn("""website_endpoint is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""", DeprecationWarning)
            pulumi.log.warn("""website_endpoint is deprecated: website_endpoint is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""")
        if website_endpoint is not None:
            pulumi.set(__self__, "website_endpoint", website_endpoint)

    @_builtins.property
    @pulumi.getter(name="accelerationStatus")
    @_utilities.deprecated("""acceleration_status is deprecated. Use the s3.BucketAccelerateConfiguration resource instead.""")
    def acceleration_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketAccelerateConfiguration` instead.
        """
        return pulumi.get(self, "acceleration_status")

    @acceleration_status.setter
    def acceleration_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acceleration_status", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""acl is deprecated. Use the s3.BucketAcl resource instead.""")
    def acl(self) -> Optional[pulumi.Input[Union[_builtins.str, 'CannedAcl']]]:
        """
        The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[Union[_builtins.str, 'CannedAcl']]]):
        pulumi.set(self, "acl", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html). The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.DirectoryBucket` resource to manage S3 Express buckets.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="bucketDomainName")
    def bucket_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Bucket domain name. Will be of format `bucketname.s3.amazonaws.com`.
        """
        return pulumi.get(self, "bucket_domain_name")

    @bucket_domain_name.setter
    def bucket_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_prefix", value)

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS region this bucket resides in.
        """
        return pulumi.get(self, "bucket_region")

    @bucket_region.setter
    def bucket_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_region", value)

    @_builtins.property
    @pulumi.getter(name="bucketRegionalDomainName")
    def bucket_regional_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bucket region-specific domain name. The bucket domain name including the region name. Please refer to the [S3 endpoints reference](https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_region) for format. Note: AWS CloudFront allows specifying an S3 region-specific endpoint when creating an S3 origin. This will prevent redirect issues from CloudFront to the S3 Origin URL. For more information, see the [Virtual Hosted-Style Requests for Other Regions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/VirtualHosting.html#deprecated-global-endpoint) section in the AWS S3 User Guide.
        """
        return pulumi.get(self, "bucket_regional_domain_name")

    @bucket_regional_domain_name.setter
    def bucket_regional_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_regional_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="corsRules")
    @_utilities.deprecated("""cors_rule is deprecated. Use the s3.BucketCorsConfiguration resource instead.""")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]:
        """
        Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketCorsConfiguration` instead.
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""grant is deprecated. Use the s3.BucketAcl resource instead.""")
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketGrantArgs']]]]:
        """
        An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketGrantArgs']]]]):
        pulumi.set(self, "grants", value)

    @_builtins.property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket's region.
        """
        return pulumi.get(self, "hosted_zone_id")

    @hosted_zone_id.setter
    def hosted_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hosted_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    @_utilities.deprecated("""lifecycle_rule is deprecated. Use the s3.BucketLifecycleConfiguration resource instead.""")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]:
        """
        Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketLifecycleConfiguration` instead.
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""logging is deprecated. Use the s3.BucketLogging resource instead.""")
    def logging(self) -> Optional[pulumi.Input['BucketLoggingArgs']]:
        """
        Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketLogging` instead.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['BucketLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="objectLockConfiguration")
    @_utilities.deprecated("""object_lock_configuration is deprecated. Use the top-level parameter object_lock_enabled and the s3.BucketObjectLockConfiguration resource instead.""")
    def object_lock_configuration(self) -> Optional[pulumi.Input['BucketObjectLockConfigurationArgs']]:
        """
        Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
        The provider wil only perform drift detection if a configuration value is provided.
        Use the `object_lock_enabled` parameter and the resource `s3.BucketObjectLockConfiguration` instead.
        """
        return pulumi.get(self, "object_lock_configuration")

    @object_lock_configuration.setter
    def object_lock_configuration(self, value: Optional[pulumi.Input['BucketObjectLockConfigurationArgs']]):
        pulumi.set(self, "object_lock_configuration", value)

    @_builtins.property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
        """
        return pulumi.get(self, "object_lock_enabled")

    @object_lock_enabled.setter
    def object_lock_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "object_lock_enabled", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""policy is deprecated. Use the s3.BucketPolicy resource instead.""")
    def policy(self) -> Optional[pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']]]:
        """
        Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
        The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketPolicy` instead.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[Union[_builtins.str, 'PolicyDocumentArgs']]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationConfiguration")
    @_utilities.deprecated("""replication_configuration is deprecated. Use the s3.BucketReplicationConfig resource instead.""")
    def replication_configuration(self) -> Optional[pulumi.Input['BucketReplicationConfigurationArgs']]:
        """
        Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketReplicationConfig` instead.
        """
        return pulumi.get(self, "replication_configuration")

    @replication_configuration.setter
    def replication_configuration(self, value: Optional[pulumi.Input['BucketReplicationConfigurationArgs']]):
        pulumi.set(self, "replication_configuration", value)

    @_builtins.property
    @pulumi.getter(name="requestPayer")
    @_utilities.deprecated("""request_payer is deprecated. Use the s3.BucketRequestPaymentConfiguration resource instead.""")
    def request_payer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies who should bear the cost of Amazon S3 data transfer.
        Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
        See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
        The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketRequestPaymentConfiguration` instead.
        """
        return pulumi.get(self, "request_payer")

    @request_payer.setter
    def request_payer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_payer", value)

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    @_utilities.deprecated("""server_side_encryption_configuration is deprecated. Use the s3.BucketServerSideEncryptionConfiguration resource instead.""")
    def server_side_encryption_configuration(self) -> Optional[pulumi.Input['BucketServerSideEncryptionConfigurationArgs']]:
        """
        Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
        The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketServerSideEncryptionConfiguration` instead.
        """
        return pulumi.get(self, "server_side_encryption_configuration")

    @server_side_encryption_configuration.setter
    def server_side_encryption_configuration(self, value: Optional[pulumi.Input['BucketServerSideEncryptionConfigurationArgs']]):
        pulumi.set(self, "server_side_encryption_configuration", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        The following arguments are deprecated, and will be removed in a future major version:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""versioning is deprecated. Use the s3.BucketVersioning resource instead.""")
    def versioning(self) -> Optional[pulumi.Input['BucketVersioningArgs']]:
        """
        Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketVersioning` instead.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['BucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""website is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""")
    def website(self) -> Optional[pulumi.Input['BucketWebsiteArgs']]:
        """
        Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketWebsiteConfiguration` instead.
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['BucketWebsiteArgs']]):
        pulumi.set(self, "website", value)

    @_builtins.property
    @pulumi.getter(name="websiteDomain")
    @_utilities.deprecated("""website_domain is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""")
    def website_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `s3.BucketWebsiteConfiguration` instead.
        """
        return pulumi.get(self, "website_domain")

    @website_domain.setter
    def website_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "website_domain", value)

    @_builtins.property
    @pulumi.getter(name="websiteEndpoint")
    @_utilities.deprecated("""website_endpoint is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""")
    def website_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `s3.BucketWebsiteConfiguration` instead.
        """
        return pulumi.get(self, "website_endpoint")

    @website_endpoint.setter
    def website_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "website_endpoint", value)


@pulumi.type_token("aws:s3/bucket:Bucket")
class Bucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acceleration_status: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[Union[_builtins.str, 'CannedAcl']]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketCorsRuleArgs', 'BucketCorsRuleArgsDict']]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketGrantArgs', 'BucketGrantArgsDict']]]]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]]] = None,
                 logging: Optional[pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']]] = None,
                 object_lock_configuration: Optional[pulumi.Input[Union['BucketObjectLockConfigurationArgs', 'BucketObjectLockConfigurationArgsDict']]] = None,
                 object_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[Union[_builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_configuration: Optional[pulumi.Input[Union['BucketReplicationConfigurationArgs', 'BucketReplicationConfigurationArgsDict']]] = None,
                 request_payer: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input[Union['BucketServerSideEncryptionConfigurationArgs', 'BucketServerSideEncryptionConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']]] = None,
                 website: Optional[pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']]] = None,
                 __props__=None):
        """
        Provides a S3 bucket resource.

        > This resource provides functionality for managing S3 general purpose buckets in an AWS Partition. To manage Amazon S3 Express directory buckets, use the `aws_directory_bucket` resource. To manage [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html), use the `s3control.Bucket` resource.

        > Object Lock can be enabled by using the `object_lock_enable` attribute or by using the `s3.BucketObjectLockConfiguration` resource. Please note, that by using the resource, Object Lock can be enabled/disabled without destroying and recreating the bucket.

        ## Example Usage

        ### Private Bucket With Tags

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example",
            bucket="my-tf-test-bucket",
            tags={
                "Name": "My bucket",
                "Environment": "Dev",
            })
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `bucket` (String) Name of the S3 bucket.

        #### Optional

        * `account_id` (String) AWS Account where this resource is managed.

        * `region` (String) Region where this resource is managed.

        Using `pulumi import`, import S3 bucket using the `bucket`. For example:

        console

        % pulumi import aws_s3_bucket.example bucket-name

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acceleration_status: Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketAccelerateConfiguration` instead.
        :param pulumi.Input[Union[_builtins.str, 'CannedAcl']] acl: The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html). The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.DirectoryBucket` resource to manage S3 Express buckets.
        :param pulumi.Input[_builtins.str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketCorsRuleArgs', 'BucketCorsRuleArgsDict']]]] cors_rules: Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketCorsConfiguration` instead.
        :param pulumi.Input[_builtins.bool] force_destroy: Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketGrantArgs', 'BucketGrantArgsDict']]]] grants: An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]] lifecycle_rules: Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketLifecycleConfiguration` instead.
        :param pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']] logging: Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketLogging` instead.
        :param pulumi.Input[Union['BucketObjectLockConfigurationArgs', 'BucketObjectLockConfigurationArgsDict']] object_lock_configuration: Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
               The provider wil only perform drift detection if a configuration value is provided.
               Use the `object_lock_enabled` parameter and the resource `s3.BucketObjectLockConfiguration` instead.
        :param pulumi.Input[_builtins.bool] object_lock_enabled: Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
        :param pulumi.Input[Union[_builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]] policy: Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketPolicy` instead.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['BucketReplicationConfigurationArgs', 'BucketReplicationConfigurationArgsDict']] replication_configuration: Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketReplicationConfig` instead.
        :param pulumi.Input[_builtins.str] request_payer: Specifies who should bear the cost of Amazon S3 data transfer.
               Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
               See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketRequestPaymentConfiguration` instead.
        :param pulumi.Input[Union['BucketServerSideEncryptionConfigurationArgs', 'BucketServerSideEncryptionConfigurationArgsDict']] server_side_encryption_configuration: Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketServerSideEncryptionConfiguration` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               The following arguments are deprecated, and will be removed in a future major version:
        :param pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']] versioning: Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketVersioning` instead.
        :param pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']] website: Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketWebsiteConfiguration` instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BucketArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a S3 bucket resource.

        > This resource provides functionality for managing S3 general purpose buckets in an AWS Partition. To manage Amazon S3 Express directory buckets, use the `aws_directory_bucket` resource. To manage [S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html), use the `s3control.Bucket` resource.

        > Object Lock can be enabled by using the `object_lock_enable` attribute or by using the `s3.BucketObjectLockConfiguration` resource. Please note, that by using the resource, Object Lock can be enabled/disabled without destroying and recreating the bucket.

        ## Example Usage

        ### Private Bucket With Tags

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example",
            bucket="my-tf-test-bucket",
            tags={
                "Name": "My bucket",
                "Environment": "Dev",
            })
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `bucket` (String) Name of the S3 bucket.

        #### Optional

        * `account_id` (String) AWS Account where this resource is managed.

        * `region` (String) Region where this resource is managed.

        Using `pulumi import`, import S3 bucket using the `bucket`. For example:

        console

        % pulumi import aws_s3_bucket.example bucket-name

        :param str resource_name: The name of the resource.
        :param BucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acceleration_status: Optional[pulumi.Input[_builtins.str]] = None,
                 acl: Optional[pulumi.Input[Union[_builtins.str, 'CannedAcl']]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketCorsRuleArgs', 'BucketCorsRuleArgsDict']]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketGrantArgs', 'BucketGrantArgsDict']]]]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]]] = None,
                 logging: Optional[pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']]] = None,
                 object_lock_configuration: Optional[pulumi.Input[Union['BucketObjectLockConfigurationArgs', 'BucketObjectLockConfigurationArgsDict']]] = None,
                 object_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[Union[_builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_configuration: Optional[pulumi.Input[Union['BucketReplicationConfigurationArgs', 'BucketReplicationConfigurationArgsDict']]] = None,
                 request_payer: Optional[pulumi.Input[_builtins.str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input[Union['BucketServerSideEncryptionConfigurationArgs', 'BucketServerSideEncryptionConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 versioning: Optional[pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']]] = None,
                 website: Optional[pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketArgs.__new__(BucketArgs)

            __props__.__dict__["acceleration_status"] = acceleration_status
            __props__.__dict__["acl"] = acl
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["bucket_prefix"] = bucket_prefix
            __props__.__dict__["cors_rules"] = cors_rules
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["grants"] = grants
            __props__.__dict__["lifecycle_rules"] = lifecycle_rules
            __props__.__dict__["logging"] = logging
            __props__.__dict__["object_lock_configuration"] = object_lock_configuration
            __props__.__dict__["object_lock_enabled"] = object_lock_enabled
            __props__.__dict__["policy"] = policy
            __props__.__dict__["region"] = region
            __props__.__dict__["replication_configuration"] = replication_configuration
            __props__.__dict__["request_payer"] = request_payer
            __props__.__dict__["server_side_encryption_configuration"] = server_side_encryption_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["versioning"] = versioning
            __props__.__dict__["website"] = website
            __props__.__dict__["arn"] = None
            __props__.__dict__["bucket_domain_name"] = None
            __props__.__dict__["bucket_region"] = None
            __props__.__dict__["bucket_regional_domain_name"] = None
            __props__.__dict__["hosted_zone_id"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["website_domain"] = None
            __props__.__dict__["website_endpoint"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:s3/bucketV2:BucketV2"), pulumi.Alias(type_="aws:s3/bucketV2:BucketV2")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Bucket, __self__).__init__(
            'aws:s3/bucket:Bucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acceleration_status: Optional[pulumi.Input[_builtins.str]] = None,
            acl: Optional[pulumi.Input[Union[_builtins.str, 'CannedAcl']]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_region: Optional[pulumi.Input[_builtins.str]] = None,
            bucket_regional_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketCorsRuleArgs', 'BucketCorsRuleArgsDict']]]]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketGrantArgs', 'BucketGrantArgsDict']]]]] = None,
            hosted_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]]] = None,
            logging: Optional[pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']]] = None,
            object_lock_configuration: Optional[pulumi.Input[Union['BucketObjectLockConfigurationArgs', 'BucketObjectLockConfigurationArgsDict']]] = None,
            object_lock_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            policy: Optional[pulumi.Input[Union[_builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replication_configuration: Optional[pulumi.Input[Union['BucketReplicationConfigurationArgs', 'BucketReplicationConfigurationArgsDict']]] = None,
            request_payer: Optional[pulumi.Input[_builtins.str]] = None,
            server_side_encryption_configuration: Optional[pulumi.Input[Union['BucketServerSideEncryptionConfigurationArgs', 'BucketServerSideEncryptionConfigurationArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            versioning: Optional[pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']]] = None,
            website: Optional[pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']]] = None,
            website_domain: Optional[pulumi.Input[_builtins.str]] = None,
            website_endpoint: Optional[pulumi.Input[_builtins.str]] = None) -> 'Bucket':
        """
        Get an existing Bucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acceleration_status: Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketAccelerateConfiguration` instead.
        :param pulumi.Input[Union[_builtins.str, 'CannedAcl']] acl: The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        :param pulumi.Input[_builtins.str] arn: ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html). The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.DirectoryBucket` resource to manage S3 Express buckets.
        :param pulumi.Input[_builtins.str] bucket_domain_name: Bucket domain name. Will be of format `bucketname.s3.amazonaws.com`.
        :param pulumi.Input[_builtins.str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
        :param pulumi.Input[_builtins.str] bucket_region: AWS region this bucket resides in.
        :param pulumi.Input[_builtins.str] bucket_regional_domain_name: The bucket region-specific domain name. The bucket domain name including the region name. Please refer to the [S3 endpoints reference](https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_region) for format. Note: AWS CloudFront allows specifying an S3 region-specific endpoint when creating an S3 origin. This will prevent redirect issues from CloudFront to the S3 Origin URL. For more information, see the [Virtual Hosted-Style Requests for Other Regions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/VirtualHosting.html#deprecated-global-endpoint) section in the AWS S3 User Guide.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketCorsRuleArgs', 'BucketCorsRuleArgsDict']]]] cors_rules: Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketCorsConfiguration` instead.
        :param pulumi.Input[_builtins.bool] force_destroy: Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketGrantArgs', 'BucketGrantArgsDict']]]] grants: An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        :param pulumi.Input[_builtins.str] hosted_zone_id: [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket's region.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]] lifecycle_rules: Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketLifecycleConfiguration` instead.
        :param pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']] logging: Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketLogging` instead.
        :param pulumi.Input[Union['BucketObjectLockConfigurationArgs', 'BucketObjectLockConfigurationArgsDict']] object_lock_configuration: Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
               The provider wil only perform drift detection if a configuration value is provided.
               Use the `object_lock_enabled` parameter and the resource `s3.BucketObjectLockConfiguration` instead.
        :param pulumi.Input[_builtins.bool] object_lock_enabled: Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
        :param pulumi.Input[Union[_builtins.str, Union['PolicyDocumentArgs', 'PolicyDocumentArgsDict']]] policy: Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketPolicy` instead.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['BucketReplicationConfigurationArgs', 'BucketReplicationConfigurationArgsDict']] replication_configuration: Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketReplicationConfig` instead.
        :param pulumi.Input[_builtins.str] request_payer: Specifies who should bear the cost of Amazon S3 data transfer.
               Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
               See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketRequestPaymentConfiguration` instead.
        :param pulumi.Input[Union['BucketServerSideEncryptionConfigurationArgs', 'BucketServerSideEncryptionConfigurationArgsDict']] server_side_encryption_configuration: Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
               The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketServerSideEncryptionConfiguration` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               The following arguments are deprecated, and will be removed in a future major version:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']] versioning: Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketVersioning` instead.
        :param pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']] website: Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
               Use the resource `s3.BucketWebsiteConfiguration` instead.
        :param pulumi.Input[_builtins.str] website_domain: (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `s3.BucketWebsiteConfiguration` instead.
        :param pulumi.Input[_builtins.str] website_endpoint: (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `s3.BucketWebsiteConfiguration` instead.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketState.__new__(_BucketState)

        __props__.__dict__["acceleration_status"] = acceleration_status
        __props__.__dict__["acl"] = acl
        __props__.__dict__["arn"] = arn
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["bucket_domain_name"] = bucket_domain_name
        __props__.__dict__["bucket_prefix"] = bucket_prefix
        __props__.__dict__["bucket_region"] = bucket_region
        __props__.__dict__["bucket_regional_domain_name"] = bucket_regional_domain_name
        __props__.__dict__["cors_rules"] = cors_rules
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["grants"] = grants
        __props__.__dict__["hosted_zone_id"] = hosted_zone_id
        __props__.__dict__["lifecycle_rules"] = lifecycle_rules
        __props__.__dict__["logging"] = logging
        __props__.__dict__["object_lock_configuration"] = object_lock_configuration
        __props__.__dict__["object_lock_enabled"] = object_lock_enabled
        __props__.__dict__["policy"] = policy
        __props__.__dict__["region"] = region
        __props__.__dict__["replication_configuration"] = replication_configuration
        __props__.__dict__["request_payer"] = request_payer
        __props__.__dict__["server_side_encryption_configuration"] = server_side_encryption_configuration
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["versioning"] = versioning
        __props__.__dict__["website"] = website
        __props__.__dict__["website_domain"] = website_domain
        __props__.__dict__["website_endpoint"] = website_endpoint
        return Bucket(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accelerationStatus")
    @_utilities.deprecated("""acceleration_status is deprecated. Use the s3.BucketAccelerateConfiguration resource instead.""")
    def acceleration_status(self) -> pulumi.Output[_builtins.str]:
        """
        Sets the accelerate configuration of an existing bucket. Can be `Enabled` or `Suspended`. Cannot be used in `cn-north-1` or `us-gov-west-1`. This provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketAccelerateConfiguration` instead.
        """
        return pulumi.get(self, "acceleration_status")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""acl is deprecated. Use the s3.BucketAcl resource instead.""")
    def acl(self) -> pulumi.Output[_builtins.str]:
        """
        The [canned ACL](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) to apply. Valid values are `private`, `public-read`, `public-read-write`, `aws-exec-read`, `authenticated-read`, and `log-delivery-write`. Defaults to `private`.  Conflicts with `grant`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the bucket. Will be of format `arn:aws:s3:::bucketname`.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the bucket. If omitted, the provider will assign a random, unique name. Must be lowercase and less than or equal to 63 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html). The name must not be in the format `[bucket_name]--[azid]--x-s3`. Use the `s3.DirectoryBucket` resource to manage S3 Express buckets.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="bucketDomainName")
    def bucket_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Bucket domain name. Will be of format `bucketname.s3.amazonaws.com`.
        """
        return pulumi.get(self, "bucket_domain_name")

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`. Must be lowercase and less than or equal to 37 characters in length. A full list of bucket naming rules [may be found here](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
        """
        return pulumi.get(self, "bucket_prefix")

    @_builtins.property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> pulumi.Output[_builtins.str]:
        """
        AWS region this bucket resides in.
        """
        return pulumi.get(self, "bucket_region")

    @_builtins.property
    @pulumi.getter(name="bucketRegionalDomainName")
    def bucket_regional_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The bucket region-specific domain name. The bucket domain name including the region name. Please refer to the [S3 endpoints reference](https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_region) for format. Note: AWS CloudFront allows specifying an S3 region-specific endpoint when creating an S3 origin. This will prevent redirect issues from CloudFront to the S3 Origin URL. For more information, see the [Virtual Hosted-Style Requests for Other Regions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/VirtualHosting.html#deprecated-global-endpoint) section in the AWS S3 User Guide.
        """
        return pulumi.get(self, "bucket_regional_domain_name")

    @_builtins.property
    @pulumi.getter(name="corsRules")
    @_utilities.deprecated("""cors_rule is deprecated. Use the s3.BucketCorsConfiguration resource instead.""")
    def cors_rules(self) -> pulumi.Output[Sequence['outputs.BucketCorsRule']]:
        """
        Rule of [Cross-Origin Resource Sharing](https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html). See CORS rule below for details. This provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketCorsConfiguration` instead.
        """
        return pulumi.get(self, "cors_rules")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean that indicates all objects (including any [locked objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock-overview.html)) should be deleted from the bucket *when the bucket is destroyed* so that the bucket can be destroyed without error. These objects are *not* recoverable. This only deletes objects when the bucket is destroyed, *not* when setting this parameter to `true`. Once this parameter is set to `true`, there must be a successful `pulumi up` run before a destroy is required to update this value in the resource state. Without a successful `pulumi up` after this parameter is set, this flag will have no effect. If setting this field in the same operation that would require replacing the bucket or destroying the bucket, this flag will not work. Additionally when importing a bucket, a successful `pulumi up` is required to set this value in state before it will take effect on a destroy operation.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""grant is deprecated. Use the s3.BucketAcl resource instead.""")
    def grants(self) -> pulumi.Output[Sequence['outputs.BucketGrant']]:
        """
        An [ACL policy grant](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#sample-acl). See Grant below for details. Conflicts with `acl`. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketAcl` instead.
        """
        return pulumi.get(self, "grants")

    @_builtins.property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        [Route 53 Hosted Zone ID](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints) for this bucket's region.
        """
        return pulumi.get(self, "hosted_zone_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    @_utilities.deprecated("""lifecycle_rule is deprecated. Use the s3.BucketLifecycleConfiguration resource instead.""")
    def lifecycle_rules(self) -> pulumi.Output[Sequence['outputs.BucketLifecycleRule']]:
        """
        Configuration of [object lifecycle management](http://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html). See Lifecycle Rule below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketLifecycleConfiguration` instead.
        """
        return pulumi.get(self, "lifecycle_rules")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""logging is deprecated. Use the s3.BucketLogging resource instead.""")
    def logging(self) -> pulumi.Output['outputs.BucketLogging']:
        """
        Configuration of [S3 bucket logging](https://docs.aws.amazon.com/AmazonS3/latest/UG/ManagingBucketLogging.html) parameters. See Logging below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketLogging` instead.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter(name="objectLockConfiguration")
    @_utilities.deprecated("""object_lock_configuration is deprecated. Use the top-level parameter object_lock_enabled and the s3.BucketObjectLockConfiguration resource instead.""")
    def object_lock_configuration(self) -> pulumi.Output['outputs.BucketObjectLockConfiguration']:
        """
        Configuration of [S3 object locking](https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html). See Object Lock Configuration below for details.
        The provider wil only perform drift detection if a configuration value is provided.
        Use the `object_lock_enabled` parameter and the resource `s3.BucketObjectLockConfiguration` instead.
        """
        return pulumi.get(self, "object_lock_configuration")

    @_builtins.property
    @pulumi.getter(name="objectLockEnabled")
    def object_lock_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
        """
        return pulumi.get(self, "object_lock_enabled")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""policy is deprecated. Use the s3.BucketPolicy resource instead.""")
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        Valid [bucket policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/example-bucket-policies.html) JSON document. Note that if the policy document is not specific enough (but still valid), this provider may view the policy as constantly changing. In this case, please make sure you use the verbose/specific version of the policy. For more information about building AWS IAM policy documents with this provider, see the AWS IAM Policy Document Guide.
        The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketPolicy` instead.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicationConfiguration")
    @_utilities.deprecated("""replication_configuration is deprecated. Use the s3.BucketReplicationConfig resource instead.""")
    def replication_configuration(self) -> pulumi.Output['outputs.BucketReplicationConfiguration']:
        """
        Configuration of [replication configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html). See Replication Configuration below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketReplicationConfig` instead.
        """
        return pulumi.get(self, "replication_configuration")

    @_builtins.property
    @pulumi.getter(name="requestPayer")
    @_utilities.deprecated("""request_payer is deprecated. Use the s3.BucketRequestPaymentConfiguration resource instead.""")
    def request_payer(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies who should bear the cost of Amazon S3 data transfer.
        Can be either `BucketOwner` or `Requester`. By default, the owner of the S3 bucket would incur the costs of any data transfer.
        See [Requester Pays Buckets](http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) developer guide for more information.
        The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketRequestPaymentConfiguration` instead.
        """
        return pulumi.get(self, "request_payer")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    @_utilities.deprecated("""server_side_encryption_configuration is deprecated. Use the s3.BucketServerSideEncryptionConfiguration resource instead.""")
    def server_side_encryption_configuration(self) -> pulumi.Output['outputs.BucketServerSideEncryptionConfiguration']:
        """
        Configuration of [server-side encryption configuration](http://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html). See Server Side Encryption Configuration below for details.
        The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketServerSideEncryptionConfiguration` instead.
        """
        return pulumi.get(self, "server_side_encryption_configuration")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the bucket. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        The following arguments are deprecated, and will be removed in a future major version:
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""versioning is deprecated. Use the s3.BucketVersioning resource instead.""")
    def versioning(self) -> pulumi.Output['outputs.BucketVersioning']:
        """
        Configuration of the [S3 bucket versioning state](https://docs.aws.amazon.com/AmazonS3/latest/dev/Versioning.html). See Versioning below for details. The provider will only perform drift detection if a configuration value is provided. Use the resource `s3.BucketVersioning` instead.
        """
        return pulumi.get(self, "versioning")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""website is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""")
    def website(self) -> pulumi.Output['outputs.BucketWebsite']:
        """
        Configuration of the [S3 bucket website](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html). See Website below for details. The provider will only perform drift detection if a configuration value is provided.
        Use the resource `s3.BucketWebsiteConfiguration` instead.
        """
        return pulumi.get(self, "website")

    @_builtins.property
    @pulumi.getter(name="websiteDomain")
    @_utilities.deprecated("""website_domain is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""")
    def website_domain(self) -> pulumi.Output[_builtins.str]:
        """
        (**Deprecated**) Domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string. This is used to create Route 53 alias records. Use the resource `s3.BucketWebsiteConfiguration` instead.
        """
        return pulumi.get(self, "website_domain")

    @_builtins.property
    @pulumi.getter(name="websiteEndpoint")
    @_utilities.deprecated("""website_endpoint is deprecated. Use the s3.BucketWebsiteConfiguration resource instead.""")
    def website_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        (**Deprecated**) Website endpoint, if the bucket is configured with a website. If not, this will be an empty string. Use the resource `s3.BucketWebsiteConfiguration` instead.
        """
        return pulumi.get(self, "website_endpoint")

