# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketLifecycleConfigurationArgs', 'BucketLifecycleConfiguration']

@pulumi.input_type
class BucketLifecycleConfigurationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleConfigurationRuleArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['BucketLifecycleConfigurationTimeoutsArgs']] = None,
                 transition_default_minimum_object_size: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BucketLifecycleConfiguration resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the source S3 bucket you want Amazon S3 to monitor.
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleConfigurationRuleArgs']]] rules: List of configuration blocks describing the rules managing the replication. See below.
        :param pulumi.Input[_builtins.str] transition_default_minimum_object_size: The default minimum object size behavior applied to the lifecycle configuration. Valid values: `all_storage_classes_128K` (default), `varies_by_storage_class`. To customize the minimum object size for any transition you can add a `filter` that specifies a custom `object_size_greater_than` or `object_size_less_than` value. Custom filters always take precedence over the default transition behavior.
        """
        pulumi.set(__self__, "bucket", bucket)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if transition_default_minimum_object_size is not None:
            pulumi.set(__self__, "transition_default_minimum_object_size", transition_default_minimum_object_size)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the source S3 bucket you want Amazon S3 to monitor.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleConfigurationRuleArgs']]]]:
        """
        List of configuration blocks describing the rules managing the replication. See below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleConfigurationRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['BucketLifecycleConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['BucketLifecycleConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="transitionDefaultMinimumObjectSize")
    def transition_default_minimum_object_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default minimum object size behavior applied to the lifecycle configuration. Valid values: `all_storage_classes_128K` (default), `varies_by_storage_class`. To customize the minimum object size for any transition you can add a `filter` that specifies a custom `object_size_greater_than` or `object_size_less_than` value. Custom filters always take precedence over the default transition behavior.
        """
        return pulumi.get(self, "transition_default_minimum_object_size")

    @transition_default_minimum_object_size.setter
    def transition_default_minimum_object_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transition_default_minimum_object_size", value)


@pulumi.input_type
class _BucketLifecycleConfigurationState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleConfigurationRuleArgs']]]] = None,
                 timeouts: Optional[pulumi.Input['BucketLifecycleConfigurationTimeoutsArgs']] = None,
                 transition_default_minimum_object_size: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketLifecycleConfiguration resources.
        :param pulumi.Input[_builtins.str] bucket: Name of the source S3 bucket you want Amazon S3 to monitor.
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleConfigurationRuleArgs']]] rules: List of configuration blocks describing the rules managing the replication. See below.
        :param pulumi.Input[_builtins.str] transition_default_minimum_object_size: The default minimum object size behavior applied to the lifecycle configuration. Valid values: `all_storage_classes_128K` (default), `varies_by_storage_class`. To customize the minimum object size for any transition you can add a `filter` that specifies a custom `object_size_greater_than` or `object_size_less_than` value. Custom filters always take precedence over the default transition behavior.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if transition_default_minimum_object_size is not None:
            pulumi.set(__self__, "transition_default_minimum_object_size", transition_default_minimum_object_size)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the source S3 bucket you want Amazon S3 to monitor.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleConfigurationRuleArgs']]]]:
        """
        List of configuration blocks describing the rules managing the replication. See below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleConfigurationRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['BucketLifecycleConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['BucketLifecycleConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="transitionDefaultMinimumObjectSize")
    def transition_default_minimum_object_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default minimum object size behavior applied to the lifecycle configuration. Valid values: `all_storage_classes_128K` (default), `varies_by_storage_class`. To customize the minimum object size for any transition you can add a `filter` that specifies a custom `object_size_greater_than` or `object_size_less_than` value. Custom filters always take precedence over the default transition behavior.
        """
        return pulumi.get(self, "transition_default_minimum_object_size")

    @transition_default_minimum_object_size.setter
    def transition_default_minimum_object_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transition_default_minimum_object_size", value)


@pulumi.type_token("aws:s3/bucketLifecycleConfiguration:BucketLifecycleConfiguration")
class BucketLifecycleConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleConfigurationRuleArgs', 'BucketLifecycleConfigurationRuleArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['BucketLifecycleConfigurationTimeoutsArgs', 'BucketLifecycleConfigurationTimeoutsArgsDict']]] = None,
                 transition_default_minimum_object_size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an independent configuration resource for S3 bucket [lifecycle configuration](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html).

        An S3 Lifecycle configuration consists of one or more Lifecycle rules. Each rule consists of the following:

        * Rule metadata (`id` and `status`)
        * Filter identifying objects to which the rule applies
        * One or more transition or expiration actions

        For more information see the Amazon S3 User Guide on [`Lifecycle Configuration Elements`](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html).

        > S3 Buckets only support a single lifecycle configuration. Declaring multiple `s3.BucketLifecycleConfiguration` resources to the same S3 Bucket will cause a perpetual difference in configuration.

        > Lifecycle configurations may take some time to fully propagate to all AWS S3 systems.
        Running Pulumi operations shortly after creating a lifecycle configuration may result in changes that affect configuration idempotence.
        See the Amazon S3 User Guide on [setting lifecycle configuration on a bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/how-to-set-lifecycle-configuration-intro.html).

        ## Example Usage

        ### With neither a filter nor prefix specified

        When you don't specify a filter or prefix, the lifecycle rule applies to all objects in the bucket. This has the same effect as setting an empty `filter` element.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "status": "Enabled",
            }])
        ```

        ### Specifying an empty filter

        The Lifecycle rule applies to all objects in the bucket.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {},
                "status": "Enabled",
            }])
        ```

        ### Specifying a filter using key prefixes

        The Lifecycle rule applies to a subset of objects based on the key name prefix (`logs/`).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {
                    "prefix": "logs/",
                },
                "status": "Enabled",
            }])
        ```

        If you want to apply a Lifecycle action to a subset of objects based on different key name prefixes, specify separate rules.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[
                {
                    "id": "rule-1",
                    "filter": {
                        "prefix": "logs/",
                    },
                    "status": "Enabled",
                },
                {
                    "id": "rule-2",
                    "filter": {
                        "prefix": "tmp/",
                    },
                    "status": "Enabled",
                },
            ])
        ```

        ### Specifying a filter based on an object tag

        The Lifecycle rule specifies a filter based on a tag key and value. The rule then applies only to a subset of objects with the specific tag.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {
                    "tag": {
                        "key": "Name",
                        "value": "Staging",
                    },
                },
                "status": "Enabled",
            }])
        ```

        ### Specifying a filter based on multiple tags

        The Lifecycle rule directs Amazon S3 to perform lifecycle actions on objects with two tags (with the specific tag keys and values). Notice `tags` is wrapped in the `and` configuration block.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {
                    "and_": {
                        "tags": {
                            "Key1": "Value1",
                            "Key2": "Value2",
                        },
                    },
                },
                "status": "Enabled",
            }])
        ```

        ### Specifying a filter based on both prefix and one or more tags

        The Lifecycle rule directs Amazon S3 to perform lifecycle actions on objects with the specified prefix and two tags (with the specific tag keys and values). Notice both `prefix` and `tags` are wrapped in the `and` configuration block.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {
                    "and_": {
                        "prefix": "logs/",
                        "tags": {
                            "Key1": "Value1",
                            "Key2": "Value2",
                        },
                    },
                },
                "status": "Enabled",
            }])
        ```

        ### Specifying a filter based on object size

        Object size values are in bytes. Maximum filter size is 5TB. Amazon S3 applies a default behavior to your Lifecycle configuration that prevents objects smaller than 128 KB from being transitioned to any storage class. You can allow smaller objects to transition by adding a minimum size (`object_size_greater_than`) or a maximum size (`object_size_less_than`) filter that specifies a smaller size to the configuration. This example allows any object smaller than 128 KB to transition to the S3 Glacier Instant Retrieval storage class:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "Allow small object transitions",
                "filter": {
                    "object_size_greater_than": 1,
                },
                "status": "Enabled",
                "transitions": [{
                    "days": 365,
                    "storage_class": "GLACIER_IR",
                }],
            }])
        ```

        ### Specifying a filter based on object size range and prefix

        The `object_size_greater_than` must be less than the `object_size_less_than`. Notice both the object size range and prefix are wrapped in the `and` configuration block.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {
                    "and_": {
                        "prefix": "logs/",
                        "object_size_greater_than": 500,
                        "object_size_less_than": 64000,
                    },
                },
                "status": "Enabled",
            }])
        ```

        ### Creating a Lifecycle Configuration for a bucket with versioning

        ```python
        import pulumi
        import pulumi_aws as aws

        bucket = aws.s3.Bucket("bucket", bucket="my-bucket")
        bucket_acl = aws.s3.BucketAcl("bucket_acl",
            bucket=bucket.id,
            acl="private")
        bucket_config = aws.s3.BucketLifecycleConfiguration("bucket-config",
            bucket=bucket.id,
            rules=[
                {
                    "id": "log",
                    "expiration": {
                        "days": 90,
                    },
                    "filter": {
                        "and_": {
                            "prefix": "log/",
                            "tags": {
                                "rule": "log",
                                "autoclean": "true",
                            },
                        },
                    },
                    "status": "Enabled",
                    "transitions": [
                        {
                            "days": 30,
                            "storage_class": "STANDARD_IA",
                        },
                        {
                            "days": 60,
                            "storage_class": "GLACIER",
                        },
                    ],
                },
                {
                    "id": "tmp",
                    "filter": {
                        "prefix": "tmp/",
                    },
                    "expiration": {
                        "date": "2023-01-13T00:00:00Z",
                    },
                    "status": "Enabled",
                },
            ])
        versioning_bucket = aws.s3.Bucket("versioning_bucket", bucket="my-versioning-bucket")
        versioning_bucket_acl = aws.s3.BucketAcl("versioning_bucket_acl",
            bucket=versioning_bucket.id,
            acl="private")
        versioning = aws.s3.BucketVersioning("versioning",
            bucket=versioning_bucket.id,
            versioning_configuration={
                "status": "Enabled",
            })
        versioning_bucket_config = aws.s3.BucketLifecycleConfiguration("versioning-bucket-config",
            bucket=versioning_bucket.id,
            rules=[{
                "id": "config",
                "filter": {
                    "prefix": "config/",
                },
                "noncurrent_version_expiration": {
                    "noncurrent_days": 90,
                },
                "noncurrent_version_transitions": [
                    {
                        "noncurrent_days": 30,
                        "storage_class": "STANDARD_IA",
                    },
                    {
                        "noncurrent_days": 60,
                        "storage_class": "GLACIER",
                    },
                ],
                "status": "Enabled",
            }],
            opts = pulumi.ResourceOptions(depends_on=[versioning]))
        ```

        ## Import

        If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        Using `pulumi import`, import an S3 bucket lifecycle configuration using the `bucket` or the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:

        If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:

        ```sh
        $ pulumi import aws:s3/bucketLifecycleConfiguration:BucketLifecycleConfiguration example bucket-name
        ```
        If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        ```sh
        $ pulumi import aws:s3/bucketLifecycleConfiguration:BucketLifecycleConfiguration example bucket-name,123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the source S3 bucket you want Amazon S3 to monitor.
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleConfigurationRuleArgs', 'BucketLifecycleConfigurationRuleArgsDict']]]] rules: List of configuration blocks describing the rules managing the replication. See below.
        :param pulumi.Input[_builtins.str] transition_default_minimum_object_size: The default minimum object size behavior applied to the lifecycle configuration. Valid values: `all_storage_classes_128K` (default), `varies_by_storage_class`. To customize the minimum object size for any transition you can add a `filter` that specifies a custom `object_size_greater_than` or `object_size_less_than` value. Custom filters always take precedence over the default transition behavior.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketLifecycleConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an independent configuration resource for S3 bucket [lifecycle configuration](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html).

        An S3 Lifecycle configuration consists of one or more Lifecycle rules. Each rule consists of the following:

        * Rule metadata (`id` and `status`)
        * Filter identifying objects to which the rule applies
        * One or more transition or expiration actions

        For more information see the Amazon S3 User Guide on [`Lifecycle Configuration Elements`](https://docs.aws.amazon.com/AmazonS3/latest/userguide/intro-lifecycle-rules.html).

        > S3 Buckets only support a single lifecycle configuration. Declaring multiple `s3.BucketLifecycleConfiguration` resources to the same S3 Bucket will cause a perpetual difference in configuration.

        > Lifecycle configurations may take some time to fully propagate to all AWS S3 systems.
        Running Pulumi operations shortly after creating a lifecycle configuration may result in changes that affect configuration idempotence.
        See the Amazon S3 User Guide on [setting lifecycle configuration on a bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/how-to-set-lifecycle-configuration-intro.html).

        ## Example Usage

        ### With neither a filter nor prefix specified

        When you don't specify a filter or prefix, the lifecycle rule applies to all objects in the bucket. This has the same effect as setting an empty `filter` element.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "status": "Enabled",
            }])
        ```

        ### Specifying an empty filter

        The Lifecycle rule applies to all objects in the bucket.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {},
                "status": "Enabled",
            }])
        ```

        ### Specifying a filter using key prefixes

        The Lifecycle rule applies to a subset of objects based on the key name prefix (`logs/`).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {
                    "prefix": "logs/",
                },
                "status": "Enabled",
            }])
        ```

        If you want to apply a Lifecycle action to a subset of objects based on different key name prefixes, specify separate rules.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[
                {
                    "id": "rule-1",
                    "filter": {
                        "prefix": "logs/",
                    },
                    "status": "Enabled",
                },
                {
                    "id": "rule-2",
                    "filter": {
                        "prefix": "tmp/",
                    },
                    "status": "Enabled",
                },
            ])
        ```

        ### Specifying a filter based on an object tag

        The Lifecycle rule specifies a filter based on a tag key and value. The rule then applies only to a subset of objects with the specific tag.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {
                    "tag": {
                        "key": "Name",
                        "value": "Staging",
                    },
                },
                "status": "Enabled",
            }])
        ```

        ### Specifying a filter based on multiple tags

        The Lifecycle rule directs Amazon S3 to perform lifecycle actions on objects with two tags (with the specific tag keys and values). Notice `tags` is wrapped in the `and` configuration block.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {
                    "and_": {
                        "tags": {
                            "Key1": "Value1",
                            "Key2": "Value2",
                        },
                    },
                },
                "status": "Enabled",
            }])
        ```

        ### Specifying a filter based on both prefix and one or more tags

        The Lifecycle rule directs Amazon S3 to perform lifecycle actions on objects with the specified prefix and two tags (with the specific tag keys and values). Notice both `prefix` and `tags` are wrapped in the `and` configuration block.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {
                    "and_": {
                        "prefix": "logs/",
                        "tags": {
                            "Key1": "Value1",
                            "Key2": "Value2",
                        },
                    },
                },
                "status": "Enabled",
            }])
        ```

        ### Specifying a filter based on object size

        Object size values are in bytes. Maximum filter size is 5TB. Amazon S3 applies a default behavior to your Lifecycle configuration that prevents objects smaller than 128 KB from being transitioned to any storage class. You can allow smaller objects to transition by adding a minimum size (`object_size_greater_than`) or a maximum size (`object_size_less_than`) filter that specifies a smaller size to the configuration. This example allows any object smaller than 128 KB to transition to the S3 Glacier Instant Retrieval storage class:

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "Allow small object transitions",
                "filter": {
                    "object_size_greater_than": 1,
                },
                "status": "Enabled",
                "transitions": [{
                    "days": 365,
                    "storage_class": "GLACIER_IR",
                }],
            }])
        ```

        ### Specifying a filter based on object size range and prefix

        The `object_size_greater_than` must be less than the `object_size_less_than`. Notice both the object size range and prefix are wrapped in the `and` configuration block.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketLifecycleConfiguration("example",
            bucket=bucket["id"],
            rules=[{
                "id": "rule-1",
                "filter": {
                    "and_": {
                        "prefix": "logs/",
                        "object_size_greater_than": 500,
                        "object_size_less_than": 64000,
                    },
                },
                "status": "Enabled",
            }])
        ```

        ### Creating a Lifecycle Configuration for a bucket with versioning

        ```python
        import pulumi
        import pulumi_aws as aws

        bucket = aws.s3.Bucket("bucket", bucket="my-bucket")
        bucket_acl = aws.s3.BucketAcl("bucket_acl",
            bucket=bucket.id,
            acl="private")
        bucket_config = aws.s3.BucketLifecycleConfiguration("bucket-config",
            bucket=bucket.id,
            rules=[
                {
                    "id": "log",
                    "expiration": {
                        "days": 90,
                    },
                    "filter": {
                        "and_": {
                            "prefix": "log/",
                            "tags": {
                                "rule": "log",
                                "autoclean": "true",
                            },
                        },
                    },
                    "status": "Enabled",
                    "transitions": [
                        {
                            "days": 30,
                            "storage_class": "STANDARD_IA",
                        },
                        {
                            "days": 60,
                            "storage_class": "GLACIER",
                        },
                    ],
                },
                {
                    "id": "tmp",
                    "filter": {
                        "prefix": "tmp/",
                    },
                    "expiration": {
                        "date": "2023-01-13T00:00:00Z",
                    },
                    "status": "Enabled",
                },
            ])
        versioning_bucket = aws.s3.Bucket("versioning_bucket", bucket="my-versioning-bucket")
        versioning_bucket_acl = aws.s3.BucketAcl("versioning_bucket_acl",
            bucket=versioning_bucket.id,
            acl="private")
        versioning = aws.s3.BucketVersioning("versioning",
            bucket=versioning_bucket.id,
            versioning_configuration={
                "status": "Enabled",
            })
        versioning_bucket_config = aws.s3.BucketLifecycleConfiguration("versioning-bucket-config",
            bucket=versioning_bucket.id,
            rules=[{
                "id": "config",
                "filter": {
                    "prefix": "config/",
                },
                "noncurrent_version_expiration": {
                    "noncurrent_days": 90,
                },
                "noncurrent_version_transitions": [
                    {
                        "noncurrent_days": 30,
                        "storage_class": "STANDARD_IA",
                    },
                    {
                        "noncurrent_days": 60,
                        "storage_class": "GLACIER",
                    },
                ],
                "status": "Enabled",
            }],
            opts = pulumi.ResourceOptions(depends_on=[versioning]))
        ```

        ## Import

        If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        Using `pulumi import`, import an S3 bucket lifecycle configuration using the `bucket` or the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:

        If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:

        ```sh
        $ pulumi import aws:s3/bucketLifecycleConfiguration:BucketLifecycleConfiguration example bucket-name
        ```
        If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        ```sh
        $ pulumi import aws:s3/bucketLifecycleConfiguration:BucketLifecycleConfiguration example bucket-name,123456789012
        ```

        :param str resource_name: The name of the resource.
        :param BucketLifecycleConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketLifecycleConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleConfigurationRuleArgs', 'BucketLifecycleConfigurationRuleArgsDict']]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['BucketLifecycleConfigurationTimeoutsArgs', 'BucketLifecycleConfigurationTimeoutsArgsDict']]] = None,
                 transition_default_minimum_object_size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketLifecycleConfigurationArgs.__new__(BucketLifecycleConfigurationArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
            __props__.__dict__["region"] = region
            __props__.__dict__["rules"] = rules
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["transition_default_minimum_object_size"] = transition_default_minimum_object_size
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:s3/bucketLifecycleConfigurationV2:BucketLifecycleConfigurationV2")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(BucketLifecycleConfiguration, __self__).__init__(
            'aws:s3/bucketLifecycleConfiguration:BucketLifecycleConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleConfigurationRuleArgs', 'BucketLifecycleConfigurationRuleArgsDict']]]]] = None,
            timeouts: Optional[pulumi.Input[Union['BucketLifecycleConfigurationTimeoutsArgs', 'BucketLifecycleConfigurationTimeoutsArgsDict']]] = None,
            transition_default_minimum_object_size: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketLifecycleConfiguration':
        """
        Get an existing BucketLifecycleConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the source S3 bucket you want Amazon S3 to monitor.
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleConfigurationRuleArgs', 'BucketLifecycleConfigurationRuleArgsDict']]]] rules: List of configuration blocks describing the rules managing the replication. See below.
        :param pulumi.Input[_builtins.str] transition_default_minimum_object_size: The default minimum object size behavior applied to the lifecycle configuration. Valid values: `all_storage_classes_128K` (default), `varies_by_storage_class`. To customize the minimum object size for any transition you can add a `filter` that specifies a custom `object_size_greater_than` or `object_size_less_than` value. Custom filters always take precedence over the default transition behavior.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketLifecycleConfigurationState.__new__(_BucketLifecycleConfigurationState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
        __props__.__dict__["region"] = region
        __props__.__dict__["rules"] = rules
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["transition_default_minimum_object_size"] = transition_default_minimum_object_size
        return BucketLifecycleConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the source S3 bucket you want Amazon S3 to monitor.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> pulumi.Output[_builtins.str]:
        """
        Account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.BucketLifecycleConfigurationRule']]]:
        """
        List of configuration blocks describing the rules managing the replication. See below.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.BucketLifecycleConfigurationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="transitionDefaultMinimumObjectSize")
    def transition_default_minimum_object_size(self) -> pulumi.Output[_builtins.str]:
        """
        The default minimum object size behavior applied to the lifecycle configuration. Valid values: `all_storage_classes_128K` (default), `varies_by_storage_class`. To customize the minimum object size for any transition you can add a `filter` that specifies a custom `object_size_greater_than` or `object_size_less_than` value. Custom filters always take precedence over the default transition behavior.
        """
        return pulumi.get(self, "transition_default_minimum_object_size")

