# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketLoggingInitArgs', 'BucketLogging']

@pulumi.input_type
class BucketLoggingInitArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 target_bucket: pulumi.Input[_builtins.str],
                 target_prefix: pulumi.Input[_builtins.str],
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_grants: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingTargetGrantArgs']]]] = None,
                 target_object_key_format: Optional[pulumi.Input['BucketLoggingTargetObjectKeyFormatArgs']] = None):
        """
        The set of arguments for constructing a BucketLogging resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket.
        :param pulumi.Input[_builtins.str] target_bucket: Name of the bucket where you want Amazon S3 to store server access logs.
        :param pulumi.Input[_builtins.str] target_prefix: Prefix for all log object keys.
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLoggingTargetGrantArgs']]] target_grants: Set of configuration blocks with information for granting permissions. See below.
        :param pulumi.Input['BucketLoggingTargetObjectKeyFormatArgs'] target_object_key_format: Amazon S3 key format for log objects. See below.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "target_bucket", target_bucket)
        pulumi.set(__self__, "target_prefix", target_prefix)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if target_grants is not None:
            pulumi.set(__self__, "target_grants", target_grants)
        if target_object_key_format is not None:
            pulumi.set(__self__, "target_object_key_format", target_object_key_format)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the bucket where you want Amazon S3 to store server access logs.
        """
        return pulumi.get(self, "target_bucket")

    @target_bucket.setter
    def target_bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_bucket", value)

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        Prefix for all log object keys.
        """
        return pulumi.get(self, "target_prefix")

    @target_prefix.setter
    def target_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_prefix", value)

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="targetGrants")
    def target_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingTargetGrantArgs']]]]:
        """
        Set of configuration blocks with information for granting permissions. See below.
        """
        return pulumi.get(self, "target_grants")

    @target_grants.setter
    def target_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingTargetGrantArgs']]]]):
        pulumi.set(self, "target_grants", value)

    @_builtins.property
    @pulumi.getter(name="targetObjectKeyFormat")
    def target_object_key_format(self) -> Optional[pulumi.Input['BucketLoggingTargetObjectKeyFormatArgs']]:
        """
        Amazon S3 key format for log objects. See below.
        """
        return pulumi.get(self, "target_object_key_format")

    @target_object_key_format.setter
    def target_object_key_format(self, value: Optional[pulumi.Input['BucketLoggingTargetObjectKeyFormatArgs']]):
        pulumi.set(self, "target_object_key_format", value)


@pulumi.input_type
class _BucketLoggingState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 target_grants: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingTargetGrantArgs']]]] = None,
                 target_object_key_format: Optional[pulumi.Input['BucketLoggingTargetObjectKeyFormatArgs']] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BucketLogging resources.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket.
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] target_bucket: Name of the bucket where you want Amazon S3 to store server access logs.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLoggingTargetGrantArgs']]] target_grants: Set of configuration blocks with information for granting permissions. See below.
        :param pulumi.Input['BucketLoggingTargetObjectKeyFormatArgs'] target_object_key_format: Amazon S3 key format for log objects. See below.
        :param pulumi.Input[_builtins.str] target_prefix: Prefix for all log object keys.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if target_bucket is not None:
            pulumi.set(__self__, "target_bucket", target_bucket)
        if target_grants is not None:
            pulumi.set(__self__, "target_grants", target_grants)
        if target_object_key_format is not None:
            pulumi.set(__self__, "target_object_key_format", target_object_key_format)
        if target_prefix is not None:
            pulumi.set(__self__, "target_prefix", target_prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the bucket where you want Amazon S3 to store server access logs.
        """
        return pulumi.get(self, "target_bucket")

    @target_bucket.setter
    def target_bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_bucket", value)

    @_builtins.property
    @pulumi.getter(name="targetGrants")
    def target_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingTargetGrantArgs']]]]:
        """
        Set of configuration blocks with information for granting permissions. See below.
        """
        return pulumi.get(self, "target_grants")

    @target_grants.setter
    def target_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingTargetGrantArgs']]]]):
        pulumi.set(self, "target_grants", value)

    @_builtins.property
    @pulumi.getter(name="targetObjectKeyFormat")
    def target_object_key_format(self) -> Optional[pulumi.Input['BucketLoggingTargetObjectKeyFormatArgs']]:
        """
        Amazon S3 key format for log objects. See below.
        """
        return pulumi.get(self, "target_object_key_format")

    @target_object_key_format.setter
    def target_object_key_format(self, value: Optional[pulumi.Input['BucketLoggingTargetObjectKeyFormatArgs']]):
        pulumi.set(self, "target_object_key_format", value)

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prefix for all log object keys.
        """
        return pulumi.get(self, "target_prefix")

    @target_prefix.setter
    def target_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_prefix", value)


@pulumi.type_token("aws:s3/bucketLogging:BucketLogging")
class BucketLogging(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 target_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLoggingTargetGrantArgs', 'BucketLoggingTargetGrantArgsDict']]]]] = None,
                 target_object_key_format: Optional[pulumi.Input[Union['BucketLoggingTargetObjectKeyFormatArgs', 'BucketLoggingTargetObjectKeyFormatArgsDict']]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an S3 bucket (server access) logging resource. For more information, see [Logging requests using server access logging](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerLogs.html)
        in the AWS S3 User Guide.

        > **Note:** Amazon S3 supports server access logging, AWS CloudTrail, or a combination of both. Refer to the [Logging options for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/logging-with-S3.html)
        to decide which method meets your requirements.

        > This resource cannot be used with S3 directory buckets.

        ## Example Usage

        ### Grant permission by using bucket policy

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        logging = aws.s3.Bucket("logging", bucket="access-logging-bucket")
        logging_bucket_policy = logging.arn.apply(lambda arn: aws.iam.get_policy_document(statements=[{
            "principals": [{
                "identifiers": ["logging.s3.amazonaws.com"],
                "type": "Service",
            }],
            "actions": ["s3:PutObject"],
            "resources": [f"{arn}/*"],
            "conditions": [{
                "test": "StringEquals",
                "variable": "aws:SourceAccount",
                "values": [current.account_id],
            }],
        }]))
        logging_bucket_policy2 = aws.s3.BucketPolicy("logging",
            bucket=logging.bucket,
            policy=logging_bucket_policy.json)
        example = aws.s3.Bucket("example", bucket="example-bucket")
        example_bucket_logging = aws.s3.BucketLogging("example",
            bucket=example.bucket,
            target_bucket=logging.bucket,
            target_prefix="log/",
            target_object_key_format={
                "partitioned_prefix": {
                    "partition_date_source": "EventTime",
                },
            })
        ```

        ### Grant permission by using bucket ACL

        The [AWS Documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html) does not recommend using the ACL.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example", bucket="my-tf-example-bucket")
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example.id,
            acl="private")
        log_bucket = aws.s3.Bucket("log_bucket", bucket="my-tf-log-bucket")
        log_bucket_acl = aws.s3.BucketAcl("log_bucket_acl",
            bucket=log_bucket.id,
            acl="log-delivery-write")
        example_bucket_logging = aws.s3.BucketLogging("example",
            bucket=example.id,
            target_bucket=log_bucket.id,
            target_prefix="log/")
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `bucket` (String) S3 bucket name.

        #### Optional

        * `account_id` (String) AWS Account where this resource is managed.

        * `expected_bucket_owner` (String) Account ID of the expected bucket owner.

        * `region` (String) Region where this resource is managed.

        If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        terraform

        import {

          to = aws_s3_bucket_logging.example

          id = "bucket-name,123456789012"

        }

        **Using `pulumi import` to import** S3 bucket logging using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:

        If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:

        console

        % pulumi import aws_s3_bucket_logging.example bucket-name

        If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        console

        % pulumi import aws_s3_bucket_logging.example bucket-name,123456789012

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket.
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] target_bucket: Name of the bucket where you want Amazon S3 to store server access logs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketLoggingTargetGrantArgs', 'BucketLoggingTargetGrantArgsDict']]]] target_grants: Set of configuration blocks with information for granting permissions. See below.
        :param pulumi.Input[Union['BucketLoggingTargetObjectKeyFormatArgs', 'BucketLoggingTargetObjectKeyFormatArgsDict']] target_object_key_format: Amazon S3 key format for log objects. See below.
        :param pulumi.Input[_builtins.str] target_prefix: Prefix for all log object keys.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketLoggingInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an S3 bucket (server access) logging resource. For more information, see [Logging requests using server access logging](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerLogs.html)
        in the AWS S3 User Guide.

        > **Note:** Amazon S3 supports server access logging, AWS CloudTrail, or a combination of both. Refer to the [Logging options for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/logging-with-S3.html)
        to decide which method meets your requirements.

        > This resource cannot be used with S3 directory buckets.

        ## Example Usage

        ### Grant permission by using bucket policy

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        logging = aws.s3.Bucket("logging", bucket="access-logging-bucket")
        logging_bucket_policy = logging.arn.apply(lambda arn: aws.iam.get_policy_document(statements=[{
            "principals": [{
                "identifiers": ["logging.s3.amazonaws.com"],
                "type": "Service",
            }],
            "actions": ["s3:PutObject"],
            "resources": [f"{arn}/*"],
            "conditions": [{
                "test": "StringEquals",
                "variable": "aws:SourceAccount",
                "values": [current.account_id],
            }],
        }]))
        logging_bucket_policy2 = aws.s3.BucketPolicy("logging",
            bucket=logging.bucket,
            policy=logging_bucket_policy.json)
        example = aws.s3.Bucket("example", bucket="example-bucket")
        example_bucket_logging = aws.s3.BucketLogging("example",
            bucket=example.bucket,
            target_bucket=logging.bucket,
            target_prefix="log/",
            target_object_key_format={
                "partitioned_prefix": {
                    "partition_date_source": "EventTime",
                },
            })
        ```

        ### Grant permission by using bucket ACL

        The [AWS Documentation](https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html) does not recommend using the ACL.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.Bucket("example", bucket="my-tf-example-bucket")
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example.id,
            acl="private")
        log_bucket = aws.s3.Bucket("log_bucket", bucket="my-tf-log-bucket")
        log_bucket_acl = aws.s3.BucketAcl("log_bucket_acl",
            bucket=log_bucket.id,
            acl="log-delivery-write")
        example_bucket_logging = aws.s3.BucketLogging("example",
            bucket=example.id,
            target_bucket=log_bucket.id,
            target_prefix="log/")
        ```

        ## Import

        ### Identity Schema

        #### Required

        * `bucket` (String) S3 bucket name.

        #### Optional

        * `account_id` (String) AWS Account where this resource is managed.

        * `expected_bucket_owner` (String) Account ID of the expected bucket owner.

        * `region` (String) Region where this resource is managed.

        If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        terraform

        import {

          to = aws_s3_bucket_logging.example

          id = "bucket-name,123456789012"

        }

        **Using `pulumi import` to import** S3 bucket logging using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:

        If the owner (account ID) of the source bucket is the same account used to configure the AWS Provider, import using the `bucket`:

        console

        % pulumi import aws_s3_bucket_logging.example bucket-name

        If the owner (account ID) of the source bucket differs from the account used to configure the AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        console

        % pulumi import aws_s3_bucket_logging.example bucket-name,123456789012

        :param str resource_name: The name of the resource.
        :param BucketLoggingInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketLoggingInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 target_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLoggingTargetGrantArgs', 'BucketLoggingTargetGrantArgsDict']]]]] = None,
                 target_object_key_format: Optional[pulumi.Input[Union['BucketLoggingTargetObjectKeyFormatArgs', 'BucketLoggingTargetObjectKeyFormatArgsDict']]] = None,
                 target_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketLoggingInitArgs.__new__(BucketLoggingInitArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
            __props__.__dict__["region"] = region
            if target_bucket is None and not opts.urn:
                raise TypeError("Missing required property 'target_bucket'")
            __props__.__dict__["target_bucket"] = target_bucket
            __props__.__dict__["target_grants"] = target_grants
            __props__.__dict__["target_object_key_format"] = target_object_key_format
            if target_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'target_prefix'")
            __props__.__dict__["target_prefix"] = target_prefix
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="aws:s3/bucketLoggingV2:BucketLoggingV2")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(BucketLogging, __self__).__init__(
            'aws:s3/bucketLogging:BucketLogging',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            target_bucket: Optional[pulumi.Input[_builtins.str]] = None,
            target_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLoggingTargetGrantArgs', 'BucketLoggingTargetGrantArgsDict']]]]] = None,
            target_object_key_format: Optional[pulumi.Input[Union['BucketLoggingTargetObjectKeyFormatArgs', 'BucketLoggingTargetObjectKeyFormatArgsDict']]] = None,
            target_prefix: Optional[pulumi.Input[_builtins.str]] = None) -> 'BucketLogging':
        """
        Get an existing BucketLogging resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the bucket.
        :param pulumi.Input[_builtins.str] expected_bucket_owner: Account ID of the expected bucket owner.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] target_bucket: Name of the bucket where you want Amazon S3 to store server access logs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketLoggingTargetGrantArgs', 'BucketLoggingTargetGrantArgsDict']]]] target_grants: Set of configuration blocks with information for granting permissions. See below.
        :param pulumi.Input[Union['BucketLoggingTargetObjectKeyFormatArgs', 'BucketLoggingTargetObjectKeyFormatArgsDict']] target_object_key_format: Amazon S3 key format for log objects. See below.
        :param pulumi.Input[_builtins.str] target_prefix: Prefix for all log object keys.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketLoggingState.__new__(_BucketLoggingState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
        __props__.__dict__["region"] = region
        __props__.__dict__["target_bucket"] = target_bucket
        __props__.__dict__["target_grants"] = target_grants
        __props__.__dict__["target_object_key_format"] = target_object_key_format
        __props__.__dict__["target_prefix"] = target_prefix
        return BucketLogging(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Account ID of the expected bucket owner.
        """
        return pulumi.get(self, "expected_bucket_owner")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="targetBucket")
    def target_bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the bucket where you want Amazon S3 to store server access logs.
        """
        return pulumi.get(self, "target_bucket")

    @_builtins.property
    @pulumi.getter(name="targetGrants")
    def target_grants(self) -> pulumi.Output[Optional[Sequence['outputs.BucketLoggingTargetGrant']]]:
        """
        Set of configuration blocks with information for granting permissions. See below.
        """
        return pulumi.get(self, "target_grants")

    @_builtins.property
    @pulumi.getter(name="targetObjectKeyFormat")
    def target_object_key_format(self) -> pulumi.Output[Optional['outputs.BucketLoggingTargetObjectKeyFormat']]:
        """
        Amazon S3 key format for log objects. See below.
        """
        return pulumi.get(self, "target_object_key_format")

    @_builtins.property
    @pulumi.getter(name="targetPrefix")
    def target_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Prefix for all log object keys.
        """
        return pulumi.get(self, "target_prefix")

