# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketMetadataConfigurationArgs', 'BucketMetadataConfiguration']

@pulumi.input_type
class BucketMetadataConfigurationArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_configuration: Optional[pulumi.Input['BucketMetadataConfigurationMetadataConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['BucketMetadataConfigurationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a BucketMetadataConfiguration resource.
        :param pulumi.Input[_builtins.str] bucket: General purpose bucket that you want to create the metadata configuration for.
        :param pulumi.Input['BucketMetadataConfigurationMetadataConfigurationArgs'] metadata_configuration: Metadata configuration. See `metadata_configuration` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "bucket", bucket)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if metadata_configuration is not None:
            pulumi.set(__self__, "metadata_configuration", metadata_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        General purpose bucket that you want to create the metadata configuration for.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @_builtins.property
    @pulumi.getter(name="metadataConfiguration")
    def metadata_configuration(self) -> Optional[pulumi.Input['BucketMetadataConfigurationMetadataConfigurationArgs']]:
        """
        Metadata configuration. See `metadata_configuration` Block for details.

        The following arguments are optional:
        """
        return pulumi.get(self, "metadata_configuration")

    @metadata_configuration.setter
    def metadata_configuration(self, value: Optional[pulumi.Input['BucketMetadataConfigurationMetadataConfigurationArgs']]):
        pulumi.set(self, "metadata_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['BucketMetadataConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['BucketMetadataConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _BucketMetadataConfigurationState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_configuration: Optional[pulumi.Input['BucketMetadataConfigurationMetadataConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['BucketMetadataConfigurationTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering BucketMetadataConfiguration resources.
        :param pulumi.Input[_builtins.str] bucket: General purpose bucket that you want to create the metadata configuration for.
        :param pulumi.Input['BucketMetadataConfigurationMetadataConfigurationArgs'] metadata_configuration: Metadata configuration. See `metadata_configuration` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if expected_bucket_owner is not None:
            pulumi.set(__self__, "expected_bucket_owner", expected_bucket_owner)
        if metadata_configuration is not None:
            pulumi.set(__self__, "metadata_configuration", metadata_configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        General purpose bucket that you want to create the metadata configuration for.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "expected_bucket_owner")

    @expected_bucket_owner.setter
    def expected_bucket_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_bucket_owner", value)

    @_builtins.property
    @pulumi.getter(name="metadataConfiguration")
    def metadata_configuration(self) -> Optional[pulumi.Input['BucketMetadataConfigurationMetadataConfigurationArgs']]:
        """
        Metadata configuration. See `metadata_configuration` Block for details.

        The following arguments are optional:
        """
        return pulumi.get(self, "metadata_configuration")

    @metadata_configuration.setter
    def metadata_configuration(self, value: Optional[pulumi.Input['BucketMetadataConfigurationMetadataConfigurationArgs']]):
        pulumi.set(self, "metadata_configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['BucketMetadataConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['BucketMetadataConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:s3/bucketMetadataConfiguration:BucketMetadataConfiguration")
class BucketMetadataConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_configuration: Optional[pulumi.Input[Union['BucketMetadataConfigurationMetadataConfigurationArgs', 'BucketMetadataConfigurationMetadataConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['BucketMetadataConfigurationTimeoutsArgs', 'BucketMetadataConfigurationTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Manages Amazon S3 Metadata for a bucket.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketMetadataConfiguration("example",
            bucket=example_aws_s3_bucket["bucket"],
            metadata_configuration={
                "inventory_table_configuration": {
                    "configuration_state": "ENABLED",
                },
                "journal_table_configuration": {
                    "record_expiration": {
                        "days": 7,
                        "expiration": "ENABLED",
                    },
                },
            })
        ```

        ## Import

        If the owner (account ID) of the source bucket differs from the account used to configure the Terraform AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        __Using `pulumi import` to import__ S3 bucket metadata configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:

        If the owner (account ID) of the source bucket is the same account used to configure the Terraform AWS Provider, import using the `bucket`:

        ```sh
        $ pulumi import aws:s3/bucketMetadataConfiguration:BucketMetadataConfiguration example bucket-name
        ```
        If the owner (account ID) of the source bucket differs from the account used to configure the Terraform AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        ```sh
        $ pulumi import aws:s3/bucketMetadataConfiguration:BucketMetadataConfiguration example bucket-name,123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: General purpose bucket that you want to create the metadata configuration for.
        :param pulumi.Input[Union['BucketMetadataConfigurationMetadataConfigurationArgs', 'BucketMetadataConfigurationMetadataConfigurationArgsDict']] metadata_configuration: Metadata configuration. See `metadata_configuration` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketMetadataConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Amazon S3 Metadata for a bucket.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.s3.BucketMetadataConfiguration("example",
            bucket=example_aws_s3_bucket["bucket"],
            metadata_configuration={
                "inventory_table_configuration": {
                    "configuration_state": "ENABLED",
                },
                "journal_table_configuration": {
                    "record_expiration": {
                        "days": 7,
                        "expiration": "ENABLED",
                    },
                },
            })
        ```

        ## Import

        If the owner (account ID) of the source bucket differs from the account used to configure the Terraform AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        __Using `pulumi import` to import__ S3 bucket metadata configuration using the `bucket` or using the `bucket` and `expected_bucket_owner` separated by a comma (`,`). For example:

        If the owner (account ID) of the source bucket is the same account used to configure the Terraform AWS Provider, import using the `bucket`:

        ```sh
        $ pulumi import aws:s3/bucketMetadataConfiguration:BucketMetadataConfiguration example bucket-name
        ```
        If the owner (account ID) of the source bucket differs from the account used to configure the Terraform AWS Provider, import using the `bucket` and `expected_bucket_owner` separated by a comma (`,`):

        ```sh
        $ pulumi import aws:s3/bucketMetadataConfiguration:BucketMetadataConfiguration example bucket-name,123456789012
        ```

        :param str resource_name: The name of the resource.
        :param BucketMetadataConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketMetadataConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_configuration: Optional[pulumi.Input[Union['BucketMetadataConfigurationMetadataConfigurationArgs', 'BucketMetadataConfigurationMetadataConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['BucketMetadataConfigurationTimeoutsArgs', 'BucketMetadataConfigurationTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketMetadataConfigurationArgs.__new__(BucketMetadataConfigurationArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
            __props__.__dict__["metadata_configuration"] = metadata_configuration
            __props__.__dict__["region"] = region
            __props__.__dict__["timeouts"] = timeouts
        super(BucketMetadataConfiguration, __self__).__init__(
            'aws:s3/bucketMetadataConfiguration:BucketMetadataConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            expected_bucket_owner: Optional[pulumi.Input[_builtins.str]] = None,
            metadata_configuration: Optional[pulumi.Input[Union['BucketMetadataConfigurationMetadataConfigurationArgs', 'BucketMetadataConfigurationMetadataConfigurationArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['BucketMetadataConfigurationTimeoutsArgs', 'BucketMetadataConfigurationTimeoutsArgsDict']]] = None) -> 'BucketMetadataConfiguration':
        """
        Get an existing BucketMetadataConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: General purpose bucket that you want to create the metadata configuration for.
        :param pulumi.Input[Union['BucketMetadataConfigurationMetadataConfigurationArgs', 'BucketMetadataConfigurationMetadataConfigurationArgsDict']] metadata_configuration: Metadata configuration. See `metadata_configuration` Block for details.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketMetadataConfigurationState.__new__(_BucketMetadataConfigurationState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["expected_bucket_owner"] = expected_bucket_owner
        __props__.__dict__["metadata_configuration"] = metadata_configuration
        __props__.__dict__["region"] = region
        __props__.__dict__["timeouts"] = timeouts
        return BucketMetadataConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        General purpose bucket that you want to create the metadata configuration for.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="expectedBucketOwner")
    def expected_bucket_owner(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "expected_bucket_owner")

    @_builtins.property
    @pulumi.getter(name="metadataConfiguration")
    def metadata_configuration(self) -> pulumi.Output[Optional['outputs.BucketMetadataConfigurationMetadataConfiguration']]:
        """
        Metadata configuration. See `metadata_configuration` Block for details.

        The following arguments are optional:
        """
        return pulumi.get(self, "metadata_configuration")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.BucketMetadataConfigurationTimeouts']]:
        return pulumi.get(self, "timeouts")

