# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InventoryArgs', 'Inventory']

@pulumi.input_type
class InventoryArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 destination: pulumi.Input['InventoryDestinationArgs'],
                 included_object_versions: pulumi.Input[_builtins.str],
                 schedule: pulumi.Input['InventoryScheduleArgs'],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter: Optional[pulumi.Input['InventoryFilterArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Inventory resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the source bucket that inventory lists the objects for.
        :param pulumi.Input['InventoryDestinationArgs'] destination: Contains information about where to publish the inventory results (documented below).
        :param pulumi.Input[_builtins.str] included_object_versions: Object versions to include in the inventory list. Valid values: `All`, `Current`.
        :param pulumi.Input['InventoryScheduleArgs'] schedule: Specifies the schedule for generating inventory results (documented below).
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the inventory is enabled or disabled.
        :param pulumi.Input['InventoryFilterArgs'] filter: Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
        :param pulumi.Input[_builtins.str] name: Unique identifier of the inventory configuration for the bucket.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] optional_fields: List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "included_object_versions", included_object_versions)
        pulumi.set(__self__, "schedule", schedule)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional_fields is not None:
            pulumi.set(__self__, "optional_fields", optional_fields)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the source bucket that inventory lists the objects for.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input['InventoryDestinationArgs']:
        """
        Contains information about where to publish the inventory results (documented below).
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['InventoryDestinationArgs']):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="includedObjectVersions")
    def included_object_versions(self) -> pulumi.Input[_builtins.str]:
        """
        Object versions to include in the inventory list. Valid values: `All`, `Current`.
        """
        return pulumi.get(self, "included_object_versions")

    @included_object_versions.setter
    def included_object_versions(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "included_object_versions", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['InventoryScheduleArgs']:
        """
        Specifies the schedule for generating inventory results (documented below).
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['InventoryScheduleArgs']):
        pulumi.set(self, "schedule", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the inventory is enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['InventoryFilterArgs']]:
        """
        Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['InventoryFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the inventory configuration for the bucket.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optionalFields")
    def optional_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
        """
        return pulumi.get(self, "optional_fields")

    @optional_fields.setter
    def optional_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "optional_fields", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _InventoryState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['InventoryDestinationArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter: Optional[pulumi.Input['InventoryFilterArgs']] = None,
                 included_object_versions: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input['InventoryScheduleArgs']] = None):
        """
        Input properties used for looking up and filtering Inventory resources.
        :param pulumi.Input[_builtins.str] bucket: Name of the source bucket that inventory lists the objects for.
        :param pulumi.Input['InventoryDestinationArgs'] destination: Contains information about where to publish the inventory results (documented below).
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the inventory is enabled or disabled.
        :param pulumi.Input['InventoryFilterArgs'] filter: Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
        :param pulumi.Input[_builtins.str] included_object_versions: Object versions to include in the inventory list. Valid values: `All`, `Current`.
        :param pulumi.Input[_builtins.str] name: Unique identifier of the inventory configuration for the bucket.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] optional_fields: List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['InventoryScheduleArgs'] schedule: Specifies the schedule for generating inventory results (documented below).
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if included_object_versions is not None:
            pulumi.set(__self__, "included_object_versions", included_object_versions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional_fields is not None:
            pulumi.set(__self__, "optional_fields", optional_fields)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the source bucket that inventory lists the objects for.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['InventoryDestinationArgs']]:
        """
        Contains information about where to publish the inventory results (documented below).
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['InventoryDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the inventory is enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input['InventoryFilterArgs']]:
        """
        Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input['InventoryFilterArgs']]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="includedObjectVersions")
    def included_object_versions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object versions to include in the inventory list. Valid values: `All`, `Current`.
        """
        return pulumi.get(self, "included_object_versions")

    @included_object_versions.setter
    def included_object_versions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "included_object_versions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the inventory configuration for the bucket.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optionalFields")
    def optional_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
        """
        return pulumi.get(self, "optional_fields")

    @optional_fields.setter
    def optional_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "optional_fields", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['InventoryScheduleArgs']]:
        """
        Specifies the schedule for generating inventory results (documented below).
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['InventoryScheduleArgs']]):
        pulumi.set(self, "schedule", value)


@pulumi.type_token("aws:s3/inventory:Inventory")
class Inventory(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['InventoryDestinationArgs', 'InventoryDestinationArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter: Optional[pulumi.Input[Union['InventoryFilterArgs', 'InventoryFilterArgsDict']]] = None,
                 included_object_versions: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['InventoryScheduleArgs', 'InventoryScheduleArgsDict']]] = None,
                 __props__=None):
        """
        Provides a S3 bucket [inventory configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html) resource.

        > This resource cannot be used with S3 directory buckets.

        ## Example Usage

        ### Add inventory configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.s3.Bucket("test", bucket="my-tf-test-bucket")
        inventory = aws.s3.Bucket("inventory", bucket="my-tf-inventory-bucket")
        test_inventory = aws.s3.Inventory("test",
            bucket=test.id,
            name="EntireBucketDaily",
            included_object_versions="All",
            schedule={
                "frequency": "Daily",
            },
            destination={
                "bucket": {
                    "format": "ORC",
                    "bucket_arn": inventory.arn,
                },
            })
        ```

        ### Add inventory configuration with S3 object prefix

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.s3.Bucket("test", bucket="my-tf-test-bucket")
        inventory = aws.s3.Bucket("inventory", bucket="my-tf-inventory-bucket")
        test_prefix = aws.s3.Inventory("test-prefix",
            bucket=test.id,
            name="DocumentsWeekly",
            included_object_versions="All",
            schedule={
                "frequency": "Daily",
            },
            filter={
                "prefix": "documents/",
            },
            destination={
                "bucket": {
                    "format": "ORC",
                    "bucket_arn": inventory.arn,
                    "prefix": "inventory",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import S3 bucket inventory configurations using `bucket:inventory`. For example:

        ```sh
        $ pulumi import aws:s3/inventory:Inventory my-bucket-entire-bucket my-bucket:EntireBucket
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the source bucket that inventory lists the objects for.
        :param pulumi.Input[Union['InventoryDestinationArgs', 'InventoryDestinationArgsDict']] destination: Contains information about where to publish the inventory results (documented below).
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the inventory is enabled or disabled.
        :param pulumi.Input[Union['InventoryFilterArgs', 'InventoryFilterArgsDict']] filter: Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
        :param pulumi.Input[_builtins.str] included_object_versions: Object versions to include in the inventory list. Valid values: `All`, `Current`.
        :param pulumi.Input[_builtins.str] name: Unique identifier of the inventory configuration for the bucket.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] optional_fields: List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['InventoryScheduleArgs', 'InventoryScheduleArgsDict']] schedule: Specifies the schedule for generating inventory results (documented below).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InventoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a S3 bucket [inventory configuration](https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-inventory.html) resource.

        > This resource cannot be used with S3 directory buckets.

        ## Example Usage

        ### Add inventory configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.s3.Bucket("test", bucket="my-tf-test-bucket")
        inventory = aws.s3.Bucket("inventory", bucket="my-tf-inventory-bucket")
        test_inventory = aws.s3.Inventory("test",
            bucket=test.id,
            name="EntireBucketDaily",
            included_object_versions="All",
            schedule={
                "frequency": "Daily",
            },
            destination={
                "bucket": {
                    "format": "ORC",
                    "bucket_arn": inventory.arn,
                },
            })
        ```

        ### Add inventory configuration with S3 object prefix

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.s3.Bucket("test", bucket="my-tf-test-bucket")
        inventory = aws.s3.Bucket("inventory", bucket="my-tf-inventory-bucket")
        test_prefix = aws.s3.Inventory("test-prefix",
            bucket=test.id,
            name="DocumentsWeekly",
            included_object_versions="All",
            schedule={
                "frequency": "Daily",
            },
            filter={
                "prefix": "documents/",
            },
            destination={
                "bucket": {
                    "format": "ORC",
                    "bucket_arn": inventory.arn,
                    "prefix": "inventory",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import S3 bucket inventory configurations using `bucket:inventory`. For example:

        ```sh
        $ pulumi import aws:s3/inventory:Inventory my-bucket-entire-bucket my-bucket:EntireBucket
        ```

        :param str resource_name: The name of the resource.
        :param InventoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InventoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[Union['InventoryDestinationArgs', 'InventoryDestinationArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filter: Optional[pulumi.Input[Union['InventoryFilterArgs', 'InventoryFilterArgsDict']]] = None,
                 included_object_versions: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optional_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['InventoryScheduleArgs', 'InventoryScheduleArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InventoryArgs.__new__(InventoryArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filter"] = filter
            if included_object_versions is None and not opts.urn:
                raise TypeError("Missing required property 'included_object_versions'")
            __props__.__dict__["included_object_versions"] = included_object_versions
            __props__.__dict__["name"] = name
            __props__.__dict__["optional_fields"] = optional_fields
            __props__.__dict__["region"] = region
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
        super(Inventory, __self__).__init__(
            'aws:s3/inventory:Inventory',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['InventoryDestinationArgs', 'InventoryDestinationArgsDict']]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            filter: Optional[pulumi.Input[Union['InventoryFilterArgs', 'InventoryFilterArgsDict']]] = None,
            included_object_versions: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            optional_fields: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            schedule: Optional[pulumi.Input[Union['InventoryScheduleArgs', 'InventoryScheduleArgsDict']]] = None) -> 'Inventory':
        """
        Get an existing Inventory resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: Name of the source bucket that inventory lists the objects for.
        :param pulumi.Input[Union['InventoryDestinationArgs', 'InventoryDestinationArgsDict']] destination: Contains information about where to publish the inventory results (documented below).
        :param pulumi.Input[_builtins.bool] enabled: Specifies whether the inventory is enabled or disabled.
        :param pulumi.Input[Union['InventoryFilterArgs', 'InventoryFilterArgsDict']] filter: Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
        :param pulumi.Input[_builtins.str] included_object_versions: Object versions to include in the inventory list. Valid values: `All`, `Current`.
        :param pulumi.Input[_builtins.str] name: Unique identifier of the inventory configuration for the bucket.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] optional_fields: List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['InventoryScheduleArgs', 'InventoryScheduleArgsDict']] schedule: Specifies the schedule for generating inventory results (documented below).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InventoryState.__new__(_InventoryState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["destination"] = destination
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["filter"] = filter
        __props__.__dict__["included_object_versions"] = included_object_versions
        __props__.__dict__["name"] = name
        __props__.__dict__["optional_fields"] = optional_fields
        __props__.__dict__["region"] = region
        __props__.__dict__["schedule"] = schedule
        return Inventory(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the source bucket that inventory lists the objects for.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.InventoryDestination']:
        """
        Contains information about where to publish the inventory results (documented below).
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the inventory is enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional['outputs.InventoryFilter']]:
        """
        Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria (documented below).
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="includedObjectVersions")
    def included_object_versions(self) -> pulumi.Output[_builtins.str]:
        """
        Object versions to include in the inventory list. Valid values: `All`, `Current`.
        """
        return pulumi.get(self, "included_object_versions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the inventory configuration for the bucket.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="optionalFields")
    def optional_fields(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of optional fields that are included in the inventory results. Please refer to the S3 [documentation](https://docs.aws.amazon.com/AmazonS3/latest/API/API_InventoryConfiguration.html#AmazonS3-Type-InventoryConfiguration-OptionalFields) for more details.
        """
        return pulumi.get(self, "optional_fields")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.InventorySchedule']:
        """
        Specifies the schedule for generating inventory results (documented below).
        """
        return pulumi.get(self, "schedule")

