# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TableBucketPolicyArgs', 'TableBucketPolicy']

@pulumi.input_type
class TableBucketPolicyArgs:
    def __init__(__self__, *,
                 resource_policy: pulumi.Input[_builtins.str],
                 table_bucket_arn: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TableBucketPolicy resource.
        :param pulumi.Input[_builtins.str] resource_policy: Amazon Web Services resource-based policy document in JSON format.
        :param pulumi.Input[_builtins.str] table_bucket_arn: ARN referencing the Table Bucket that owns this policy.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "resource_policy", resource_policy)
        pulumi.set(__self__, "table_bucket_arn", table_bucket_arn)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> pulumi.Input[_builtins.str]:
        """
        Amazon Web Services resource-based policy document in JSON format.
        """
        return pulumi.get(self, "resource_policy")

    @resource_policy.setter
    def resource_policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_policy", value)

    @_builtins.property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN referencing the Table Bucket that owns this policy.
        """
        return pulumi.get(self, "table_bucket_arn")

    @table_bucket_arn.setter
    def table_bucket_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "table_bucket_arn", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _TableBucketPolicyState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 table_bucket_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TableBucketPolicy resources.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_policy: Amazon Web Services resource-based policy document in JSON format.
        :param pulumi.Input[_builtins.str] table_bucket_arn: ARN referencing the Table Bucket that owns this policy.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_policy is not None:
            pulumi.set(__self__, "resource_policy", resource_policy)
        if table_bucket_arn is not None:
            pulumi.set(__self__, "table_bucket_arn", table_bucket_arn)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Web Services resource-based policy document in JSON format.
        """
        return pulumi.get(self, "resource_policy")

    @resource_policy.setter
    def resource_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_policy", value)

    @_builtins.property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN referencing the Table Bucket that owns this policy.
        """
        return pulumi.get(self, "table_bucket_arn")

    @table_bucket_arn.setter
    def table_bucket_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_bucket_arn", value)


@pulumi.type_token("aws:s3tables/tableBucketPolicy:TableBucketPolicy")
class TableBucketPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 table_bucket_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an Amazon S3 Tables Table Bucket Policy.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.get_policy_document(statements=[{}])
        example_table_bucket_policy = aws.s3tables.TableBucketPolicy("example",
            resource_policy=example.json,
            table_bucket_arn=example_aws_s3tables_table_bucket["arn"])
        test = aws.s3tables.TableBucket("test", name="example-bucket")
        ```

        ## Import

        Using `pulumi import`, import S3 Tables Table Bucket Policy using the `table_bucket_arn`. For example:

        ```sh
        $ pulumi import aws:s3tables/tableBucketPolicy:TableBucketPolicy example 'arn:aws:s3tables:us-west-2:123456789012:bucket/example-bucket;example-namespace'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_policy: Amazon Web Services resource-based policy document in JSON format.
        :param pulumi.Input[_builtins.str] table_bucket_arn: ARN referencing the Table Bucket that owns this policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableBucketPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an Amazon S3 Tables Table Bucket Policy.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.iam.get_policy_document(statements=[{}])
        example_table_bucket_policy = aws.s3tables.TableBucketPolicy("example",
            resource_policy=example.json,
            table_bucket_arn=example_aws_s3tables_table_bucket["arn"])
        test = aws.s3tables.TableBucket("test", name="example-bucket")
        ```

        ## Import

        Using `pulumi import`, import S3 Tables Table Bucket Policy using the `table_bucket_arn`. For example:

        ```sh
        $ pulumi import aws:s3tables/tableBucketPolicy:TableBucketPolicy example 'arn:aws:s3tables:us-west-2:123456789012:bucket/example-bucket;example-namespace'
        ```

        :param str resource_name: The name of the resource.
        :param TableBucketPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableBucketPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 table_bucket_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableBucketPolicyArgs.__new__(TableBucketPolicyArgs)

            __props__.__dict__["region"] = region
            if resource_policy is None and not opts.urn:
                raise TypeError("Missing required property 'resource_policy'")
            __props__.__dict__["resource_policy"] = resource_policy
            if table_bucket_arn is None and not opts.urn:
                raise TypeError("Missing required property 'table_bucket_arn'")
            __props__.__dict__["table_bucket_arn"] = table_bucket_arn
        super(TableBucketPolicy, __self__).__init__(
            'aws:s3tables/tableBucketPolicy:TableBucketPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_policy: Optional[pulumi.Input[_builtins.str]] = None,
            table_bucket_arn: Optional[pulumi.Input[_builtins.str]] = None) -> 'TableBucketPolicy':
        """
        Get an existing TableBucketPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_policy: Amazon Web Services resource-based policy document in JSON format.
        :param pulumi.Input[_builtins.str] table_bucket_arn: ARN referencing the Table Bucket that owns this policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableBucketPolicyState.__new__(_TableBucketPolicyState)

        __props__.__dict__["region"] = region
        __props__.__dict__["resource_policy"] = resource_policy
        __props__.__dict__["table_bucket_arn"] = table_bucket_arn
        return TableBucketPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Web Services resource-based policy document in JSON format.
        """
        return pulumi.get(self, "resource_policy")

    @_builtins.property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN referencing the Table Bucket that owns this policy.
        """
        return pulumi.get(self, "table_bucket_arn")

