# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecretRotationResult',
    'AwaitableGetSecretRotationResult',
    'get_secret_rotation',
    'get_secret_rotation_output',
]

@pulumi.output_type
class GetSecretRotationResult:
    """
    A collection of values returned by getSecretRotation.
    """
    def __init__(__self__, id=None, region=None, rotation_enabled=None, rotation_lambda_arn=None, rotation_rules=None, secret_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rotation_enabled and not isinstance(rotation_enabled, bool):
            raise TypeError("Expected argument 'rotation_enabled' to be a bool")
        pulumi.set(__self__, "rotation_enabled", rotation_enabled)
        if rotation_lambda_arn and not isinstance(rotation_lambda_arn, str):
            raise TypeError("Expected argument 'rotation_lambda_arn' to be a str")
        pulumi.set(__self__, "rotation_lambda_arn", rotation_lambda_arn)
        if rotation_rules and not isinstance(rotation_rules, list):
            raise TypeError("Expected argument 'rotation_rules' to be a list")
        pulumi.set(__self__, "rotation_rules", rotation_rules)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rotationEnabled")
    def rotation_enabled(self) -> _builtins.bool:
        """
        Specifies whether automatic rotation is enabled for this secret.
        """
        return pulumi.get(self, "rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="rotationLambdaArn")
    def rotation_lambda_arn(self) -> _builtins.str:
        """
        Amazon Resource Name (ARN) of the lambda function used for rotation.
        """
        return pulumi.get(self, "rotation_lambda_arn")

    @_builtins.property
    @pulumi.getter(name="rotationRules")
    def rotation_rules(self) -> Sequence['outputs.GetSecretRotationRotationRuleResult']:
        """
        Configuration block for rotation rules. See `rotation_rules` below.
        """
        return pulumi.get(self, "rotation_rules")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        return pulumi.get(self, "secret_id")


class AwaitableGetSecretRotationResult(GetSecretRotationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretRotationResult(
            id=self.id,
            region=self.region,
            rotation_enabled=self.rotation_enabled,
            rotation_lambda_arn=self.rotation_lambda_arn,
            rotation_rules=self.rotation_rules,
            secret_id=self.secret_id)


def get_secret_rotation(region: Optional[_builtins.str] = None,
                        secret_id: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretRotationResult:
    """
    Retrieve information about a Secrets Manager secret rotation. To retrieve secret metadata, see the `secretsmanager.Secret` data source. To retrieve a secret value, see the `secretsmanager.SecretVersion` data source.

    ## Example Usage

    ### Retrieve Secret Rotation Configuration

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.secretsmanager.get_secret_rotation(secret_id=example_aws_secretsmanager_secret["id"])
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str secret_id: Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['secretId'] = secret_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:secretsmanager/getSecretRotation:getSecretRotation', __args__, opts=opts, typ=GetSecretRotationResult).value

    return AwaitableGetSecretRotationResult(
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        rotation_enabled=pulumi.get(__ret__, 'rotation_enabled'),
        rotation_lambda_arn=pulumi.get(__ret__, 'rotation_lambda_arn'),
        rotation_rules=pulumi.get(__ret__, 'rotation_rules'),
        secret_id=pulumi.get(__ret__, 'secret_id'))
def get_secret_rotation_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretRotationResult]:
    """
    Retrieve information about a Secrets Manager secret rotation. To retrieve secret metadata, see the `secretsmanager.Secret` data source. To retrieve a secret value, see the `secretsmanager.SecretVersion` data source.

    ## Example Usage

    ### Retrieve Secret Rotation Configuration

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.secretsmanager.get_secret_rotation(secret_id=example_aws_secretsmanager_secret["id"])
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str secret_id: Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['secretId'] = secret_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:secretsmanager/getSecretRotation:getSecretRotation', __args__, opts=opts, typ=GetSecretRotationResult)
    return __ret__.apply(lambda __response__: GetSecretRotationResult(
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        rotation_enabled=pulumi.get(__response__, 'rotation_enabled'),
        rotation_lambda_arn=pulumi.get(__response__, 'rotation_lambda_arn'),
        rotation_rules=pulumi.get(__response__, 'rotation_rules'),
        secret_id=pulumi.get(__response__, 'secret_id')))
