# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'SecretReplica',
    'SecretRotationRotationRules',
    'GetSecretRotationRotationRuleResult',
    'GetSecretVersionsVersionResult',
    'GetSecretsFilterResult',
]

@pulumi.output_type
class SecretReplica(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "lastAccessedDate":
            suggest = "last_accessed_date"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretReplica. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretReplica.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretReplica.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: _builtins.str,
                 kms_key_id: Optional[_builtins.str] = None,
                 last_accessed_date: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 status_message: Optional[_builtins.str] = None):
        """
        :param _builtins.str region: Region for replicating the secret.
        :param _builtins.str kms_key_id: ARN, Key ID, or Alias of the AWS KMS key within the region secret is replicated to. If one is not specified, then Secrets Manager defaults to using the AWS account's default KMS key (`aws/secretsmanager`) in the region or creates one for use if non-existent.
        :param _builtins.str last_accessed_date: Date that you last accessed the secret in the Region.
        :param _builtins.str status: Status can be `InProgress`, `Failed`, or `InSync`.
        :param _builtins.str status_message: Message such as `Replication succeeded` or `Secret with this name already exists in this region`.
        """
        pulumi.set(__self__, "region", region)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if last_accessed_date is not None:
            pulumi.set(__self__, "last_accessed_date", last_accessed_date)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Region for replicating the secret.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        ARN, Key ID, or Alias of the AWS KMS key within the region secret is replicated to. If one is not specified, then Secrets Manager defaults to using the AWS account's default KMS key (`aws/secretsmanager`) in the region or creates one for use if non-existent.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="lastAccessedDate")
    def last_accessed_date(self) -> Optional[_builtins.str]:
        """
        Date that you last accessed the secret in the Region.
        """
        return pulumi.get(self, "last_accessed_date")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status can be `InProgress`, `Failed`, or `InSync`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[_builtins.str]:
        """
        Message such as `Replication succeeded` or `Secret with this name already exists in this region`.
        """
        return pulumi.get(self, "status_message")


@pulumi.output_type
class SecretRotationRotationRules(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticallyAfterDays":
            suggest = "automatically_after_days"
        elif key == "scheduleExpression":
            suggest = "schedule_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretRotationRotationRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretRotationRotationRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretRotationRotationRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatically_after_days: Optional[_builtins.int] = None,
                 duration: Optional[_builtins.str] = None,
                 schedule_expression: Optional[_builtins.str] = None):
        """
        :param _builtins.int automatically_after_days: Specifies the number of days between automatic scheduled rotations of the secret. Either `automatically_after_days` or `schedule_expression` must be specified.
        :param _builtins.str duration: The length of the rotation window in hours. For example, `3h` for a three hour window.
        :param _builtins.str schedule_expression: A `cron()` or `rate()` expression that defines the schedule for rotating your secret. Either `automatically_after_days` or `schedule_expression` must be specified.
        """
        if automatically_after_days is not None:
            pulumi.set(__self__, "automatically_after_days", automatically_after_days)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)

    @_builtins.property
    @pulumi.getter(name="automaticallyAfterDays")
    def automatically_after_days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days between automatic scheduled rotations of the secret. Either `automatically_after_days` or `schedule_expression` must be specified.
        """
        return pulumi.get(self, "automatically_after_days")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional[_builtins.str]:
        """
        The length of the rotation window in hours. For example, `3h` for a three hour window.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[_builtins.str]:
        """
        A `cron()` or `rate()` expression that defines the schedule for rotating your secret. Either `automatically_after_days` or `schedule_expression` must be specified.
        """
        return pulumi.get(self, "schedule_expression")


@pulumi.output_type
class GetSecretRotationRotationRuleResult(dict):
    def __init__(__self__, *,
                 automatically_after_days: _builtins.int,
                 duration: _builtins.str,
                 schedule_expression: _builtins.str):
        """
        :param _builtins.int automatically_after_days: Number of days between automatic scheduled rotations of the secret.
        :param _builtins.str duration: Length of the rotation window in hours.
        :param _builtins.str schedule_expression: A `cron()` or `rate()` expression that defines the schedule for rotating the secret.
        """
        pulumi.set(__self__, "automatically_after_days", automatically_after_days)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "schedule_expression", schedule_expression)

    @_builtins.property
    @pulumi.getter(name="automaticallyAfterDays")
    def automatically_after_days(self) -> _builtins.int:
        """
        Number of days between automatic scheduled rotations of the secret.
        """
        return pulumi.get(self, "automatically_after_days")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.str:
        """
        Length of the rotation window in hours.
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> _builtins.str:
        """
        A `cron()` or `rate()` expression that defines the schedule for rotating the secret.
        """
        return pulumi.get(self, "schedule_expression")


@pulumi.output_type
class GetSecretVersionsVersionResult(dict):
    def __init__(__self__, *,
                 created_time: _builtins.str,
                 last_accessed_date: _builtins.str,
                 version_id: _builtins.str,
                 version_stages: Sequence[_builtins.str]):
        """
        :param _builtins.str created_time: Date and time this version of the secret was created.
        :param _builtins.str last_accessed_date: Date that this version of the secret was last accessed.
        :param _builtins.str version_id: Unique version identifier of this version of the secret.
        :param Sequence[_builtins.str] version_stages: List of staging labels attached to the version.
        """
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "last_accessed_date", last_accessed_date)
        pulumi.set(__self__, "version_id", version_id)
        pulumi.set(__self__, "version_stages", version_stages)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> _builtins.str:
        """
        Date and time this version of the secret was created.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter(name="lastAccessedDate")
    def last_accessed_date(self) -> _builtins.str:
        """
        Date that this version of the secret was last accessed.
        """
        return pulumi.get(self, "last_accessed_date")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        Unique version identifier of this version of the secret.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="versionStages")
    def version_stages(self) -> Sequence[_builtins.str]:
        """
        List of staging labels attached to the version.
        """
        return pulumi.get(self, "version_stages")


@pulumi.output_type
class GetSecretsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: Name of the filter field. Valid values can be found in the [Secrets Manager ListSecrets API Reference](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_ListSecrets.html).
        :param Sequence[_builtins.str] values: Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the filter field. Valid values can be found in the [Secrets Manager ListSecrets API Reference](https://docs.aws.amazon.com/secretsmanager/latest/apireference/API_ListSecrets.html).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Set of values that are accepted for the given filter field. Results will be selected if any given value matches.
        """
        return pulumi.get(self, "values")


