# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SecretPolicyArgs', 'SecretPolicy']

@pulumi.input_type
class SecretPolicyArgs:
    def __init__(__self__, *,
                 policy: pulumi.Input[_builtins.str],
                 secret_arn: pulumi.Input[_builtins.str],
                 block_public_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecretPolicy resource.
        :param pulumi.Input[_builtins.str] policy: Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
        :param pulumi.Input[_builtins.str] secret_arn: Secret ARN.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] block_public_policy: Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "secret_arn", secret_arn)
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Input[_builtins.str]:
        """
        Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> pulumi.Input[_builtins.str]:
        """
        Secret ARN.

        The following arguments are optional:
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_arn", value)

    @_builtins.property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
        """
        return pulumi.get(self, "block_public_policy")

    @block_public_policy.setter
    def block_public_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "block_public_policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SecretPolicyState:
    def __init__(__self__, *,
                 block_public_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecretPolicy resources.
        :param pulumi.Input[_builtins.bool] block_public_policy: Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
        :param pulumi.Input[_builtins.str] policy: Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] secret_arn: Secret ARN.
               
               The following arguments are optional:
        """
        if block_public_policy is not None:
            pulumi.set(__self__, "block_public_policy", block_public_policy)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)

    @_builtins.property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
        """
        return pulumi.get(self, "block_public_policy")

    @block_public_policy.setter
    def block_public_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "block_public_policy", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secret ARN.

        The following arguments are optional:
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_arn", value)


@pulumi.type_token("aws:secretsmanager/secretPolicy:SecretPolicy")
class SecretPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_public_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to manage AWS Secrets Manager secret policy.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example_secret = aws.secretsmanager.Secret("example", name="example")
        example = aws.iam.get_policy_document(statements=[{
            "sid": "EnableAnotherAWSAccountToReadTheSecret",
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": ["arn:aws:iam::123456789012:root"],
            }],
            "actions": ["secretsmanager:GetSecretValue"],
            "resources": ["*"],
        }])
        example_secret_policy = aws.secretsmanager.SecretPolicy("example",
            secret_arn=example_secret.arn,
            policy=example.json)
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the Secrets Manager secret.

        Using `pulumi import`, import `aws_secretsmanager_secret_policy` using the secret Amazon Resource Name (ARN). For example:

        console

        % pulumi import aws_secretsmanager_secret_policy.example arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] block_public_policy: Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
        :param pulumi.Input[_builtins.str] policy: Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] secret_arn: Secret ARN.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage AWS Secrets Manager secret policy.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws

        example_secret = aws.secretsmanager.Secret("example", name="example")
        example = aws.iam.get_policy_document(statements=[{
            "sid": "EnableAnotherAWSAccountToReadTheSecret",
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": ["arn:aws:iam::123456789012:root"],
            }],
            "actions": ["secretsmanager:GetSecretValue"],
            "resources": ["*"],
        }])
        example_secret_policy = aws.secretsmanager.SecretPolicy("example",
            secret_arn=example_secret.arn,
            policy=example.json)
        ```

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the Secrets Manager secret.

        Using `pulumi import`, import `aws_secretsmanager_secret_policy` using the secret Amazon Resource Name (ARN). For example:

        console

        % pulumi import aws_secretsmanager_secret_policy.example arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456

        :param str resource_name: The name of the resource.
        :param SecretPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_public_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretPolicyArgs.__new__(SecretPolicyArgs)

            __props__.__dict__["block_public_policy"] = block_public_policy
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            __props__.__dict__["region"] = region
            if secret_arn is None and not opts.urn:
                raise TypeError("Missing required property 'secret_arn'")
            __props__.__dict__["secret_arn"] = secret_arn
        super(SecretPolicy, __self__).__init__(
            'aws:secretsmanager/secretPolicy:SecretPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            block_public_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secret_arn: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecretPolicy':
        """
        Get an existing SecretPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] block_public_policy: Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
        :param pulumi.Input[_builtins.str] policy: Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] secret_arn: Secret ARN.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretPolicyState.__new__(_SecretPolicyState)

        __props__.__dict__["block_public_policy"] = block_public_policy
        __props__.__dict__["policy"] = policy
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_arn"] = secret_arn
        return SecretPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="blockPublicPolicy")
    def block_public_policy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
        """
        return pulumi.get(self, "block_public_policy")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> pulumi.Output[_builtins.str]:
        """
        Secret ARN.

        The following arguments are optional:
        """
        return pulumi.get(self, "secret_arn")

