# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FindingAggregatorArgs', 'FindingAggregator']

@pulumi.input_type
class FindingAggregatorArgs:
    def __init__(__self__, *,
                 linking_mode: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 specified_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a FindingAggregator resource.
        :param pulumi.Input[_builtins.str] linking_mode: Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED`, `SPECIFIED_REGIONS` or `NO_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] specified_regions: List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        pulumi.set(__self__, "linking_mode", linking_mode)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if specified_regions is not None:
            pulumi.set(__self__, "specified_regions", specified_regions)

    @_builtins.property
    @pulumi.getter(name="linkingMode")
    def linking_mode(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED`, `SPECIFIED_REGIONS` or `NO_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        """
        return pulumi.get(self, "linking_mode")

    @linking_mode.setter
    def linking_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "linking_mode", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="specifiedRegions")
    def specified_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        return pulumi.get(self, "specified_regions")

    @specified_regions.setter
    def specified_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "specified_regions", value)


@pulumi.input_type
class _FindingAggregatorState:
    def __init__(__self__, *,
                 linking_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 specified_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering FindingAggregator resources.
        :param pulumi.Input[_builtins.str] linking_mode: Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED`, `SPECIFIED_REGIONS` or `NO_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] specified_regions: List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        if linking_mode is not None:
            pulumi.set(__self__, "linking_mode", linking_mode)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if specified_regions is not None:
            pulumi.set(__self__, "specified_regions", specified_regions)

    @_builtins.property
    @pulumi.getter(name="linkingMode")
    def linking_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED`, `SPECIFIED_REGIONS` or `NO_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        """
        return pulumi.get(self, "linking_mode")

    @linking_mode.setter
    def linking_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "linking_mode", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="specifiedRegions")
    def specified_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        return pulumi.get(self, "specified_regions")

    @specified_regions.setter
    def specified_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "specified_regions", value)


@pulumi.type_token("aws:securityhub/findingAggregator:FindingAggregator")
class FindingAggregator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 linking_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 specified_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Security Hub finding aggregator. Security Hub needs to be enabled in a region in order for the aggregator to pull through findings.

        ## Example Usage

        ### All Regions Usage

        The following example will enable the aggregator for every region.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        example_finding_aggregator = aws.securityhub.FindingAggregator("example", linking_mode="ALL_REGIONS",
        opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### All Regions Except Specified Regions Usage

        The following example will enable the aggregator for every region except those specified in `specified_regions`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        example_finding_aggregator = aws.securityhub.FindingAggregator("example",
            linking_mode="ALL_REGIONS_EXCEPT_SPECIFIED",
            specified_regions=[
                "eu-west-1",
                "eu-west-2",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### Specified Regions Usage

        The following example will enable the aggregator for every region specified in `specified_regions`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        example_finding_aggregator = aws.securityhub.FindingAggregator("example",
            linking_mode="SPECIFIED_REGIONS",
            specified_regions=[
                "eu-west-1",
                "eu-west-2",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### No Regions Usage

        The following example will enable the aggregator but not link any AWS Regions to the home Region.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        example_finding_aggregator = aws.securityhub.FindingAggregator("example", linking_mode="NO_REGIONS",
        opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ## Import

        Using `pulumi import`, import an existing Security Hub finding aggregator using the `arn`. For example:

        ```sh
        $ pulumi import aws:securityhub/findingAggregator:FindingAggregator example arn:aws:securityhub:eu-west-1:123456789098:finding-aggregator/abcd1234-abcd-1234-1234-abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] linking_mode: Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED`, `SPECIFIED_REGIONS` or `NO_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] specified_regions: List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FindingAggregatorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Security Hub finding aggregator. Security Hub needs to be enabled in a region in order for the aggregator to pull through findings.

        ## Example Usage

        ### All Regions Usage

        The following example will enable the aggregator for every region.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        example_finding_aggregator = aws.securityhub.FindingAggregator("example", linking_mode="ALL_REGIONS",
        opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### All Regions Except Specified Regions Usage

        The following example will enable the aggregator for every region except those specified in `specified_regions`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        example_finding_aggregator = aws.securityhub.FindingAggregator("example",
            linking_mode="ALL_REGIONS_EXCEPT_SPECIFIED",
            specified_regions=[
                "eu-west-1",
                "eu-west-2",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### Specified Regions Usage

        The following example will enable the aggregator for every region specified in `specified_regions`.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        example_finding_aggregator = aws.securityhub.FindingAggregator("example",
            linking_mode="SPECIFIED_REGIONS",
            specified_regions=[
                "eu-west-1",
                "eu-west-2",
            ],
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### No Regions Usage

        The following example will enable the aggregator but not link any AWS Regions to the home Region.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.securityhub.Account("example")
        example_finding_aggregator = aws.securityhub.FindingAggregator("example", linking_mode="NO_REGIONS",
        opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ## Import

        Using `pulumi import`, import an existing Security Hub finding aggregator using the `arn`. For example:

        ```sh
        $ pulumi import aws:securityhub/findingAggregator:FindingAggregator example arn:aws:securityhub:eu-west-1:123456789098:finding-aggregator/abcd1234-abcd-1234-1234-abcdef123456
        ```

        :param str resource_name: The name of the resource.
        :param FindingAggregatorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FindingAggregatorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 linking_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 specified_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FindingAggregatorArgs.__new__(FindingAggregatorArgs)

            if linking_mode is None and not opts.urn:
                raise TypeError("Missing required property 'linking_mode'")
            __props__.__dict__["linking_mode"] = linking_mode
            __props__.__dict__["region"] = region
            __props__.__dict__["specified_regions"] = specified_regions
        super(FindingAggregator, __self__).__init__(
            'aws:securityhub/findingAggregator:FindingAggregator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            linking_mode: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            specified_regions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'FindingAggregator':
        """
        Get an existing FindingAggregator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] linking_mode: Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED`, `SPECIFIED_REGIONS` or `NO_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] specified_regions: List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FindingAggregatorState.__new__(_FindingAggregatorState)

        __props__.__dict__["linking_mode"] = linking_mode
        __props__.__dict__["region"] = region
        __props__.__dict__["specified_regions"] = specified_regions
        return FindingAggregator(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="linkingMode")
    def linking_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED`, `SPECIFIED_REGIONS` or `NO_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
        """
        return pulumi.get(self, "linking_mode")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="specifiedRegions")
    def specified_regions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
        """
        return pulumi.get(self, "specified_regions")

